import random, math
from sudoku import Sudoku

def eval_sudoku(array):
    #return sum(array)  # un-comment this line and watch the GA optimize to all max numbers
    #return -sum(array) # un-comment this line and watch the GA optimize to all ones
    s = Sudoku(0)
    size = int(math.sqrt(len(array)))
    s.set_arr(array)
    fitness = 0
    # count unique values in each row
    for r in range(s.size()):
        vals = set()
        for c in range(s.size()):
            vals.add(s.get(r,c))
        fitness += len(vals)
    # count unique values in each column
    for c in range(s.size()):
        vals = set()
        for r in range(s.size()): 
            vals.add(s.get(r,c))
        fitness += len(vals)
    # count unique values in each square
    sqsize = int(math.sqrt(s.size()))
    for sr in range(sqsize):
        for sc in range(sqsize):
            vals = set()
            for r in range(sqsize):
                for c in range(sqsize):
                    vals.add(s.get(sr*sqsize+r, sc*sqsize+c))
            fitness += len(vals)
    return fitness

# the class that stores the genetic algorithm settings
class GASettings:
    # we need something in here so that python doesn't complain about blank classes
    description = 'Blank struct to hold our GA settings in'

def get_ga_settings(sudoko_size):
    settings = GASettings()
    settings.individual_values      = [(i+1) for i in range(sudoko_size)]   # possible values individuals can take
    settings.individual_size        = sudoko_size*sudoko_size               # length of an individual gene
    settings.fitness_function       = eval_sudoku                           # the fitness function of an individual
    settings.population_size        = 100                                   # total size of each populatio
    settings.elitism_ratio          = 0.2                                   # select top x% of individuals to survive
    settings.parent_roulette_ratio  = 0.2                                   # select x% of individuals as parents via linear roulette wheel
    settings.mutation_rate          = 0.2                                   # mutation rate percentage
    settings.crossover_index        = settings.individual_size // 2         # the index to split parents for recombination
    return settings

def evolve(population, settings):

    # compute the fitnesses for this population
    pop_fitness = list(map(settings.fitness_function, population))

    parents              = []
    next_population      = []
    num_elite            = int(settings.elitism_ratio*len(pop_fitness))
    num_roulette_parents = int(settings.parent_roulette_ratio * len(population))

    # elitism, select the top 10 parents
    population.sort(key=settings.fitness_function, reverse=True)
    pop_fitness.sort(reverse=True)
    next_population.extend(population[:num_elite])

    # select the parents for the next generation based on roulette wheel
    max = sum(pop_fitness)
    for p in range(num_roulette_parents):
        pick = random.uniform(0, max)
        current = 0
        pick_index = 0
        for i in range(len(population)):
            current += pop_fitness[i]
            if current > pick:
                pick_index = i
                break
        parents.append(population[pick_index])

    # do crossover to create children
    num_parents = len(parents)
    num_children = settings.population_size - len(next_population)
    while len(next_population) < len(population):
        # select a random mother and father form the parents
        mother = random.randint(0, num_parents - 1)
        father = random.randint(0, num_parents - 1)
        # if they're not the same, breed a child from them
        if mother != father:
            mother = parents[mother]
            father = parents[father]
            child = [0]* len(mother)
            for i in range(len(mother)):
                child[i] = mother[i] if random.random() > 0.5 else father[i]
            #child = mother[:settings.crossover_index] + father[settings.crossover_index:]
            if settings.mutation_rate > random.random():
                index = random.randint(0, len(child)-1)
                child[index] = random.choice(settings.individual_values)
            next_population.append(child)

    return next_population
