class Node:

    def __init__(self, tile):
        self.tile = tile
        self.action = (0, 0)
        self.g = 0
        self.f = 0
        self.parent = None
    
    def __lt__(self, other):
        return self.f < other.f

class AStar:

    def __init__(self, grid):
        self.__grid = grid
        self.reset()

    def __reset(self):
        self.__open_list = []
        self.__closed_list = []

    def __add_to_open(self, tile):
        self.__open_list.append(tile)

    def __remove_min_from_open(self):
        # find the min node in the open list
        # remove it from the open list
        # return it

    # AStar Code from Notes
    def a_star_search(self, start, goal, size):
        closed = set()
        open = [Node(start)]
        while (len(open) > 0):
            node = remove_min_from(open)
            if (node.state == end) return self.reconstruct_path(node)
            closed.add(node.state)
            for child in self.expand(node):
                if (child.state in closed) continue
                child.g = child.g + self.grid.estimate_cost(start, goal)
                open.append(child)
        return []
