/*
 * Decompiled with CFR 0.152.
 */
package bwta;

import bwapi.Pair;
import bwapi.Point;
import bwapi.Position;
import bwapi.WalkPosition;
import bwem.ChokePoint;
import bwta.BWTA;
import bwta.Region;
import java.util.List;

public class Chokepoint {
    private final ChokePoint chokePoint;
    private final Pair<Position, Position> sides;
    private final Position center;
    private final double width;

    Chokepoint(ChokePoint chokePoint) {
        this.chokePoint = chokePoint;
        this.sides = Chokepoint.calculateSides(chokePoint.getGeometry());
        this.center = this.sides.getFirst().add(this.sides.getSecond()).divide(2);
        this.width = this.sides.getLeft().getDistance((Point)this.sides.getRight());
    }

    public Pair<Region, Region> getRegions() {
        return new Pair<Region, Region>(BWTA.regionMap.get(this.chokePoint.getAreas().getLeft()), BWTA.regionMap.get(this.chokePoint.getAreas().getRight()));
    }

    public Pair<Position, Position> getSides() {
        return this.sides;
    }

    public Position getCenter() {
        return this.center;
    }

    public double getWidth() {
        return this.width;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Chokepoint)) {
            return false;
        }
        return this.chokePoint.equals(((Chokepoint)o).chokePoint);
    }

    public int hashCode() {
        return this.chokePoint.hashCode();
    }

    private static Pair<Position, Position> calculateSides(List<WalkPosition> wp) {
        WalkPosition p1 = wp.get(0);
        WalkPosition p2 = wp.get(0);
        double d_max = -1.0;
        for (int i = 0; i < wp.size(); ++i) {
            for (int j = i + 1; j < wp.size(); ++j) {
                double d = wp.get(i).getDistance((Point)wp.get(j));
                if (!(d > d_max)) continue;
                d_max = d;
                p1 = wp.get(i);
                p2 = wp.get(j);
            }
        }
        return new Pair<Position, Position>(p1.toPosition(), p2.toPosition());
    }
}

