/*
 * Decompiled with CFR 0.152.
 */
package jps;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jps.Graph;
import jps.JPS;
import jps.Node;

public class JPSDiagNever<T extends Node>
extends JPS<T> {
    public JPSDiagNever(Graph<T> graph) {
        super(graph);
    }

    @Override
    protected Set<T> findNeighbors(T node, Map<T, T> parentMap) {
        HashSet<T> neighbors = new HashSet<T>();
        Node parent = (Node)parentMap.get(node);
        if (parent != null) {
            int x = ((Node)node).x;
            int y = ((Node)node).y;
            int dx = (x - parent.x) / Math.max(Math.abs(x - parent.x), 1);
            int dy = (y - parent.y) / Math.max(Math.abs(y - parent.y), 1);
            if (dx != 0) {
                if (this.graph.isWalkable(x + dx, y)) {
                    neighbors.add(this.graph.getNode(x + dx, y));
                }
                if (this.graph.isWalkable(x, y + 1)) {
                    neighbors.add(this.graph.getNode(x, y + 1));
                }
                if (this.graph.isWalkable(x, y - 1)) {
                    neighbors.add(this.graph.getNode(x, y - 1));
                }
            } else if (dy != 0) {
                if (this.graph.isWalkable(x, y + dy)) {
                    neighbors.add(this.graph.getNode(x, y + dy));
                }
                if (this.graph.isWalkable(x + 1, y)) {
                    neighbors.add(this.graph.getNode(x + 1, y));
                }
                if (this.graph.isWalkable(x - 1, y)) {
                    neighbors.add(this.graph.getNode(x - 1, y));
                }
            }
        } else {
            neighbors.addAll(this.graph.getNeighborsOf(node, Graph.Diagonal.NEVER));
        }
        return neighbors;
    }

    @Override
    protected T jump(T neighbor, T current, Set<T> goals) {
        if (neighbor == null || !((Node)neighbor).walkable) {
            return null;
        }
        if (goals.contains(neighbor)) {
            return neighbor;
        }
        int dx = ((Node)neighbor).x - ((Node)current).x;
        int dy = ((Node)neighbor).y - ((Node)current).y;
        if (dx != 0) {
            if (this.graph.isWalkable(((Node)neighbor).x, ((Node)neighbor).y + 1) && !this.graph.isWalkable(((Node)neighbor).x - dx, ((Node)neighbor).y + 1) || this.graph.isWalkable(((Node)neighbor).x, ((Node)neighbor).y - 1) && !this.graph.isWalkable(((Node)neighbor).x - dx, ((Node)neighbor).y - 1)) {
                return neighbor;
            }
        } else if (dy != 0) {
            if (this.graph.isWalkable(((Node)neighbor).x + 1, ((Node)neighbor).y) && !this.graph.isWalkable(((Node)neighbor).x + 1, ((Node)neighbor).y - dy) || this.graph.isWalkable(((Node)neighbor).x - 1, ((Node)neighbor).y) && !this.graph.isWalkable(((Node)neighbor).x - 1, ((Node)neighbor).y - dy)) {
                return neighbor;
            }
            if (this.jump(this.graph.getNode(((Node)neighbor).x + 1, ((Node)neighbor).y), neighbor, goals) != null || this.jump(this.graph.getNode(((Node)neighbor).x - 1, ((Node)neighbor).y), neighbor, goals) != null) {
                return neighbor;
            }
        } else {
            return null;
        }
        return this.jump(this.graph.getNode(((Node)neighbor).x + dx, ((Node)neighbor).y + dy), neighbor, goals);
    }
}

