/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.Game;
import bwapi.Player;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class Force
implements Comparable<Force> {
    private final Game game;
    private final int id;
    private final String name;

    Force(ClientData.ForceData forceData, int id, Game game) {
        this.game = game;
        this.id = id;
        this.name = forceData.getName();
    }

    public int getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<Player> getPlayers() {
        return this.game.getPlayers().stream().filter(p -> this.equals(p.getForce())).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Force force = (Force)o;
        return this.id == force.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(Force other) {
        return this.id - other.id;
    }
}

