/*
 * Decompiled with CFR 0.152.
 */
package Performance.TaskQueue;

import Lifecycle.With$;
import Mathematics.Maff$;
import Performance.Tasks.TimedTask;
import Performance.Timer;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.Numeric$IntIsIntegral$;
import scala.math.Ordering$Boolean$;
import scala.math.Ordering$Long$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001A2AAB\u0004\u0001\u0019!A1\u0003\u0001BC\u0002\u0013\u0005A\u0003\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0016\u0011\u0015a\u0002\u0001\"\u0001\u001e\u0011\u0015\t\u0003\u0001\"\u0011#\u0011\u00151\u0003\u0001\"\u0011(\u0005E!\u0016m]6Rk\u0016,X\rU1sC2dW\r\u001c\u0006\u0003\u0011%\t\u0011\u0002V1tWF+X-^3\u000b\u0003)\t1\u0002U3sM>\u0014X.\u00198dK\u000e\u00011C\u0001\u0001\u000e!\tq\u0011#D\u0001\u0010\u0015\t\u0001\u0012\"A\u0003UCN\\7/\u0003\u0002\u0013\u001f\tIA+[7fIR\u000b7o[\u0001\u0006i\u0006\u001c8n]\u000b\u0002+A\u0019a#G\u0007\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?\u0003\u0019!\u0018m]6tA\u00051A(\u001b8jiz\"\"A\b\u0011\u0011\u0005}\u0001Q\"A\u0004\t\u000bM\u0019\u0001\u0019A\u000b\u0002\u0015%\u001c8i\\7qY\u0016$X-F\u0001$!\t1B%\u0003\u0002&/\t9!i\\8mK\u0006t\u0017!B8o%VtGC\u0001\u0015,!\t1\u0012&\u0003\u0002+/\t!QK\\5u\u0011\u0015aS\u00011\u0001.\u0003!\u0011W\u000fZ4fi6\u001b\bC\u0001\f/\u0013\tysC\u0001\u0003M_:<\u0007")
public class TaskQueueParallel
extends TimedTask {
    private final Seq<TimedTask> tasks;

    public Seq<TimedTask> tasks() {
        return this.tasks;
    }

    @Override
    public boolean isComplete() {
        return this.tasks().forall((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(x$1.isComplete()));
    }

    @Override
    public void onRun(long budgetMs) {
        Timer timer = new Timer(budgetMs);
        if (this.tasks().exists((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.hasNeverRun()))) {
            while (With$.MODULE$.performance().continueRunning() && this.tasks().exists((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.hasNeverRun()))) {
                ((TimedTask)this.tasks().find((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(x$4.hasNeverRun())).get()).run(With$.MODULE$.performance().msBeforeTarget());
            }
            return;
        }
        int taskWeightTotal = BoxesRunTime.unboxToInt(((TraversableOnce)this.tasks().view().map((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger(x$5.weight()), SeqView$.MODULE$.canBuildFrom())).sum(Numeric$IntIsIntegral$.MODULE$));
        Seq tasksSorted = (Seq)((SeqLike)((SeqLike)this.tasks().sortBy((Function1<TimedTask, Object> & Serializable & scala.Serializable)task -> BoxesRunTime.boxToLong(TaskQueueParallel.$anonfun$onRun$5(task)), Ordering$Long$.MODULE$)).sortBy((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean(TaskQueueParallel.$anonfun$onRun$6(x$6)), Ordering$Boolean$.MODULE$)).sortBy((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean(x$7.cosmetic()), Ordering$Boolean$.MODULE$);
        for (int i = 0; i < tasksSorted.length(); ++i) {
            TimedTask task2 = (TimedTask)tasksSorted.apply(i);
            double budgetRatio = (double)task2.weight() / (double)taskWeightTotal;
            double budgetMsRecent = (double)With$.MODULE$.configuration().frameTargetMs() * budgetRatio * (double)8;
            long budgetMsRecentSpent = BoxesRunTime.unboxToLong(task2.runMsRecentTotal().apply());
            long taskBudgetMs = (long)Maff$.MODULE$.clamp(budgetMsRecent - (double)budgetMsRecentSpent, 0.0, With$.MODULE$.performance().msBeforeTarget());
            if (i == 0 || task2.due() && !With$.MODULE$.performance().disqualificationDanger() || timer.greenLight() && task2.safeToRun(taskBudgetMs)) {
                task2.run(taskBudgetMs);
                continue;
            }
            task2.skip();
        }
        if (With$.MODULE$.performance().frameBrokeLimit()) {
            String arg$macro$3 = this.toString();
            Integer arg$macro$4 = BoxesRunTime.boxToInteger(With$.MODULE$.configuration().frameLimitMs());
            Long arg$macro$5 = BoxesRunTime.boxToLong(With$.MODULE$.performance().frameElapsedMs());
            String arg$macro$6 = ((TraversableOnce)((TraversableLike)((SeqLike)tasksSorted.filter((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean(TaskQueueParallel.$anonfun$onRun$8(x$8)))).sortBy((Function1<TimedTask, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong(TaskQueueParallel.$anonfun$onRun$9(x$9)), Ordering$Long$.MODULE$)).map((Function1<TimedTask, String> & Serializable & scala.Serializable)t -> {
                Long arg$macro$1 = BoxesRunTime.boxToLong(t.runMsLast());
                String arg$macro$2 = t.toString();
                return new StringOps("(%sms: %s)").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1, arg$macro$2}));
            }, Seq$.MODULE$.canBuildFrom())).mkString(" ");
            With$.MODULE$.logger().performance(new StringOps("%s crossed %sms to %sms. Task durations: %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$3, arg$macro$4, arg$macro$5, arg$macro$6})));
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$onRun$5(TimedTask task) {
        return BoxesRunTime.unboxToLong(task.runMsRecentTotal().apply()) / (long)Math.max(1, task.weight());
    }

    public static final /* synthetic */ boolean $anonfun$onRun$6(TimedTask x$6) {
        return !x$6.due();
    }

    public static final /* synthetic */ boolean $anonfun$onRun$8(TimedTask x$8) {
        return x$8.framesSinceRunning() <= 1;
    }

    public static final /* synthetic */ long $anonfun$onRun$9(TimedTask x$9) {
        return -x$9.runMsLast();
    }

    public TaskQueueParallel(Seq<TimedTask> tasks) {
        this.tasks = tasks;
        this.withAlwaysSafe(true);
    }
}

