/*
 * Decompiled with CFR 0.152.
 */
package Micro.Targeting;

import Information.Battles.Types.Team;
import Lifecycle.With$;
import Mathematics.Maff$;
import Mathematics.Points.Tile;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.UnitInfo.CombatUnit;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.$qmark$;
import Utilities.UnitFilters.UnitFilter;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric$IntIsIntegral$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcD$sp;
import scala.runtime.java8.JFunction0$mcI$sp;
import scala.runtime.java8.JFunction0$mcZ$sp;

public final class TargetScoring$ {
    public static TargetScoring$ MODULE$;
    private double baseValue;
    private final double Micro$Targeting$TargetScoring$$combatBonus;
    private volatile boolean bitmap$0;

    static {
        new TargetScoring$();
    }

    public double Micro$Targeting$TargetScoring$$pixelCost(CombatUnit attacker, CombatUnit target) {
        return Math.max(0.0, attacker.pixelsToGetInRange(target) - 0.5 * (double)attacker.cooldownLeft() * attacker.topSpeed());
    }

    public double Micro$Targeting$TargetScoring$$attackValue(double targetValue, double injury, double pixelCost, double efficacy) {
        double value = targetValue + 4.0 * injury;
        return BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(value > 0.0, (JFunction0$mcD$sp & scala.Serializable)() -> efficacy, (JFunction0$mcD$sp & scala.Serializable)() -> 1.0)) * value - Maff$.MODULE$.inv32() * pixelCost;
    }

    public double fast(CombatUnit attacker, CombatUnit target) {
        return this.Micro$Targeting$TargetScoring$$attackValue(target.targetValue(), target.injury(), this.Micro$Targeting$TargetScoring$$pixelCost(attacker, target), attacker.damageMultiplierAgainst(target) * attacker.hitChanceAgainst(target, attacker.hitChanceAgainst$default$2(), attacker.hitChanceAgainst$default$3()));
    }

    public double slow(FriendlyUnitInfo attacker, UnitInfo target) {
        double d;
        double splashEfficacy = this.Micro$Targeting$TargetScoring$$mult((JFunction0$mcD$sp & scala.Serializable)() -> Math.max(1.0, 0.5 * (double)BoxesRunTime.unboxToInt(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])target.tile().adjacent9())).iterator().map((Function1<Tile, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger(TargetScoring$.$anonfun$slow$2(attacker, x$1))).sum(Numeric$IntIsIntegral$.MODULE$))), attacker.isAny(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Terran$.MODULE$.SiegeTankSieged(), Protoss$.MODULE$.Archon(), Protoss$.MODULE$.Reaver(), Zerg$.MODULE$.Lurker()})));
        double attackValue = this.Micro$Targeting$TargetScoring$$attackValue(target.targetValue(), BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(target.doomed(), (JFunction0$mcD$sp & scala.Serializable)() -> 0.0, (JFunction0$mcD$sp & scala.Serializable)() -> target.injury())), this.Micro$Targeting$TargetScoring$$pixelCost(attacker, target), splashEfficacy * attacker.hitChanceAgainst(target, attacker.hitChanceAgainst$default$2(), attacker.hitChanceAgainst$default$3()) * attacker.damageMultiplierAgainst(target));
        boolean active = target.canAttack();
        boolean passive = !target.unitClass().attacksOrCastsOrDetectsOrTransports();
        boolean inCombat = attacker.team().exists((Function1<Team, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(x$2.engagedUpon())) || target.team().exists((Function1<Team, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean(x$3.engagingOn()));
        boolean actionMatch = inCombat && active || !inCombat && passive;
        double combatValue = this.Micro$Targeting$TargetScoring$$combatBonus() * (double)BoxesRunTime.unboxToInt($qmark$.MODULE$.apply(actionMatch, (JFunction0$mcI$sp & scala.Serializable)() -> 1, (JFunction0$mcI$sp & scala.Serializable)() -> -1));
        double meleeSpreadBonus = 8.0;
        if (attacker.unitClass().melee()) {
            int otherAttackers = Math.max(0, target.targetedByRecentlyMelee().size() - 1);
            int surfaceArea = target.unitClass().perimeter();
            int surfaceRatio = attacker.unitClass().dimensionMax() * otherAttackers / surfaceArea;
            if (otherAttackers > 1 && (double)surfaceRatio >= 0.25) {
                meleeSpreadBonus = Math.max(0.0, meleeSpreadBonus - 1.0 * (double)otherAttackers);
            }
        }
        double catchBonus = this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 12.0, target.caught() || target.caughtBy(attacker));
        switch (((Tile)$qmark$.MODULE$.apply(Protoss$.MODULE$.Carrier().apply(attacker), (Function0<Tile> & Serializable & scala.Serializable)() -> target.tile(), (Function0<Tile> & Serializable & scala.Serializable)() -> attacker.pixelToFireAtSimple(target).tile())).enemiesAttacking(attacker).length()) {
            case 0: {
                d = 0.0;
                break;
            }
            case 1: {
                d = 1.0;
                break;
            }
            default: {
                d = 3.0;
            }
        }
        double threatCost = d;
        return (attackValue + combatValue + meleeSpreadBonus + catchBonus) * splashEfficacy - threatCost;
    }

    private double baseValue$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.baseValue = 1.0 / Protoss$.MODULE$.Dragoon().subjectiveValueOverHealth();
                this.bitmap$0 = true;
            }
        }
        return this.baseValue;
    }

    private double baseValue() {
        if (!this.bitmap$0) {
            return this.baseValue$lzycompute();
        }
        return this.baseValue;
    }

    public double Micro$Targeting$TargetScoring$$combatBonus() {
        return this.Micro$Targeting$TargetScoring$$combatBonus;
    }

    public double apply(UnitInfo target) {
        double output = 4.0 * this.baseValue() * target.unitClass().subjectiveValueOverHealth();
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 10.0, target.matrixPoints() == 0);
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 4.0, target.constructing());
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 6.0, target.gathering());
        if (target.unitClass().attacksOrCastsOrDetectsOrTransports() && !Zerg$.MODULE$.Overlord().apply(target)) {
            output += this.Micro$Targeting$TargetScoring$$combatBonus();
            output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 2.0, target.presumptiveTarget().exists((Function1<UnitInfo, Object> & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean(TargetScoring$.$anonfun$apply$5(t))));
            output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 2.0, !target.canMove());
            output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 6.0, !target.canMove() || BoxesRunTime.unboxToBoolean($qmark$.MODULE$.apply(target.isOurs(), (JFunction0$mcZ$sp & scala.Serializable)() -> target.visibleToOpponents(), (JFunction0$mcZ$sp & scala.Serializable)() -> target.visible())));
            output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 6.0, !target.canMove() || target.likelyStillThere());
        }
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 2.0, !target.likelyDoomed());
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 2.0, !target.doomed());
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 8.0, Protoss$.MODULE$.DarkTemplar().apply(target));
        output += this.Micro$Targeting$TargetScoring$$add((JFunction0$mcD$sp & scala.Serializable)() -> 6.0, (Terran$.MODULE$.WraithCloak().apply() || With$.MODULE$.units().existsOurs(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Zerg$.MODULE$.Lurker(), Protoss$.MODULE$.Arbiter(), Protoss$.MODULE$.DarkTemplar()}))) && this.aidsDetection(target));
        output = Math.max(output, BoxesRunTime.unboxToDouble(target.orderTarget().filter((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(TargetScoring$.$anonfun$apply$15(target, x$4))).map((Function1<UnitInfo, Object> & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble(TargetScoring$.$anonfun$apply$16(x$5))).getOrElse((JFunction0$mcD$sp & scala.Serializable)() -> 0.0)));
        return output;
    }

    public boolean aidsDetection(UnitInfo target) {
        return target.unitClass().isDetector() || Terran$.MODULE$.Comsat().apply(target) || Terran$.MODULE$.Academy().apply(target) && !With$.MODULE$.units().existsEnemy(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Terran$.MODULE$.Comsat(), Terran$.MODULE$.ScienceVessel(), Terran$.MODULE$.ScienceFacility()})) || Terran$.MODULE$.EngineeringBay().apply(target) && !With$.MODULE$.units().existsEnemy(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Terran$.MODULE$.Comsat(), Terran$.MODULE$.ScienceVessel(), Terran$.MODULE$.ScienceFacility(), Terran$.MODULE$.MissileTurret()})) || Protoss$.MODULE$.RoboticsFacility().apply(target) && !With$.MODULE$.units().existsEnemy(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Protoss$.MODULE$.Observer()})) || Protoss$.MODULE$.Forge().apply(target) && !With$.MODULE$.units().existsEnemy(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Protoss$.MODULE$.Observer(), Protoss$.MODULE$.Observatory(), Protoss$.MODULE$.PhotonCannon()})) || Zerg$.MODULE$.CreepColony().apply(target) && With$.MODULE$.units().existsEverEnemy(Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{Zerg$.MODULE$.SporeColony(), Zerg$.MODULE$.EvolutionChamber()}));
    }

    public double Micro$Targeting$TargetScoring$$add(Function0<Object> value, boolean predicate) {
        return BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(predicate, value, (JFunction0$mcD$sp & scala.Serializable)() -> 0.0));
    }

    public double Micro$Targeting$TargetScoring$$mult(Function0<Object> value, boolean predicate) {
        return BoxesRunTime.unboxToDouble($qmark$.MODULE$.apply(predicate, value, (JFunction0$mcD$sp & scala.Serializable)() -> 1.0));
    }

    public static final /* synthetic */ boolean $anonfun$slow$3(FriendlyUnitInfo attacker$1, UnitInfo u) {
        return attacker$1.canAttack(u) && u.isEnemy();
    }

    public static final /* synthetic */ int $anonfun$slow$2(FriendlyUnitInfo attacker$1, Tile x$1) {
        return x$1.units().count((Function1<UnitInfo, Object> & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean(TargetScoring$.$anonfun$slow$3(attacker$1, u)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(UnitInfo t) {
        return t.isFriendly() && t.flying() && t.attacksAgainstGround() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$apply$15(UnitInfo target$2, UnitInfo x$4) {
        return target$2.repairing() && !x$4.repairing();
    }

    public static final /* synthetic */ double $anonfun$apply$16(UnitInfo x$5) {
        return 2.5 + x$5.targetValue();
    }

    private TargetScoring$() {
        MODULE$ = this;
        this.Micro$Targeting$TargetScoring$$combatBonus = 8.0;
    }
}

