/*
 * Decompiled with CFR 0.152.
 */
package jps;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import jps.Graph;
import jps.JPSDiagAlways;
import jps.JPSDiagNever;
import jps.JPSDiagNoObstacles;
import jps.JPSDiagOneObstacle;
import jps.Node;

public abstract class JPS<T extends Node> {
    protected final Graph<T> graph;

    public JPS(Graph<T> graph) {
        this.graph = graph;
    }

    public Future<Queue<T>> findPath(T start, T goal) {
        return this.findPath(start, goal, false, false);
    }

    public Future<Queue<T>> findPath(T start, T goal, boolean adjacentStop) {
        return this.findPath(start, goal, adjacentStop, true);
    }

    public Future<Queue<T>> findPath(T start, T goal, boolean adjacentStop, boolean diagonalStop) {
        FutureTask<Queue<T>> future = new FutureTask<Queue<T>>(() -> this.findPathSync(start, goal, adjacentStop, diagonalStop));
        future.run();
        return future;
    }

    public Queue<T> findPathSync(T start, T goal) {
        return this.findPathSync(start, goal, false, false);
    }

    public Queue<T> findPathSync(T start, T goal, boolean adjacentStop) {
        return this.findPathSync(start, goal, adjacentStop, true);
    }

    public Queue<T> findPathSync(T start, T goal, boolean adjacentStop, boolean diagonalStop) {
        HashMap fMap = new HashMap();
        HashMap gMap = new HashMap();
        HashMap hMap = new HashMap();
        PriorityQueue<T> open = new PriorityQueue<T>((a, b) -> Double.compare(fMap.getOrDefault(a, 0.0), fMap.getOrDefault(b, 0.0)));
        HashSet<Node> closed = new HashSet<Node>();
        HashMap parentMap = new HashMap();
        Set<T> goals = new HashSet<T>();
        if (adjacentStop) {
            goals = !diagonalStop ? this.graph.getNeighborsOf(goal, Graph.Diagonal.NEVER) : this.findNeighbors(goal, parentMap);
        }
        if (((Node)goal).isWalkable()) {
            goals.add(goal);
        }
        if (goals.isEmpty()) {
            return null;
        }
        System.out.println("Start: " + ((Node)start).x + "," + ((Node)start).y);
        open.add(start);
        while (!open.isEmpty()) {
            Node node = (Node)open.poll();
            closed.add(node);
            if (goals.contains(node)) {
                return this.backtrace(node, parentMap);
            }
            this.identifySuccessors(node, goal, goals, open, closed, parentMap, fMap, gMap, hMap);
        }
        return null;
    }

    private void identifySuccessors(T node, T goal, Set<T> goals, Queue<T> open, Set<T> closed, Map<T, T> parentMap, Map<T, Double> fMap, Map<T, Double> gMap, Map<T, Double> hMap) {
        Set<T> neighbors = this.findNeighbors(node, parentMap);
        for (Node neighbor : neighbors) {
            Node jumpNode = this.jump(neighbor, node, goals);
            if (jumpNode == null || closed.contains(jumpNode)) continue;
            double d = this.graph.getDistance(jumpNode, (Node)node);
            double ng = gMap.getOrDefault(node, 0.0) + d;
            if (open.contains(jumpNode) && !(ng < gMap.getOrDefault(jumpNode, 0.0))) continue;
            gMap.put(jumpNode, ng);
            hMap.put(jumpNode, this.graph.getHeuristicDistance(jumpNode, (Node)goal));
            fMap.put(jumpNode, gMap.getOrDefault(jumpNode, 0.0) + hMap.getOrDefault(jumpNode, 0.0));
            parentMap.put(jumpNode, node);
            if (open.contains(jumpNode)) continue;
            open.offer(jumpNode);
        }
    }

    protected abstract Set<T> findNeighbors(T var1, Map<T, T> var2);

    protected abstract T jump(T var1, T var2, Set<T> var3);

    private Queue<T> backtrace(T node, Map<T, T> parentMap) {
        LinkedList<T> path = new LinkedList<T>();
        path.add(node);
        while (parentMap.containsKey(node)) {
            int previousX = ((Node)parentMap.get(node)).x;
            int previousY = ((Node)parentMap.get(node)).y;
            int currentX = ((Node)node).x;
            int currentY = ((Node)node).y;
            int steps = Integer.max(Math.abs(previousX - currentX), Math.abs(previousY - currentY));
            int dx = Integer.compare(previousX, currentX);
            int dy = Integer.compare(previousY, currentY);
            T temp = node;
            for (int i = 0; i < steps; ++i) {
                temp = this.graph.getNode(((Node)temp).x + dx, ((Node)temp).y + dy);
                path.addFirst(temp);
            }
            node = (Node)parentMap.get(node);
        }
        return path;
    }

    public static class JPSFactory {
        public static <T extends Node> JPS<T> getJPS(Graph<T> graph, Graph.Diagonal diagonal) {
            switch (diagonal) {
                case ALWAYS: {
                    return new JPSDiagAlways<T>(graph);
                }
                case ONE_OBSTACLE: {
                    return new JPSDiagOneObstacle<T>(graph);
                }
                case NO_OBSTACLES: {
                    return new JPSDiagNoObstacles<T>(graph);
                }
                case NEVER: {
                    return new JPSDiagNever<T>(graph);
                }
            }
            return null;
        }
    }
}

