/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.Game;
import bwapi.TilePosition;
import bwapi.WalkPosition;
import bwem.MapData;
import bwem.MiniTile;
import bwem.Tile;
import bwem.TileData;
import bwem.util.CheckMode;
import java.util.ArrayList;

public final class TerrainData {
    private final MapData mapData;
    private final TileData tileData;

    TerrainData(MapData mapData, TileData tileData) {
        this.mapData = mapData;
        this.tileData = tileData;
    }

    public MapData getMapData() {
        return this.mapData;
    }

    public TileData getTileData() {
        return this.tileData;
    }

    public Tile getTile(TilePosition tilePosition, CheckMode checkMode) {
        if (checkMode != CheckMode.NO_CHECK && !this.getMapData().isValid(tilePosition)) {
            this.tileData.asserter.throwIllegalStateException("");
        }
        return this.getTileData().getTile(this.getMapData().getTileSize().getX() * tilePosition.getY() + tilePosition.getX());
    }

    public Tile getTile(TilePosition tilePosition) {
        return this.getTile(tilePosition, CheckMode.CHECK);
    }

    public MiniTile getMiniTile(WalkPosition walkPosition, CheckMode checkMode) {
        if (checkMode != CheckMode.NO_CHECK && !this.getMapData().isValid(walkPosition)) {
            this.tileData.asserter.throwIllegalStateException("");
        }
        return this.getTileData().getMiniTile(this.getMapData().getWalkSize().getX() * walkPosition.getY() + walkPosition.getX());
    }

    public MiniTile getMiniTile(WalkPosition walkPosition) {
        return this.getMiniTile(walkPosition, CheckMode.CHECK);
    }

    boolean isSeaWithNonSeaNeighbors(WalkPosition walkPosition) {
        WalkPosition[] deltas;
        if (!this.getMiniTile(walkPosition).isSea()) {
            return false;
        }
        for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
            WalkPosition walkPositionDelta = walkPosition.add(delta);
            if (!this.getMapData().isValid(walkPositionDelta) || this.getMiniTile(walkPositionDelta, CheckMode.NO_CHECK).isSea()) continue;
            return true;
        }
        return false;
    }

    void markUnwalkableMiniTiles(Game game) {
        for (int y = 0; y < this.getMapData().getWalkSize().getY(); ++y) {
            for (int x = 0; x < this.getMapData().getWalkSize().getX(); ++x) {
                if (game.isWalkable(x, y)) continue;
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dx = -1; dx <= 1; ++dx) {
                        WalkPosition walkPosition = new WalkPosition(x + dx, y + dy);
                        if (!this.getMapData().isValid(walkPosition)) continue;
                        this.getMiniTile(walkPosition, CheckMode.NO_CHECK).setWalkable(false);
                    }
                }
            }
        }
    }

    void markBuildableTilesAndGroundHeight(Game game) {
        for (int y = 0; y < this.getMapData().getTileSize().getY(); ++y) {
            for (int x = 0; x < this.getMapData().getTileSize().getX(); ++x) {
                TilePosition tilePosition = new TilePosition(x, y);
                WalkPosition walkPosition = tilePosition.toWalkPosition();
                Tile tile = this.getTile(tilePosition);
                if (game.isBuildable(tilePosition, false)) {
                    tile.setBuildable();
                    for (int dy = 0; dy < 4; ++dy) {
                        for (int dx = 0; dx < 4; ++dx) {
                            this.getMiniTile(walkPosition.add(new WalkPosition(dx, dy)), CheckMode.NO_CHECK).setWalkable(true);
                        }
                    }
                }
                int bwapiGroundHeight = game.getGroundHeight(tilePosition);
                tile.setGroundHeight(bwapiGroundHeight / 2);
                if (bwapiGroundHeight % 2 == 0) continue;
                tile.setDoodad();
            }
        }
    }

    void decideSeasOrLakes() {
        for (int y = 0; y < this.getMapData().getWalkSize().getY(); ++y) {
            for (int x = 0; x < this.getMapData().getWalkSize().getX(); ++x) {
                WalkPosition originWalkPosition = new WalkPosition(x, y);
                MiniTile originMiniTile = this.getMiniTile(originWalkPosition, CheckMode.NO_CHECK);
                if (!originMiniTile.isSeaOrLake()) continue;
                ArrayList<WalkPosition> toSearch = new ArrayList<WalkPosition>();
                toSearch.add(originWalkPosition);
                ArrayList<MiniTile> seaExtent = new ArrayList<MiniTile>();
                originMiniTile.setSea();
                seaExtent.add(originMiniTile);
                int topLeftX = originWalkPosition.getX();
                int topLeftY = originWalkPosition.getY();
                int bottomRightX = originWalkPosition.getX();
                int bottomRightY = originWalkPosition.getY();
                while (!toSearch.isEmpty()) {
                    WalkPosition[] deltas;
                    WalkPosition current = (WalkPosition)toSearch.remove(toSearch.size() - 1);
                    if (current.getX() < topLeftX) {
                        topLeftX = current.getX();
                    }
                    if (current.getY() < topLeftY) {
                        topLeftY = current.getY();
                    }
                    if (current.getX() > bottomRightX) {
                        bottomRightX = current.getX();
                    }
                    if (current.getY() > bottomRightY) {
                        bottomRightY = current.getY();
                    }
                    for (WalkPosition delta : deltas = new WalkPosition[]{new WalkPosition(0, -1), new WalkPosition(-1, 0), new WalkPosition(1, 0), new WalkPosition(0, 1)}) {
                        MiniTile nextMiniTile;
                        WalkPosition nextWalkPosition = current.add(delta);
                        if (!this.getMapData().isValid(nextWalkPosition) || !(nextMiniTile = this.getMiniTile(nextWalkPosition, CheckMode.NO_CHECK)).isSeaOrLake()) continue;
                        toSearch.add(nextWalkPosition);
                        if (seaExtent.size() <= 300) {
                            seaExtent.add(nextMiniTile);
                        }
                        nextMiniTile.setSea();
                    }
                }
                if (seaExtent.size() > 300 || bottomRightX - topLeftX > 32 || bottomRightY - topLeftY > 32 || topLeftX < 2 || topLeftY < 2 || bottomRightX >= this.getMapData().getWalkSize().getX() - 2 || bottomRightY >= this.getMapData().getWalkSize().getY() - 2) continue;
                for (MiniTile miniTile : seaExtent) {
                    miniTile.setLake();
                }
            }
        }
    }
}

