/*
 * Decompiled with CFR 0.152.
 */
package Tactic.Missions;

import Information.Geography.Types.Base;
import Information.Geography.Types.Metro;
import Lifecycle.With$;
import Mathematics.Maff$;
import Planning.ResourceLocks.LockUnits;
import Planning.ResourceLocks.LockUnits$;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.UnitClasses.UnitClass;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Tactic.Missions.Mission;
import Tactic.Squads.Squad;
import Tactic.Squads.SquadAutomation$;
import Utilities.Time.Minutes;
import Utilities.UnitCounters.CountExactly;
import Utilities.UnitFilters.IsAll;
import Utilities.UnitFilters.IsAntiGround$;
import Utilities.UnitFilters.IsMobileDetector$;
import Utilities.UnitFilters.IsWarrior$;
import Utilities.UnitFilters.UnitFilter;
import Utilities.UnitPreferences.PreferClose;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0005\n\u0001/!)!\u0005\u0001C\u0001G!)Q\u0005\u0001C\u0001M!)q\b\u0001C\u0001\u0001\")Q\t\u0001C!\r\"9!\n\u0001a\u0001\n\u0003Y\u0005bB(\u0001\u0001\u0004%\t\u0001\u0015\u0005\u0007-\u0002\u0001\u000b\u0015\u0002'\t\u000f]\u0003!\u0019!C\u00011\"1\u0011\r\u0001Q\u0001\neCQA\u0019\u0001\u0005B\rDQ\u0001\u001a\u0001\u0005\n\u0015DQ\u0001\u001b\u0001\u0005\n%DQa\u001b\u0001\u0005\n1DQa\u001b\u0001\u0005\n9DQa\u001c\u0001\u0005\n\u0019CQ\u0001\u001d\u0001\u0005B\r\u0014A#T5tg&|gnS5mY\u0016C\b/\u00198tS>t'BA\n\u0015\u0003!i\u0015n]:j_:\u001c(\"A\u000b\u0002\rQ\u000b7\r^5d\u0007\u0001\u00192\u0001\u0001\r\u001f!\tIB$D\u0001\u001b\u0015\tYB#\u0001\u0004TcV\fGm]\u0005\u0003;i\u0011QaU9vC\u0012\u0004\"a\b\u0011\u000e\u0003II!!\t\n\u0003\u000f5K7o]5p]\u00061A(\u001b8jiz\"\u0012\u0001\n\t\u0003?\u0001\t\u0001\"\u001a7jO&\u0014G.Z\u000b\u0002OA\u0019\u0001FM\u001b\u000f\u0005%zcB\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0017\u0003\u0019a$o\\8u}%\ta&A\u0003tG\u0006d\u0017-\u0003\u00021c\u00059\u0001/Y2lC\u001e,'\"\u0001\u0018\n\u0005M\"$aA*fc*\u0011\u0001'\r\t\u0003muj\u0011a\u000e\u0006\u0003qe\nQ\u0001V=qKNT!AO\u001e\u0002\u0013\u001d+wn\u001a:ba\"L(\"\u0001\u001f\u0002\u0017%sgm\u001c:nCRLwN\\\u0005\u0003}]\u0012AAQ1tK\u0006!!-Z:u+\u0005\t\u0005c\u0001\"Dk5\t\u0011'\u0003\u0002Ec\t1q\n\u001d;j_:\f!b\u001d5pk2$gi\u001c:n+\u00059\u0005C\u0001\"I\u0013\tI\u0015GA\u0004C_>dW-\u00198\u0002\u001f1\f7\u000f\u001e$sC6,\u0017J\u001c\"bg\u0016,\u0012\u0001\u0014\t\u0003\u00056K!AT\u0019\u0003\u0007%sG/A\nmCN$hI]1nK&s')Y:f?\u0012*\u0017\u000f\u0006\u0002R)B\u0011!IU\u0005\u0003'F\u0012A!\u00168ji\"9QKBA\u0001\u0002\u0004a\u0015a\u0001=%c\u0005\u0001B.Y:u\rJ\fW.Z%o\u0005\u0006\u001cX\rI\u0001\rI\u0016$Xm\u0019;pe2{7m[\u000b\u00023B\u0011!lX\u0007\u00027*\u0011A,X\u0001\u000e%\u0016\u001cx.\u001e:dK2{7m[:\u000b\u0003y\u000b\u0001\u0002\u00157b]:LgnZ\u0005\u0003An\u0013\u0011\u0002T8dWVs\u0017\u000e^:\u0002\u001b\u0011,G/Z2u_JdunY6!\u0003\u001d\u0011Xm\u0019:vSR$\u0012!U\u0001\u0010E\u0006\u001cXMR1s\rJ|W.T1j]R\u0011qI\u001a\u0005\u0006O.\u0001\r!N\u0001\u0005E\u0006\u001cX-A\ncCN,7\t\\8tKJ$vnT;s\u0003Jl\u0017\u0010\u0006\u0002HU\")q\r\u0004a\u0001k\u0005iQO\\5ugJ+\u0017/^5sK\u0012$\"\u0001T7\t\u000b\u001dl\u0001\u0019A\u001b\u0015\u00031\u000bQ\"\u001a8pk\u001eD7*\u001b7mKJ\u001c\u0018a\u0001:v]\u0002")
public class MissionKillExpansion
extends Squad
implements Mission {
    private int lastFrameInBase;
    private final LockUnits detectorLock;
    private boolean launched;
    private int launchFrame;

    @Override
    public void reset() {
        Mission.reset$(this);
    }

    @Override
    public void onRun() {
        Mission.onRun$(this);
    }

    @Override
    public final int duration() {
        return Mission.duration$(this);
    }

    @Override
    public final void launch() {
        Mission.launch$(this);
    }

    @Override
    public final void terminate(String reason) {
        Mission.terminate$(this, reason);
    }

    @Override
    public final String terminate$default$1() {
        return Mission.terminate$default$1$(this);
    }

    @Override
    public boolean launched() {
        return this.launched;
    }

    @Override
    public void launched_$eq(boolean x$1) {
        this.launched = x$1;
    }

    @Override
    public int launchFrame() {
        return this.launchFrame;
    }

    @Override
    public void launchFrame_$eq(int x$1) {
        this.launchFrame = x$1;
    }

    public Seq<Base> eligible() {
        return (Seq)With$.MODULE$.geography().bases().filter((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)MissionKillExpansion.$anonfun$eligible$1(this, b)));
    }

    public Option<Base> best() {
        return Maff$.MODULE$.maxBy(this.eligible(), (Function1 & Serializable & scala.Serializable)base -> BoxesRunTime.boxToDouble((double)MissionKillExpansion.$anonfun$best$1(base)), Ordering.Double$.MODULE$);
    }

    @Override
    public boolean shouldForm() {
        return BoxesRunTime.unboxToBoolean((Object)With$.MODULE$.blackboard().wantToAttack().apply()) && With$.MODULE$.scouting().ourProximity() < 0.5 && this.eligible().nonEmpty() && With$.MODULE$.recruiter().available().count((Function1)this.lock().matcher()) >= 20;
    }

    public int lastFrameInBase() {
        return this.lastFrameInBase;
    }

    public void lastFrameInBase_$eq(int x$1) {
        this.lastFrameInBase = x$1;
    }

    public LockUnits detectorLock() {
        return this.detectorLock;
    }

    @Override
    public void recruit() {
        Option<Base> targetBase = this.best();
        if (targetBase.isEmpty()) {
            this.terminate("No target base available");
            return;
        }
        this.vicinity_$eq(((Base)targetBase.get()).heart().center());
        this.lock().setCounter(new CountExactly(this.unitsRequired((Base)targetBase.get()))).setPreference(new PreferClose(this.vicinity())).acquire();
    }

    private boolean baseFarFromMain(Base base) {
        return With$.MODULE$.scouting().enemyMain().forall((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)MissionKillExpansion.$anonfun$baseFarFromMain$1(base, b)));
    }

    private boolean baseCloserToOurArmy(Base base) {
        return base.heart().groundPixels(With$.MODULE$.scouting().ourMuscleOrigin()) + (double)320 < base.heart().groundPixels(With$.MODULE$.scouting().enemyThreatOrigin());
    }

    private int unitsRequired(Base base) {
        return Math.max(4, base.enemies().view().count((Function1 & Serializable & scala.Serializable)u -> BoxesRunTime.boxToBoolean((boolean)MissionKillExpansion.$anonfun$unitsRequired$1(u))) * 3);
    }

    private int unitsRequired() {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.option2Iterable(this.vicinity().base().map((Function1 & Serializable & scala.Serializable)base -> BoxesRunTime.boxToInteger((int)this.unitsRequired(base)))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    private boolean enoughKillers() {
        return Maff$.MODULE$.orElse(Predef$.MODULE$.wrapRefArray((Object[])new Iterable[]{this.units(), (Iterable)With$.MODULE$.recruiter().available().filter((Function1)IsWarrior$.MODULE$)})).size() >= this.unitsRequired();
    }

    @Override
    public void run() {
        if (this.vicinity().base().exists((Function1 & Serializable & scala.Serializable)b -> BoxesRunTime.boxToBoolean((boolean)MissionKillExpansion.$anonfun$run$1(this, b)))) {
            this.lastFrameInBase_$eq(With$.MODULE$.frame());
        }
        if (this.duration() > new Minutes(3).apply()) {
            this.terminate("Exceeded duration");
            return;
        }
        if (With$.MODULE$.framesSince(Math.max(this.launchFrame(), this.lastFrameInBase())) > new Minutes(1).apply()) {
            this.terminate("Left base or never made it in");
            return;
        }
        if (!this.vicinity().base().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isEnemy()))) {
            this.terminate("Vicinity not an eligible base");
            return;
        }
        if (!this.enoughKillers()) {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)this.units().size());
            Integer arg$macro$2 = BoxesRunTime.boxToInteger((int)this.unitsRequired());
            this.terminate(new StringOps("Not enough fighters: %s vs %s ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2})));
            return;
        }
        if (With$.MODULE$.unitsShown().any((Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Terran$.MODULE$.Wraith(), Terran$.MODULE$.Ghost(), Terran$.MODULE$.SpiderMine(), Terran$.MODULE$.Vulture(), Protoss$.MODULE$.Arbiter(), Protoss$.MODULE$.DarkTemplar(), Zerg$.MODULE$.Lurker(), Zerg$.MODULE$.LurkerEgg()})) || With$.MODULE$.enemies().exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.hasTech(Zerg$.MODULE$.Burrow())))) {
            this.detectorLock().setPreference(new PreferClose(this.vicinity())).acquire();
        }
        SquadAutomation$.MODULE$.targetRaid(this);
        SquadAutomation$.MODULE$.formAndSend(this);
        this.units().foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.intent().setCanSneak(true));
    }

    public static final /* synthetic */ boolean $anonfun$eligible$1(MissionKillExpansion $this, Base b) {
        return b.isEnemy() && $this.baseFarFromMain(b) && $this.baseCloserToOurArmy(b);
    }

    public static final /* synthetic */ double $anonfun$best$1(Base base) {
        return (double)2 * base.heart().groundPixels(With$.MODULE$.scouting().enemyThreatOrigin()) - base.heart().groundPixels(With$.MODULE$.scouting().ourMuscleOrigin());
    }

    public static final /* synthetic */ boolean $anonfun$baseFarFromMain$1(Base base$1, Base b) {
        Metro metro = b.metro();
        Metro metro2 = base$1.metro();
        return (metro == null ? metro2 != null : !metro.equals(metro2)) && !b.natural().contains((Object)base$1);
    }

    public static final /* synthetic */ boolean $anonfun$unitsRequired$1(UnitInfo u) {
        return u.canAttack() && !u.unitClass().isWorker();
    }

    public static final /* synthetic */ boolean $anonfun$run$2(Base b$1, FriendlyUnitInfo x$1) {
        return x$1.base().contains((Object)b$1);
    }

    public static final /* synthetic */ boolean $anonfun$run$1(MissionKillExpansion $this, Base b) {
        return $this.units().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MissionKillExpansion.$anonfun$run$2(b, x$1)));
    }

    public MissionKillExpansion() {
        Mission.$init$(this);
        this.lastFrameInBase = 0;
        this.lock().matcher_$eq(new IsAll((Seq<UnitFilter>)Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{IsWarrior$.MODULE$, IsAntiGround$.MODULE$})));
        this.detectorLock = new LockUnits(this, IsMobileDetector$.MODULE$, LockUnits$.MODULE$.$lessinit$greater$default$3(), LockUnits$.MODULE$.$lessinit$greater$default$4(), LockUnits$.MODULE$.$lessinit$greater$default$5()).setCounter(new CountExactly(1));
    }
}

