/*
 * Decompiled with CFR 0.152.
 */
package Placement.Walls;

import Information.Geography.Types.Edge;
import Information.Geography.Types.Zone;
import Lifecycle.With$;
import Mathematics.Points.Tile;
import Placement.Walls.Wall;
import Placement.Walls.WallCache;
import Placement.Walls.WallConstraint;
import Placement.Walls.WallSpans$TerrainGas$;
import Placement.Walls.WallSpans$TerrainHall$;
import Placement.Walls.WallSpans$TerrainTerrain$;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.UnitClasses.UnitClass;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class WallDesigner$ {
    public static WallDesigner$ MODULE$;

    static {
        new WallDesigner$();
    }

    public Option<Wall> apply(Zone zone) {
        if (With$.MODULE$.self().isProtoss()) {
            return this.protoss(zone);
        }
        if (With$.MODULE$.self().isTerran()) {
            return this.terran(zone);
        }
        return this.zerg(zone);
    }

    public Option<Wall> terran(Zone zone) {
        return None$.MODULE$;
    }

    public Option<Wall> zerg(Zone zone) {
        return None$.MODULE$;
    }

    public Option<Wall> protoss(Zone zone) {
        Option<Edge> exit = zone.exitOriginal();
        if (exit.isEmpty()) {
            return None$.MODULE$;
        }
        Tile entrance = (Tile)zone.entranceOriginal().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.pixelCenter().tile()).getOrElse((Function0 & Serializable & scala.Serializable)() -> zone.heart());
        Vector constraints = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new WallConstraint[]{new WallConstraint(1, Zerg$.MODULE$.Zergling(), WallSpans$TerrainTerrain$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Zerg$.MODULE$.Hydralisk(), WallSpans$TerrainTerrain$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Protoss$.MODULE$.Dragoon(), WallSpans$TerrainTerrain$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Protoss$.MODULE$.Dragoon(), WallSpans$TerrainTerrain$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge(), Protoss$.MODULE$.Pylon()})), new WallConstraint(2, Protoss$.MODULE$.Dragoon(), WallSpans$TerrainTerrain$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge(), Protoss$.MODULE$.Pylon()})), new WallConstraint(1, Zerg$.MODULE$.Zergling(), WallSpans$TerrainGas$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Zerg$.MODULE$.Hydralisk(), WallSpans$TerrainGas$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Zerg$.MODULE$.Hydralisk(), WallSpans$TerrainGas$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge(), Protoss$.MODULE$.Pylon()})), new WallConstraint(1, Zerg$.MODULE$.Zergling(), WallSpans$TerrainHall$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Zerg$.MODULE$.Hydralisk(), WallSpans$TerrainHall$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge()})), new WallConstraint(1, Zerg$.MODULE$.Hydralisk(), WallSpans$TerrainHall$.MODULE$, (Seq<UnitClass>)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Gateway(), Protoss$.MODULE$.Forge(), Protoss$.MODULE$.Pylon()}))}));
        WallCache cache = new WallCache(zone, (Edge)exit.get(), entrance, (Seq<WallConstraint>)constraints, (Seq<UnitClass>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UnitClass[]{Protoss$.MODULE$.Pylon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon(), Protoss$.MODULE$.PhotonCannon()}))));
        Option<Wall> wall = cache.generate();
        String arg$macro$2 = wall.isDefined() ? "CREATED WALL" : "FAILED to create wall";
        With$.MODULE$.logger().debug(new StringOps("%s: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{zone, arg$macro$2})));
        if (wall.isDefined()) {
            WallConstraint arg$macro$3 = ((Wall)wall.get()).constraint();
            With$.MODULE$.logger().debug(new StringOps("Constraints:              %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$3})));
            Integer arg$macro$4 = BoxesRunTime.boxToInteger((int)cache.metricAcceptableWalls());
            With$.MODULE$.logger().debug(new StringOps("Acceptable walls:         %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$4})));
        }
        Integer arg$macro$5 = BoxesRunTime.boxToInteger((int)cache.metricPermutations());
        With$.MODULE$.logger().debug(new StringOps("Permutations:             %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$5})));
        Integer arg$macro$6 = BoxesRunTime.boxToInteger((int)cache.metricTilesConsidered());
        With$.MODULE$.logger().debug(new StringOps("Tiles considered:         %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$6})));
        Integer arg$macro$7 = BoxesRunTime.boxToInteger((int)cache.metricUnbuildableTerrain());
        With$.MODULE$.logger().debug(new StringOps("Unbuildable (Terrain):    %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$7})));
        Integer arg$macro$8 = BoxesRunTime.boxToInteger((int)cache.metricUnbuildableGranular());
        With$.MODULE$.logger().debug(new StringOps("Unbuildable (Granular):   %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$8})));
        Integer arg$macro$9 = BoxesRunTime.boxToInteger((int)cache.metricIntersectsPrevious());
        With$.MODULE$.logger().debug(new StringOps("Intersection (Previous):  %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$9})));
        Integer arg$macro$10 = BoxesRunTime.boxToInteger((int)cache.metricIntersectsHall());
        With$.MODULE$.logger().debug(new StringOps("Intersection (Hall):      %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$10})));
        Integer arg$macro$11 = BoxesRunTime.boxToInteger((int)cache.metricWrongZone());
        With$.MODULE$.logger().debug(new StringOps("Wrong zone:               %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$11})));
        Integer arg$macro$12 = BoxesRunTime.boxToInteger((int)cache.metricInsufficientlyTight());
        With$.MODULE$.logger().debug(new StringOps("Insufficiently tight:     %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$12})));
        Integer arg$macro$13 = BoxesRunTime.boxToInteger((int)cache.metricGapTooNarrow());
        With$.MODULE$.logger().debug(new StringOps("Gap too narrow:           %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$13})));
        Integer arg$macro$14 = BoxesRunTime.boxToInteger((int)cache.metricGapTooWide());
        With$.MODULE$.logger().debug(new StringOps("Gap too wide:             %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$14})));
        Integer arg$macro$15 = BoxesRunTime.boxToInteger((int)cache.metricFailedRecursively());
        With$.MODULE$.logger().debug(new StringOps("Failed recursively:       %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$15})));
        With$.MODULE$.logger().debug("");
        return wall;
    }

    private WallDesigner$() {
        MODULE$ = this;
    }
}

