/*
 * Decompiled with CFR 0.152.
 */
package Micro.Heuristics;

import Mathematics.Maff$;
import Mathematics.Physics.Force;
import Mathematics.Physics.ForceMath$;
import Mathematics.Physics.Forces$;
import Mathematics.Points.Pixel;
import Micro.Coordination.Pathing.MicroPathing$;
import ProxyBwapi.UnitInfo.FriendlyUnitInfo;
import ProxyBwapi.UnitInfo.UnitInfo;
import Tactic.Squads.UnitGroup;
import Utilities.$qmark$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyInt;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

public final class Potential$ {
    public static Potential$ MODULE$;

    static {
        new Potential$();
    }

    public Force towards(FriendlyUnitInfo unit, Pixel goal) {
        return ForceMath$.MODULE$.fromPixels(unit.pixel(), MicroPathing$.MODULE$.getWaypointToPixel(unit, goal), ForceMath$.MODULE$.fromPixels$default$3());
    }

    public Force towardsUnitCustom(FriendlyUnitInfo unit, UnitInfo other, Function2<UnitInfo, UnitInfo, Object> magnifier) {
        return this.towardsUnit(unit, other, BoxesRunTime.unboxToDouble((Object)magnifier.apply((Object)unit, (Object)other)));
    }

    public Force towardsUnit(FriendlyUnitInfo unit, UnitInfo other, double magnitude) {
        return ForceMath$.MODULE$.fromPixels(unit.pixel(), other.pixel().nearestTraversablePixel(unit), magnitude);
    }

    public Function2<UnitInfo, UnitInfo, Object> towardsUnitCustom$default$3() {
        return (Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToDouble((double)Potential$.$anonfun$towardsUnitCustom$default$3$1(a, b));
    }

    public double towardsUnit$default$3() {
        return 1.0;
    }

    public Force towardsDestination(FriendlyUnitInfo unit) {
        return this.towards(unit, unit.agent().destinationNext().apply());
    }

    public Force towardsTarget(FriendlyUnitInfo unit) {
        Pixel target = (Pixel)unit.agent().choosePerch().pixel().getOrElse((Function0 & Serializable & scala.Serializable)() -> unit.agent().destinationNext().apply());
        double distance = unit.pixelDistanceTravelling(target);
        return this.towards(unit, target).normalize(Maff$.MODULE$.clamp(Maff$.MODULE$.nanToInfinity(32.0 / distance), 0.0, 1.0));
    }

    public Force hardAvoid(FriendlyUnitInfo unit, Pixel pixel, double minDistance, double equidistance) {
        return ForceMath$.MODULE$.fromPixels(pixel, unit.pixel(), this.hardScale(unit.pixelDistanceCenter(pixel), minDistance, equidistance, this.hardScale$default$4()));
    }

    public Force hardAvoidEntanglement(FriendlyUnitInfo unit, UnitInfo other, double minDistance, double equidistance) {
        return ForceMath$.MODULE$.fromPixels(other.pixel(), unit.pixel(), this.hardScale(-unit.pixelsOfEntanglement(other), minDistance, equidistance, this.hardScale$default$4()));
    }

    private double hardScale(double distance, double minDistance, double equidistance, double cap) {
        if (distance >= equidistance) {
            return equidistance / distance;
        }
        if (distance > minDistance) {
            return Math.min(cap, (equidistance - minDistance) / (distance - minDistance));
        }
        return cap;
    }

    private double hardScale$default$4() {
        return 1000000.0;
    }

    public Force softAvoidThreatRange(FriendlyUnitInfo unit) {
        return ForceMath$.MODULE$.sum((Traversable<Force>)((Traversable)unit.matchups().threats().map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.threatRepulsion(unit, (UnitInfo)x$1), Seq$.MODULE$.canBuildFrom()))).normalize();
    }

    public Force threatRepulsion(FriendlyUnitInfo unit, UnitInfo threat) {
        double entanglement = unit.pixelsOfEntanglement(threat);
        double magnitudeEntanglement = 1.0 + Maff$.MODULE$.fastTanh11(entanglement * Maff$.MODULE$.inv32()) + Math.max(0.0, entanglement * Maff$.MODULE$.inv32());
        double magnitudeFinal = threat.dpfOnNextHitAgainst(unit) * magnitudeEntanglement;
        return this.towardsUnit(unit, threat, -magnitudeFinal);
    }

    public Force hardAvoidThreatRange(FriendlyUnitInfo unit, double margin) {
        return (Force)unit.matchups().threatDeepest().map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.hardAvoidEntanglement(unit, (UnitInfo)x$2, 0.0, margin)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Forces$.MODULE$.None());
    }

    public double hardAvoidThreatRange$default$2() {
        return 32.0;
    }

    public Force avoidDetection(FriendlyUnitInfo unit) {
        if (!unit.cloaked()) {
            return Forces$.MODULE$.None();
        }
        Seq forces = (Seq)((Seq)unit.matchups().enemies().filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$avoidDetection$1(e)))).map((Function1 & Serializable & scala.Serializable)detector -> MODULE$.towardsUnit(unit, (UnitInfo)detector, -1.0 / detector.pixelDistanceCenter(unit)), Seq$.MODULE$.canBuildFrom());
        return ForceMath$.MODULE$.sum((Traversable<Force>)forces).normalize();
    }

    public Force regroup(FriendlyUnitInfo unit) {
        return (Force)unit.squad().orElse((Function0 & Serializable & scala.Serializable)() -> unit.team()).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$regroup$2(x$3))).map((Function1 & Serializable & scala.Serializable)g -> (Pixel)$qmark$.MODULE$.apply(unit.flying(), (Function0 & Serializable & scala.Serializable)() -> g.centroidKey(), (Function0 & Serializable & scala.Serializable)() -> g.centroidGround())).map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.towards(unit, (Pixel)x$4)).getOrElse((Function0 & Serializable & scala.Serializable)() -> Forces$.MODULE$.None());
    }

    private double collisionRepulsionMagnitude(FriendlyUnitInfo unit, UnitInfo other, double margin) {
        if (unit.flying()) {
            return 0.0;
        }
        if (other.flying()) {
            return 0.0;
        }
        if (other.velocity().lengthSquared() < 0.01) {
            return 0.0;
        }
        if (other.topSpeed() >= unit.topSpeed() && other.speedApproaching(unit) < 0.0) {
            return 0.0;
        }
        return 1.0 - Maff$.MODULE$.clamp(other.pixelDistanceEdge(unit) / margin, 0.0, 1.0);
    }

    public Force collisionRepulsion(FriendlyUnitInfo unit, UnitInfo other) {
        double magnitude = this.collisionRepulsionMagnitude(unit, other, 16.0);
        if (magnitude == 0.0) {
            return Forces$.MODULE$.None();
        }
        return this.towardsUnit(unit, other, -magnitude);
    }

    public Force avoidCollision(FriendlyUnitInfo unit) {
        if (unit.flying()) {
            return Forces$.MODULE$.None();
        }
        Traversable repulsions = (Traversable)((TraversableLike)unit.inTileRadius(3).filter((Function1 & Serializable & scala.Serializable)o -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$avoidCollision$1(unit, o)))).map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.collisionRepulsion(unit, (UnitInfo)x$5), Traversable$.MODULE$.canBuildFrom());
        return ForceMath$.MODULE$.mean((Traversable<Force>)repulsions).clipAtMost(1.0);
    }

    public Force avoidSplash(FriendlyUnitInfo unit) {
        LazyInt splashRadius25$lzy = new LazyInt();
        LazyInt splashRadius50$lzy = new LazyInt();
        LazyRef splashAllies$lzy = new LazyRef();
        int margin = 96;
        if (unit.matchups().threatDeepest().forall((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$avoidSplash$1(unit, margin, x$6)))) {
            return Forces$.MODULE$.None();
        }
        Vector splashThreats = ((TraversableOnce)((TraversableLike)((TraversableLike)unit.matchups().threats().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$avoidSplash$2(x$7)))).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$avoidSplash$3(unit, margin, x$8)))).filterNot((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)x$9.burrowed()))).toVector();
        if (splashThreats.isEmpty()) {
            return Forces$.MODULE$.None();
        }
        if (Potential$.splashRadius25$1(splashRadius25$lzy, splashThreats, unit) <= 0) {
            return Forces$.MODULE$.None();
        }
        if (Potential$.splashAllies$1(splashAllies$lzy, unit).isEmpty()) {
            return Forces$.MODULE$.None();
        }
        Iterable forces = (Iterable)((TraversableLike)Potential$.splashAllies$1(splashAllies$lzy, unit).map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.pixel(), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.hardAvoid(unit, (Pixel)x$11, Potential$.splashRadius50$1(splashRadius50$lzy, splashThreats, unit), Potential$.splashRadius25$1(splashRadius25$lzy, splashThreats, unit)), Iterable$.MODULE$.canBuildFrom());
        return ForceMath$.MODULE$.sum((Traversable<Force>)forces).normalize(BoxesRunTime.unboxToDouble((Object)((TraversableOnce)forces.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12.lengthFast()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$)));
    }

    public Force preferSpacing(FriendlyUnitInfo unit) {
        Force splashForce = this.avoidSplash(unit);
        if (splashForce.lengthSquared() > 0.0) {
            return splashForce;
        }
        return this.avoidCollision(unit);
    }

    public Force followPushes(FriendlyUnitInfo unit) {
        return unit.agent().receivedPushForce().apply().clipAtMost(1.0);
    }

    public static final /* synthetic */ double $anonfun$towardsUnitCustom$default$3$1(UnitInfo a, UnitInfo b) {
        return 1.0;
    }

    public static final /* synthetic */ boolean $anonfun$avoidDetection$1(UnitInfo e) {
        return e.aliveAndComplete() && e.unitClass().isDetector();
    }

    public static final /* synthetic */ boolean $anonfun$regroup$2(UnitGroup x$3) {
        return x$3.attackers().size() > 1;
    }

    public static final /* synthetic */ boolean $anonfun$avoidCollision$1(FriendlyUnitInfo unit$6, UnitInfo o) {
        FriendlyUnitInfo friendlyUnitInfo = unit$6;
        return (friendlyUnitInfo == null ? o != null : !friendlyUnitInfo.equals(o)) && o.canMove();
    }

    public static final /* synthetic */ boolean $anonfun$avoidSplash$1(FriendlyUnitInfo unit$7, int margin$2, UnitInfo x$6) {
        return x$6.pixelsToGetInRange(unit$7) > (double)margin$2;
    }

    public static final /* synthetic */ boolean $anonfun$avoidSplash$2(UnitInfo x$7) {
        return x$7.unitClass().dealsRadialSplashDamage();
    }

    public static final /* synthetic */ boolean $anonfun$avoidSplash$3(FriendlyUnitInfo unit$7, int margin$2, UnitInfo x$8) {
        return x$8.pixelsToGetInRange(unit$7) < (double)margin$2;
    }

    public static final /* synthetic */ int $anonfun$avoidSplash$5(FriendlyUnitInfo unit$7, UnitInfo t) {
        if (unit$7.flying()) {
            return t.unitClass().airSplashRadius25();
        }
        return t.unitClass().groundSplashRadius25();
    }

    private static final /* synthetic */ int splashRadius25$lzycompute$1(LazyInt splashRadius25$lzy$1, Vector splashThreats$1, FriendlyUnitInfo unit$7) {
        synchronized (splashRadius25$lzy$1) {
            int n = splashRadius25$lzy$1.initialized() ? splashRadius25$lzy$1.value() : splashRadius25$lzy$1.initialize(BoxesRunTime.unboxToInt((Object)Maff$.MODULE$.max((TraversableOnce)splashThreats$1.map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)Potential$.$anonfun$avoidSplash$5(unit$7, t)), Vector$.MODULE$.canBuildFrom()), Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
            return n;
        }
    }

    private static final int splashRadius25$1(LazyInt splashRadius25$lzy$1, Vector splashThreats$1, FriendlyUnitInfo unit$7) {
        if (splashRadius25$lzy$1.initialized()) {
            return splashRadius25$lzy$1.value();
        }
        return Potential$.splashRadius25$lzycompute$1(splashRadius25$lzy$1, splashThreats$1, unit$7);
    }

    public static final /* synthetic */ int $anonfun$avoidSplash$7(FriendlyUnitInfo unit$7, UnitInfo t) {
        if (unit$7.flying()) {
            return t.unitClass().airSplashRadius50();
        }
        return t.unitClass().groundSplashRadius50();
    }

    private static final /* synthetic */ int splashRadius50$lzycompute$1(LazyInt splashRadius50$lzy$1, Vector splashThreats$1, FriendlyUnitInfo unit$7) {
        synchronized (splashRadius50$lzy$1) {
            int n = splashRadius50$lzy$1.initialized() ? splashRadius50$lzy$1.value() : splashRadius50$lzy$1.initialize(BoxesRunTime.unboxToInt((Object)Maff$.MODULE$.max((TraversableOnce)splashThreats$1.map((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToInteger((int)Potential$.$anonfun$avoidSplash$7(unit$7, t)), Vector$.MODULE$.canBuildFrom()), Ordering.Int$.MODULE$).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)));
            return n;
        }
    }

    private static final int splashRadius50$1(LazyInt splashRadius50$lzy$1, Vector splashThreats$1, FriendlyUnitInfo unit$7) {
        if (splashRadius50$lzy$1.initialized()) {
            return splashRadius50$lzy$1.value();
        }
        return Potential$.splashRadius50$lzycompute$1(splashRadius50$lzy$1, splashThreats$1, unit$7);
    }

    public static final /* synthetic */ boolean $anonfun$avoidSplash$9(FriendlyUnitInfo unit$7, FriendlyUnitInfo a) {
        return !a.unitClass().isBuilding() && a.flying() == unit$7.flying();
    }

    private static final /* synthetic */ Iterable splashAllies$lzycompute$1(LazyRef splashAllies$lzy$1, FriendlyUnitInfo unit$7) {
        synchronized (splashAllies$lzy$1) {
            Iterable iterable = splashAllies$lzy$1.initialized() ? (Iterable)splashAllies$lzy$1.value() : (Iterable)splashAllies$lzy$1.initialize(unit$7.alliesBattle().filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)Potential$.$anonfun$avoidSplash$9(unit$7, a))));
            return iterable;
        }
    }

    private static final Iterable splashAllies$1(LazyRef splashAllies$lzy$1, FriendlyUnitInfo unit$7) {
        if (splashAllies$lzy$1.initialized()) {
            return (Iterable)splashAllies$lzy$1.value();
        }
        return Potential$.splashAllies$lzycompute$1(splashAllies$lzy$1, unit$7);
    }

    private Potential$() {
        MODULE$ = this;
    }
}

