/*
 * Decompiled with CFR 0.152.
 */
package Micro.Coordination.Pushing;

import Information.Grids.ArrayTypes.GridBuffer;
import Lifecycle.With$;
import Mathematics.Points.Pixel;
import Mathematics.Points.Tile;
import Micro.Coordination.Pushing.ExplosionEMP;
import Micro.Coordination.Pushing.ExplosionInfestedTerran;
import Micro.Coordination.Pushing.ExplosionIrradiateSplash;
import Micro.Coordination.Pushing.ExplosionLurkerNow;
import Micro.Coordination.Pushing.ExplosionNuke;
import Micro.Coordination.Pushing.ExplosionPsionicStorm;
import Micro.Coordination.Pushing.ExplosionScarab;
import Micro.Coordination.Pushing.ExplosionSpiderMineBlast;
import Micro.Coordination.Pushing.Push;
import ProxyBwapi.Bullets.BulletInfo;
import ProxyBwapi.Players.PlayerInfo;
import ProxyBwapi.Races.Protoss$;
import ProxyBwapi.Races.Terran$;
import ProxyBwapi.Races.Zerg$;
import ProxyBwapi.UnitInfo.UnitInfo;
import Utilities.Time.Minutes;
import Utilities.UnitFilters.IsAll;
import Utilities.UnitFilters.IsVisible$;
import Utilities.UnitFilters.UnitFilter;
import bwapi.BulletType;
import bwapi.Position;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.SeqView$;
import scala.collection.TraversableViewLike;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u000b\u0017\u0001uAQ\u0001\n\u0001\u0005\u0002\u0015Bq\u0001\u000b\u0001A\u0002\u0013%\u0011\u0006C\u00048\u0001\u0001\u0007I\u0011\u0002\u001d\t\ry\u0002\u0001\u0015)\u0003+\u0011\u001dy\u0004\u00011A\u0005\n%Bq\u0001\u0011\u0001A\u0002\u0013%\u0011\t\u0003\u0004D\u0001\u0001\u0006KA\u000b\u0005\b\t\u0002\u0001\r\u0011\"\u0003F\u0011\u001dq\u0005\u00011A\u0005\n=Ca!\u0015\u0001!B\u00131\u0005b\u0002*\u0001\u0001\u0004%I!\u0012\u0005\b'\u0002\u0001\r\u0011\"\u0003U\u0011\u00191\u0006\u0001)Q\u0005\r\")q\u000b\u0001C\u00011\")1\f\u0001C\u00019\")\u0001\u000e\u0001C\u0001S\")\u0001\u000e\u0001C\u0001{\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000b\u0001\u0011\u0005\u00111\u0003\u0005\b\u0003/\u0001A\u0011AA\r\u0005\u0019\u0001Vo\u001d5fg*\u0011q\u0003G\u0001\b!V\u001c\b.\u001b8h\u0015\tI\"$\u0001\u0007D_>\u0014H-\u001b8bi&|gNC\u0001\u001c\u0003\u0015i\u0015n\u0019:p\u0007\u0001\u0019\"\u0001\u0001\u0010\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002(\u00015\ta#A\u0006he&$7)\u001e:sK:$X#\u0001\u0016\u0011\u0007-\u0012D'D\u0001-\u0015\tic&\u0001\u0006BeJ\f\u0017\u0010V=qKNT!a\f\u0019\u0002\u000b\u001d\u0013\u0018\u000eZ:\u000b\u0003E\n1\"\u00138g_Jl\u0017\r^5p]&\u00111\u0007\f\u0002\u000b\u000fJLGMQ;gM\u0016\u0014\bCA\u00146\u0013\t1dC\u0001\u0003QkND\u0017aD4sS\u0012\u001cUO\u001d:f]R|F%Z9\u0015\u0005eb\u0004CA\u0010;\u0013\tY\u0004E\u0001\u0003V]&$\bbB\u001f\u0004\u0003\u0003\u0005\rAK\u0001\u0004q\u0012\n\u0014\u0001D4sS\u0012\u001cUO\u001d:f]R\u0004\u0013\u0001D4sS\u0012\u0004&/\u001a<j_V\u001c\u0018\u0001E4sS\u0012\u0004&/\u001a<j_V\u001cx\fJ3r)\tI$\tC\u0004>\r\u0005\u0005\t\u0019\u0001\u0016\u0002\u001b\u001d\u0014\u0018\u000e\u001a)sKZLw.^:!\u00035\u0001Xo\u001d5fg\u000e+(O]3oiV\ta\tE\u0002H\u0019Rj\u0011\u0001\u0013\u0006\u0003\u0013*\u000bq!\\;uC\ndWM\u0003\u0002LA\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00055C%aC!se\u0006L()\u001e4gKJ\f\u0011\u0003];tQ\u0016\u001c8)\u001e:sK:$x\fJ3r)\tI\u0004\u000bC\u0004>\u0013\u0005\u0005\t\u0019\u0001$\u0002\u001dA,8\u000f[3t\u0007V\u0014(/\u001a8uA\u0005q\u0001/^:iKN\u0004&/\u001a<j_V\u001c\u0018A\u00059vg\",7\u000f\u0015:fm&|Wo]0%KF$\"!O+\t\u000fub\u0011\u0011!a\u0001\r\u0006y\u0001/^:iKN\u0004&/\u001a<j_V\u001c\b%A\u0002qkR$\"!O-\t\u000bis\u0001\u0019\u0001\u001b\u0002\tA,8\u000f[\u0001\u0004C2dW#A/\u0011\u0007y+GG\u0004\u0002`GB\u0011\u0001\rI\u0007\u0002C*\u0011!\rH\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011\u0004\u0013A\u0002)sK\u0012,g-\u0003\u0002gO\n\u00191+\u001a;\u000b\u0005\u0011\u0004\u0013aA4fiR\u0011!n\u001d\t\u0004WB$dB\u00017o\u001d\t\u0001W.C\u0001\"\u0013\ty\u0007%A\u0004qC\u000e\\\u0017mZ3\n\u0005E\u0014(aA*fc*\u0011q\u000e\t\u0005\u0006iB\u0001\r!^\u0001\u0005i&dW\r\u0005\u0002ww6\tqO\u0003\u0002ys\u00061\u0001k\\5oiNT\u0011A_\u0001\f\u001b\u0006$\b.Z7bi&\u001c7/\u0003\u0002}o\n!A+\u001b7f)\tQg\u0010\u0003\u0004\u0000#\u0001\u0007\u0011\u0011A\u0001\u0005k:LG\u000f\u0005\u0003\u0002\u0004\u00055QBAA\u0003\u0015\u0011\t9!!\u0003\u0002\u0011Us\u0017\u000e^%oM>T!!a\u0003\u0002\u0015A\u0013x\u000e_=Co\u0006\u0004\u0018.\u0003\u0003\u0002\u0010\u0005\u0015!\u0001C+oSRLeNZ8\u0002\u0019=t\u0017iZ3oi\u000eK8\r\\3\u0015\u0003e\nQ\"\u00193e\u000bb\u0004Hn\\:j_:\u001c\u0018\u0001E2iK\u000e\\W*\u0019:j]\u0016\u0014\u0016M\\4f)\rI\u00141\u0004\u0005\b\u0003;!\u0002\u0019AA\u0010\u0003\u0019\u0011W\u000f\u001c7fiB!\u0011\u0011EA\u0014\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005%\u0011a\u0002\"vY2,Go]\u0005\u0005\u0003S\t\u0019C\u0001\u0006Ck2dW\r^%oM>\u0004")
public class Pushes {
    private GridBuffer<Push> gridCurrent = new GridBuffer();
    private GridBuffer<Push> gridPrevious = new GridBuffer();
    private ArrayBuffer<Push> pushesCurrent = new ArrayBuffer();
    private ArrayBuffer<Push> pushesPrevious = new ArrayBuffer();

    private GridBuffer<Push> gridCurrent() {
        return this.gridCurrent;
    }

    private void gridCurrent_$eq(GridBuffer<Push> x$1) {
        this.gridCurrent = x$1;
    }

    private GridBuffer<Push> gridPrevious() {
        return this.gridPrevious;
    }

    private void gridPrevious_$eq(GridBuffer<Push> x$1) {
        this.gridPrevious = x$1;
    }

    private ArrayBuffer<Push> pushesCurrent() {
        return this.pushesCurrent;
    }

    private void pushesCurrent_$eq(ArrayBuffer<Push> x$1) {
        this.pushesCurrent = x$1;
    }

    private ArrayBuffer<Push> pushesPrevious() {
        return this.pushesPrevious;
    }

    private void pushesPrevious_$eq(ArrayBuffer<Push> x$1) {
        this.pushesPrevious = x$1;
    }

    public void put(Push push) {
        this.pushesCurrent().$plus$eq((Object)push);
        push.tiles().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            Pushes.$anonfun$put$1(this, push, x$1);
            return BoxedUnit.UNIT;
        });
    }

    public Set<Push> all() {
        return (Set)this.pushesPrevious().toSet().$plus$plus(this.pushesCurrent());
    }

    public Seq<Push> get(Tile tile) {
        return (Seq)((SeqLike)this.gridCurrent().get(tile)).view().$plus$plus((GenTraversableOnce)this.gridPrevious().get(tile), SeqView$.MODULE$.canBuildFrom());
    }

    public Seq<Push> get(UnitInfo unit) {
        return this.get(unit.tile());
    }

    public void onAgentCycle() {
        GridBuffer<Push> gridSwap = this.gridPrevious();
        ArrayBuffer<Push> pushesSwap = this.pushesPrevious();
        this.gridPrevious_$eq(this.gridCurrent());
        this.pushesPrevious_$eq(this.pushesCurrent());
        this.gridCurrent_$eq(gridSwap);
        this.pushesCurrent_$eq(pushesSwap);
        this.gridCurrent().update();
        this.pushesCurrent().clear();
        this.addExplosions();
    }

    public void addExplosions() {
        With$.MODULE$.bullets().all().foreach((Function1 & Serializable & scala.Serializable)bullet -> {
            Pushes.$anonfun$addExplosions$1(this, bullet);
            return BoxedUnit.UNIT;
        });
        With$.MODULE$.units().all().foreach((Function1 & Serializable & scala.Serializable)unit -> {
            Pushes.$anonfun$addExplosions$3(this, unit);
            return BoxedUnit.UNIT;
        });
        ((IterableLike)((TraversableViewLike)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(With$.MODULE$.game().getNukeDots()).asScala()).view().map((Function1 & Serializable & scala.Serializable)x$3 -> new Pixel((Position)x$3), SeqView$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> new ExplosionNuke((Pixel)x$4), SeqView$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)push -> {
            this.put(push);
            return BoxedUnit.UNIT;
        });
    }

    public void checkMarineRange(BulletInfo bullet) {
        if (bullet.sourceUnit().isEmpty() && With$.MODULE$.enemies().exists((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Pushes.$anonfun$checkMarineRange$1(x$5))) && !With$.MODULE$.units().existsEnemy((Seq<UnitFilter>)Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{new IsAll((Seq<UnitFilter>)Predef$.MODULE$.wrapRefArray((Object[])new UnitFilter[]{IsVisible$.MODULE$, Terran$.MODULE$.Marine()}))})) && bullet.targetUnit().exists((Function1 & Serializable & scala.Serializable)target -> BoxesRunTime.boxToBoolean((boolean)Pushes.$anonfun$checkMarineRange$2(target)))) {
            ((IterableLike)With$.MODULE$.enemies().filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.isTerran()))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
                x$8.ratchetUpgradeLevel(Terran$.MODULE$.MarineRange(), 1);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$put$1(Pushes $this, Push push$1, Tile x$1) {
        $this.gridCurrent().addItem(push$1, x$1);
    }

    public static final /* synthetic */ void $anonfun$addExplosions$1(Pushes $this, BulletInfo bullet) {
        BulletType bulletType = bullet.bulletType();
        if (((Object)((Object)BulletType.EMP_Missile)).equals((Object)bulletType)) {
            $this.put(new ExplosionEMP(bullet));
            return;
        }
        if (((Object)((Object)BulletType.Subterranean_Spines)).equals((Object)bulletType)) {
            if (!bullet.sourceUnit().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isOurs()))) {
                $this.put(new ExplosionLurkerNow(bullet));
                return;
            }
            return;
        }
        if (((Object)((Object)BulletType.Psionic_Storm)).equals((Object)bulletType)) {
            $this.put(new ExplosionPsionicStorm(bullet));
            return;
        }
        if (((Object)((Object)BulletType.Gauss_Rifle_Hit)).equals((Object)bulletType)) {
            $this.checkMarineRange(bullet);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$addExplosions$3(Pushes $this, UnitInfo unit) {
        if (unit.irradiated()) {
            $this.put(new ExplosionIrradiateSplash(unit));
        }
        if (Terran$.MODULE$.SpiderMine().apply(unit) && unit.visible() && (unit.isEnemy() || !unit.burrowed() && With$.MODULE$.framesSince(unit.frameDiscovered()) > new Minutes(3).apply())) {
            $this.put(new ExplosionSpiderMineBlast(unit));
        }
        if (Zerg$.MODULE$.InfestedTerran().apply(unit)) {
            $this.put(new ExplosionInfestedTerran(unit));
        }
        if (Protoss$.MODULE$.Scarab().apply(unit) && unit.visible() && !unit.isOurs()) {
            $this.put(new ExplosionScarab(unit));
        }
        if (Terran$.MODULE$.NuclearMissile().apply(unit)) {
            $this.put(new ExplosionNuke((Pixel)unit.targetPixel().getOrElse((Function0 & Serializable & scala.Serializable)() -> unit.pixel())));
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$checkMarineRange$1(PlayerInfo x$5) {
        return !Terran$.MODULE$.MarineRange().apply(x$5);
    }

    public static final /* synthetic */ boolean $anonfun$checkMarineRange$3(UnitInfo target$1, UnitInfo x$6) {
        return x$6.pixelsToGetInRange(target$1) > (double)16;
    }

    public static final /* synthetic */ boolean $anonfun$checkMarineRange$2(UnitInfo target) {
        return ((IterableLike)target.matchups().threats().filter((Function1)Terran$.MODULE$.Bunker())).exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Pushes.$anonfun$checkMarineRange$3(target, x$6)));
    }
}

