/*
 * Decompiled with CFR 0.152.
 */
package Lifecycle.Configure;

import Lifecycle.Configure.Configuration;
import Lifecycle.Configure.FileFlag;
import Lifecycle.With$;
import Strategery.HumanPlaybook$;
import Strategery.Playbook;
import Strategery.PretrainingPlaybook$;
import Strategery.Strategies.Strategy;
import Strategery.TournamentPlaybook$;
import java.io.File;
import java.io.Serializable;
import mjson.Json;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ConfigurationLoader$ {
    public static ConfigurationLoader$ MODULE$;

    static {
        new ConfigurationLoader$();
    }

    public <T> T getOrDefault(Json json, String property, T t) {
        Object attemptedOutput;
        Json value = json.at(property);
        if (value == null) {
            return t;
        }
        Object object = t instanceof Boolean ? (Serializable)(value.isBoolean() ? BoxesRunTime.boxToBoolean((boolean)value.asBoolean()) : t) : (Serializable)(t instanceof Integer ? (Number)(value.isNumber() ? BoxesRunTime.boxToInteger((int)value.asInteger()) : t) : (Number)(t instanceof Double ? (value.isNumber() ? BoxesRunTime.boxToDouble((double)value.asDouble()) : t) : (attemptedOutput = value.isString() ? value.asString() : t)));
        if (attemptedOutput == null) {
            return t;
        }
        return attemptedOutput;
    }

    public void load() {
        File[] configFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(With$.MODULE$.bwapiData().ai()).listFiles())).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ConfigurationLoader$.$anonfun$load$1(f)));
        File[] configFilesMatching = (File[])new .colon.colon((Object)((File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configFiles)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationLoader$.$anonfun$load$3(x$1)))), (List)new .colon.colon((Object)configFiles, (List)Nil$.MODULE$)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationLoader$.$anonfun$load$4(x$2))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configFilesMatching)).isEmpty()) {
            With$.MODULE$.logger().warn("Didn't find any matching configurations");
            return;
        }
        File configFile = (File)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configFiles)).head();
        if (configFilesMatching.length > 1) {
            With$.MODULE$.logger().warn(new StringBuilder(40).append("Found multiple matching configurations: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])configFilesMatching)).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(", ")).toString());
        }
        With$.MODULE$.logger().debug(new StringBuilder(25).append("Using configuration file ").append(configFile.getName()).toString());
        try {
            BufferedSource configSource = Source$.MODULE$.fromFile(configFile, Codec$.MODULE$.fallbackSystemCodec());
            String configText = configSource.mkString();
            configSource.close();
            Json config = Json.read(configText);
            boolean human = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "human", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean ladder = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "ladder", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean livestream = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "livestream", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean tournament = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "tournament", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean roundrobin = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "roundrobin", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean elimination = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "elimination", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean pretraining = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "pretraining", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean debugging = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "debugging", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean debugginglive = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "debugginglive", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean logstd = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "logstd", BoxesRunTime.boxToBoolean((boolean)false)));
            boolean multiCPU = BoxesRunTime.unboxToBoolean((Object)this.getOrDefault(config, "multiCPU", BoxesRunTime.boxToBoolean((boolean)true)));
            int frameMsTarget = BoxesRunTime.unboxToInt((Object)this.getOrDefault(config, "framemstarget", BoxesRunTime.boxToInteger((int)With$.MODULE$.configuration().frameTargetMs())));
            int frameMsLimit = BoxesRunTime.unboxToInt((Object)this.getOrDefault(config, "framemslimit", BoxesRunTime.boxToInteger((int)With$.MODULE$.configuration().frameLimitMs())));
            With$.MODULE$.configuration().fixedBuilds_$eq(new FileFlag("fixedbuilds.txt").contents());
            With$.MODULE$.configuration().frameTargetMs_$eq(frameMsTarget);
            With$.MODULE$.configuration().frameLimitMs_$eq(frameMsLimit);
            if (tournament && ladder) {
                With$.MODULE$.logger().warn("Both tournament and ladder modes are enabled");
            }
            if (tournament && livestream) {
                With$.MODULE$.logger().warn("Both tournament and livestream modes are enabled");
            }
            if (tournament && pretraining) {
                With$.MODULE$.logger().warn("Both tournament and pretraining modes are enabled");
            }
            if (pretraining && ladder) {
                With$.MODULE$.logger().warn("Both pretraining and laddermodes are enabled");
            }
            if (pretraining && livestream) {
                With$.MODULE$.logger().warn("Both pretraining and livestream modes are enabled");
            }
            if (roundrobin && elimination) {
                With$.MODULE$.logger().warn("Both round robin and elimination modes are enabled");
            }
            if (debugginglive && !debugging) {
                With$.MODULE$.logger().warn("debugginglive enabled without debugging enabled");
            }
            if (livestream) {
                this.setLivestreamMode();
            }
            if (human) {
                this.setHumanMode();
            }
            if (ladder) {
                this.setLadderMode();
            }
            if (tournament) {
                this.setTournamentMode();
            }
            if (roundrobin) {
                this.setRoundRobinMode();
            }
            if (elimination) {
                this.setEliminationMode();
            }
            if (pretraining) {
                this.setPretraining();
            }
            if (debugging) {
                this.setDebugMode();
            }
            if (debugginglive) {
                this.setDebugLiveMode();
            }
            if (logstd) {
                With$.MODULE$.configuration().logstd_$eq(true);
            }
            With$.MODULE$.configuration().simulationAsynchronous_$eq(multiCPU);
            ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"Human", (Object)Boolean.toString(human)), new Tuple2((Object)"Ladder", (Object)Boolean.toString(ladder)), new Tuple2((Object)"Livestream", (Object)BoxesRunTime.boxToBoolean((boolean)livestream)), new Tuple2((Object)"Tournament", (Object)Boolean.toString(tournament)), new Tuple2((Object)"Round-robin", (Object)Boolean.toString(roundrobin)), new Tuple2((Object)"Elimination", (Object)Boolean.toString(elimination)), new Tuple2((Object)"Pretraining", (Object)Boolean.toString(pretraining)), new Tuple2((Object)"Debugging", (Object)Boolean.toString(debugging)), new Tuple2((Object)"DebuggingLive", (Object)Boolean.toString(debugginglive)), new Tuple2((Object)"Log stdout", (Object)Boolean.toString(logstd)), new Tuple2((Object)"Frame MS target", (Object)BoxesRunTime.boxToInteger((int)frameMsTarget)), new Tuple2((Object)"Frame MS limit", (Object)BoxesRunTime.boxToInteger((int)frameMsLimit)), new Tuple2((Object)"Fixed build", (Object)With$.MODULE$.configuration().fixedBuilds())}))).foreach((Function1 & Serializable & scala.Serializable)pair -> {
                ConfigurationLoader$.$anonfun$load$7(pair);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Exception exception) {
            With$.MODULE$.logger().onException(exception);
            return;
        }
    }

    private void setTournamentMode() {
        this.config().forcedPlaybook_$eq((Option<Playbook>)new Some((Object)TournamentPlaybook$.MODULE$));
    }

    private void setLadderMode() {
        this.config().historyHalfLife_$eq(40.0);
        this.config().recentFingerprints_$eq(4);
    }

    private void setEliminationMode() {
        this.config().recentFingerprints_$eq(2);
    }

    private void setRoundRobinMode() {
        this.config().historyHalfLife_$eq(30.0);
        this.config().recentFingerprints_$eq(3);
    }

    private void setLivestreamMode() {
        this.config().visualizeFun_$eq(true);
        this.config().enableChat_$eq(true);
        this.config().enableSurrenders_$eq(true);
    }

    private void setHumanMode() {
        this.config().humanMode_$eq(true);
        this.config().enableChat_$eq(true);
        this.config().enableSurrenders_$eq(true);
        this.config().forcedPlaybook_$eq((Option<Playbook>)new Some((Object)HumanPlaybook$.MODULE$));
    }

    private void setPretraining() {
        this.config().forcedPlaybook_$eq((Option<Playbook>)new Some((Object)PretrainingPlaybook$.MODULE$));
    }

    private void setDebugMode() {
        this.config().enableChat_$eq(true);
        this.config().enableSurrenders_$eq(true);
        this.config().debugging_$eq(true);
    }

    private void setDebugLiveMode() {
        this.setDebugMode();
        this.config().camera_$eq(true);
        this.config().visualizeDebug_$eq(true);
        this.config().detectBreakpoints_$eq(true);
    }

    public Seq<Seq<Strategy>> matchNames(Seq<String> names, Seq<Seq<Strategy>> branches) {
        return (Seq)branches.filter((Function1 & Serializable & scala.Serializable)branch -> BoxesRunTime.boxToBoolean((boolean)names.forall((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)branch.exists((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConfigurationLoader$.$anonfun$matchNames$3(name, x$4)))))));
    }

    private Configuration config() {
        return With$.MODULE$.configuration();
    }

    public static final /* synthetic */ boolean $anonfun$load$1(File f) {
        return new .colon.colon((Object)"Purple", (List)new .colon.colon((Object)".config", (List)new .colon.colon((Object)".json", (List)Nil$.MODULE$))).forall(arg_0 -> ConfigurationLoader$.$anonfun$load$2$adapted(f.getName(), arg_0));
    }

    public static final /* synthetic */ boolean $anonfun$load$3(File x$1) {
        return x$1.getName().contains(With$.MODULE$.self().name());
    }

    public static final /* synthetic */ boolean $anonfun$load$4(File[] x$2) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$load$7(Tuple2 pair) {
        With$.MODULE$.logger().debug(new StringBuilder(2).append((String)pair._1()).append(": ").append(pair._2()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$matchNames$3(String name$1, Strategy x$4) {
        String string = x$4.toString();
        return !(string != null ? !string.equals(name$1) : name$1 != null);
    }

    private ConfigurationLoader$() {
        MODULE$ = this;
    }

    public static final /* synthetic */ Object $anonfun$load$2$adapted(String eta$0$1$1, CharSequence x$1) {
        return BoxesRunTime.boxToBoolean((boolean)eta$0$1$1.contains(x$1));
    }
}

