/*
 * Decompiled with CFR 0.152.
 */
package Information.Geography.NeoGeo;

import Information.Geography.NeoGeo.Internal.NeoColors$;
import Information.Geography.NeoGeo.Internal.NeoColors$Hues$;
import Information.Geography.NeoGeo.Internal.NeoContinentBackend;
import Information.Geography.NeoGeo.NeoGeo;
import Information.Geography.NeoGeo.NeoMath$;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class NeoRender$ {
    public static NeoRender$ MODULE$;

    static {
        new NeoRender$();
    }

    public String filepathBase() {
        return "./bwapi-data/write/";
    }

    private Color binary(boolean bl) {
        if (bl) {
            return new Color(255, 255, 255);
        }
        return new Color(0, 0, 0);
    }

    private Color grayscale(int n) {
        int v = NeoMath$.MODULE$.clamp(n, 0, 255);
        return new Color(v, v, v);
    }

    private Color safeHV(int h, int v) {
        return NeoColors$.MODULE$.hv(NeoMath$.MODULE$.clamp(h, 0, 255), NeoMath$.MODULE$.clamp(v, 0, 255));
    }

    private Color safeHSV(int h, int s, int v) {
        return NeoColors$.MODULE$.hsv(NeoMath$.MODULE$.clamp(h, 0, 255), NeoMath$.MODULE$.clamp(s, 0, 255), NeoMath$.MODULE$.clamp(v, 0, 255));
    }

    private int walk64(NeoGeo geo, int i) {
        if (geo.walkability()[i]) {
            return 64;
        }
        return 0;
    }

    public void apply(NeoGeo geo) {
        this.renderWalks(geo, "walkable", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.binary(geo.walkability()[BoxesRunTime.unboxToInt((Object)i)]));
        this.renderWalks(geo, "altitude", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.grayscale(NeoRender$.MODULE$.walk64(geo, BoxesRunTime.unboxToInt((Object)i)) + (int)((double)191 * geo.altitude()[BoxesRunTime.unboxToInt((Object)i)] / (double)64)));
        this.renderWalks(geo, "continents", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.$anonfun$apply$3(geo, BoxesRunTime.unboxToInt((Object)i)));
        this.renderWalks(geo, "clearanceMinWalks", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.safeHV(BoxesRunTime.unboxToInt((Object)NeoColors$Hues$.MODULE$.eight().apply(geo.clearanceMinDir()[BoxesRunTime.unboxToInt((Object)i)])), NeoRender$.MODULE$.walk64(geo, BoxesRunTime.unboxToInt((Object)i)) + 191 * geo.clearanceMinWalks()[BoxesRunTime.unboxToInt((Object)i)] / 64));
        this.renderWalks(geo, "clearanceMaxWalks", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.safeHV(BoxesRunTime.unboxToInt((Object)NeoColors$Hues$.MODULE$.eight().apply(geo.clearanceMaxDir()[BoxesRunTime.unboxToInt((Object)i)])), NeoRender$.MODULE$.walk64(geo, BoxesRunTime.unboxToInt((Object)i)) + 191 * geo.clearanceMaxWalks()[BoxesRunTime.unboxToInt((Object)i)] / 256));
        this.renderWalks(geo, "clearanceMin", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.grayscale(NeoRender$.MODULE$.walk64(geo, BoxesRunTime.unboxToInt((Object)i)) + 191 * geo.clearanceMinWalks()[BoxesRunTime.unboxToInt((Object)i)] / 64));
        this.renderWalks(geo, "clearanceMax", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.grayscale(NeoRender$.MODULE$.walk64(geo, BoxesRunTime.unboxToInt((Object)i)) + 191 * geo.clearanceMaxWalks()[BoxesRunTime.unboxToInt((Object)i)] / 256));
        this.renderTiles(geo, "buildable", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.binary(geo.buildability()[BoxesRunTime.unboxToInt((Object)i)]));
        this.renderTiles(geo, "groundheight", (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.grayscale(255 * geo.groundHeight()[BoxesRunTime.unboxToInt((Object)i)] / 5));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])geo.directions())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)d -> {
            Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)d);
            MODULE$.renderWalks(geo, new StringOps("clearance-%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1})), (Function1<Object, Color>)(Function1 & java.io.Serializable & Serializable)i -> NeoRender$.MODULE$.grayscale(NeoRender$.MODULE$.walk64(geo, BoxesRunTime.unboxToInt((Object)i)) + 191 * geo.clearance()[d][BoxesRunTime.unboxToInt((Object)i)] / 128));
        });
    }

    public void renderTiles(NeoGeo geo, String name, Function1<Object, Color> color) {
        this.render(geo, name, geo.tileWidth(), geo.tileHeight(), color);
    }

    public void renderWalks(NeoGeo geo, String name, Function1<Object, Color> color) {
        this.render(geo, name, geo.walkWidth(), geo.walkHeight(), color);
    }

    private void render(NeoGeo geo, String name, int width, int height, Function1<Object, Color> color) {
        BufferedImage image = new BufferedImage(width, height, 1);
        int x = 0;
        int i = 0;
        for (int y = 0; y < height; ++y) {
            while (x < width) {
                image.setRGB(x, y, ((Color)color.apply((Object)BoxesRunTime.boxToInteger((int)i))).getRGB());
                ++x;
                ++i;
            }
            x = 0;
        }
        String arg$macro$1 = this.filepathBase();
        String arg$macro$2 = geo.mapNickname();
        ImageIO.write((RenderedImage)image, "png", new File(new StringOps("%s%s-%s.png").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, name}))));
    }

    public static final /* synthetic */ Color $anonfun$apply$3(NeoGeo geo$1, int i) {
        if (geo$1.continentByWalk()[i] == null) {
            return new Color(0, 0, 0);
        }
        return ((NeoContinentBackend)geo$1.continentByWalk()[i]).color();
    }

    private NeoRender$() {
        MODULE$ = this;
    }
}

