/*
 * Decompiled with CFR 0.152.
 */
package bwem;

import bwapi.Pair;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.WalkPosition;
import bwem.Altitude;
import bwem.Area;
import bwem.AreaId;
import bwem.AreaInitializer;
import bwem.BWMap;
import bwem.Base;
import bwem.CPPath;
import bwem.ChokePoint;
import bwem.Geyser;
import bwem.Mineral;
import bwem.Neutral;
import bwem.PathingResult;
import bwem.StaticBuilding;
import bwem.TerrainData;
import bwem.Tile;
import bwem.util.BwemExt;
import bwem.util.CheckMode;
import bwem.util.Pred;
import bwem.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;

public final class Graph {
    private final BWMap map;
    private final List<Area> areas = new ArrayList<Area>();
    private final List<ChokePoint> chokePoints = new ArrayList<ChokePoint>();
    private final List<List<List<ChokePoint>>> chokePointsMatrix = new ArrayList<List<List<ChokePoint>>>();
    private final List<List<Integer>> chokePointDistanceMatrix = new ArrayList<List<Integer>>();
    private final List<List<CPPath>> pathsBetweenChokePoints = new ArrayList<List<CPPath>>();
    private final List<Base> bases = new ArrayList<Base>();

    Graph(BWMap map) {
        this.map = map;
    }

    public BWMap getMap() {
        return this.map;
    }

    public List<Area> getAreas() {
        return this.areas;
    }

    public int getAreaCount() {
        return this.areas.size();
    }

    public Area getArea(AreaId id) {
        if (!this.isValid(id)) {
            this.map.asserter.throwIllegalStateException("");
        }
        return this.areas.get(id.intValue() - 1);
    }

    public Area getArea(WalkPosition walkPosition) {
        AreaId areaId = this.getMap().getData().getMiniTile(walkPosition).getAreaId();
        return areaId.intValue() > 0 ? this.getArea(areaId) : null;
    }

    public Area getArea(TilePosition tilePosition) {
        AreaId areaId = this.getMap().getData().getTile(tilePosition).getAreaId();
        return areaId.intValue() > 0 ? this.getArea(areaId) : null;
    }

    public Area getNearestArea(WalkPosition walkPosition) {
        Area area = this.getArea(walkPosition);
        if (area != null) {
            return area;
        }
        WalkPosition w = this.getMap().breadthFirstSearch(walkPosition, (miniTile, unused) -> miniTile.getAreaId().intValue() > 0, Pred.accept());
        return this.getArea(w);
    }

    public Area getNearestArea(TilePosition tilePosition) {
        Area area = this.getArea(tilePosition);
        if (area != null) {
            return area;
        }
        TilePosition t = this.getMap().breadthFirstSearch(tilePosition, (tile, unused) -> tile.getAreaId().intValue() > 0, (tile, unused) -> true);
        return this.getArea(t);
    }

    public List<ChokePoint> getChokePoints() {
        return this.chokePoints;
    }

    private List<ChokePoint> getChokePoints(AreaId a, AreaId b) {
        int bVal;
        int aVal;
        if (!this.isValid(a) || !this.isValid(b) || a.intValue() == b.intValue()) {
            this.map.asserter.throwIllegalStateException("");
        }
        if ((aVal = a.intValue()) > (bVal = b.intValue())) {
            int aValTmp = aVal;
            aVal = bVal;
            bVal = aValTmp;
        }
        return this.chokePointsMatrix.get(bVal).get(aVal);
    }

    private List<ChokePoint> getChokePoints(Area a, Area b) {
        return this.getChokePoints(a.getId(), b.getId());
    }

    public int distance(ChokePoint cpA, ChokePoint cpB) {
        return this.chokePointDistanceMatrix.get(cpA.getIndex()).get(cpB.getIndex());
    }

    public CPPath getPath(ChokePoint cpA, ChokePoint cpB) {
        return this.pathsBetweenChokePoints.get(cpA.getIndex()).get(cpB.getIndex());
    }

    public Optional<PathingResult> getPathingResult(Position a, Position b) {
        return new Pathing(a, b).getPathWithLength();
    }

    public Optional<CPPath> getPath(Position a, Position b) {
        return new Pathing(a, b).getPath();
    }

    public List<Base> getBases() {
        return this.bases;
    }

    void createAreas(List<Pair<WalkPosition, Integer>> areasList) {
        for (int id = 1; id <= areasList.size(); ++id) {
            WalkPosition top = areasList.get(id - 1).getLeft();
            int miniTileCount = areasList.get(id - 1).getRight();
            this.areas.add(new AreaInitializer(this.getMap(), new AreaId(id), top, miniTileCount));
        }
    }

    private void initializeChokePointsMatrix() {
        int areasCount = this.getAreaCount();
        this.chokePointsMatrix.clear();
        this.chokePointsMatrix.add(null);
        for (int id = 1; id <= areasCount; ++id) {
            ArrayList subList = new ArrayList();
            this.chokePointsMatrix.add(subList);
            for (int n = 0; n < id; ++n) {
                subList.add(new ArrayList());
            }
        }
    }

    private Map<Pair<AreaId, AreaId>, List<WalkPosition>> createRawFrontierByAreaPairMap(List<Pair<Pair<AreaId, AreaId>, WalkPosition>> rawFrontier) {
        HashMap<Pair<AreaId, AreaId>, List<WalkPosition>> rawFrontierByAreaPair = new HashMap<Pair<AreaId, AreaId>, List<WalkPosition>>();
        for (Pair<Pair<AreaId, AreaId>, WalkPosition> raw : rawFrontier) {
            int b;
            int a = raw.getLeft().getLeft().intValue();
            if (a > (b = raw.getLeft().getRight().intValue())) {
                int a_tmp = a;
                a = b;
                b = a_tmp;
            }
            if (a < 1 || b > this.getAreaCount()) {
                this.map.asserter.throwIllegalStateException("");
            }
            Pair<AreaId, AreaId> key = new Pair<AreaId, AreaId>(new AreaId(a), new AreaId(b));
            rawFrontierByAreaPair.computeIfAbsent(key, mp -> new ArrayList()).add(raw.getRight());
        }
        return rawFrontierByAreaPair;
    }

    /*
     * WARNING - void declaration
     */
    public void createChokePoints(List<StaticBuilding> staticBuildings, List<Mineral> minerals, List<Pair<Pair<AreaId, AreaId>, WalkPosition>> rawFrontier) {
        void var7_13;
        Iterator<Object> iterator;
        int newIndex = 0;
        ArrayList<Neutral> blockingNeutrals = new ArrayList<Neutral>();
        for (StaticBuilding staticBuilding : staticBuildings) {
            if (!staticBuilding.isBlocking()) continue;
            blockingNeutrals.add(staticBuilding);
        }
        for (Mineral mineral : minerals) {
            if (!mineral.isBlocking()) continue;
            blockingNeutrals.add(mineral);
        }
        this.initializeChokePointsMatrix();
        Map<Pair<AreaId, AreaId>, List<WalkPosition>> rawFrontierByAreaPair = this.createRawFrontierByAreaPairMap(rawFrontier);
        for (Map.Entry<Pair<AreaId, AreaId>, List<WalkPosition>> entry : rawFrontierByAreaPair.entrySet()) {
            Pair<AreaId, AreaId> rawleft = entry.getKey();
            List<WalkPosition> rawFrontierAB = entry.getValue();
            ArrayList<Altitude> altitudes = new ArrayList<Altitude>();
            iterator = rawFrontierAB.iterator();
            while (iterator.hasNext()) {
                WalkPosition w = iterator.next();
                altitudes.add(this.getMap().getData().getMiniTile(w).getAltitude());
            }
            for (int i = 1; i < altitudes.size(); ++i) {
                int curr;
                int prev = ((Altitude)altitudes.get(i - 1)).intValue();
                if (prev >= (curr = ((Altitude)altitudes.get(i)).intValue())) continue;
                this.map.asserter.throwIllegalStateException("");
            }
            int clusterMinDist = (int)Math.sqrt(300.0);
            ArrayList clusters = new ArrayList();
            Iterator prev = rawFrontierAB.iterator();
            while (prev.hasNext()) {
                WalkPosition w = (WalkPosition)prev.next();
                boolean added = false;
                for (List list : clusters) {
                    int distToBack;
                    int distToFront = BwemExt.queenWiseDist((WalkPosition)list.get(0), w);
                    if (Math.min(distToFront, distToBack = BwemExt.queenWiseDist((WalkPosition)list.get(list.size() - 1), w)) > clusterMinDist) continue;
                    if (distToFront < distToBack) {
                        list.add(0, w);
                    } else {
                        list.add(w);
                    }
                    added = true;
                    break;
                }
                if (added) continue;
                ArrayList<WalkPosition> arrayList = new ArrayList<WalkPosition>();
                arrayList.add(w);
                clusters.add(arrayList);
            }
            AreaId a = rawleft.getLeft();
            AreaId b = rawleft.getRight();
            for (List list : clusters) {
                this.getChokePoints(a, b).add(new ChokePoint(this, newIndex, this.getArea(a), this.getArea(b), list));
                ++newIndex;
            }
        }
        for (Neutral neutral : blockingNeutrals) {
            if (neutral.getNextStacked() != null) continue;
            List<Area> blockedAreas = neutral.getBlockedAreas();
            for (Area blockedAreaA : blockedAreas) {
                Area blockedAreaB;
                iterator = blockedAreas.iterator();
                while (iterator.hasNext() && !(blockedAreaB = (Area)iterator.next()).equals(blockedAreaA)) {
                    WalkPosition center = this.getMap().breadthFirstSearch(neutral.getCenter().toWalkPosition(), (miniTile, unused) -> miniTile.isWalkable(), Pred.accept());
                    ArrayList<WalkPosition> list = new ArrayList<WalkPosition>();
                    list.add(center);
                    this.getChokePoints(blockedAreaA, blockedAreaB).add(new ChokePoint(this, newIndex, blockedAreaA, blockedAreaB, list, neutral));
                    ++newIndex;
                }
            }
        }
        boolean bl = true;
        while (var7_13 <= this.getAreaCount()) {
            void var8_18;
            boolean bl2 = true;
            while (var8_18 < var7_13) {
                AreaId a = new AreaId((int)var7_13);
                AreaId b = new AreaId((int)var8_18);
                if (!this.getChokePoints(a, b).isEmpty()) {
                    ((AreaInitializer)this.getArea(a)).addChokePoints(this.getArea(b), this.getChokePoints(a, b));
                    ((AreaInitializer)this.getArea(b)).addChokePoints(this.getArea(a), this.getChokePoints(a, b));
                    this.chokePoints.addAll(this.getChokePoints(a, b));
                }
                ++var8_18;
            }
            ++var7_13;
        }
    }

    public void computeChokePointDistanceMatrix() {
        int n;
        this.chokePointDistanceMatrix.clear();
        for (int i = 0; i < this.chokePoints.size(); ++i) {
            this.chokePointDistanceMatrix.add(new ArrayList());
        }
        for (List<Integer> chokePointDistanceMatrix1 : this.chokePointDistanceMatrix) {
            for (n = 0; n < this.chokePoints.size(); ++n) {
                chokePointDistanceMatrix1.add(-1);
            }
        }
        this.pathsBetweenChokePoints.clear();
        for (int i = 0; i < this.chokePoints.size(); ++i) {
            this.pathsBetweenChokePoints.add(new ArrayList());
        }
        for (List<CPPath> pathsBetweenChokePoint : this.pathsBetweenChokePoints) {
            for (n = 0; n < this.chokePoints.size(); ++n) {
                pathsBetweenChokePoint.add(new CPPath());
            }
        }
        for (Area area : this.getAreas()) {
            this.computeChokePointDistances(area);
        }
        this.computeChokePointDistances(this);
        for (ChokePoint cp : this.getChokePoints()) {
            this.setDistance(cp, cp, 0);
            CPPath cppath = new CPPath();
            cppath.add(cp);
            this.setPath(cp, cp, cppath);
        }
        for (Area area : this.getAreas()) {
            ((AreaInitializer)area).updateAccessibleNeighbors();
        }
        this.updateGroupIds();
    }

    public void collectInformation() {
        Area area;
        for (Mineral mineral : this.getMap().getNeutralData().getMinerals()) {
            area = this.getMap().getMainArea(mineral.getTopLeft(), mineral.getSize());
            if (area == null) continue;
            ((AreaInitializer)area).addMineral(mineral);
        }
        for (Geyser geyser : this.getMap().getNeutralData().getGeysers()) {
            area = this.getMap().getMainArea(geyser.getTopLeft(), geyser.getSize());
            if (area == null) continue;
            ((AreaInitializer)area).addGeyser(geyser);
        }
        for (int y = 0; y < this.getMap().getData().getMapData().getTileSize().getY(); ++y) {
            for (int x = 0; x < this.getMap().getData().getMapData().getTileSize().getX(); ++x) {
                Tile tile = this.getMap().getData().getTile(new TilePosition(x, y));
                if (tile.getAreaId().intValue() <= 0) continue;
                ((AreaInitializer)this.getArea(tile.getAreaId())).addTileInformation(new TilePosition(x, y), tile);
            }
        }
    }

    public void createBases(TerrainData terrainData) {
        this.bases.clear();
        for (Area area : this.areas) {
            ((AreaInitializer)area).createBases(terrainData);
            this.bases.addAll(area.getBases());
        }
    }

    private void computeChokePointDistances(Area pContext) {
        for (ChokePoint pStart : pContext.getChokePoints()) {
            ArrayList<ChokePoint> targets = new ArrayList<ChokePoint>();
            for (ChokePoint cp : pContext.getChokePoints()) {
                if (cp.equals(pStart)) break;
                targets.add(cp);
            }
            int[] distanceToTargets = ((AreaInitializer)pContext).computeDistances(pStart, targets);
            this.setPathForComputeChokePointDistances(distanceToTargets, pStart, targets, false);
        }
    }

    private void computeChokePointDistances(Graph pContext) {
        for (ChokePoint pStart : pContext.getChokePoints()) {
            ArrayList<ChokePoint> targets = new ArrayList<ChokePoint>();
            for (ChokePoint cp : pContext.getChokePoints()) {
                if (cp.equals(pStart)) break;
                targets.add(cp);
            }
            int[] distanceToTargets = pContext.computeDistances(pStart, targets);
            this.setPathForComputeChokePointDistances(distanceToTargets, pStart, targets, true);
        }
    }

    private void setPathForComputeChokePointDistances(int[] distanceToTargets, ChokePoint pStart, List<ChokePoint> targets, boolean collectIntermediateChokePoints) {
        for (int i = 0; i < targets.size(); ++i) {
            int newDist = distanceToTargets[i];
            ChokePoint target = targets.get(i);
            int existingDist = this.distance(pStart, target);
            if (newDist == 0 || existingDist != -1 && newDist >= existingDist) continue;
            this.setDistance(pStart, target, newDist);
            CPPath path = new CPPath();
            path.add(pStart);
            path.add(target);
            if (collectIntermediateChokePoints) {
                ChokePoint pPrev = target.getPathBackTrace();
                while (!pPrev.equals(pStart)) {
                    path.add(1, pPrev);
                    pPrev = pPrev.getPathBackTrace();
                }
            }
            this.setPath(pStart, target, path);
        }
    }

    private int[] computeDistances(ChokePoint start, List<ChokePoint> targets) {
        int[] distances = new int[targets.size()];
        Tile.getStaticMarkable().unmarkAll();
        PriorityQueue<Pair> toVisit = new PriorityQueue<Pair>(Comparator.comparingInt(Pair::getLeft));
        toVisit.offer(new Pair<Integer, ChokePoint>(0, start));
        int remainingTargets = targets.size();
        while (!toVisit.isEmpty()) {
            Pair distanceAndChokePoint = (Pair)toVisit.poll();
            int currentDist = (Integer)distanceAndChokePoint.getLeft();
            ChokePoint current = (ChokePoint)distanceAndChokePoint.getRight();
            Tile currentTile = this.getMap().getData().getTile(current.getCenter().toTilePosition(), CheckMode.NO_CHECK);
            if (currentTile.getInternalData() != currentDist) {
                this.map.asserter.throwIllegalStateException("");
            }
            currentTile.setInternalData(0);
            currentTile.getMarkable().setMarked();
            for (int i = 0; i < targets.size(); ++i) {
                if (current != targets.get(i)) continue;
                distances[i] = currentDist;
                --remainingTargets;
            }
            if (remainingTargets == 0) break;
            if (current.isBlocked() && !current.equals(start)) continue;
            for (Area pArea : new Area[]{current.getAreas().getLeft(), current.getAreas().getRight()}) {
                for (ChokePoint next : pArea.getChokePoints()) {
                    if (next.equals(current)) continue;
                    int newNextDist = currentDist + this.distance(current, next);
                    Tile nextTile = this.getMap().getData().getTile(next.getCenter().toTilePosition(), CheckMode.NO_CHECK);
                    if (!nextTile.getMarkable().isUnmarked()) continue;
                    if (nextTile.getInternalData() != 0) {
                        if (newNextDist >= nextTile.getInternalData()) continue;
                        boolean removed = toVisit.remove(new Pair<Integer, ChokePoint>(nextTile.getInternalData(), next));
                        if (!removed) {
                            this.map.asserter.throwIllegalStateException("");
                        }
                        nextTile.setInternalData(newNextDist);
                        next.setPathBackTrace(current);
                        toVisit.offer(new Pair<Integer, ChokePoint>(newNextDist, next));
                        continue;
                    }
                    nextTile.setInternalData(newNextDist);
                    next.setPathBackTrace(current);
                    toVisit.offer(new Pair<Integer, ChokePoint>(newNextDist, next));
                }
            }
        }
        for (Pair distanceToChokePoint : toVisit) {
            this.getMap().getData().getTile(((ChokePoint)distanceToChokePoint.getRight()).getCenter().toTilePosition(), CheckMode.NO_CHECK).setInternalData(0);
        }
        return distances;
    }

    private void updateGroupIds() {
        int nextGroupId = 1;
        AreaInitializer.getStaticMarkable().unmarkAll();
        for (Area start : this.getAreas()) {
            if (!((AreaInitializer)start).getMarkable().isUnmarked()) continue;
            ArrayList<Area> toVisit = new ArrayList<Area>();
            toVisit.add(start);
            while (!toVisit.isEmpty()) {
                Area current = (Area)toVisit.remove(toVisit.size() - 1);
                ((AreaInitializer)current).setGroupId(nextGroupId);
                for (Area next : current.getAccessibleNeighbors()) {
                    if (!((AreaInitializer)next).getMarkable().isUnmarked()) continue;
                    ((AreaInitializer)next).getMarkable().setMarked();
                    toVisit.add(next);
                }
            }
            ++nextGroupId;
        }
    }

    private void setDistance(ChokePoint cpA, ChokePoint cpB, int value) {
        int indexA = cpA.getIndex();
        int indexB = cpB.getIndex();
        this.chokePointDistanceMatrix.get(indexA).set(indexB, value);
        this.chokePointDistanceMatrix.get(indexB).set(indexA, value);
    }

    private void setPath(ChokePoint cpA, ChokePoint cpB, CPPath pathAB) {
        int indexA = cpA.getIndex();
        int indexB = cpB.getIndex();
        this.pathsBetweenChokePoints.get(indexA).set(indexB, pathAB);
        if (cpA != cpB) {
            CPPath reversePath = this.pathsBetweenChokePoints.get(indexB).get(indexA);
            reversePath.clear();
            for (int i = pathAB.size() - 1; i >= 0; --i) {
                ChokePoint cp = pathAB.get(i);
                reversePath.add(cp);
            }
        }
    }

    private boolean isValid(AreaId id) {
        return 1 <= id.intValue() && id.intValue() <= this.getAreaCount();
    }

    private class Pathing {
        private final Position a;
        private final Position b;
        private final Area areaA;
        private final Area areaB;
        private final CPPath path;
        private ChokePoint pBestCpA;
        private ChokePoint pBestCpB;
        private int minDistAB;

        Pathing(Position a, Position b) {
            this.a = a;
            this.b = b;
            this.areaA = Graph.this.getNearestArea(a.toWalkPosition());
            this.areaB = Graph.this.getNearestArea(b.toWalkPosition());
            if (this.areaA.equals(this.areaB)) {
                this.path = CPPath.EMPTY_PATH;
                return;
            }
            if (!this.areaA.isAccessibleFrom(this.areaB)) {
                this.path = null;
                return;
            }
            this.minDistAB = Integer.MAX_VALUE;
            for (ChokePoint cpA : this.areaA.getChokePoints()) {
                if (cpA.isBlocked()) continue;
                int distACpA = a.getApproxDistance(cpA.getCenter().toPosition());
                for (ChokePoint cpB : this.areaB.getChokePoints()) {
                    int distBToCPB;
                    int distAToB;
                    if (cpB.isBlocked() || (distAToB = distACpA + (distBToCPB = b.getApproxDistance(cpB.getCenter().toPosition())) + Graph.this.distance(cpA, cpB)) >= this.minDistAB) continue;
                    this.minDistAB = distAToB;
                    this.pBestCpA = cpA;
                    this.pBestCpB = cpB;
                }
            }
            if (this.minDistAB == Integer.MAX_VALUE) {
                ((Graph)Graph.this).map.asserter.throwIllegalStateException("");
            }
            this.path = Graph.this.getPath(this.pBestCpA, this.pBestCpB);
        }

        Optional<PathingResult> getPathWithLength() {
            if (this.path == null) {
                return Optional.empty();
            }
            if (this.areaA.equals(this.areaB)) {
                return Optional.of(new PathingResult(this.path, this.a.getApproxDistance(this.b)));
            }
            if (this.path.size() == 1) {
                if (!this.pBestCpA.equals(this.pBestCpB)) {
                    ((Graph)Graph.this).map.asserter.throwIllegalStateException("");
                }
                Position cpEnd1 = BwemExt.center(this.pBestCpA.getNodePosition(ChokePoint.Node.END1));
                Position cpEnd2 = BwemExt.center(this.pBestCpA.getNodePosition(ChokePoint.Node.END2));
                if (Utils.intersect(this.a.getX(), this.a.getY(), this.b.getX(), this.b.getY(), cpEnd1.getX(), cpEnd1.getY(), cpEnd2.getX(), cpEnd2.getY())) {
                    return Optional.of(new PathingResult(this.path, this.a.getApproxDistance(this.b)));
                }
                int pLength = this.minDistAB;
                for (ChokePoint.Node node : new ChokePoint.Node[]{ChokePoint.Node.END1, ChokePoint.Node.END2}) {
                    Position c = BwemExt.center(this.pBestCpA.getNodePosition(node));
                    int distAToB = this.a.getApproxDistance(c) + this.b.getApproxDistance(c);
                    pLength = Math.min(pLength, distAToB);
                }
                return Optional.of(new PathingResult(this.path, pLength));
            }
            return Optional.of(new PathingResult(this.path, this.minDistAB));
        }

        Optional<CPPath> getPath() {
            return Optional.ofNullable(this.path);
        }
    }
}

