/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;
import bwapi.Point;
import bwapi.Position;
import bwapi.WalkPosition;

public class TilePosition
extends Point<TilePosition> {
    public static final int SIZE_IN_PIXELS = 32;
    public static final TilePosition Invalid = new TilePosition(1000, 1000);
    public static final TilePosition None = new TilePosition(1000, 1001);
    public static final TilePosition Unknown = new TilePosition(1000, 1002);
    public static final TilePosition Origin = new TilePosition(0, 0);

    public TilePosition(int x, int y) {
        super(x, y, 32);
    }

    TilePosition(ClientData.Position position) {
        this(position.getX(), position.getY());
    }

    public Position toPosition() {
        return new Position(this.x * 32, this.y * 32);
    }

    public WalkPosition toWalkPosition() {
        return new WalkPosition(this.x * 4, this.y * 4);
    }

    @Override
    public TilePosition subtract(TilePosition other) {
        return new TilePosition(this.x - other.x, this.y - other.y);
    }

    @Override
    public TilePosition add(TilePosition other) {
        return new TilePosition(this.x + other.x, this.y + other.y);
    }

    @Override
    public TilePosition divide(int divisor) {
        return new TilePosition(this.x / divisor, this.y / divisor);
    }

    @Override
    public TilePosition multiply(int multiplier) {
        return new TilePosition(this.x * multiplier, this.y * multiplier);
    }
}

