/*
 * Decompiled with CFR 0.152.
 */
package unit;

import bwapi.Game;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import info.GameState;
import info.InformationManager;
import info.ScoutData;
import info.UnitTypeCount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import macro.plan.Plan;
import unit.BuildingManager;
import unit.WorkerManager;
import unit.managed.ManagedUnit;
import unit.managed.ManagedUnitFactory;
import unit.managed.UnitRole;
import unit.scout.ScoutManager;
import unit.squad.SquadManager;
import util.Time;

public class UnitManager {
    private Game game;
    private GameState gameState;
    private ManagedUnitFactory factory;
    private BuildingManager buildingManager;
    private InformationManager informationManager;
    private ScoutManager scoutManager;
    private SquadManager squadManager;
    private WorkerManager workerManager;
    private HashMap<Unit, ManagedUnit> managedUnitLookup;
    private HashSet<ManagedUnit> managedUnits;

    public UnitManager(Game game, InformationManager informationManager, BWEM bwem, GameState gameState) {
        this.game = game;
        this.gameState = gameState;
        this.factory = new ManagedUnitFactory(game);
        this.informationManager = informationManager;
        this.workerManager = new WorkerManager(game, gameState);
        this.squadManager = new SquadManager(game, gameState, informationManager);
        this.scoutManager = new ScoutManager(game, gameState, informationManager);
        this.buildingManager = new BuildingManager(game, gameState);
        this.managedUnitLookup = gameState.getManagedUnitLookup();
        this.managedUnits = gameState.getManagedUnits();
        this.initManagedUnits();
    }

    private void initManagedUnits() {
        for (Unit unit : this.game.getAllUnits()) {
            if (unit.getPlayer() != this.game.self()) continue;
            UnitType unitType = unit.getType();
            ManagedUnit managedUnit = this.createManagedUnit(unit, UnitRole.IDLE);
            if (unitType == UnitType.Zerg_Overlord) {
                this.createScout(managedUnit);
            }
            if (unitType == UnitType.Zerg_Drone) {
                this.createDrone(unit, managedUnit);
            }
            if (unitType == UnitType.Zerg_Larva) {
                this.createLarva(unit, managedUnit);
            }
            if (unitType != UnitType.Zerg_Hatchery) continue;
            this.createBuilding(unit, managedUnit);
        }
    }

    public void onFrame() {
        int frameCount = this.game.getFrameCount();
        if (frameCount < 1) {
            return;
        }
        this.checkBaseThreats();
        this.buildingManager.onFrame();
        this.workerManager.onFrame();
        this.squadManager.updateOverlordSquad();
        this.squadManager.updateFightSquads();
        this.squadManager.updateDefenseSquads();
        this.scoutManager.onFrame();
        Set<ManagedUnit> disbandedSquadUnits = this.squadManager.getDisbandedUnits();
        if (!disbandedSquadUnits.isEmpty()) {
            for (ManagedUnit managedUnit : disbandedSquadUnits) {
                this.squadManager.removeManagedUnit(managedUnit);
                this.createScout(managedUnit);
            }
        }
        for (ManagedUnit managedUnit : this.managedUnits) {
            if (!managedUnit.isReady() && this.game.getFrameCount() >= managedUnit.getUnreadyUntilFrame()) {
                managedUnit.setReady(true);
            }
            UnitRole role = managedUnit.getRole();
            switch (role) {
                case GATHER: 
                case FIGHT: 
                case BUILD: 
                case MORPH: 
                case LARVA: 
                case RETREAT: 
                case DEFEND: 
                case BUILDING: 
                case RALLY: 
                case REGROUP: {
                    managedUnit.execute();
                    break;
                }
                default: {
                    UnitType type = managedUnit.getUnitType();
                    switch (type) {
                        case Zerg_Drone: {
                            this.onFrameDrone(managedUnit, role);
                            break;
                        }
                        default: {
                            this.onFrameDefault(managedUnit, role);
                        }
                    }
                    managedUnit.execute();
                }
            }
        }
    }

    public void onUnitShow(Unit unit) {
        UnitType unitType;
        if (unit.getPlayer() != this.game.self()) {
            return;
        }
        if (unit.getType() == UnitType.Zerg_Larva && !this.managedUnitLookup.containsKey(unit)) {
            ManagedUnit managedUnit = this.createManagedUnit(unit, UnitRole.LARVA);
            this.workerManager.onUnitComplete(managedUnit);
            return;
        }
        ManagedUnit managedUnit = this.managedUnitLookup.containsKey(unit) ? this.managedUnitLookup.get(unit) : this.createManagedUnit(unit, UnitRole.IDLE);
        if (unit.getType() != managedUnit.getUnitType()) {
            UnitTypeCount unitTypeCount = this.gameState.getUnitTypeCount();
            unitTypeCount.removeUnit(managedUnit.getUnitType());
            unitTypeCount.addUnit(unit.getType());
            managedUnit.setUnitType(unit.getType());
        }
        if ((unitType = unit.getType()).isBuilding()) {
            this.createBuilding(unit, managedUnit);
            return;
        }
        this.assignManagedUnit(managedUnit);
    }

    private void assignManagedUnit(ManagedUnit managedUnit) {
        ScoutData scoutData = this.gameState.getScoutData();
        UnitType unitType = managedUnit.getUnitType();
        UnitRole role = managedUnit.getRole();
        if (role != UnitRole.IDLE) {
            return;
        }
        if (unitType == UnitType.Zerg_Larva) {
            this.workerManager.onUnitComplete(managedUnit);
            return;
        }
        if (unitType == UnitType.Zerg_Drone) {
            if (this.scoutManager.needDroneScout()) {
                this.createScout(managedUnit);
            } else {
                this.workerManager.onUnitComplete(managedUnit);
            }
            return;
        }
        if (unitType == UnitType.Zerg_Overlord) {
            HashSet<Unit> enemies = new HashSet<Unit>(this.gameState.getVisibleEnemyUnits());
            if (!scoutData.shouldOverlordsContinueScouting(this.game.enemy().getRace(), enemies)) {
                this.squadManager.addManagedUnit(managedUnit);
                this.scoutManager.removeScout(managedUnit);
            } else {
                this.createScout(managedUnit);
            }
            return;
        }
        if (!this.informationManager.isEnemyUnitVisible() && this.gameState.getEnemyBuildings().isEmpty()) {
            if (role != UnitRole.SCOUT) {
                this.createScout(managedUnit);
                this.squadManager.removeManagedUnit(managedUnit);
            }
            return;
        }
        if (managedUnit.canFight()) {
            managedUnit.setRole(UnitRole.FIGHT);
            this.squadManager.addManagedUnit(managedUnit);
        } else {
            this.createScout(managedUnit);
        }
    }

    public void onUnitComplete(Unit unit) {
        UnitType unitType = unit.getType();
        if (unitType.isBuilding()) {
            if (unitType == UnitType.Zerg_Extractor) {
                this.workerManager.onExtractorComplete(unit);
            } else {
                ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
                this.createBuilding(unit, managedUnit);
            }
            return;
        }
        if (!this.managedUnitLookup.containsKey(unit)) {
            return;
        }
        ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
        if (managedUnit.getRole() == UnitRole.MORPH) {
            managedUnit.setRole(UnitRole.IDLE);
        }
        this.assignManagedUnit(managedUnit);
    }

    private void removeManagedUnit(Unit unit) {
        ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
        if (managedUnit == null) {
            return;
        }
        HashMap<Unit, Plan> assignedPlannedItems = this.gameState.getAssignedPlannedItems();
        Plan assignedPlan = assignedPlannedItems.get(unit);
        if (assignedPlan != null) {
            this.gameState.cancelPlan(unit, assignedPlan);
        }
        this.buildingManager.remove(managedUnit);
        this.workerManager.removeManagedWorker(managedUnit);
        this.managedUnits.remove(managedUnit);
        this.squadManager.removeManagedUnit(managedUnit);
        this.scoutManager.removeScout(managedUnit);
        this.managedUnitLookup.remove(unit);
    }

    public void onUnitDestroy(Unit unit) {
        UnitType unitType = unit.getType();
        if (unitType == UnitType.Resource_Mineral_Field) {
            this.workerManager.removeMineral(unit);
            return;
        }
        if (unitType == UnitType.Zerg_Extractor) {
            this.workerManager.removeGeyser(unit);
            return;
        }
        this.removeManagedUnit(unit);
        this.squadManager.onUnitDestroy(unit);
    }

    public void onUnitMorph(Unit unit) {
        if (unit.getType() == UnitType.Zerg_Larva && !this.managedUnitLookup.containsKey(unit)) {
            this.workerManager.onUnitComplete(this.createManagedUnit(unit, UnitRole.LARVA));
            return;
        }
        if (!this.managedUnitLookup.containsKey(unit)) {
            return;
        }
        ManagedUnit managedUnit = this.managedUnitLookup.get(unit);
        UnitType type = unit.getType();
        if (type != managedUnit.getUnitType()) {
            managedUnit.setUnitType(unit.getType());
        }
        this.removeManagedUnit(unit);
        if (type.isBuilding()) {
            this.createBuilding(unit, managedUnit);
            return;
        }
        this.createManagedUnit(unit, managedUnit.getRole());
        this.assignManagedUnit(managedUnit);
    }

    private void onFrameDrone(ManagedUnit unit, UnitRole role) {
        if (role == UnitRole.SCOUT && this.scoutManager.endDroneScout()) {
            this.scoutManager.removeScout(unit);
            this.workerManager.addManagedWorker(unit);
        }
    }

    private void onFrameDefault(ManagedUnit managedUnit, UnitRole role) {
        ScoutData scoutData = this.gameState.getScoutData();
        if (role == UnitRole.SCOUT) {
            boolean shouldStopScouting = false;
            if (managedUnit.getUnitType() == UnitType.Zerg_Overlord) {
                HashSet<Unit> enemies = new HashSet<Unit>(this.gameState.getVisibleEnemyUnits());
                shouldStopScouting = !scoutData.shouldOverlordsContinueScouting(this.game.enemy().getRace(), enemies);
            } else {
                boolean bl = shouldStopScouting = scoutData.isEnemyBuildingLocationKnown() || this.informationManager.isEnemyUnitVisible();
            }
            if (shouldStopScouting) {
                managedUnit.setRole(UnitRole.RALLY);
                this.squadManager.addManagedUnit(managedUnit);
                this.scoutManager.removeScout(managedUnit);
                return;
            }
        }
        this.assignManagedUnit(managedUnit);
    }

    private void checkBaseThreats() {
        HashMap<Base, HashSet<Unit>> baseThreats = this.gameState.getBaseToThreatLookup();
        for (Base base : baseThreats.keySet()) {
            if (!baseThreats.get(base).isEmpty()) {
                this.assignGatherersToDefense(base);
                continue;
            }
            this.assignDefendersToGather(base);
        }
    }

    private void assignGatherersToDefense(Base base) {
        if (this.gameState.getGameTime().greaterThan(new Time(5, 0))) {
            return;
        }
        HashSet<ManagedUnit> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase().get(base);
        if (gatherersAssignedToBase.isEmpty()) {
            return;
        }
        ArrayList<Unit> threateningUnits = new ArrayList<Unit>((Collection)this.gameState.getBaseToThreatLookup().get(base));
        List<ManagedUnit> gatherersToReassign = this.squadManager.assignGathererDefenders(base, gatherersAssignedToBase, threateningUnits);
        for (ManagedUnit managedUnit : gatherersToReassign) {
            this.workerManager.removeManagedWorker(managedUnit);
        }
    }

    private void assignDefendersToGather(Base base) {
        HashSet<ManagedUnit> gatherersAssignedToBase = this.gameState.getGatherersAssignedToBase().get(base);
        List<ManagedUnit> gatherersToReassign = this.squadManager.disbandDefendSquad(base);
        for (ManagedUnit managedUnit : gatherersToReassign) {
            this.workerManager.addManagedWorker(managedUnit);
        }
    }

    private ManagedUnit createManagedUnit(Unit unit, UnitRole role) {
        ManagedUnit managedUnit = this.factory.create(unit, role);
        this.managedUnitLookup.put(unit, managedUnit);
        this.managedUnits.add(managedUnit);
        return managedUnit;
    }

    private void createScout(ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.SCOUT);
        this.scoutManager.addScout(managedUnit);
    }

    private void createDrone(Unit unit, ManagedUnit managedUnit) {
        this.managedUnits.add(managedUnit);
        this.workerManager.onUnitComplete(managedUnit);
        this.managedUnitLookup.put(unit, managedUnit);
    }

    private void createLarva(Unit unit, ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.LARVA);
        this.managedUnits.add(managedUnit);
        this.workerManager.onUnitComplete(managedUnit);
        this.managedUnitLookup.put(unit, managedUnit);
    }

    private void createBuilding(Unit unit, ManagedUnit managedUnit) {
        managedUnit.setRole(UnitRole.BUILDING);
        managedUnit.setCanFight(false);
        this.managedUnits.add(managedUnit);
        this.buildingManager.add(managedUnit);
        this.managedUnitLookup.put(unit, managedUnit);
    }

    @Generated
    public ScoutManager getScoutManager() {
        return this.scoutManager;
    }

    @Generated
    public SquadManager getSquadManager() {
        return this.squadManager;
    }
}

