/*
 * Decompiled with CFR 0.152.
 */
package org.bk.ass.sim;

import java.util.ArrayList;
import java.util.Collection;
import org.bk.ass.sim.Agent;
import org.bk.ass.sim.AgentUtil;
import org.bk.ass.sim.DamageType;
import org.bk.ass.sim.SplashType;
import org.bk.ass.sim.Weapon;

public class Evaluator {
    private static final double EPS = 1.0E-10;
    private final Parameters parameters;

    public Evaluator(Parameters parameters) {
        this.parameters = parameters;
    }

    public Evaluator() {
        this(new Parameters());
    }

    public double evaluate(Collection<Agent> agentsA, Collection<Agent> agentsB) {
        if (agentsA.isEmpty() && agentsB.isEmpty()) {
            return 0.5;
        }
        if (agentsA.isEmpty()) {
            return 0.0;
        }
        if (agentsB.isEmpty()) {
            return 1.0;
        }
        ArrayList<Agent> finalAgentsA = new ArrayList<Agent>();
        agentsA.forEach(a -> a.onDeathHandler.accept((Agent)a, (Collection<Agent>)finalAgentsA));
        ArrayList<Agent> finalAgentsB = new ArrayList<Agent>();
        agentsB.forEach(a -> a.onDeathHandler.accept((Agent)a, (Collection<Agent>)finalAgentsB));
        finalAgentsA.addAll(agentsA);
        finalAgentsB.addAll(agentsB);
        double damageToA = new DamageBoard(finalAgentsB).sumDamageTo(finalAgentsA);
        double damageToB = new DamageBoard(finalAgentsA).sumDamageTo(finalAgentsB);
        int regenToA = this.regeneration(finalAgentsA);
        int regenToB = this.regeneration(finalAgentsB);
        damageToA -= (double)regenToA;
        if (damageToA < 0.0) {
            damageToA = 0.0;
        }
        if ((damageToB -= (double)regenToB) < 0.0) {
            damageToB = 0.0;
        }
        double evalA = damageToA / (finalAgentsA.stream().mapToDouble(a -> (double)a.getHealth() + (double)a.getShields() * this.parameters.shieldScale).sum() + 1.0E-10);
        double evalB = damageToB / (finalAgentsB.stream().mapToDouble(a -> (double)a.getHealth() + (double)a.getShields() * this.parameters.shieldScale).sum() + 1.0E-10);
        return ((evalB *= (double)finalAgentsA.size()) + 5.0E-11) / ((evalA *= (double)finalAgentsB.size()) + evalB + 1.0E-10);
    }

    private int regeneration(Collection<Agent> agents) {
        int healables = (int)(agents.stream().filter(it -> it.isOrganic).count() - 1L);
        return agents.stream().mapToInt(a -> {
            int healed = 0;
            if (a.isHealer) {
                healed = (int)((double)healed + (double)healables * this.parameters.heal);
            }
            return healed;
        }).sum();
    }

    public static class Parameters {
        final double shieldScale;
        final double speedScale;
        final double rangeScale;
        final double radialSplashScale;
        final double lineSplashScale;
        final double bounceSplashFactor;
        final double heal;

        public Parameters(double[] source) {
            this.shieldScale = source[0];
            this.speedScale = source[1];
            this.rangeScale = source[2];
            this.radialSplashScale = source[3];
            this.lineSplashScale = source[4];
            this.bounceSplashFactor = source[5];
            this.heal = source[6] * 500000.0;
        }

        public Parameters() {
            this(new double[]{2.0608350462547205, 8.19938619214691, 0.19223277374228906, 7.706789576045348, 6.154650149331842, 5.884458141154542, 0.8991451082849068});
        }
    }

    private class DamageBoard {
        private int airDamageNormal;
        private int airConcussiveDamage;
        private int airExplosiveDamage;
        private int airConcussiveHits;
        private int airExplosiveHits;
        private int airNormalHits;
        private int groundDamageNormal;
        private int groundConcussiveDamage;
        private int groundExplosiveDamage;
        private int groundConcussiveHits;
        private int groundExplosiveHits;
        private int groundNormalHits;

        DamageBoard(Collection<Agent> attackers) {
            for (Agent agent : attackers) {
                this.sumAirDamage(agent);
                this.sumGroundDamage(agent);
            }
        }

        private void sumGroundDamage(Agent agent) {
            Weapon weapon = agent.groundWeapon;
            double damageToApply = this.calculateDamage(agent, weapon);
            if (weapon.damageType == DamageType.CONCUSSIVE) {
                this.groundConcussiveHits += weapon.hits;
                this.groundConcussiveDamage += (int)damageToApply;
            } else if (weapon.damageType == DamageType.EXPLOSIVE) {
                this.groundExplosiveHits += weapon.hits;
                this.groundExplosiveDamage += (int)damageToApply;
            } else {
                this.groundNormalHits += weapon.hits;
                this.groundDamageNormal += (int)damageToApply;
            }
        }

        private void sumAirDamage(Agent agent) {
            Weapon weapon = agent.airWeapon;
            double damageToApply = this.calculateDamage(agent, weapon);
            if (weapon.damageType == DamageType.CONCUSSIVE) {
                this.airConcussiveDamage += (int)damageToApply;
                this.airConcussiveHits += weapon.hits;
            } else if (weapon.damageType == DamageType.EXPLOSIVE) {
                this.airExplosiveDamage += (int)damageToApply;
                this.airExplosiveHits += weapon.hits;
            } else {
                this.airDamageNormal += (int)damageToApply;
                this.airNormalHits += weapon.hits;
            }
        }

        private double calculateDamage(Agent attacker, Weapon weapon) {
            double rangeFactor = (double)weapon.maxRange * ((Evaluator)Evaluator.this).parameters.rangeScale;
            double speedFactor = attacker.burrowedAttacker ? 0.0 : (double)attacker.speed * ((Evaluator)Evaluator.this).parameters.speedScale;
            double radialSplashFactor = weapon.splashType == SplashType.RADIAL_ENEMY_SPLASH || weapon.splashType == SplashType.RADIAL_SPLASH ? ((Evaluator)Evaluator.this).parameters.radialSplashScale * (double)weapon.innerSplashRadius : 0.0;
            double lineSplashFactor = weapon.splashType == SplashType.LINE_SPLASH ? ((Evaluator)Evaluator.this).parameters.lineSplashScale * (double)weapon.innerSplashRadius : 0.0;
            double bounceSplashFactor = weapon.splashType == SplashType.BOUNCE ? ((Evaluator)Evaluator.this).parameters.bounceSplashFactor : 0.0;
            return (double)weapon.damageShifted * (1.0 + rangeFactor + speedFactor + radialSplashFactor + lineSplashFactor + bounceSplashFactor) / (double)attacker.maxCooldown;
        }

        double sumDamageTo(Collection<Agent> targets) {
            double damageSum = 0.0;
            for (Agent target : targets) {
                if (!target.detected) continue;
                if (target.isFlyer) {
                    damageSum += (double)this.damageTakenBy(target, this.airConcussiveDamage, this.airConcussiveHits, this.airExplosiveDamage, this.airExplosiveHits, this.airDamageNormal, this.airNormalHits);
                    continue;
                }
                damageSum += (double)this.damageTakenBy(target, this.groundConcussiveDamage, this.groundConcussiveHits, this.groundExplosiveDamage, this.groundExplosiveHits, this.groundDamageNormal, this.groundNormalHits);
            }
            return damageSum;
        }

        private int damageTakenBy(Agent target, int concussiveDamage, int concussiveHits, int explosiveDamage, int explosiveHits, int normalDamage, int normalHits) {
            int damage = Math.max(AgentUtil.reduceDamageByTargetSizeAndDamageType(target, DamageType.CONCUSSIVE, concussiveDamage - concussiveHits * target.armorShifted), concussiveHits * 128);
            damage += Math.max(AgentUtil.reduceDamageByTargetSizeAndDamageType(target, DamageType.EXPLOSIVE, explosiveDamage - explosiveHits * target.armorShifted), explosiveHits * 128);
            return damage += Math.max(normalDamage - normalHits * target.armorShifted, normalHits * 128);
        }
    }
}

