/*
 * Decompiled with CFR 0.152.
 */
package macro.plan;

import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.UnitType;
import bwapi.UpgradeType;
import java.util.UUID;
import lombok.Generated;
import macro.plan.PlanState;
import macro.plan.PlanType;
import org.jetbrains.annotations.Nullable;

public class Plan {
    private final String uuid = UUID.randomUUID().toString();
    private PlanType type;
    private PlanState state = PlanState.PLANNED;
    protected int priority;
    private int frameStart;
    private int retries = 0;
    private int predictedReadyFrame = 0;
    protected boolean blockOtherPlans;
    @Nullable
    private TilePosition buildPosition;
    @Nullable
    private UnitType plannedUnit;
    @Nullable
    private UpgradeType plannedUpgrade;
    @Nullable
    private TechType plannedTechType;

    public Plan(int priority, boolean isBlocking) {
        this.priority = priority;
        this.blockOtherPlans = isBlocking;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Plan)) {
            return false;
        }
        Plan u = (Plan)o;
        return this.uuid.equals(u.getUuid());
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    public String getName() {
        return "PLAN";
    }

    public int mineralPrice() {
        return 0;
    }

    @Generated
    public String getUuid() {
        return this.uuid;
    }

    @Generated
    public PlanType getType() {
        return this.type;
    }

    @Generated
    public PlanState getState() {
        return this.state;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public int getFrameStart() {
        return this.frameStart;
    }

    @Generated
    public int getRetries() {
        return this.retries;
    }

    @Generated
    public int getPredictedReadyFrame() {
        return this.predictedReadyFrame;
    }

    @Generated
    public boolean isBlockOtherPlans() {
        return this.blockOtherPlans;
    }

    @Nullable
    @Generated
    public TilePosition getBuildPosition() {
        return this.buildPosition;
    }

    @Nullable
    @Generated
    public UnitType getPlannedUnit() {
        return this.plannedUnit;
    }

    @Nullable
    @Generated
    public UpgradeType getPlannedUpgrade() {
        return this.plannedUpgrade;
    }

    @Nullable
    @Generated
    public TechType getPlannedTechType() {
        return this.plannedTechType;
    }

    @Generated
    public void setType(PlanType type) {
        this.type = type;
    }

    @Generated
    public void setState(PlanState state) {
        this.state = state;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setFrameStart(int frameStart) {
        this.frameStart = frameStart;
    }

    @Generated
    public void setRetries(int retries) {
        this.retries = retries;
    }

    @Generated
    public void setPredictedReadyFrame(int predictedReadyFrame) {
        this.predictedReadyFrame = predictedReadyFrame;
    }

    @Generated
    public void setBlockOtherPlans(boolean blockOtherPlans) {
        this.blockOtherPlans = blockOtherPlans;
    }

    @Generated
    public void setBuildPosition(@Nullable TilePosition buildPosition) {
        this.buildPosition = buildPosition;
    }

    @Generated
    public void setPlannedUnit(@Nullable UnitType plannedUnit) {
        this.plannedUnit = plannedUnit;
    }

    @Generated
    public void setPlannedUpgrade(@Nullable UpgradeType plannedUpgrade) {
        this.plannedUpgrade = plannedUpgrade;
    }

    @Generated
    public void setPlannedTechType(@Nullable TechType plannedTechType) {
        this.plannedTechType = plannedTechType;
    }

    @Generated
    public String toString() {
        return "Plan(uuid=" + this.getUuid() + ", type=" + (Object)((Object)this.getType()) + ", state=" + (Object)((Object)this.getState()) + ", priority=" + this.getPriority() + ", frameStart=" + this.getFrameStart() + ", retries=" + this.getRetries() + ", predictedReadyFrame=" + this.getPredictedReadyFrame() + ", blockOtherPlans=" + this.isBlockOtherPlans() + ", buildPosition=" + this.getBuildPosition() + ", plannedUnit=" + (Object)((Object)this.getPlannedUnit()) + ", plannedUpgrade=" + (Object)((Object)this.getPlannedUpgrade()) + ", plannedTechType=" + (Object)((Object)this.getPlannedTechType()) + ")";
    }
}

