/*
 * Decompiled with CFR 0.152.
 */
package learning;

import java.util.ArrayList;
import java.util.List;
import learning.UCBRecord;
import lombok.Generated;

public class Record
implements UCBRecord {
    private static final double GAMMA = 0.95;
    private String opener;
    private int wins;
    private int losses;
    private List<Long> winTimestamps;
    private List<Long> lossTimestamps;

    public int netWins() {
        return this.wins - this.losses;
    }

    @Override
    public int wins() {
        return this.wins;
    }

    @Override
    public int games() {
        return this.wins + this.losses;
    }

    @Override
    public int winsSquared() {
        return this.wins * this.wins;
    }

    public void addWinTimestamp(long timestamp) {
        this.winTimestamps.add(timestamp);
    }

    public void addLossTimestamp(long timestamp) {
        this.lossTimestamps.add(timestamp);
    }

    @Override
    public double index(int totalGames) {
        if (totalGames == 0 || this.games() == 0) {
            return 1.0;
        }
        double discountedWins = this.calculateDiscountedWins();
        double discountedGames = this.calculateDiscountedGames();
        if (discountedGames == 0.0) {
            return 1.0;
        }
        double sampleMean = discountedWins / discountedGames;
        double c = Math.sqrt(2.0 * Math.log(totalGames) / discountedGames);
        return sampleMean + c;
    }

    private double calculateDiscountedWins() {
        ArrayList<Long> allTimestamps = new ArrayList<Long>();
        allTimestamps.addAll(this.winTimestamps);
        allTimestamps.addAll(this.lossTimestamps);
        allTimestamps.sort((a, b) -> Long.compare(b, a));
        double discountedWins = 0.0;
        int i = 0;
        while (i < allTimestamps.size()) {
            Long t = (Long)allTimestamps.get(i);
            if (this.winTimestamps.contains(t)) {
                double weight = Math.pow(0.95, i);
                discountedWins += weight;
            }
            ++i;
        }
        return discountedWins;
    }

    private double calculateDiscountedGames() {
        ArrayList<Long> allTimestamps = new ArrayList<Long>();
        allTimestamps.addAll(this.winTimestamps);
        allTimestamps.addAll(this.lossTimestamps);
        double discountedGames = 0.0;
        int i = 0;
        while (i < allTimestamps.size()) {
            double weight = Math.pow(0.95, i);
            discountedGames += weight;
            ++i;
        }
        return discountedGames;
    }

    @Generated
    private static List<Long> $default$winTimestamps() {
        return new ArrayList<Long>();
    }

    @Generated
    private static List<Long> $default$lossTimestamps() {
        return new ArrayList<Long>();
    }

    @Generated
    Record(String opener, int wins, int losses, List<Long> winTimestamps, List<Long> lossTimestamps) {
        this.opener = opener;
        this.wins = wins;
        this.losses = losses;
        this.winTimestamps = winTimestamps;
        this.lossTimestamps = lossTimestamps;
    }

    @Generated
    public static RecordBuilder builder() {
        return new RecordBuilder();
    }

    @Generated
    public String getOpener() {
        return this.opener;
    }

    @Generated
    public int getWins() {
        return this.wins;
    }

    @Generated
    public int getLosses() {
        return this.losses;
    }

    @Generated
    public List<Long> getWinTimestamps() {
        return this.winTimestamps;
    }

    @Generated
    public List<Long> getLossTimestamps() {
        return this.lossTimestamps;
    }

    @Generated
    public void setOpener(String opener) {
        this.opener = opener;
    }

    @Generated
    public void setWins(int wins) {
        this.wins = wins;
    }

    @Generated
    public void setLosses(int losses) {
        this.losses = losses;
    }

    @Generated
    public void setWinTimestamps(List<Long> winTimestamps) {
        this.winTimestamps = winTimestamps;
    }

    @Generated
    public void setLossTimestamps(List<Long> lossTimestamps) {
        this.lossTimestamps = lossTimestamps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWins() != other.getWins()) {
            return false;
        }
        if (this.getLosses() != other.getLosses()) {
            return false;
        }
        String this$opener = this.getOpener();
        String other$opener = other.getOpener();
        if (this$opener == null ? other$opener != null : !this$opener.equals(other$opener)) {
            return false;
        }
        List<Long> this$winTimestamps = this.getWinTimestamps();
        List<Long> other$winTimestamps = other.getWinTimestamps();
        if (this$winTimestamps == null ? other$winTimestamps != null : !((Object)this$winTimestamps).equals(other$winTimestamps)) {
            return false;
        }
        List<Long> this$lossTimestamps = this.getLossTimestamps();
        List<Long> other$lossTimestamps = other.getLossTimestamps();
        return !(this$lossTimestamps == null ? other$lossTimestamps != null : !((Object)this$lossTimestamps).equals(other$lossTimestamps));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Record;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWins();
        result = result * 59 + this.getLosses();
        String $opener = this.getOpener();
        result = result * 59 + ($opener == null ? 43 : $opener.hashCode());
        List<Long> $winTimestamps = this.getWinTimestamps();
        result = result * 59 + ($winTimestamps == null ? 43 : ((Object)$winTimestamps).hashCode());
        List<Long> $lossTimestamps = this.getLossTimestamps();
        result = result * 59 + ($lossTimestamps == null ? 43 : ((Object)$lossTimestamps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Record(opener=" + this.getOpener() + ", wins=" + this.getWins() + ", losses=" + this.getLosses() + ", winTimestamps=" + this.getWinTimestamps() + ", lossTimestamps=" + this.getLossTimestamps() + ")";
    }

    @Generated
    public static class RecordBuilder {
        @Generated
        private String opener;
        @Generated
        private int wins;
        @Generated
        private int losses;
        @Generated
        private List<Long> winTimestamps$value;
        @Generated
        private boolean winTimestamps$set;
        @Generated
        private List<Long> lossTimestamps$value;
        @Generated
        private boolean lossTimestamps$set;

        @Generated
        RecordBuilder() {
        }

        @Generated
        public RecordBuilder opener(String opener) {
            this.opener = opener;
            return this;
        }

        @Generated
        public RecordBuilder wins(int wins) {
            this.wins = wins;
            return this;
        }

        @Generated
        public RecordBuilder losses(int losses) {
            this.losses = losses;
            return this;
        }

        @Generated
        public RecordBuilder winTimestamps(List<Long> winTimestamps) {
            this.winTimestamps$value = winTimestamps;
            this.winTimestamps$set = true;
            return this;
        }

        @Generated
        public RecordBuilder lossTimestamps(List<Long> lossTimestamps) {
            this.lossTimestamps$value = lossTimestamps;
            this.lossTimestamps$set = true;
            return this;
        }

        @Generated
        public Record build() {
            List winTimestamps$value = this.winTimestamps$value;
            if (!this.winTimestamps$set) {
                winTimestamps$value = Record.$default$winTimestamps();
            }
            List lossTimestamps$value = this.lossTimestamps$value;
            if (!this.lossTimestamps$set) {
                lossTimestamps$value = Record.$default$lossTimestamps();
            }
            return new Record(this.opener, this.wins, this.losses, winTimestamps$value, lossTimestamps$value);
        }

        @Generated
        public String toString() {
            return "Record.RecordBuilder(opener=" + this.opener + ", wins=" + this.wins + ", losses=" + this.losses + ", winTimestamps$value=" + this.winTimestamps$value + ", lossTimestamps$value=" + this.lossTimestamps$value + ")";
        }
    }
}

