/*
 * Decompiled with CFR 0.152.
 */
package learning;

import bwapi.Game;
import bwapi.Race;
import bwem.BWEM;
import config.Config;
import info.GameState;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import learning.Decisions;
import learning.GameRecord;
import learning.MapAwareRecord;
import learning.OpponentRecord;
import learning.Record;
import learning.UCBRecordComparator;
import learning.WeightedUCBCalculator;
import strategy.BuildOrderFactory;
import strategy.buildorder.BuildOrder;

public class LearningManager {
    private Config config;
    private static String READ_DIR = "bwapi-data/read/";
    private static String WRITE_DIR = "bwapi-data/write/";
    private Game game;
    private BWEM bwem;
    private GameState gameState;
    private Race opponentRace;
    private String opponentName;
    private String opponentFileName;
    private OpponentRecord opponentRecord;
    private Decisions decisions = new Decisions();
    private Record currentOpener;
    private Record activeBuildOrderRecord;
    private BuildOrderFactory buildOrderFactory;

    public LearningManager(Config config, Game game, BWEM bwem, GameState gameState) {
        this.config = config;
        this.game = game;
        this.bwem = bwem;
        this.gameState = gameState;
        this.opponentRace = game.enemy().getRace();
        this.opponentName = game.enemy().getName();
        this.opponentFileName = String.valueOf(this.opponentName) + "_" + (Object)((Object)this.opponentRace) + ".csv";
        this.opponentRecord = OpponentRecord.builder().name(this.opponentName).race(this.opponentRace.toString()).wins(0).losses(0).version(0).openerRecord(new HashMap<String, Record>()).buildOrderRecord(new HashMap<String, Record>()).build();
        this.buildOrderFactory = new BuildOrderFactory(bwem.getMap().getStartingLocations().size(), this.opponentRace);
        try {
            this.readOpponentRecord();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.ensureOpenersInOpponentRecord();
        this.decisions.setOpener(this.determineOpener());
    }

    public void onEnd(boolean isWinner) {
        long currentTimestamp = System.currentTimeMillis();
        if (isWinner) {
            this.currentOpener.setWins(this.currentOpener.getWins() + 1);
            this.currentOpener.addWinTimestamp(currentTimestamp);
            this.opponentRecord.setWins(this.opponentRecord.getWins() + 1);
        } else {
            this.currentOpener.setLosses(this.currentOpener.getLosses() + 1);
            this.currentOpener.addLossTimestamp(currentTimestamp);
            this.opponentRecord.setLosses(this.opponentRecord.getLosses() + 1);
        }
        Map<String, Record> openerRecords = this.opponentRecord.getOpenerRecord();
        openerRecords.put(this.currentOpener.getOpener(), this.currentOpener);
        if (this.activeBuildOrderRecord != null && !this.activeBuildOrderRecord.getOpener().equals(this.currentOpener.getOpener())) {
            if (isWinner) {
                this.activeBuildOrderRecord.setWins(this.activeBuildOrderRecord.getWins() + 1);
                this.activeBuildOrderRecord.addWinTimestamp(currentTimestamp);
            } else {
                this.activeBuildOrderRecord.setLosses(this.activeBuildOrderRecord.getLosses() + 1);
                this.activeBuildOrderRecord.addLossTimestamp(currentTimestamp);
            }
            Map<String, Record> buildOrderRecords = this.opponentRecord.getBuildOrderRecord();
            buildOrderRecords.put(this.activeBuildOrderRecord.getOpener(), this.activeBuildOrderRecord);
        }
        try {
            this.writeGameRecord(isWinner);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Decisions getDecisions() {
        return this.decisions;
    }

    public OpponentRecord getOpponentRecord() {
        return this.opponentRecord;
    }

    private void readOpponentRecord() throws IOException {
        File file = new File(String.valueOf(READ_DIR) + this.opponentFileName);
        if (!file.exists()) {
            this.opponentRecord.setName(this.opponentName);
            this.opponentRecord.setRace(this.opponentRace.toString());
            this.opponentRecord.ensureMapSpecificRecords();
            return;
        }
        List<String> lines = Files.readAllLines(file.toPath());
        if (lines.size() <= 1) {
            this.opponentRecord.setName(this.opponentName);
            this.opponentRecord.setRace(this.opponentRace.toString());
            this.opponentRecord.ensureMapSpecificRecords();
            return;
        }
        this.opponentRecord.ensureMapSpecificRecords();
        int i = 1;
        while (i < lines.size()) {
            Record openerRecord;
            GameRecord record = GameRecord.fromCsvRow(lines.get(i));
            if (record.isWinner()) {
                this.opponentRecord.setWins(this.opponentRecord.getWins() + 1);
            } else {
                this.opponentRecord.setLosses(this.opponentRecord.getLosses() + 1);
            }
            Map<String, Record> openerRecords = this.opponentRecord.getOpenerRecord();
            if (openerRecords == null) {
                openerRecords = new HashMap<String, Record>();
                this.opponentRecord.setOpenerRecord(openerRecords);
            }
            if ((openerRecord = openerRecords.get(record.getOpener())) == null) {
                openerRecord = Record.builder().opener(record.getOpener()).wins(0).losses(0).build();
                openerRecords.put(record.getOpener(), openerRecord);
            }
            if (record.isWinner()) {
                openerRecord.setWins(openerRecord.getWins() + 1);
                openerRecord.addWinTimestamp(record.getTimestamp());
            } else {
                openerRecord.setLosses(openerRecord.getLosses() + 1);
                openerRecord.addLossTimestamp(record.getTimestamp());
            }
            String mapOpenerKey = WeightedUCBCalculator.createMapKey(record.getMapName(), record.getOpener());
            MapAwareRecord mapOpenerRecord = this.opponentRecord.getMapSpecificOpenerRecord().get(mapOpenerKey);
            if (mapOpenerRecord == null) {
                mapOpenerRecord = MapAwareRecord.builder().strategy(record.getOpener()).mapName(record.getMapName()).opponentName(this.opponentName).opponentRace(this.opponentRace.toString()).wins(0).losses(0).build();
                this.opponentRecord.getMapSpecificOpenerRecord().put(mapOpenerKey, mapOpenerRecord);
            }
            if (record.isWinner()) {
                mapOpenerRecord.setWins(mapOpenerRecord.getWins() + 1);
                mapOpenerRecord.addWinTimestamp(record.getTimestamp());
            } else {
                mapOpenerRecord.setLosses(mapOpenerRecord.getLosses() + 1);
                mapOpenerRecord.addLossTimestamp(record.getTimestamp());
            }
            if (record.getBuildOrder() != null && !record.getBuildOrder().equals(record.getOpener())) {
                Record buildOrderRecord;
                Map<String, Record> buildOrderRecords = this.opponentRecord.getBuildOrderRecord();
                if (buildOrderRecords == null) {
                    buildOrderRecords = new HashMap<String, Record>();
                    this.opponentRecord.setBuildOrderRecord(buildOrderRecords);
                }
                if ((buildOrderRecord = buildOrderRecords.get(record.getBuildOrder())) == null) {
                    buildOrderRecord = Record.builder().opener(record.getBuildOrder()).wins(0).losses(0).build();
                    buildOrderRecords.put(record.getBuildOrder(), buildOrderRecord);
                }
                if (record.isWinner()) {
                    buildOrderRecord.setWins(buildOrderRecord.getWins() + 1);
                    buildOrderRecord.addWinTimestamp(record.getTimestamp());
                } else {
                    buildOrderRecord.setLosses(buildOrderRecord.getLosses() + 1);
                    buildOrderRecord.addLossTimestamp(record.getTimestamp());
                }
                String mapBuildOrderKey = WeightedUCBCalculator.createMapKey(record.getMapName(), record.getBuildOrder());
                MapAwareRecord mapBuildOrderRecord = this.opponentRecord.getMapSpecificBuildOrderRecord().get(mapBuildOrderKey);
                if (mapBuildOrderRecord == null) {
                    mapBuildOrderRecord = MapAwareRecord.builder().strategy(record.getBuildOrder()).mapName(record.getMapName()).opponentName(this.opponentName).opponentRace(this.opponentRace.toString()).wins(0).losses(0).build();
                    this.opponentRecord.getMapSpecificBuildOrderRecord().put(mapBuildOrderKey, mapBuildOrderRecord);
                }
                if (record.isWinner()) {
                    mapBuildOrderRecord.setWins(mapBuildOrderRecord.getWins() + 1);
                    mapBuildOrderRecord.addWinTimestamp(record.getTimestamp());
                } else {
                    mapBuildOrderRecord.setLosses(mapBuildOrderRecord.getLosses() + 1);
                    mapBuildOrderRecord.addLossTimestamp(record.getTimestamp());
                }
            }
            ++i;
        }
    }

    private void writeGameRecord(boolean isWinner) throws IOException {
        File readFile = new File(String.valueOf(READ_DIR) + this.opponentFileName);
        File writeFile = new File(String.valueOf(WRITE_DIR) + this.opponentFileName);
        if (!writeFile.exists()) {
            writeFile.createNewFile();
            String header = "timestamp,is_winner,num_starting_locations,map_name,opponent_name,opponent_race,opener,build_order,detected_strategies\n";
            Files.write(writeFile.toPath(), header.getBytes(), StandardOpenOption.APPEND);
            if (readFile.exists() && readFile.isFile()) {
                List<String> readLines = Files.readAllLines(readFile.toPath());
                int i = 1;
                while (i < readLines.size()) {
                    String dataRow = String.valueOf(readLines.get(i)) + "\n";
                    Files.write(writeFile.toPath(), dataRow.getBytes(), StandardOpenOption.APPEND);
                    ++i;
                }
            }
        }
        if (!writeFile.isFile()) {
            return;
        }
        GameRecord gameRecord = GameRecord.builder().timestamp(System.currentTimeMillis()).numStartingLocations(this.bwem.getMap().getStartingLocations().size()).mapName(this.game.mapFileName()).opponentName(this.opponentName).opponentRace(this.opponentRace.toString()).opener(this.currentOpener.getOpener()).buildOrder(this.activeBuildOrderRecord != null ? this.activeBuildOrderRecord.getOpener() : this.currentOpener.getOpener()).detectedStrategies(this.gameState.getStrategyTracker() != null ? this.gameState.getStrategyTracker().getDetectedStrategiesAsString() : "").isWinner(isWinner).build();
        String csvRow = String.valueOf(gameRecord.toCsvRow()) + "\n";
        Files.write(writeFile.toPath(), csvRow.getBytes(), StandardOpenOption.APPEND);
    }

    private void ensureOpenersInOpponentRecord() {
        Map<String, Record> openerRecordMap = this.opponentRecord.getOpenerRecord();
        if (openerRecordMap == null) {
            openerRecordMap = new HashMap<String, Record>();
            this.opponentRecord.setOpenerRecord(openerRecordMap);
        }
        ArrayList<String> knownOpeners = new ArrayList<String>(openerRecordMap.keySet());
        Set missingOpeners = this.buildOrderFactory.getOpenerNames().stream().filter(s -> !knownOpeners.contains(s)).collect(Collectors.toSet());
        for (String opener : missingOpeners) {
            openerRecordMap.put(opener, Record.builder().opener(opener).wins(0).losses(0).build());
        }
        Map<String, Record> buildOrderRecordMap = this.opponentRecord.getBuildOrderRecord();
        if (buildOrderRecordMap == null) {
            buildOrderRecordMap = new HashMap<String, Record>();
            this.opponentRecord.setBuildOrderRecord(buildOrderRecordMap);
        }
        ArrayList<String> knownBuildOrders = new ArrayList<String>(buildOrderRecordMap.keySet());
        Set missingBuildOrders = this.buildOrderFactory.getPlayableNonOpenerNames().stream().filter(s -> !knownBuildOrders.contains(s)).collect(Collectors.toSet());
        for (String buildOrder : missingBuildOrders) {
            buildOrderRecordMap.put(buildOrder, Record.builder().opener(buildOrder).wins(0).losses(0).build());
        }
    }

    private BuildOrder determineOpener() {
        BuildOrder forced;
        if (this.config.openerOverride != null && (forced = this.buildOrderFactory.getByName(this.config.openerOverride)) != null && this.buildOrderFactory.isPlayableOpener(forced)) {
            this.currentOpener = this.opponentRecord.getOpenerRecord().get(forced.getName());
            return forced;
        }
        String currentMapName = this.game.mapFileName();
        List<String> playableOpeners = this.opponentRecord.getOpenerRecord().keySet().stream().filter(openerName -> this.buildOrderFactory.isPlayableOpener(this.buildOrderFactory.getByName((String)openerName))).collect(Collectors.toList());
        if (playableOpeners.isEmpty()) {
            List allRecords = this.opponentRecord.getOpenerRecord().values().stream().filter(rec -> this.buildOrderFactory.isPlayableOpener(this.buildOrderFactory.getByName(rec.getOpener()))).sorted(new UCBRecordComparator(this.opponentRecord.totalGames())).collect(Collectors.toList());
            if (allRecords.isEmpty()) {
                return null;
            }
            this.currentOpener = (Record)allRecords.get(0);
            return this.buildOrderFactory.getByName(this.currentOpener.getOpener());
        }
        String bestOpener = WeightedUCBCalculator.findBestStrategy(playableOpeners, currentMapName, this.opponentName, this.opponentRecord.getMapSpecificOpenerRecord(), this.opponentRecord.getOpenerRecord(), this.opponentRecord.totalGames());
        if (bestOpener != null) {
            this.currentOpener = this.opponentRecord.getOpenerRecord().get(bestOpener);
            return this.buildOrderFactory.getByName(bestOpener);
        }
        return null;
    }

    public BuildOrder determineBuildOrder(Set<BuildOrder> candidates) {
        BuildOrder forced;
        if (candidates.size() == 0) {
            return null;
        }
        for (BuildOrder candidate : candidates) {
            if (this.opponentRecord.getBuildOrderRecord().containsKey(candidate.getName())) continue;
            this.opponentRecord.getBuildOrderRecord().put(candidate.getName(), Record.builder().opener(candidate.getName()).wins(0).losses(0).build());
        }
        if (this.config.strategyOverride != null && (forced = this.buildOrderFactory.getByName(this.config.strategyOverride)) != null && candidates.contains(forced)) {
            this.activeBuildOrderRecord = this.opponentRecord.getBuildOrderRecord().get(forced.getName());
            return forced;
        }
        if (candidates.size() == 1) {
            BuildOrder singleCandidate = candidates.iterator().next();
            this.activeBuildOrderRecord = this.opponentRecord.getBuildOrderRecord().get(singleCandidate.getName());
            return singleCandidate;
        }
        String currentMapName = this.game.mapFileName();
        List<String> candidateNames = candidates.stream().map(BuildOrder::getName).collect(Collectors.toList());
        String bestBuildOrder = WeightedUCBCalculator.findBestStrategy(candidateNames, currentMapName, this.opponentName, this.opponentRecord.getMapSpecificBuildOrderRecord(), this.opponentRecord.getBuildOrderRecord(), this.opponentRecord.totalGames());
        if (bestBuildOrder != null) {
            this.activeBuildOrderRecord = this.opponentRecord.getBuildOrderRecord().get(bestBuildOrder);
            return this.buildOrderFactory.getByName(bestBuildOrder);
        }
        List allRecords = this.opponentRecord.getBuildOrderRecord().values().stream().filter(rec -> {
            BuildOrder buildOrder = this.buildOrderFactory.getByName(rec.getOpener());
            return buildOrder != null && candidates.contains(buildOrder);
        }).sorted(new UCBRecordComparator(this.opponentRecord.totalGames())).collect(Collectors.toList());
        if (allRecords.isEmpty()) {
            return null;
        }
        this.activeBuildOrderRecord = (Record)allRecords.get(0);
        return this.buildOrderFactory.getByName(this.activeBuildOrderRecord.getOpener());
    }
}

