/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.Color;
import bwapi.Game;
import bwapi.PlayerType;
import bwapi.Position;
import bwapi.Race;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WalkPosition;
import bwem.BWEM;
import bwem.Base;
import bwem.Geyser;
import info.BaseData;
import info.BaseManager;
import info.GameState;
import info.ScoutData;
import info.TechProgression;
import info.UnitTypeCount;
import info.map.BuildingPlanner;
import info.map.GameMap;
import info.map.MapTile;
import info.map.MapTileType;
import info.tracking.ObservedUnitTracker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import learning.LearningManager;
import macro.plan.Plan;
import macro.plan.PlanType;
import org.jetbrains.annotations.Nullable;
import strategy.buildorder.BuildOrder;

public class InformationManager {
    private BWEM bwem;
    private Game game;
    private GameState gameState;
    private BaseManager baseManager;
    private LearningManager learningManager;
    private HashSet<Base> startingBasesSet = new HashSet();
    private HashSet<Base> expansionBasesSet = new HashSet();
    private static final int DETECTION_DISTANCE = 10;

    private boolean isGasStructure(UnitType unitType) {
        return unitType == UnitType.Terran_Refinery || unitType == UnitType.Zerg_Extractor || unitType == UnitType.Protoss_Assimilator;
    }

    public InformationManager(BWEM bwem, Game game, GameState gameState, LearningManager learningManager) {
        this.bwem = bwem;
        this.game = game;
        this.gameState = gameState;
        this.learningManager = learningManager;
        this.initBases();
        this.initializeGameMap();
        this.baseManager = new BaseManager(bwem, game, gameState);
    }

    public void onFrame() {
        this.gameState.onFrame();
        this.ageHeatMap();
        this.trackEnemyUnits();
        this.trackEnemyBuildings();
        this.checkEnemyBuildingPositions();
        this.debugEnemyTargets();
        this.checkScoutTargets();
        this.checkIfEnemyUnitsStillThreatenBase();
        this.checkBaseThreats();
        BuildOrder active = this.gameState.getActiveBuildOrder();
        if (active.shouldTransition(this.gameState)) {
            BuildOrder transition = this.transitionBuildOrder();
            this.gameState.setActiveBuildOrder(transition);
            this.gameState.setTransitionBuildOrder(true);
        }
    }

    public void onUnitHide(Unit unit) {
        UnitType unitType = unit.getInitialType();
        if (unit.getPlayer() == this.game.self() || unitType.isResourceContainer() || unitType.isMineralField() || unitType.isNeutral() || unitType.isSpecialBuilding() || unitType == UnitType.Unknown) {
            return;
        }
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        tracker.onUnitHide(unit, this.game.getFrameCount());
    }

    public void updateTechProgression(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (unitType) {
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(true);
                break;
            }
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(true);
                break;
            }
            case Zerg_Spire: {
                techProgression.setSpire(true);
                break;
            }
            case Zerg_Lair: {
                techProgression.setLair(true);
                break;
            }
            case Zerg_Evolution_Chamber: {
                techProgression.setPlannedEvolutionChambers(techProgression.getPlannedEvolutionChambers() - 1);
                techProgression.setEvolutionChambers(techProgression.evolutionChambers() + 1);
                break;
            }
            case Zerg_Queens_Nest: {
                techProgression.setQueensNest(true);
                break;
            }
            case Zerg_Hive: {
                techProgression.setHive(true);
            }
        }
    }

    public void onUnitShow(Unit unit) {
        UnitType unitType = unit.getInitialType();
        PlayerType playerType = unit.getPlayer().getType();
        if (playerType == PlayerType.Neutral || playerType == PlayerType.None) {
            return;
        }
        if (unit.getPlayer() == this.game.self()) {
            this.updateTechProgression(unitType);
            return;
        }
        if (unitType.isResourceContainer() && !this.isGasStructure(unitType) || unitType.isMineralField() || unitType.isNeutral() || unitType.isSpecialBuilding() || unitType == UnitType.Unknown) {
            return;
        }
        if (this.gameState.getOpponentRace() == Race.Unknown) {
            Race race = unit.getType().getRace();
            this.gameState.updateRace(race);
        }
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        boolean isProxied = this.isProxiedBuilding(unit);
        tracker.onUnitShow(unit, this.game.getFrameCount(), isProxied);
    }

    public void onUnitMorph(Unit unit) {
        HashMap<Unit, Plan> assignedPlannedItems = this.gameState.getAssignedPlannedItems();
        Plan assignedPlan = assignedPlannedItems.get(unit);
        if (assignedPlan == null) {
            return;
        }
        UnitType plannedUnit = assignedPlan.getPlannedUnit();
        if (assignedPlan.getType() == PlanType.BUILDING) {
            UnitTypeCount count = this.gameState.getUnitTypeCount();
            if (plannedUnit == UnitType.Zerg_Sunken_Colony) {
                count.removeUnit(UnitType.Zerg_Creep_Colony);
            } else if (plannedUnit == UnitType.Zerg_Lair) {
                count.removeUnit(UnitType.Zerg_Hatchery);
            } else {
                count.removeUnit(UnitType.Zerg_Drone);
            }
            this.updateTechProgression(plannedUnit);
        } else if (assignedPlan.getType() == PlanType.UNIT) {
            UnitTypeCount count = this.gameState.getUnitTypeCount();
            if (plannedUnit == UnitType.Zerg_Lurker) {
                count.removeUnit(UnitType.Zerg_Hydralisk);
            }
        }
    }

    public void onUnitComplete(Unit unit) {
        UnitType unitType = unit.getType();
        UnitTypeCount unitCount = this.gameState.getUnitTypeCount();
        unitCount.addUnit(unitType);
        unitCount.unplanUnit(unitType);
    }

    public void onUnitRenegade(Unit unit) {
        if (unit.getType() == UnitType.Resource_Vespene_Geyser) {
            this.onUnitDestroy(unit);
        }
    }

    public void updateTechOnDestroy(UnitType unitType) {
        TechProgression techProgression = this.gameState.getTechProgression();
        switch (unitType) {
            case Zerg_Spawning_Pool: {
                techProgression.setSpawningPool(false);
                techProgression.setPlannedSpawningPool(false);
                break;
            }
            case Zerg_Hydralisk_Den: {
                techProgression.setHydraliskDen(false);
                techProgression.setPlannedDen(false);
                break;
            }
            case Zerg_Spire: {
                techProgression.setSpire(false);
                techProgression.setPlannedSpire(false);
                break;
            }
            case Zerg_Lair: {
                techProgression.setLair(false);
                techProgression.setPlannedLair(false);
                break;
            }
            case Zerg_Evolution_Chamber: {
                int evolutionChambers = techProgression.getEvolutionChambers();
                techProgression.setEvolutionChambers(evolutionChambers - 1);
                break;
            }
            case Zerg_Queens_Nest: {
                techProgression.setQueensNest(false);
                techProgression.setPlannedQueensNest(false);
                break;
            }
            case Zerg_Hive: {
                techProgression.setHive(false);
                techProgression.setPlannedHive(false);
            }
        }
    }

    public void onUnitDestroy(Unit unit) {
        UnitType unitType = unit.getType();
        if (unit.getPlayer() == this.game.enemy() && unitType.isBuilding()) {
            ScoutData scoutData = this.gameState.getScoutData();
            scoutData.removeEnemyBuildingLocation(unit.getTilePosition());
        }
        this.ensureEnemyUnitRemovedFromBaseThreats(unit);
        if (unit.getPlayer() == this.game.self()) {
            this.baseManager.onUnitDestroy(unit);
            this.updateTechOnDestroy(unitType);
            UnitTypeCount unitCount = this.gameState.getUnitTypeCount();
            unitCount.removeUnit(unitType);
        } else {
            BaseData baseData = this.gameState.getBaseData();
            TilePosition tp = unit.getTilePosition();
            if (unitType.isResourceDepot() && baseData.isBaseTilePosition(tp)) {
                Base enemyBaseCandidate = baseData.baseAtTilePosition(tp);
                baseData.removeEnemyBase(enemyBaseCandidate);
            }
            ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
            tracker.onUnitDestroy(unit, this.game.getFrameCount());
        }
    }

    public boolean isEnemyUnitVisible() {
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        for (Unit enemy : tracker.getVisibleEnemyUnits()) {
            if (!enemy.isDetected()) continue;
            return true;
        }
        for (Unit enemy : tracker.getBuilding()) {
            if (!enemy.isVisible()) continue;
            return true;
        }
        return false;
    }

    public int getEnemyHostileToGroundBuildingsCount() {
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        return tracker.getHostileToGroundBuildings().size();
    }

    public Position getRallyPoint() {
        BaseData baseData = this.gameState.getBaseData();
        if (baseData.hasNaturalExpansion()) {
            return baseData.naturalExpansionPosition().toPosition();
        }
        return baseData.mainBasePosition().toPosition();
    }

    private void trackEnemyUnits() {
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        for (Unit unit : this.game.getAllUnits()) {
            UnitType unitType = unit.getType();
            if (unit.getPlayer() == this.game.self() || unitType.isResourceContainer() || unitType.isMineralField() || unitType.isNeutral() || unitType == UnitType.Zerg_Lurker_Egg || unitType.isSpecialBuilding() || unitType.isBuilding() || unit.isMorphing() || tracker.getVisibleEnemyUnits().size() > 0 && unitType == UnitType.Zerg_Larva) continue;
            boolean isProxied = this.isProxiedBuilding(unit);
            tracker.onUnitShow(unit, this.game.getFrameCount(), isProxied);
        }
    }

    private Base closestBaseToUnit(Unit unit, List<Base> baseList) {
        if (baseList.size() == 1) {
            return baseList.get(0);
        }
        Base closestBase = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Base b : baseList) {
            int distance = unit.getDistance(b.getCenter());
            if (distance >= closestDistance) continue;
            closestBase = b;
            closestDistance = distance;
        }
        return closestBase;
    }

    private void trackEnemyBuildings() {
        BaseData baseData = this.gameState.getBaseData();
        ScoutData scoutData = this.gameState.getScoutData();
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        for (Unit unit : this.game.getAllUnits()) {
            if (unit.getPlayer() != this.game.enemy()) continue;
            UnitType unitType = unit.getType();
            TilePosition tp = unit.getTilePosition();
            if (!unit.isVisible() || !unitType.isBuilding()) continue;
            boolean isProxied = this.isProxiedBuilding(unit);
            tracker.onUnitShow(unit, this.game.getFrameCount(), isProxied);
            scoutData.addEnemyBuildingLocation(tp);
            if (baseData.getMainEnemyBase() == null) {
                Base enemyMainCandidate = this.closestBaseToUnit(unit, new ArrayList<Base>(this.startingBasesSet));
                if (enemyMainCandidate == baseData.getMainBase()) continue;
                baseData.addEnemyBase(enemyMainCandidate);
            }
            if (!unitType.isResourceDepot() || !baseData.isBaseTilePosition(tp)) continue;
            Base enemyBaseCandidate = baseData.baseAtTilePosition(tp);
            baseData.addEnemyBase(enemyBaseCandidate);
        }
    }

    private boolean canSeeEnemyBuilding() {
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        for (Unit building : tracker.getBuilding()) {
            if (building.getType() == UnitType.Unknown) continue;
            return true;
        }
        return false;
    }

    private void checkEnemyBuildingPositions() {
        if (this.canSeeEnemyBuilding()) {
            return;
        }
        ScoutData scoutData = this.gameState.getScoutData();
        ArrayList<TilePosition> foundBuildings = new ArrayList<TilePosition>();
        for (TilePosition tilePosition : scoutData.getEnemyBuildingPositions()) {
            if (!this.game.isVisible(tilePosition)) continue;
            foundBuildings.add(tilePosition);
        }
        foundBuildings.stream().forEach(buildingPosition -> scoutData.removeEnemyBuildingLocation((TilePosition)buildingPosition));
    }

    private void ensureScoutTargets() {
        ScoutData scoutData = this.gameState.getScoutData();
        if (scoutData.hasScoutTargets() && scoutData.getScoutTargets().size() > 2) {
            return;
        }
        int curImportance = 0;
        for (MapTile mapTile : this.gameState.getGameMap().getHeatMap()) {
            TilePosition tile = mapTile.getTile();
            int importance = mapTile.getScoutImportance();
            if (curImportance == 0) {
                curImportance = importance;
            }
            if (importance < curImportance) break;
            if (scoutData.hasScoutTarget(tile) || !mapTile.isBuildable()) continue;
            scoutData.addScoutTarget(tile);
        }
    }

    private void checkScoutTargets() {
        this.ensureScoutTargets();
        ScoutData scoutData = this.gameState.getScoutData();
        ArrayList<TilePosition> foundTargets = new ArrayList<TilePosition>();
        for (TilePosition target : scoutData.getActiveScoutTargets()) {
            if (target == null) {
                scoutData.removeActiveScoutTarget(target);
                return;
            }
            if (!this.game.isVisible(target)) continue;
            foundTargets.add(target);
        }
        for (TilePosition target : foundTargets) {
            scoutData.removeActiveScoutTarget(target);
            scoutData.removeEnemyBuildingLocation(target);
        }
        ArrayList<Base> foundBases = new ArrayList<Base>();
        for (Base base : scoutData.getScoutingBaseSet()) {
            TilePosition tp = base.getLocation();
            if (!this.game.isVisible(tp)) continue;
            foundBases.add(base);
        }
        for (Base base : foundBases) {
            scoutData.clearScoutedBase(base);
        }
    }

    private void initBases() {
        ScoutData scoutData = this.gameState.getScoutData();
        for (Base b : this.bwem.getMap().getBases()) {
            if (b.isStartingLocation()) {
                scoutData.addBaseScoutAssignment(b);
                this.startingBasesSet.add(b);
                scoutData.addScoutTarget(b.getLocation());
                continue;
            }
            this.expansionBasesSet.add(b);
        }
    }

    private void initializeGameMap() {
        HashSet startingPositions = new HashSet();
        HashSet expansionPositions = new HashSet();
        HashSet<TilePosition> resourcePositions = new HashSet<TilePosition>();
        this.startingBasesSet.stream().map(base -> base.getLocation()).forEach(startingPositions::add);
        this.expansionBasesSet.stream().map(base -> base.getLocation()).forEach(expansionPositions::add);
        for (Base base2 : this.startingBasesSet) {
            for (Geyser geyser : base2.getGeysers()) {
                TilePosition topLeft = geyser.getTopLeft();
                TilePosition bottomRight = geyser.getBottomRight();
                int x = topLeft.getX();
                while (x < bottomRight.getX()) {
                    int y = topLeft.getY();
                    while (y < bottomRight.getY()) {
                        resourcePositions.add(topLeft.add(new TilePosition(x, y)));
                        ++y;
                    }
                    ++x;
                }
            }
        }
        GameMap gameMap = new GameMap(this.game.mapWidth(), this.game.mapHeight());
        int x = 0;
        while (x < this.game.mapWidth()) {
            int y = 0;
            while (y < this.game.mapHeight()) {
                TilePosition tp = new TilePosition(x, y);
                MapTile mapTile = startingPositions.contains(tp) ? new MapTile(tp, 2, true, true, MapTileType.BASE_START) : (expansionPositions.contains(tp) ? new MapTile(tp, 1, true, true, MapTileType.BASE_EXPANSION) : (resourcePositions.contains(tp) ? new MapTile(tp, 0, false, false, MapTileType.NORMAL) : new MapTile(tp, 0, this.isBuildable(tp), this.isWalkable(tp), MapTileType.NORMAL)));
                gameMap.addTile(mapTile, x, y);
                ++y;
            }
            ++x;
        }
        this.gameState.setGameMap(gameMap);
        this.gameState.setBuildingPlanner(new BuildingPlanner(this.game, this.bwem, gameMap));
    }

    private boolean isWalkable(TilePosition tp) {
        WalkPosition wp = tp.toWalkPosition();
        int x = 0;
        while (x < 4) {
            int y = 0;
            while (y < 4) {
                if (!this.game.isWalkable(wp.add(new WalkPosition(x, y)))) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    private boolean isBuildable(TilePosition tp) {
        if (!this.isWalkable(tp)) {
            return false;
        }
        return this.game.isBuildable(tp);
    }

    private void ageHeatMap() {
        ScoutData scoutData = this.gameState.getScoutData();
        GameMap gameMap = this.gameState.getGameMap();
        for (MapTile mapTile : gameMap.getHeatMap()) {
            TilePosition mapTp = mapTile.getTile();
            if (!this.game.isVisible(mapTp)) continue;
            mapTile.setScoutImportance(0);
            scoutData.removeScoutTarget(mapTp);
        }
        gameMap.ageHeatMap();
    }

    private void debugEnemyTargets() {
        ScoutData scoutData = this.gameState.getScoutData();
        ObservedUnitTracker tracker = this.gameState.getObservedUnitTracker();
        for (Unit target : tracker.getBuilding()) {
            this.game.drawCircleMap(target.getPosition(), 3, Color.Yellow);
        }
        for (Unit target : tracker.getVisibleEnemyUnits()) {
            this.game.drawCircleMap(target.getPosition(), 3, Color.Red);
        }
        for (TilePosition tilePosition : scoutData.getEnemyBuildingPositions()) {
            this.game.drawCircleMap(tilePosition.toPosition(), 2, Color.Orange);
        }
    }

    private void ensureEnemyUnitRemovedFromBaseThreats(Unit unit) {
        for (HashSet<Unit> baseThreat : this.gameState.getBaseToThreatLookup().values()) {
            if (!baseThreat.contains(unit)) continue;
            baseThreat.remove(unit);
        }
    }

    private void checkIfEnemyUnitsStillThreatenBase() {
        HashMap<Base, HashSet<Unit>> baseThreats = this.gameState.getBaseToThreatLookup();
        for (Base base : baseThreats.keySet()) {
            HashSet<Unit> unitThreats = baseThreats.get(base);
            ArrayList<Unit> noLongerThreats = new ArrayList<Unit>();
            for (Unit unit : unitThreats) {
                if (unit.getType() == UnitType.Unknown) {
                    noLongerThreats.add(unit);
                    continue;
                }
                int distance = (int)base.getLocation().toPosition().getDistance(unit.getTilePosition().toPosition());
                if (distance > 256) {
                    noLongerThreats.add(unit);
                    continue;
                }
                if (unit.getPlayer() != this.game.self()) continue;
                noLongerThreats.add(unit);
            }
            for (Unit unit : noLongerThreats) {
                unitThreats.remove(unit);
            }
        }
    }

    private void checkBaseThreats() {
        Set<Unit> visibleUnits = this.gameState.getDetectedEnemyUnits();
        if (visibleUnits.isEmpty()) {
            return;
        }
        Set<Base> bases = this.gameState.getGatherersAssignedToBase().keySet();
        HashMap<Base, HashSet<Unit>> baseThreats = this.gameState.getBaseToThreatLookup();
        for (Base base : bases) {
            if (!baseThreats.containsKey(base)) {
                baseThreats.put(base, new HashSet());
            }
            for (Unit unit : visibleUnits) {
                if (!(base.getLocation().toPosition().getDistance(unit.getTilePosition().toPosition()) < 256.0)) continue;
                baseThreats.get(base).add(unit);
            }
        }
    }

    public TilePosition pollScoutTarget(boolean _) {
        TilePosition scoutTile;
        Base baseTarget;
        BaseData baseData = this.gameState.getBaseData();
        ScoutData scoutData = this.gameState.getScoutData();
        if (baseData.getMainEnemyBase() == null && !scoutData.isEnemyBuildingLocationKnown() && (baseTarget = this.fetchBaseRoundRobin(scoutData.getScoutingBaseSet())) != null) {
            int assignments = scoutData.getScoutsAssignedToBase(baseTarget);
            scoutData.updateBaseScoutAssignment(baseTarget, assignments);
            return baseTarget.getLocation();
        }
        if (scoutData.isEnemyBuildingLocationKnown()) {
            for (TilePosition target : scoutData.getEnemyBuildingPositions()) {
                if (scoutData.hasScoutTarget(target) || this.game.isVisible(target)) continue;
                return target;
            }
        }
        if ((scoutTile = this.getHotScoutTile()) != null) {
            return scoutTile;
        }
        return scoutData.findNewActiveScoutTarget();
    }

    @Nullable
    private TilePosition getHotScoutTile() {
        GameMap gameMap = this.gameState.getGameMap();
        ArrayList<MapTile> heatMap = gameMap.getHeatMap();
        if (!heatMap.isEmpty()) {
            MapTile scoutTile = heatMap.get(0);
            scoutTile.setScoutImportance(0);
            gameMap.ageHeatMap();
            return scoutTile.getTile();
        }
        return null;
    }

    private Base fetchBaseRoundRobin(Set<Base> candidateBases) {
        Base leastScoutedBase = null;
        Integer fewestScouts = Integer.MAX_VALUE;
        ScoutData scoutData = this.gameState.getScoutData();
        for (Base base : candidateBases) {
            Integer assignedScoutsToBase = scoutData.getScoutsAssignedToBase(base);
            if (assignedScoutsToBase >= fewestScouts) continue;
            leastScoutedBase = base;
            fewestScouts = assignedScoutsToBase;
        }
        return leastScoutedBase;
    }

    private BuildOrder transitionBuildOrder() {
        BuildOrder active = this.gameState.getActiveBuildOrder();
        Set<BuildOrder> candidates = active.transition(this.gameState);
        return this.learningManager.determineBuildOrder(candidates);
    }

    private boolean isProxiedBuilding(Unit unit) {
        BaseData baseData = this.gameState.getBaseData();
        return this.isNearAnyBase(unit.getTilePosition(), baseData.getMyBases());
    }

    private boolean isNearAnyBase(TilePosition position, Set<Base> myBases) {
        for (Base base : myBases) {
            TilePosition baseLocation = base.getLocation();
            int manhattanDistance = Math.abs(baseLocation.getX() - position.getX()) + Math.abs(baseLocation.getY() - position.getY());
            if (manhattanDistance > 10) continue;
            return true;
        }
        return false;
    }
}

