/*
 * Decompiled with CFR 0.152.
 */
package info;

import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import info.exception.NoWalkablePathException;
import info.map.GameMap;
import info.map.GroundPath;
import info.map.GroundPathComparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import util.BaseUnitDistanceComparator;

public class BaseData {
    private Base mainBase;
    private Base naturalExpansion;
    private Base mainEnemyBase;
    private HashSet<Unit> macroHatcheries = new HashSet();
    private HashSet<Unit> baseHatcheries = new HashSet();
    private HashSet<Base> allBases = new HashSet();
    private HashSet<Base> myBases = new HashSet();
    private HashSet<Base> reservedBases = new HashSet();
    private HashSet<Base> enemyBases = new HashSet();
    private HashSet<Base> islands = new HashSet();
    private HashSet<Base> mineralOnlyBase = new HashSet();
    private HashSet<Base> mains = new HashSet();
    private HashMap<Unit, Base> baseLookup = new HashMap();
    private HashSet<TilePosition> baseTilePositionSet = new HashSet();
    private HashMap<TilePosition, Base> baseTilePositionLookup = new HashMap();
    private HashMap<Base, GroundPath> allBasePaths = new HashMap();
    private HashMap<Base, GroundPath> availableBases = new HashMap();
    private HashSet<Unit> extractors = new HashSet();
    private HashSet<Unit> availableGeysers = new HashSet();
    private HashMap<Base, Integer> sunkenColonyLookup = new HashMap();
    private HashMap<Base, Integer> sunkenColonyReserveLookup = new HashMap();

    public BaseData(List<Base> allBases) {
        for (Base base : allBases) {
            this.allBases.add(base);
            this.baseTilePositionSet.add(base.getLocation());
            this.baseTilePositionLookup.put(base.getLocation(), base);
            if (base.getGeysers().size() == 0) {
                this.mineralOnlyBase.add(base);
            }
            if (!base.isStartingLocation()) continue;
            this.mains.add(base);
        }
    }

    public HashMap<Base, GroundPath> getBasePaths() {
        return this.allBasePaths;
    }

    public void initializeMainBase(Base base, GameMap map) {
        this.mainBase = base;
        HashSet potentialBases = this.allBases.stream().filter(b -> b != base).collect(Collectors.toCollection(HashSet::new));
        for (Base b2 : potentialBases) {
            try {
                GroundPath path = map.aStarSearch(this.mainBase.getLocation(), b2.getLocation());
                this.availableBases.put(b2, path);
                this.allBasePaths.put(b2, path);
            }
            catch (NoWalkablePathException e) {
                this.islands.add(b2);
            }
        }
    }

    public Base getMainBase() {
        return this.mainBase;
    }

    public void addBase(Unit hatchery, Base base) {
        this.baseHatcheries.add(hatchery);
        this.myBases.add(base);
        this.baseLookup.put(hatchery, base);
        this.availableBases.remove(base);
        this.reservedBases.remove(base);
        if (this.naturalExpansion == null && this.myBases.size() > 1) {
            this.naturalExpansion = base;
        }
        base.getGeysers().stream().forEach(g -> {
            boolean bl = this.availableGeysers.add(g.getUnit());
        });
    }

    public Set<Base> availableBases() {
        return this.availableBases.keySet();
    }

    public boolean canReserveExtractor() {
        return this.availableGeysers.size() > 0;
    }

    public Unit reserveExtractor() {
        Unit candidate = this.availableGeysers.iterator().next();
        this.extractors.add(candidate);
        this.availableGeysers.remove(candidate);
        return candidate;
    }

    public void addExtractorCandidate(Unit geyser) {
    }

    public int numExtractor() {
        return this.extractors.size();
    }

    public int numMacroHatcheries() {
        return this.macroHatcheries.size();
    }

    public Base reserveBase() {
        Base base = this.findNewBase();
        if (base == null) {
            return null;
        }
        this.reservedBases.add(base);
        return base;
    }

    public void cancelReserveBase(Base base) {
        GroundPath oldPath = this.allBasePaths.get(base);
        this.availableBases.put(base, oldPath);
        this.reservedBases.remove(base);
    }

    public Base claimBase(Unit hatchery) {
        TilePosition tp = hatchery.getTilePosition();
        Base base = null;
        for (Base reservedBase : this.reservedBases) {
            if (!tp.equals(reservedBase.getLocation())) continue;
            base = reservedBase;
            break;
        }
        if (base == null && (base = this.findNewBase()) == null) {
            return null;
        }
        return base;
    }

    public Base get(Unit hatchery) {
        return this.baseLookup.get(hatchery);
    }

    public boolean isBase(Unit hatchery) {
        return this.baseHatcheries.contains(hatchery);
    }

    public void addMacroHatchery(Unit hatchery) {
        this.macroHatcheries.add(hatchery);
    }

    public void removeHatchery(Unit hatchery) {
        if (this.baseHatcheries.contains(hatchery)) {
            this.removeBase(hatchery);
        } else {
            this.removeMacroHatchery(hatchery);
        }
    }

    private void removeBase(Unit hatchery) {
        Base base = this.baseLookup.get(hatchery);
        this.baseHatcheries.remove(hatchery);
        this.myBases.remove(base);
        GroundPath pathToRemovedBase = this.allBasePaths.get(base);
        this.availableBases.put(base, pathToRemovedBase);
    }

    private void removeMacroHatchery(Unit hatchery) {
        this.macroHatcheries.remove(hatchery);
    }

    public HashSet<Unit> baseHatcheries() {
        return this.baseHatcheries;
    }

    public int currentBaseCount() {
        return this.baseHatcheries.size();
    }

    public int currentAndReservedCount() {
        return this.myBases.size() + this.reservedBases.size();
    }

    public int numHatcheries() {
        return this.myBases.size() + this.macroHatcheries.size() + this.reservedBases.size();
    }

    public TilePosition mainBasePosition() {
        return this.mainBase.getLocation();
    }

    public TilePosition naturalExpansionPosition() {
        return this.naturalExpansion.getLocation();
    }

    public boolean hasNaturalExpansion() {
        return this.naturalExpansion != null;
    }

    public boolean isBaseTilePosition(TilePosition tilePosition) {
        return this.baseTilePositionSet.contains(tilePosition);
    }

    public Base baseAtTilePosition(TilePosition tilePosition) {
        return this.baseTilePositionLookup.get(tilePosition);
    }

    public Base findNewBase() {
        List potential = this.availableBases.entrySet().stream().filter(p -> !this.reservedBases.contains(p.getKey())).collect(Collectors.toList());
        if (this.myBases.size() == 1) {
            potential = potential.stream().filter(e -> !((Base)e.getKey()).getGeysers().isEmpty()).collect(Collectors.toList());
        }
        if (potential.isEmpty()) {
            return null;
        }
        if (this.knowEnemyMainBase()) {
            Base enemyBase = this.getMainEnemyBase();
            try {
                return potential.stream().min((e1, e2) -> {
                    double score1 = (double)((GroundPath)e1.getValue()).getGroundDistance() - ((Base)e1.getKey()).getLocation().getDistance(enemyBase.getLocation());
                    double score2 = (double)((GroundPath)e2.getValue()).getGroundDistance() - ((Base)e2.getKey()).getLocation().getDistance(enemyBase.getLocation());
                    return Double.compare(score1, score2);
                }).map(Map.Entry::getKey).orElse(null);
            }
            catch (Exception e3) {
                return null;
            }
        }
        potential.sort(Map.Entry.comparingByValue(new GroundPathComparator()));
        return (Base)((Map.Entry)potential.get(0)).getKey();
    }

    public void removeSunkenColony(Unit sunken) {
        if (sunken.getType() != UnitType.Zerg_Sunken_Colony) {
            return;
        }
        Base base = (Base)this.myBases.stream().sorted(new BaseUnitDistanceComparator(sunken)).collect(Collectors.toList()).get(0);
        this.sunkenColonyLookup.put(base, Math.max(this.sunkenColonyLookup.getOrDefault(base, 0) - 1, 0));
    }

    public void addSunkenColony(Unit sunken) {
        Base base = (Base)this.myBases.stream().sorted(new BaseUnitDistanceComparator(sunken)).collect(Collectors.toList()).get(0);
        this.sunkenColonyLookup.put(base, this.sunkenColonyLookup.getOrDefault(base, 0) + 1);
        this.sunkenColonyReserveLookup.put(base, Math.max(this.sunkenColonyReserveLookup.getOrDefault(base, 0) - 1, 0));
    }

    public void reserveSunkenColony(Base base) {
        this.sunkenColonyReserveLookup.put(base, this.sunkenColonyReserveLookup.getOrDefault(base, 0) + 1);
    }

    public boolean isEligibleForSunkenColony(Base base) {
        if (base == this.mainBase && this.currentBaseCount() > 1) {
            return false;
        }
        return !this.islands.contains(base);
    }

    public int sunkensPerBase(Base base) {
        int reserved = this.sunkenColonyReserveLookup.getOrDefault(base, 0);
        int sunkens = this.sunkenColonyLookup.getOrDefault(base, 0);
        return reserved + sunkens;
    }

    public Base getMainEnemyBase() {
        return this.mainEnemyBase;
    }

    public void addEnemyBase(Base base) {
        if (this.enemyBases.add(base)) {
            this.availableBases.remove(base);
            this.reservedBases.remove(base);
            if (this.mains.contains(base) && this.mainEnemyBase == null) {
                this.mainEnemyBase = base;
            }
        }
    }

    public void removeEnemyBase(Base base) {
        if (this.enemyBases.remove(base)) {
            GroundPath path;
            if (base == this.mainEnemyBase) {
                this.mainEnemyBase = null;
            }
            if (!this.islands.contains(base) && (path = this.allBasePaths.get(base)) != null) {
                this.availableBases.put(base, path);
            }
        }
    }

    public boolean knowEnemyMainBase() {
        return this.mainEnemyBase != null;
    }

    public Base findFarthestStartingBaseByGround() {
        Base best = null;
        for (Base b : this.mains) {
            if (b == this.mainBase) continue;
            if (best == null) {
                best = b;
                continue;
            }
            GroundPath bestPath = this.allBasePaths.get(best);
            GroundPath candidatePath = this.allBasePaths.get(b);
            if (candidatePath.getGroundDistance() <= bestPath.getGroundDistance()) continue;
            best = b;
        }
        return best;
    }

    public int numMains() {
        return this.mains.size();
    }

    @Generated
    public HashSet<Base> getMyBases() {
        return this.myBases;
    }

    @Generated
    public HashSet<Base> getEnemyBases() {
        return this.enemyBases;
    }
}

