/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.ClientData;

class GameDataUtils {
    static final int MAX_COUNT = 19999;
    private static final int MAX_STRING_SIZE = 1024;

    GameDataUtils() {
    }

    static int addString(ClientData.GameData gameData, String string) {
        int stringCount = gameData.getStringCount();
        if (stringCount >= 19999) {
            throw new IllegalStateException("Too many strings!");
        }
        String stringTruncated = string.length() >= 1024 ? string.substring(0, 1023) : string;
        gameData.setStringCount(stringCount + 1);
        gameData.setStrings(stringCount, stringTruncated);
        return stringCount;
    }

    static ClientData.Shape addShape(ClientData.GameData gameData) {
        int shapeCount = gameData.getShapeCount();
        if (shapeCount >= 19999) {
            throw new IllegalStateException("Too many shapes!");
        }
        gameData.setShapeCount(shapeCount + 1);
        return gameData.getShapes(shapeCount);
    }

    static ClientData.Command addCommand(ClientData.GameData gameData) {
        int commandCount = gameData.getCommandCount();
        if (commandCount >= 19999) {
            throw new IllegalStateException("Too many commands!");
        }
        gameData.setCommandCount(commandCount + 1);
        return gameData.getCommands(commandCount);
    }

    static ClientData.UnitCommand addUnitCommand(ClientData.GameData gameData) {
        int unitCommandCount = gameData.getUnitCommandCount();
        if (unitCommandCount >= 19999) {
            throw new IllegalStateException("Too many unit commands!");
        }
        gameData.setUnitCommandCount(unitCommandCount + 1);
        return gameData.getUnitCommands(unitCommandCount);
    }
}

