#include "unitmicro.h"

#include <queue>

#include "data.h"

int hitPointPercent(BWAPI::Unit unit) {
  auto type = unit->getType();
  if (type.maxHitPoints() == 0) {
    return 100;
  }
  else {
    return unit->getHitPoints() * 100 / unit->getType().maxHitPoints();
  }
}

int energyPercent(BWAPI::Unit unit) {
  auto type = unit->getType();
  if (type.maxEnergy() == 0)
    return 100;
  else
    return 100 * unit->getEnergy() / unit->getType().maxEnergy();
}

bool issueOrder(BWAPI::Unit unit, BWAPI::Order orderType, BWAPI::Position targetPosition, BWAPI::Unit targetUnit) {
  bool result = false;
  if (!unit)
    return result;

  if (targetPosition != BWAPI::Positions::None
    && !unit->getType().isFlyer()) {
    auto targetRegion = BWAPI::Broodwar->getRegionAt(targetPosition);
    auto unitRegion = unit->getRegion();
    if (targetRegion && unitRegion && targetRegion->getRegionGroupID() != unitRegion->getRegionGroupID()) {
      auto transport = unit->getClosestUnit([](BWAPI::Unit unit) {
        return (unit->getType() == BWAPI::UnitTypes::Protoss_Shuttle
          || unit->getType() == BWAPI::UnitTypes::Terran_Dropship
          || unit->getType() == BWAPI::UnitTypes::Zerg_Overlord && BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Pneumatized_Carapace))
          && (8 - unit->getSpaceRemaining()) + unit->getClientInfo<int>(static_cast<int>(ClientInfo::QueuedTransport)) < 8
          && 100 < unit->getDistance(BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) });
        });
      if (transport) {
        result = unit->rightClick(transport);
        if (result) {
          transport->setClientInfo(transport->getClientInfo<int>(static_cast<int>(ClientInfo::QueuedTransport)) + unit->getType().spaceRequired(), static_cast<int>(ClientInfo::QueuedTransport));
          transport->setClientInfo(static_cast<int>(JobType::Taxi), static_cast<int>(ClientInfo::Job));
          transport->setClientInfo(targetPosition.x, static_cast<int>(ClientInfo::JobX));
          transport->setClientInfo(targetPosition.y, static_cast<int>(ClientInfo::JobY));
          transport->setClientInfo(7, static_cast<int>(ClientInfo::Sleep));
        }
      }
      else {
        return false;
      }
    }
  }

  if (!result) {
    switch (orderType) {
    case BWAPI::Orders::AttackUnit:
      if (targetUnit) {
        if (unit->isBurrowed()
          && unit->getType() != BWAPI::UnitTypes::Zerg_Lurker) {
          result = unit->unburrow();
        }
        else {
          result = unit->attack(targetUnit);
        }
      }
      break;
    case BWAPI::Orders::MoveToGas:
      if (targetUnit && targetUnit->getType().isRefinery()) {
        if (unit->isBurrowed()) {
          result = unit->unburrow();
        }
        else {
          result = unit->gather(targetUnit);
        }
      }
      break;
    case BWAPI::Orders::MoveToMinerals:
      if (targetUnit && targetUnit->getType().isMineralField()) {
        if (unit->isBurrowed()) {
          result = unit->unburrow();
        }
        else {
          result = unit->gather(targetUnit);
        }
      }
      break;
    case BWAPI::Orders::Move:
      if (targetPosition != BWAPI::Positions::None) {
        if (unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode) {
          useTech(unit, BWAPI::TechTypes::Tank_Siege_Mode);
          result = true;
        }
        else if (unit->isBurrowed()) {
          result = unit->unburrow();
        }
        else {
          result = unit->move(targetPosition);
        }
      }
      break;
    case BWAPI::Orders::PickupTransport:
      if (targetUnit) {
        result = unit->load(targetUnit);
      }
      break;
    case BWAPI::Orders::Repair:
      if (targetUnit) {
        result = unit->repair(targetUnit);
      }
      break;
    case BWAPI::Orders::Stop:
      result = unit->stop();
      break;
    case BWAPI::Orders::Unload:
      if (targetPosition != BWAPI::Positions::None) {
        if (100 < unit->getDistance(targetPosition)) {
          result = unit->move(targetPosition);
        }
        else {
          unit->unloadAll();
        }
      }
      break;
    default:
      break;
    }
  }
  if (result) {
    unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
  }
  return result;
}

bool canUseTech(BWAPI::Unit unit, BWAPI::TechType tech) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  auto self = BWAPI::Broodwar->self();
  auto type = unit->getType();
  switch (tech) {
  case Stim_Packs:
    return ((type == Terran_Marine || type == Terran_Firebat) && self->hasResearched(Stim_Packs)) || type == Hero_Jim_Raynor_Marine || type == Hero_Gui_Montag;
  case Lockdown:
    return type == Hero_Infested_Duran || (type == Terran_Ghost && self->hasResearched(Lockdown)) || type == Hero_Alexei_Stukov || type == Hero_Samir_Duran || type == Hero_Sarah_Kerrigan;
  case EMP_Shockwave:
    return (type == Terran_Science_Vessel && self->hasResearched(EMP_Shockwave)) || type == Hero_Magellan;
  case Spider_Mines:
    return 0 < unit->getSpiderMineCount() && ((type == Terran_Vulture && self->hasResearched(Spider_Mines)) || type == Hero_Jim_Raynor_Vulture);
  case Scanner_Sweep:
    return type == Terran_Comsat_Station;
  case Tank_Siege_Mode:
    return ((type == Terran_Siege_Tank_Siege_Mode || type == Terran_Siege_Tank_Tank_Mode) && self->hasResearched(Tank_Siege_Mode)) || type == Hero_Edmund_Duke_Siege_Mode || type == Hero_Edmund_Duke_Tank_Mode;
  case Defensive_Matrix:
    return type == Terran_Science_Vessel || type == Hero_Magellan;
  case Irradiate:
    return (type == Terran_Science_Vessel && self->hasResearched(Irradiate)) || type == Hero_Magellan;
  case Yamato_Gun:
    return (type == Terran_Battlecruiser && self->hasResearched(Yamato_Gun)) || type == Hero_Gerard_DuGalle || type == Hero_Hyperion || type == Hero_Norad_II;
  case Cloaking_Field:
    return (type == Terran_Wraith && self->hasResearched(Cloaking_Field)) || type == Hero_Tom_Kazansky;
  case Personnel_Cloaking:
    return type == Hero_Infested_Duran || type == Hero_Infested_Kerrigan || (type == Terran_Ghost && self->hasResearched(Personnel_Cloaking)) || type == Hero_Samir_Duran || type == Hero_Sarah_Kerrigan;
  case Burrowing:
    return ((type == Zerg_Infested_Terran || type == Zerg_Drone || type == Zerg_Hydralisk || type == Zerg_Zergling || type == Zerg_Defiler) && self->hasResearched(Burrowing)) || type == Zerg_Lurker || type == Hero_Devouring_One || type == Hero_Hunter_Killer || type == Hero_Unclean_One;
  case Infestation:
    return type == Zerg_Queen || type == Hero_Matriarch;
  case Spawn_Broodlings:
    return (type == Zerg_Queen && self->hasResearched(Spawn_Broodlings)) || type == Hero_Matriarch;
  case Dark_Swarm:
    return type == Zerg_Defiler || type == Hero_Unclean_One;
  case Plague:
    return (type == Zerg_Defiler && self->hasResearched(Plague)) || type == Hero_Unclean_One;
  case Consume:
    return (type == Zerg_Defiler && self->hasResearched(Consume)) || type == Hero_Infested_Duran || type == Hero_Infested_Kerrigan || type == Hero_Unclean_One;
  case Ensnare:
    return (type == Zerg_Queen && self->hasResearched(Ensnare)) || type == Hero_Infested_Kerrigan || type == Hero_Matriarch;
  case Parasite:
    return type == Zerg_Queen || type == Hero_Matriarch;
  case Psionic_Storm:
    return type == Hero_Infested_Kerrigan || (type == Protoss_High_Templar && self->hasResearched(Psionic_Storm)) || type == Hero_Tassadar;
  case Hallucination:
    return (type == Protoss_High_Templar && self->hasResearched(Hallucination)) || type == Hero_Tassadar;
  case Recall:
    return (type == Protoss_Arbiter && self->hasResearched(Recall)) || type == Hero_Danimoth;
  case Stasis_Field:
    return (type == Protoss_Arbiter && self->hasResearched(Stasis_Field)) || type == Hero_Danimoth;
  case Archon_Warp:
    return type == Protoss_High_Templar;
  case Restoration:
    return type == Terran_Medic && self->hasResearched(Restoration);
  case Disruption_Web:
    return (type == Protoss_Corsair && self->hasResearched(Disruption_Web)) || type == Hero_Raszagal;
  case Mind_Control:
    return type == Protoss_Dark_Archon && self->hasResearched(Mind_Control);
  case Dark_Archon_Meld:
    return type == Protoss_Dark_Templar;
  case Feedback:
    return type == Protoss_Dark_Archon;
  case Optical_Flare:
    return type == Terran_Medic && self->hasResearched(Optical_Flare);
  case Maelstrom:
    return type == Protoss_Dark_Archon && self->hasResearched(Maelstrom);
  case Lurker_Aspect:
    return type == Zerg_Hydralisk && self->hasResearched(Lurker_Aspect);
  case Healing:
    return type == Terran_Medic;
  case BWAPI::TechTypes::None:
    return false;
  case Nuclear_Strike:
    return type == Terran_Ghost;
  default:
    return false;
  }
}

bool useStimPacks(BWAPI::Unit unit) {
  using namespace BWAPI::TechTypes;
  if (canUseTech(unit, Stim_Packs)
    && unit->isAttacking()
    && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() == 100
    && !unit->isStimmed()) {
    useTech(unit, Stim_Packs);
    return true;
  }
  return false;
}

bool useOpticalFlare(BWAPI::Unit unit) {
  using namespace BWAPI::TechTypes;
  if (canUseTech(unit, Optical_Flare)
    && Optical_Flare.energyCost() < unit->getEnergy() - 25) {
    auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && BWAPI::Filter::IsDetector && !BWAPI::Filter::IsBlind && !BWAPI::Filter::IsBuilding);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Optical_Flare, target);
      return true;
    }
  }
  return false;
}

bool useRestoration(BWAPI::Unit unit) {
  using namespace BWAPI::TechTypes;
  if (canUseTech(unit, Restoration)
    && Restoration.energyCost() < unit->getEnergy() - 25) {
    auto target = unit->getClosestUnit((BWAPI::Filter::IsAlly || BWAPI::Filter::IsOwned) && (BWAPI::Filter::IsLockedDown || BWAPI::Filter::IsBlind || BWAPI::Filter::IsIrradiated || BWAPI::Filter::IsPlagued || BWAPI::Filter::IsEnsnared || BWAPI::Filter::IsParasited) && !BWAPI::Filter::IsBuilding);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Restoration, target);
      return true;
    }
  }
  return false;
}

bool checkPanic(BWAPI::Unit unit) {
  if (unit->getClientInfo<bool>(static_cast<int>(ClientInfo::Panic))) {
    if (unit->isIdle()) {
      unit->setClientInfo(false, static_cast<int>(ClientInfo::Panic));
    }
    else {
      return true;
    }
  }
  return false;
}

bool chaseDetectionTarget(BWAPI::Unit unit) {
  auto target = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection));
  if (target && target->exists()) {
    if (target->isDetected()
      && unit->getDistance(target) < unit->getType().sightRange() / 2) {
      issueOrder(unit, BWAPI::Orders::Stop);
      return true;
    }
    else {
      issueOrder(unit, BWAPI::Orders::Move, target->getPosition());
      return true;
    }
  }
  else {
    unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDetection));
  }
  return false;
}

BWAPI::Unit getClosestNotMacroResourceDepot(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  BWAPI::Unit closestDepot = nullptr;
  int closestDistance = INT_MAX;
  for (auto& resourceDepot : data->resourceDepots) {
    if (resourceDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == -1)
      continue;

    auto distance = unit->getDistance(resourceDepot);
    if (distance < closestDistance) {
      closestDistance = distance;
      closestDepot = resourceDepot;
    }
  }
  return closestDepot;
}

void useTech(BWAPI::Unit unit, BWAPI::TechType tech, BWAPI::Unit target, BWAPI::Position targetPosition) {
  if (target) {
    unit->useTech(tech, target);
  }
  else if (targetPosition != BWAPI::Positions::None) {
    unit->useTech(tech, targetPosition);
  }
  else {
    unit->useTech(tech);
  }
  unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
}

bool acquireAndAttackTarget(BWAPI::Unit unit) {
  BWAPI::Unit enemy = nullptr;
  if ((unit->getType().groundWeapon() != BWAPI::WeaponTypes::None
    && unit->getType().airWeapon() != BWAPI::WeaponTypes::None)
    || unit->getType() == BWAPI::UnitTypes::Protoss_Carrier) {
    enemy = unit->getClosestUnit(
      BWAPI::Filter::IsEnemy
      && BWAPI::Filter::IsDetected
      && (BWAPI::Filter::GroundWeapon != BWAPI::WeaponTypes::None || BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None)
      && !BWAPI::Filter::IsWorker
      , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    if (!enemy) {
      enemy = unit->getClosestUnit(
        BWAPI::Filter::IsEnemy
        && BWAPI::Filter::IsDetected
        , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    }
    if (!enemy) {
      enemy = unit->getClosestUnit(
        BWAPI::Filter::IsCritter
        , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    }
  }
  else if (unit->getType().groundWeapon() != BWAPI::WeaponTypes::None) {
    enemy = unit->getClosestUnit(
      BWAPI::Filter::IsEnemy
      && BWAPI::Filter::IsDetected
      && !BWAPI::Filter::IsFlyer
      && !BWAPI::Filter::IsWorker
      && (BWAPI::Filter::GroundWeapon != BWAPI::WeaponTypes::None || BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None)
      , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    if (!enemy) {
      enemy = unit->getClosestUnit(
        BWAPI::Filter::IsEnemy
        && BWAPI::Filter::IsDetected
        && !BWAPI::Filter::IsFlyer
        , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    }
    if (!enemy) {
      enemy = unit->getClosestUnit(
        BWAPI::Filter::IsCritter
        && !BWAPI::Filter::IsFlyer
        , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    }
  }
  else if (unit->getType().airWeapon() != BWAPI::WeaponTypes::None) {
    enemy = unit->getClosestUnit(
      BWAPI::Filter::IsEnemy
      && BWAPI::Filter::IsDetected
      && BWAPI::Filter::IsFlyer
      && (BWAPI::Filter::GroundWeapon != BWAPI::WeaponTypes::None || BWAPI::Filter::AirWeapon != BWAPI::WeaponTypes::None)
      , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    if (!enemy) {
      enemy = unit->getClosestUnit(
        BWAPI::Filter::IsEnemy
        && BWAPI::Filter::IsDetected
        && BWAPI::Filter::IsFlyer
        , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    }
    if (!enemy) {
      enemy = unit->getClosestUnit(
        BWAPI::Filter::IsCritter
        && BWAPI::Filter::IsFlyer
        , unit->getType().isBuilding() ? unit->getType().groundWeapon().maxRange() : unit->getType().sightRange());
    }
  }
  if (enemy && enemy != unit->getOrderTarget()) {
    return issueOrder(unit, BWAPI::Orders::AttackUnit, BWAPI::Positions::None, enemy);
  }
  return false;
}

void militaryUnitAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  auto self = BWAPI::Broodwar->self();
  auto assignedRegion = unit->getClientInfo<BWAPI::Region>(static_cast<int>(ClientInfo::AssignedRegion));
  auto assignedBunker = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedBunker));
  auto job = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job)));
  if (job == JobType::HelpExpand) {
    BWAPI::TilePosition location = { unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
    BWAPI::Position locationPosition = BWAPI::Position{ location };
    auto unitsAtLocation = BWAPI::Broodwar->getUnitsInRectangle(locationPosition, locationPosition + BWAPI::Position{ 64, 64 }, BWAPI::Filter::GetPlayer == self && BWAPI::Filter::IsResourceDepot);
    if (unitsAtLocation.size()) {
      unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
      unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
      unit->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
      unit->setClientInfo((*unitsAtLocation.begin()), static_cast<int>(ClientInfo::AssignedDepot));
      return;
    }
    if (unit->isIdle()) {
      if (100 < unit->getDistance(locationPosition)) {
        int tries = 0;
        while (tries < 50) {
          auto movePosition = locationPosition + BWAPI::Position{ data->getRandomInteger(-100, 100), data->getRandomInteger(-100, 100) };
          auto difference = movePosition - locationPosition;
          if (difference.x < 64 && 0 < difference.x && difference.y < 64 && 0 < difference.y) {
            tries++;
          }
          else {
            issueOrder(unit, BWAPI::Orders::Move, movePosition);
            tries = 50;
          }
        }
      }
    }
    return;
  }
  else if (job == JobType::HoldDefend) {
    if (unit->getType().isMechanical()
      && unit->getType().getRace() == BWAPI::Races::Terran
      && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 90) {
      auto repairers = unit->getUnitsInRadius(999999
        , BWAPI::Filter::OrderTarget == unit
        && BWAPI::Filter::GetPlayer == self
        && BWAPI::Filter::CurrentOrder == BWAPI::Orders::Repair);
      if (!repairers.size()) {
        auto repairer = unit->getClosestUnit([](BWAPI::Unit u) {
          return u->getType() == BWAPI::UnitTypes::Terran_SCV
            && static_cast<JobType>(u->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend
            && u->getOrder() != BWAPI::Orders::Repair;
          });
        if (repairer
          && data->minerals
          && (unit->getType().gasPrice() > 0 ? data->gas > 0 : true))
          issueOrder(repairer, BWAPI::Orders::Repair, BWAPI::Positions::None, unit);
        unit->setClientInfo<int>(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        return;
      }
    }
    /*if (unit->getType().isWorker()) {
      auto assignedDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
      if (assignedDepot) {
        unit->stop();
        unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDepot));
        return;
      }
    }*/
    auto holdPosition = BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
    if (50 < unit->getDistance(holdPosition)
      && unit->getOrder() != BWAPI::Orders::EnterTransport
      && unit->getOrder() != BWAPI::Orders::Repair) {
      issueOrder(unit, BWAPI::Orders::Move, holdPosition);
      return;
    }
  }
  else if (job == JobType::Move) {
    if (unit->isIdle()) {
      issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ BWAPI::TilePosition{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) } });
      return;
    }
  }
  else if (job == JobType::Attack) {
    auto squadLeader = unit->getClientInfo<bool>(static_cast<int>(ClientInfo::SquadLeader));
    auto target = BWAPI::Position{ BWAPI::TilePosition{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) } };
    auto acquireNewTarget = [unit, data]() {
      int closestDistance = INT_MAX;
      BWAPI::Unit closestUnit = nullptr;
      for (auto& [__, building] : data->enemyBuildings) {
        BWAPI::Position location = BWAPI::Position{ BWAPI::TilePosition{ building->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), building->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)) } };
        auto distance = unit->getDistance(location);
        if (distance < closestDistance
          && unit->getType().sightRange() - 20 <= distance) {
          closestDistance = distance;
          closestUnit = building;
        }
      }
      if (closestUnit) {
        std::stringstream information;
        unit->setClientInfo(closestUnit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), static_cast<int>(ClientInfo::JobX));
        unit->setClientInfo(closestUnit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)), static_cast<int>(ClientInfo::JobY));
        return;
      }
      else {
        auto itr = data->attackLocations.begin();
        auto hasTransports = [data]() {
          using namespace BWAPI::UnitTypes;
          return 0 <= data->counts.complete[Protoss_Shuttle] || 0 <= data->counts.complete[Terran_Dropship] || BWAPI::Broodwar->self()->getUpgradeLevel(BWAPI::UpgradeTypes::Ventral_Sacs) == 1;
        };
        while (itr != data->attackLocations.end()) {
          if (BWAPI::Broodwar->isVisible(*itr)
            || (BWAPI::Broodwar->getRegionAt(BWAPI::Position{ *itr })->getRegionGroupID() != unit->getRegion()->getRegionGroupID()
              && !hasTransports())) {
            itr++;
            continue;
          }
          else {
            BWAPI::TilePosition target = *itr;
            unit->setClientInfo(target.x, static_cast<int>(ClientInfo::JobX));
            unit->setClientInfo(target.y, static_cast<int>(ClientInfo::JobY));
            issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ target });
            auto addToEnd = *itr;
            itr = data->attackLocations.erase(itr);
            data->attackLocations.push_back(addToEnd);
            itr = data->attackLocations.end();
            return;
          }
        }
      }
    };
    if (unit->isLoaded()) {
      if (unit->getTransport()->getType() == BWAPI::UnitTypes::Terran_Bunker) {
        unit->getTransport()->unload(unit);
        unit->getTransport()->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        return;
      }
    }
    if (unit->isIdle()) {
      if (squadLeader
        && unit->getDistance(target) < unit->getType().sightRange() - 20) {
        acquireNewTarget();
      }
      else if (target.x != 0) {
        issueOrder(unit, BWAPI::Orders::Move, target);
        if (BWAPI::Broodwar->isVisible(BWAPI::TilePosition{ target })) {
          unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
          unit->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
        }
        return;
      }
      else {
        if (squadLeader) {
          acquireNewTarget();
        }
        else {
          // get target from squad leader
          for (auto& unitSet : data->attackerUnitSets) {
            BWAPI::Unit leader = nullptr;
            bool found = false;
            for (auto& attacker : unitSet) {
              if (attacker->getClientInfo<bool>(static_cast<int>(ClientInfo::SquadLeader))) {
                leader = attacker;
              }
              if (attacker == unit) {
                found = true;
              }
            }
            if (found
              && leader) {
              unit->setClientInfo(leader->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), static_cast<int>(ClientInfo::JobX));
              unit->setClientInfo(leader->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)), static_cast<int>(ClientInfo::JobY));
              return;
            }
          }
        }
      }
    }
  }
  else if (job == JobType::Defend) {
    if (unit->isIdle()) {
      bool found = false;
      auto requestedUnit = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::JobUnit));
      for (auto& checkJob : data->jobList) {
        if (checkJob.requestingUnit == requestedUnit) {
          found = true;
          break;
        }
      }
      if (!found
        || !requestedUnit) {
        unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
        unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::JobUnit));
        issueOrder(unit, BWAPI::Orders::Stop);
        return;
      }
      else {
        auto enemySet = requestedUnit->getUnitsInRadius(BWAPI::WeaponTypes::Arclite_Shock_Cannon.maxRange(), BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding);
        for (auto& enemy : enemySet) {
          if (!enemy->getType().isFlyer() && unit->getType().groundWeapon() != BWAPI::WeaponTypes::None
            && (enemy->isDetected())) {
            issueOrder(unit, BWAPI::Orders::Move, enemy->getPosition());
            return;
          }
          if (enemy->getType().isFlyer() && unit->getType().airWeapon() != BWAPI::WeaponTypes::None
            && (enemy->isDetected())) {
            issueOrder(unit, BWAPI::Orders::Move, enemy->getPosition());
            return;
          }
        }
      }
    }
  }
  else if (unit->isIdle()
    && ((assignedRegion && unit->getRegion() != assignedRegion)
      || (assignedBunker && assignedBunker->getRegion() != unit->getRegion()))) {
    if (assignedBunker) {
      issueOrder(unit, BWAPI::Orders::Move, assignedBunker->getPosition());
    }
    else {
      issueOrder(unit, BWAPI::Orders::Move, assignedRegion->getCenter());
    }
    return;
  }
  else if (!assignedRegion
    && (unit->isIdle() || unit->getOrder() == BWAPI::Orders::BunkerGuard)
    && !unit->getType().isBuilding()) {
    auto depot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));

    if (!depot) {
      depot = getClosestNotMacroResourceDepot(unit, data);
      if (depot) {

        unit->setClientInfo(depot, static_cast<int>(ClientInfo::AssignedDepot));
        data->defenderUnitSets[depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))].insert(unit);
      }
    }
    if (depot) {
      if (!depot->exists()) {
        unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDepot));
        return;
      }
      if (unit->getType().getRace() == BWAPI::Races::Zerg
        || unit->getType() == BWAPI::UnitTypes::Terran_Science_Vessel
        || unit->getType() == BWAPI::UnitTypes::Protoss_High_Templar) {
        if (depot->getDistance(unit) > 400 && unit->isIdle()) {
          issueOrder(unit, BWAPI::Orders::Move, depot->getPosition());
          return;
        }
        else if (unit->isIdle()
          && !unit->isBurrowed()
          && canUseTech(unit, BWAPI::TechTypes::Burrowing)) {
          useTech(unit, BWAPI::TechTypes::Burrowing);
          return;
        }
      }
      else if (unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Tank_Mode
        || unit->getType() == BWAPI::UnitTypes::Terran_Siege_Tank_Siege_Mode) {
        auto bunker = depot->getClosestUnit(BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_Bunker);
        if (bunker) {
          unit->setClientInfo(bunker, static_cast<int>(ClientInfo::AssignedBunker));
          return;
        }
      }
      else {
        BWAPI::Region region = nullptr;
        for (auto& r : data->defenderRegions[depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]) {
          if (!region)
            region = r;
          else if (r->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedCount)) < region->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedCount))) {
            region = r;
          }
        }
        if (region) {
          region->setClientInfo(region->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedCount)) + 1, static_cast<int>(ClientInfo::AssignedCount));
          unit->setClientInfo(region, static_cast<int>(ClientInfo::AssignedRegion));
          return;
        }
      }
    }
  }
}

void unitWithWeaponsAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  auto job = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job)));
  if (job != JobType::Move
    && acquireAndAttackTarget(unit)) {
    return;
  }
  militaryUnitAI(unit, data);
}

void panic(BWAPI::Unit unit) {
  auto enemy = unit->getClosestUnit(BWAPI::Filter::IsEnemy && BWAPI::Filter::OrderTarget == unit);
  if (enemy) {
    issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ static_cast<int>(unit->getPosition().x + 100 * std::cos(enemy->getAngle())), static_cast<int>(unit->getPosition().y + 100 * std::sin(enemy->getAngle())) });
    unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
    unit->setClientInfo(true, static_cast<int>(ClientInfo::Panic));
  }
}

void workerAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  auto self = BWAPI::Broodwar->self();
  if (checkPanic(unit)) {
    return;
  }
  auto job = static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job)));
  if (job == JobType::Scout) {
    auto clientInfo = static_cast<int>(ClientInfo::JobX);
    auto targetStartLocation = unit->getClientInfo<int>(clientInfo);
    auto startLocations = BWAPI::Broodwar->getStartLocations();
    if (targetStartLocation < startLocations.size()) {
      auto targetLocation = startLocations[targetStartLocation];
      using namespace BWAPI::Filter;
      if (BWAPI::Broodwar->isVisible(targetLocation)
        || unit->getUnitsInRadius(unit->getType().sightRange(),
        IsEnemy
        && IsBuilding).size()) {
        issueOrder(unit, BWAPI::Orders::Stop);
        targetStartLocation++;
        unit->setClientInfo(targetStartLocation, clientInfo);
        return;
      }
      else if (unit->isIdle()) {
        issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ targetLocation });
        return;
      }
    }
    else {
      issueOrder(unit, BWAPI::Orders::Stop);
      unit->setClientInfo(JobType::None, static_cast<int>(ClientInfo::Job));
      return;
    }
  }
  else if (job != JobType::HoldDefend) {
    if (unit->isUnderAttack()
      && !unit->getBuildUnit()) {
      auto target = unit->getTarget();
      if (!target
        || !target->getPlayer()->isEnemy(self)) {
        target = unit->getClosestUnit(BWAPI::Filter::IsEnemy
          && BWAPI::Filter::Target == unit
          && (BWAPI::Filter::GetType == BWAPI::UnitTypes::Zerg_Zergling
            || BWAPI::Filter::GetType == BWAPI::UnitTypes::Zerg_Drone
            || BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_SCV
            || BWAPI::Filter::GetType == BWAPI::UnitTypes::Protoss_Probe));
        if (target && unit->getDistance(target) <= unit->getType().groundWeapon().maxRange() + 75) {
          issueOrder(unit, BWAPI::Orders::AttackUnit, BWAPI::Positions::None, target);
          return;
        }
        else {
          panic(unit);
          return;
        }
      }
    }
    else {
      if (unit->isIdle()) {
        auto buildType = unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::BuildType));
        if (buildType.isBuilding()) {
          auto location = BWAPI::TilePosition{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::BuildLocationY)) };
          if (!unit->build(buildType, location)) {
            auto moveableUnits = BWAPI::Broodwar->getUnitsInRectangle(BWAPI::Position{ location }, BWAPI::Position{ location + buildType.tileSize() }, BWAPI::Filter::CanMove && BWAPI::Filter::GetPlayer == self);
            if (moveableUnits.size()) {
              for (auto& u : moveableUnits) {
                issueOrder(u, BWAPI::Orders::Move, BWAPI::Position{ location } + BWAPI::Position{ data->getRandomInteger(128, 188), data->getRandomInteger(100, 150) });
              }
              moveableUnits.setClientInfo(100, static_cast<int>(ClientInfo::Sleep));
            }
            issueOrder(unit, BWAPI::Orders::Move, BWAPI::Position{ location });
          }
          unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
          return;
        }
        BWAPI::Unit assignedDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
        if (assignedDepot && !assignedDepot->exists()) {
          unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDepot));
          return;
        }
        else if (assignedDepot
          && (assignedDepot->isCompleted()
            || assignedDepot->getType() == BWAPI::UnitTypes::Zerg_Lair
            || assignedDepot->getType() == BWAPI::UnitTypes::Zerg_Hive)) {
          auto closestMineral = assignedDepot->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
          if (closestMineral) {
            issueOrder(unit, BWAPI::Orders::MoveToMinerals, BWAPI::Positions::None, closestMineral);
            return;
          }
          else {
            int lowestWorkerCount = INT_MAX;
            BWAPI::Unit closestDepot = nullptr;
            for (auto& [id, workers] : data->mineralWorkers) {
              if (data->maxMineralWorkers[id]
                && workers < lowestWorkerCount) {
                lowestWorkerCount = workers;
                for (auto& depot : data->resourceDepots) {
                  if (depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup)) == id) {
                    auto closestMineral = assignedDepot->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
                    closestDepot = depot;
                  }
                }
              }
            }
            if (closestDepot) {
              auto closestMineral = closestDepot->getClosestUnit(BWAPI::Filter::IsMineralField, 500);
              if (closestMineral) {
                issueOrder(unit, BWAPI::Orders::MoveToMinerals, BWAPI::Positions::None, closestMineral);
                unit->setClientInfo(closestDepot, static_cast<int>(ClientInfo::AssignedDepot));
                data->mineralWorkers[closestDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]++;
                data->mineralWorkers[assignedDepot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup))]--;
                return;
              }
            }
            auto closestRefinery = assignedDepot->getClosestUnit(BWAPI::Filter::IsRefinery, 500);
            if (closestRefinery) {
              issueOrder(unit, BWAPI::Orders::MoveToGas, BWAPI::Positions::None, closestRefinery);
              return;
            }
          }
        }
        else if (!assignedDepot
          && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {
          int lowestWorkerPercent = INT_MAX;
          BWAPI::Unit lowestDepot = nullptr;
          int lowestID = -1;
          for (auto& depot : data->resourceDepots) {
            auto resourceGroup = depot->getClientInfo<int>(static_cast<int>(ClientInfo::ResourceGroup));
            if (resourceGroup != -1
              && (depot->isCompleted()
                || depot->getType() == BWAPI::UnitTypes::Zerg_Lair
                || depot->getType() == BWAPI::UnitTypes::Zerg_Hive)) {
              if (0 < data->maxMineralWorkers[resourceGroup]) {
                auto tempPercent = 100 * data->mineralWorkers[resourceGroup] / data->maxMineralWorkers[resourceGroup];
                if (tempPercent < lowestWorkerPercent) {
                  lowestWorkerPercent = tempPercent;
                  lowestDepot = depot;
                }
              }
            }
          }
          if (lowestDepot) {
            unit->setClientInfo(lowestDepot, static_cast<int>(ClientInfo::AssignedDepot));
            data->mineralWorkers[lowestID]++;
          }
        }
        //else if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::HoldDefend) {

        //}
      }
      else if (unit->isGatheringMinerals()
        && !unit->isCarryingMinerals()) {
        auto buildType = unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::BuildType));
        if (buildType != BWAPI::UnitTypes::None) {
          issueOrder(unit, BWAPI::Orders::Stop);
          return;
        }
      }
    }
  }
  else {
    auto assignedRegion = unit->getClientInfo<BWAPI::Region>(static_cast<int>(ClientInfo::AssignedRegion));

    if (job != JobType::Move
      && acquireAndAttackTarget(unit)) {
      return;
    }

    if (unit->getType().isMechanical()
      && unit->getType().getRace() == BWAPI::Races::Terran
      && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 90) {
      auto repairers = unit->getUnitsInRadius(999999
        , BWAPI::Filter::OrderTarget == unit
        && BWAPI::Filter::GetPlayer == self
        && BWAPI::Filter::CurrentOrder == BWAPI::Orders::Repair);
      if (!repairers.size()) {
        auto repairer = unit->getClosestUnit([](BWAPI::Unit u) {
          return u->getType() == BWAPI::UnitTypes::Terran_SCV
            && static_cast<JobType>(u->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::HoldDefend
            && u->getOrder() != BWAPI::Orders::Repair;
          });
        if (repairer
          && data->minerals
          && (unit->getType().gasPrice() > 0 ? data->gas > 0 : true))
          issueOrder(repairer, BWAPI::Orders::Repair, BWAPI::Positions::None, unit);
        unit->setClientInfo<int>(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        return;
      }
    }
    if (unit->getType().isWorker()) {
      auto assignedDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
      if (assignedDepot) {
        unit->stop();
        unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDepot));
        return;
      }
    }
    auto holdPosition = BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
    if (50 < unit->getDistance(holdPosition)
      && unit->getOrder() != BWAPI::Orders::EnterTransport
      && unit->getOrder() != BWAPI::Orders::Repair) {
      issueOrder(unit, BWAPI::Orders::Move, holdPosition);
      return;
    }
  }
}

void stimmableAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  auto self = BWAPI::Broodwar->self();
  if (useStimPacks(unit)) {
    return;
  }
  unitWithWeaponsAI(unit, data);
  return;
}

void medicAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  if (useOpticalFlare(unit)) {
    return;
  }
  if (useRestoration(unit)) {
    return;
  }

  BWAPI::Unit healTarget = nullptr;
  auto job = unit->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job));
  int closestDistance = INT_MAX;
  auto target = unit->getTarget();
  if (target) {
    closestDistance = unit->getDistance(target);
  }
  for (auto& u : BWAPI::Broodwar->getAllUnits()) {
    if (u->getType().maxHitPoints() == 0) {
      continue;
    }
    auto player = u->getPlayer();
    if (player->isEnemy(BWAPI::Broodwar->self())
      || player->isNeutral()
      || !u->isCompleted()
      || u->getType().isBuilding()) {
      continue;
    }

    if (hitPointPercent(u) < 100 &&
      u->getType().isOrganic()) {
      auto uJob = u->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job));
      if (job == JobType::Attack) {
        if (uJob != JobType::Attack) {
          continue;
        }
      }
      else {
        if (uJob == JobType::Attack) {
          continue;
        }
      }
      bool isBeingHealed = false;
      for (auto& tu : BWAPI::Broodwar->getAllUnits()) {
        if (tu == unit)
          continue;
        auto targetingPlayer = tu->getPlayer();
        if (tu->getType() != BWAPI::UnitTypes::Terran_Medic
          || targetingPlayer->isEnemy(BWAPI::Broodwar->self())
          || targetingPlayer->isNeutral()) {
          continue;
        }
        if (tu->getTarget() == u) {
          isBeingHealed = true;
          break;
        }
      }
      if (isBeingHealed) {
        continue;
      }
      else {
        auto distance = unit->getDistance(u);
        if (distance < closestDistance) {
          healTarget = u;
          closestDistance = distance;
        }
      }
    }
  }
  /*healTarget = unit->getClosestUnit((BWAPI::Filter::IsOwned || BWAPI::Filter::IsAlly)
    && BWAPI::Filter::HP_Percent < 100
    && !BWAPI::Filter::IsMechanical
    && !BWAPI::Filter::IsBeingHealed);*/
  if (healTarget && healTarget != unit->getTarget()) {
    useTech(unit, BWAPI::TechTypes::Healing, healTarget);
    return;
  }

  militaryUnitAI(unit, data);
  return;
}

void ghostAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  if (canUseTech(unit, Personnel_Cloaking)
    && !unit->isCloaked()
    && unit->isUnderAttack()
    && Personnel_Cloaking.energyCost() + 20 < unit->getEnergy()) {
    useTech(unit, Personnel_Cloaking);
    return;
  }

  auto self = BWAPI::Broodwar->self();
  if (canUseTech(unit, Lockdown)
    && unit->isUnderAttack()
    && Lockdown.energyCost() < unit->getEnergy()) {
    auto target = unit->getClosestUnit([self, unit](BWAPI::Unit u) {
      if (u->getPlayer()->isEnemy(self)
        && u->getType().isMechanical()
        && !u->getType().isBuilding()
        && u->getOrderTarget() == unit) {
        for (auto bullet : BWAPI::Broodwar->getBullets()) {
          if (bullet->getType() == BWAPI::BulletTypes::EMP_Missile
            && bullet->getTarget() == u) {
            return false;
          }
        }
        return true;
      }
      return false;
      });
    if (target) {
      useTech(unit, Lockdown, target);
      return;
    }
  }

  // NEED NUKE LOGIC

  unitWithWeaponsAI(unit, data);
  return;
}

void vultureAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  if (canUseTech(unit, Spider_Mines)
    //&& unit->getSpiderMineCount()
    && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::None
    && unit->isIdle()
    && unit->getClientInfo<int>(static_cast<int>(ClientInfo::AssignedRegion))) {
    auto region = unit->getRegion();
    std::queue<BWAPI::Region> Q;
    std::map<BWAPI::Region, bool> checked;
    Q.push(region);
    checked[region] = true;
    region = nullptr;
    bool usedTech = false;
    while (Q.size()) {
      auto v = Q.front();
      Q.pop();
      for (auto r : v->getNeighbors()) {
        if (!checked[r]
          && r->getUnits(BWAPI::Filter::IsBuilding && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self()).size()
          && !r->getUnits(BWAPI::Filter::GetType == BWAPI::UnitTypes::Terran_Vulture_Spider_Mine
            && BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self()).size()) {
          useTech(unit, Spider_Mines, nullptr, r->getCenter());
          usedTech = true;
          return;
        }
        else if (!checked[r]) {
          Q.push(r);
          checked[r] = true;
        }
      }
    }
  }

  unitWithWeaponsAI(unit, data);
}

void tankAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::WeaponTypes;
  using namespace BWAPI::Filter;
  using namespace BWAPI::UnitTypes;
  auto currentJob = unit->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job));
  auto getEnemiesInRangeNotMelee = [](BWAPI::Unit unit) {
    return unit->getUnitsInRadius(Arclite_Shock_Cannon.maxRange()
      , !IsFlyer
      && IsEnemy
      && [unit](BWAPI::Unit other) {
        return other->getDistance(unit) >= Arclite_Shock_Cannon.minRange()
          && other->getType().groundWeapon().maxRange() >= Arclite_Shock_Cannon.minRange();
      });
  };
  if (unit->getType() == Terran_Siege_Tank_Tank_Mode
    && canUseTech(unit, Tank_Siege_Mode)) {
    auto enemiesInRangeNotMelee = getEnemiesInRangeNotMelee(unit);
    if (enemiesInRangeNotMelee.size()) {
      useTech(unit, Tank_Siege_Mode);
      return;
    }
    if (currentJob == JobType::None) {
      auto assignedRegion = unit->getClientInfo<BWAPI::Region>(static_cast<int>(ClientInfo::AssignedRegion));
      if (assignedRegion == unit->getRegion()
        && unit->isIdle()
        && canUseTech(unit, Tank_Siege_Mode)) {
        useTech(unit, Tank_Siege_Mode);
      }
    }
  }
  if (unit->getType() == Terran_Siege_Tank_Siege_Mode) {
    auto enemiesInRangeNotMelee = getEnemiesInRangeNotMelee(unit);
    if (enemiesInRangeNotMelee.size()) {
      bool onlyBuildings = true;
      for (auto& enemy : enemiesInRangeNotMelee) {
        if (enemy->getType().isBuilding() &&
          (enemy->getType().groundWeapon() == BWAPI::TechTypes::None
            || enemy->getType() == Terran_Bunker)) {
          onlyBuildings = false;
        }
      }
      auto unitNotClose = [enemiesInRangeNotMelee](BWAPI::Unit other) {
        return enemiesInRangeNotMelee.find(other) != enemiesInRangeNotMelee.end();
      };
      if (!onlyBuildings) {
        auto potentialTarget = unit->getClosestUnit((GroundWeapon != BWAPI::WeaponTypes::None) && unitNotClose);
        if (!potentialTarget) {
          potentialTarget = unit->getClosestUnit((AirWeapon != BWAPI::WeaponTypes::None) && unitNotClose);
          if (!potentialTarget) {
            potentialTarget = unit->getClosestUnit(unitNotClose);
            if (potentialTarget) {
              if (potentialTarget != unit->getTarget()) {
                issueOrder(unit, BWAPI::Orders::AttackUnit, BWAPI::Positions::None, potentialTarget);
                return;
              }
            }
          }
        }
      }
      else {
        auto target = unit->getClosestUnit(unitNotClose);
        if (target) {
          issueOrder(unit, BWAPI::Orders::AttackUnit, BWAPI::Positions::None, target);
          return;
        }
      }
    }
    else if (currentJob != JobType::None) {
      useTech(unit, Tank_Siege_Mode);
      return;
    }
  }

  unitWithWeaponsAI(unit, data);
  return;
}

void wraithAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  if (unit->isUnderAttack()
    && !unit->isCloaked()
    && canUseTech(unit, Cloaking_Field)
    && Cloaking_Field.energyCost() + 25 < unit->getEnergy()) {
    useTech(unit, Cloaking_Field);
    return;
  }

  unitWithWeaponsAI(unit, data);
  return;
}

void vesselAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::Filter;
  using namespace BWAPI::TechTypes;
  if (checkPanic(unit)) {
    return;
  }

  if (unit->isUnderAttack()) {
    if (canUseTech(unit, Irradiate)
      && Irradiate.energyCost() < unit->getEnergy()) {
      auto target = unit->getClosestUnit(Target == unit
        && IsOrganic
        && IsEnemy
        && !IsIrradiated);
      if (target) {
        useTech(unit, Irradiate, target);
        return;
      }
    }
    if (canUseTech(unit, EMP_Shockwave)
      && EMP_Shockwave.energyCost() < unit->getEnergy()) {
      auto target = unit->getClosestUnit(Target == unit
        && (Shields > 0
          || Energy > 0)
        && IsEnemy);
      if (target) {
        useTech(unit, EMP_Shockwave, target);
        return;
      }
    }
    if (canUseTech(unit, Defensive_Matrix)
      && Defensive_Matrix.energyCost() < unit->getEnergy()) {
      useTech(unit, Defensive_Matrix, unit);
      return;
    }
    panic(unit);
  }

  if (unit->isIdle()) {
    if (canUseTech(unit, Irradiate)
      && Irradiate.energyCost() < unit->getEnergy()) {
      auto target = unit->getClosestUnit(IsOrganic
        && IsEnemy
        && !IsIrradiated);
      if (target) {
        useTech(unit, Irradiate, target);
        return;
      }
    }
    if (canUseTech(unit, EMP_Shockwave)
      && EMP_Shockwave.energyCost() < unit->getEnergy()) {
      auto target = unit->getClosestUnit((Shields_Percent > 50
          || Energy_Percent > 25)
        && IsEnemy);
      if (target) {
        useTech(unit, EMP_Shockwave, target);
        return;
      }
    }
    if (canUseTech(unit, Defensive_Matrix)
      && Defensive_Matrix.energyCost() < unit->getEnergy()) {
      auto target = unit->getClosestUnit((IsAlly || IsOwned)
        && IsUnderAttack);
      if (target) {
        useTech(unit, Defensive_Matrix, unit);
        return;
      }
    }
  }

  if (chaseDetectionTarget(unit)) {
    return;
  }

  militaryUnitAI(unit, data);
}

void battlecruiserAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::Filter;
  auto currentJob = unit->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job));
  auto range = (currentJob == JobType::Defend || currentJob == JobType::Attack || currentJob == JobType::HelpExpand) ? unit->getType().sightRange() : 999999;
  if (canUseTech(unit, Yamato_Gun)
    && Yamato_Gun.energyCost() < unit->getEnergy()) {
    auto target = unit->getClosestUnit(IsEnemy
      && MaxHP > 79, range);
    if (target) {
      useTech(unit, Yamato_Gun, target);
      return;
    }
  }

  unitWithWeaponsAI(unit, data);
}

void comsatAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  using namespace BWAPI::Filter;
  
  auto target = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDetection));
  if (target
    && target->exists()
    && Scanner_Sweep.energyCost() < unit->getEnergy()) {
    auto scan = target->getUnitsInRadius(Spell_Scanner_Sweep.sightRange(), IsOwned && GetType == Spell_Scanner_Sweep);
    if (scan.size() == 0) {
      useTech(unit, Scanner_Sweep, nullptr, target->getPosition());
      return;
    }
  }
  else if (target
    && !target->exists()) {
    unit->setClientInfo(nullptr, static_cast<int>(ClientInfo::AssignedDetection));
  }
  return;
}

void hydraliskAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  auto& minerals = data->minerals;
  auto& gas = data->gas;
  auto& supplyUsed = data->supplyUsed;
  const auto mineralPrice = Zerg_Lurker.mineralPrice();
  const auto gasPrice = Zerg_Lurker.gasPrice();
  const auto job = unit->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job));
  if ( job == JobType::None
    && canUseTech(unit, Lurker_Aspect)
    && data->allowed.units[Zerg_Lurker]
    && data->supplyUsed + Zerg_Lurker.supplyRequired() - Zerg_Hydralisk.supplyRequired() <= data->supplyTotal
    && mineralPrice < minerals
    && gasPrice < gas
    && hitPointPercent(unit) > 50) {
    unit->morph(Zerg_Lurker);
    data->counts.raw[Zerg_Lurker]++;
    minerals -= mineralPrice;
    gas -= gasPrice;
    supplyUsed += Zerg_Lurker.supplyRequired() - Zerg_Hydralisk.supplyRequired();
    return;
  }

  auto assignedRegion = unit->getClientInfo<BWAPI::Region>(static_cast<int>(ClientInfo::AssignedRegion));
  if (unit->isIdle()
    && canUseTech(unit, Burrowing)
    && assignedRegion
    && assignedRegion == unit->getRegion()) {
    useTech(unit, Burrowing);
    return;
  }

  unitWithWeaponsAI(unit, data);
  return;
}

void lurkerEggAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  if (hitPointPercent(unit) < 15) {
    unit->cancelMorph();
    unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
  }
  return;
}

void lurkerAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  if (unit->isBurrowed()) {
    unitWithWeaponsAI(unit, data);
  }
  else {
    if (unit->isUnderAttack()) {
      useTech(unit, BWAPI::TechTypes::Burrowing);
      return;
    }
    militaryUnitAI(unit, data);
  }
  return;
}

void patrolDetectorAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  auto self = BWAPI::Broodwar->self();
  if (0 < unit->getType().maxShields()
    && (unit->getTarget() && unit->getTarget()->getType() != BWAPI::UnitTypes::Protoss_Shield_Battery && unit->getTarget()->getPlayer() == self)
    && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::Attack
    && static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) != JobType::Taxi
    && 100 * unit->getShields() / unit->getType().maxShields() < 10
    && 100 * unit->getHitPoints() / unit->getType().maxHitPoints() < 50) {
    auto battery = unit->getClosestUnit(BWAPI::Filter::GetPlayer == self
      && BWAPI::Filter::GetType == BWAPI::UnitTypes::Protoss_Shield_Battery
      && BWAPI::Filter::Energy_Percent > 10);
    if (battery) {
      unit->rightClick(battery);
      unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Job));
    }
  }
  if (checkPanic(unit)) {
    return;
  }
  auto assignedResourceDepot = unit->getClientInfo<BWAPI::Unit>(static_cast<int>(ClientInfo::AssignedDepot));
  if (!assignedResourceDepot || !assignedResourceDepot->exists()) {
    assignedResourceDepot = getClosestNotMacroResourceDepot(unit, data);
    unit->setClientInfo(assignedResourceDepot, static_cast<int>(ClientInfo::AssignedDepot));
  }

  if (unit->isUnderAttack() && !unit->getClientInfo<bool>(static_cast<int>(ClientInfo::Panic))) {
    panic(unit);
    return;
  }

  if (chaseDetectionTarget(unit)) {
    return;
  }

  if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::Attack) {
    auto itr = data->attackerUnitSets.begin();
    while (itr != data->attackerUnitSets.end()) {
      BWAPI::Position avgPosition = BWAPI::Positions::None;
      bool found = false;
      for (auto unitItr = itr->begin(); unitItr != itr->end(); unitItr++) {
        if ((*unitItr) == unit) {
          found = true;
        }
        else {
          avgPosition = avgPosition + (*unitItr)->getPosition();
        }
      }
      if (found) {
        if (itr->size() == 1) {
          data->attackerUnitSets.erase(itr);
          unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
        }
        else {
          avgPosition = avgPosition / (itr->size() - 1);
          issueOrder(unit, BWAPI::Orders::Move, avgPosition);
        }
        return;
      }
      else {
        itr++;
      }
    }
  }
  if (assignedResourceDepot) {
    if (unit->isIdle()) {
      auto region = unit->getRegion();
      bool hasOwnBuildings = false;
      BWAPI::Regionset potentialRegions;
      for (auto& neighbor : region->getNeighbors()) {
        for (auto& regionUnit : region->getUnits()) {
          if (regionUnit->getType().isBuilding() && regionUnit->getPlayer() == self) {
            hasOwnBuildings = true;
            break;
          }
        }
        if (hasOwnBuildings) {
          potentialRegions.insert(neighbor);
        }
      }
      if (!potentialRegions.size()) {
        issueOrder(unit, BWAPI::Orders::Move, assignedResourceDepot->getPosition());
        return;
      }
      else {
        auto choice = data->getRandomInteger(0, potentialRegions.size() - 1);
        auto itr = potentialRegions.begin();
        while (choice) {
          itr++;
          choice--;
        }
        issueOrder(unit, BWAPI::Orders::Move, (*itr)->getCenter());
        return;
      }
    }
  }
  return;
}

void overlordAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  if (static_cast<JobType>(unit->getClientInfo<int>(static_cast<int>(ClientInfo::Job))) == JobType::Taxi) {
    if (unit->isIdle()) {
      auto rider = unit->getClosestUnit(BWAPI::Filter::GetPlayer == BWAPI::Broodwar->self() && BWAPI::Filter::OrderTarget == unit);
      if (rider &&
        rider->getType().spaceRequired() <= unit->getSpaceRemaining()) {
        issueOrder(unit, BWAPI::Orders::PickupTransport, BWAPI::Positions::None, rider);
        return;
      }
      else {
        auto position = BWAPI::Position{ unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobX)), unit->getClientInfo<int>(static_cast<int>(ClientInfo::JobY)) };
        issueOrder(unit, BWAPI::Orders::Unload, position);
      }
      if (unit->getType().spaceProvided() == unit->getSpaceRemaining()) {
        unit->setClientInfo(static_cast<int>(JobType::None), static_cast<int>(ClientInfo::Job));
        unit->setClientInfo(0, static_cast<int>(ClientInfo::JobX));
        unit->setClientInfo(0, static_cast<int>(ClientInfo::JobY));
      }
    }
    return;
  }

  patrolDetectorAI(unit, data);
}

void queenAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::Filter;
  if (checkPanic) {
    return;
  }
  
  if (unit->isUnderAttack()) {
    auto target = unit->getClosestUnit(Target == unit && IsEnemy);
    if (target) {
      if (!target->getType().isFlyer()
        && !target->getType().isBuilding()
        && target->getType().isOrganic()
        && canUseTech(unit, Spawn_Broodlings)
        && unit->getEnergy() < Spawn_Broodlings.energyCost()) {
        useTech(unit, Spawn_Broodlings, target);
        return;
      }
      else if (!target->getType().isBuilding()
        && canUseTech(unit, Ensnare)
        && unit->getEnergy() < Ensnare.energyCost()) {
        useTech(unit, Ensnare, target);
        return;
      }
      else {
        panic(unit);
        return;
      }
    }
  }

  if (unit->isIdle()) {
    if (canUseTech(unit, Spawn_Broodlings)
      && unit->getEnergy() < Spawn_Broodlings.energyCost()) {
      auto target = unit->getClosestUnit(!IsFlyer && !IsBuilding && IsOrganic && IsEnemy);
      if (target) {
        useTech(unit, Spawn_Broodlings, target);
        return;
      }
    }

    if (canUseTech(unit, Ensnare)
      && unit->getEnergy() < Ensnare.energyCost()) {
      auto target = unit->getClosestUnit(!IsBuilding && IsEnemy);
      if (target) {
        auto nearbyEnemies = BWAPI::Broodwar->getUnitsInRectangle(target->getPosition() + BWAPI::Position{ -64, -64 }, target->getPosition() + BWAPI::Position{ 64, 64 }, IsEnemy);
        if (4 < nearbyEnemies.size()) {
          useTech(unit, Ensnare, target);
          return;
        }
      }
    }

    auto target = unit->getClosestUnit(GetType == BWAPI::UnitTypes::Terran_Command_Center
      && IsEnemy
      && [](BWAPI::Unit other) {
        return hitPointPercent(other) < 40;
      });
    if (target) {
      useTech(unit, Infestation, target);
      return;
    }
  }

  militaryUnitAI(unit, data);
}

void mutaliskAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::UnitTypes;
  if (unit->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job)) == JobType::None) {
    if (unit->isIdle()) {
      const auto guardianMineralPrice = Zerg_Guardian.mineralPrice();
      const auto guardianGasPrice = Zerg_Guardian.gasPrice();
      const auto devourerMineralPrice = Zerg_Devourer.mineralPrice();
      const auto devourerGasPrice = Zerg_Devourer.gasPrice();
      if (data->allowed.units[Zerg_Guardian]
        &&  guardianMineralPrice < data->minerals
        && guardianGasPrice < data->gas) {
        unit->morph(Zerg_Guardian);
        data->allowed.units[Zerg_Guardian] = false;
        unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        data->minerals -= guardianMineralPrice;
        data->gas -= guardianGasPrice;
      }
      else if (data->allowed.units[Zerg_Devourer]
        && devourerMineralPrice < data->minerals
        && devourerGasPrice < data->gas) {
        unit->morph(Zerg_Devourer);
        data->allowed.units[Zerg_Devourer] = false;
        unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
        data->minerals -= devourerMineralPrice;
        data->gas -= devourerGasPrice;
      }
    }
  }
  
  unitWithWeaponsAI(unit, data);
}

void defilerAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::Filter;
  using namespace BWAPI::TechTypes;
  auto affectedBySwarm = [](BWAPI::Unit unit) {
    using namespace BWAPI::UnitTypes;
    switch (unit->getType()) {
    case Zerg_Zergling:
    case Zerg_Ultralisk:
    case Protoss_Zealot:
    case Protoss_Dark_Templar:
    case Protoss_Reaver:
    case Protoss_Scarab:
    case Zerg_Infested_Terran:
    case Terran_Vulture_Spider_Mine:
      return false;
    default:
      return true;
    }
  };

  if (checkPanic(unit)) {
    return;
  }
  if (unit->isUnderAttack()) {
    auto target = unit->getClosestUnit(IsEnemy
      && GroundWeapon != BWAPI::WeaponTypes::None
      && Target == unit);
    if (target) {
      if (canUseTech(unit, Dark_Swarm)
        && affectedBySwarm(target)
        && Dark_Swarm.energyCost() < unit->getEnergy()
        && !unit->isUnderDarkSwarm()) {
        useTech(unit, Dark_Swarm, nullptr, unit->getPosition());
        return;
      }
      else if (canUseTech(unit, Plague)
        && Plague.energyCost() < unit->getEnergy()
        && !target->isPlagued()) {
        useTech(unit, Plague, target);
        return;
      }
    }
    else {
      panic(unit);
      return;
    }
  }

  if (canUseTech(unit, Plague)
      && Plague.energyCost() < unit->getEnergy()) {
    auto range = unit->getClientInfo<JobType>(static_cast<int>(ClientInfo::Job)) == JobType::None ? 999999 : unit->getType().sightRange();
    auto target = unit->getClosestUnit(IsEnemy
      && HP_Percent > 50
      && (GroundWeapon != BWAPI::WeaponTypes::None || AirWeapon != BWAPI::WeaponTypes::None));
    if (target) {
      useTech(unit, Plague);
      return;
    }
    else {
      target = unit->getClosestUnit(IsEnemy && HP_Percent > 50);
      if (target) {
        useTech(unit, Plague);
        return;
      }
    }
  }

  militaryUnitAI(unit, data);
}

void templarAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  using namespace BWAPI::Filter;
  if (canUseTech(unit, Archon_Warp)
    && unit->isIdle()
    && data->allowed.units[Protoss_Archon]
    && unit->getEnergy() < Psionic_Storm.energyCost()) {
    auto target = unit->getClosestUnit(GetType == Protoss_High_Templar && IsOwned && CurrentOrder != BWAPI::Orders::ArchonWarp);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Archon_Warp, target);
      return;
    }
  }
  if (canUseTech(unit, Psionic_Storm)
    && Psionic_Storm.energyCost() < unit->getEnergy()
    && (unit->isUnderAttack()
      || 75 < energyPercent(unit))) {
    auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Psionic_Storm, target);
      return;
    }
  }
  if (canUseTech(unit, Hallucination)
    && Hallucination.energyCost() < unit->getEnergy()
    && unit->isIdle()
    && 75 < energyPercent(unit)) {
    auto target = unit->getClosestUnit(IsOwned && !IsBuilding);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Hallucination, target);
      return;
    }
  }
  militaryUnitAI(unit, data);
}

void darkTemplarAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  using namespace BWAPI::Filter;
  if (canUseTech(unit, Dark_Archon_Meld)
    && data->allowed.units[Protoss_Dark_Archon]) {
    auto target = unit->getClosestUnit(GetType == Protoss_Dark_Templar
      && IsOwned
      && CurrentOrder != BWAPI::Orders::DarkArchonMeld);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Dark_Archon_Meld, target);
      data->allowed.units[Protoss_Dark_Archon] = false;
      return;
    }
  }
  unitWithWeaponsAI(unit, data);
}

void carrierAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::UnitTypes;
  using namespace BWAPI::UpgradeTypes;
  if (unit->getType() == Protoss_Carrier
    && unit->getInterceptorCount() < BWAPI::Broodwar->self()->getUpgradeLevel(Carrier_Capacity) == 1 ? 8 : 4
    && !unit->isTraining()
    && Protoss_Interceptor.mineralPrice() < data->minerals
    && Protoss_Interceptor.gasPrice() < data->gas) {
    if (unit->train(Protoss_Interceptor)) {
      data->minerals -= Protoss_Interceptor.mineralPrice();
      data->gas -= Protoss_Interceptor.gasPrice();
      unit->setClientInfo(BWAPI::Broodwar->getLatencyFrames(), static_cast<int>(ClientInfo::Sleep));
      return;
    }
  }
  if (unit->getInterceptorCount() > 0) {
    unitWithWeaponsAI(unit, data);
  }
  else {
    militaryUnitAI(unit, data);
  }
}

void arbiterAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::Filter;
  if (canUseTech(unit, Stasis_Field)
    && Stasis_Field.energyCost() < unit->getEnergy()
    && (unit->isUnderAttack()
      || 75 < energyPercent(unit))) {
    auto target = unit->getClosestUnit(IsEnemy && !IsBuilding);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Stasis_Field, target);
      return;
    }
  }

  unitWithWeaponsAI(unit, data);
}

void corsairAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::Filter;
  if (canUseTech(unit, Disruption_Web)
    && unit->isUnderAttack()) {
    auto closestGroundEnemy = unit->getClosestUnit(IsEnemy
      && !IsFlyer
      && AirWeapon != BWAPI::WeaponTypes::None
      && !IsUnderDisruptionWeb);
    if (closestGroundEnemy
      && closestGroundEnemy != unit->getOrderTarget()) {
      useTech(unit, Disruption_Web, closestGroundEnemy);
      return;
    }
  }

  unitWithWeaponsAI(unit, data);
}

void darkArchonAI(BWAPI::Unit unit, std::shared_ptr<Data> data) {
  using namespace BWAPI::TechTypes;
  using namespace BWAPI::UnitTypes;
  using namespace BWAPI::Filter;
  if (canUseTech(unit, Mind_Control)
    && Mind_Control.energyCost() < unit->getEnergy()
    && unit->isUnderAttack()) {
    BWAPI::Unit target = nullptr;
    for (auto& potentialTarget : unit->getUnitsInRadius(unit->getType().sightRange(), BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsBuilding)) {
      if (!target)
        target = potentialTarget;
      else {
        if ((potentialTarget->getType().isDetector() || potentialTarget->getType() == Zerg_Overlord) && target->getType().maxHitPoints() + target->getType().maxShields() < 300) {
          target = potentialTarget;
        }
        else if (target->getType().maxHitPoints() + target->getType().maxShields() < potentialTarget->getType().maxHitPoints() + potentialTarget->getType().maxShields()) {
          target = potentialTarget;
        }
      }
    }
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Mind_Control, target);
      return;
    }
  }
  if (canUseTech(unit, Maelstrom)
    && Maelstrom.energyCost() < unit->getEnergy()
    && (unit->isUnderAttack()
      || 75 < energyPercent(unit))) {
    auto target = unit->getClosestUnit(BWAPI::Filter::IsEnemy && !BWAPI::Filter::IsMechanical && !BWAPI::Filter::IsBuilding);
    if (target && target != unit->getOrderTarget()) {
      useTech(unit, Maelstrom, target);
      return;
    }
  }
  if (canUseTech(unit, Feedback)) {
    auto energyRequirement = canUseTech(unit, Mind_Control) ? Mind_Control.energyCost() : (canUseTech(unit, Maelstrom) ? Maelstrom.energyCost() : 0);
    energyRequirement += Feedback.energyCost();
    if (energyRequirement < unit->getEnergy()) {
      auto target = unit->getClosestUnit(IsEnemy
        && MaxEnergy > 0
        && [data](BWAPI::Unit other) {
          return data->feedbackCooldowns.find(other->getID()) == data->feedbackCooldowns.end()
            || !data->feedbackCooldowns[other->getID()];
        });
      if (target) {
        useTech(unit, Feedback, target);
        // frames per 1 energy * energy waiting for.
        auto sightRange = unit->getType().sightRange();
        auto distance = unit->getDistance(target);
        data->feedbackCooldowns[target->getID()] = 42 * 75 + (distance < sightRange ? 0 : (distance - sightRange) * 24);
        return;
      }
    }
  }

  militaryUnitAI(unit, data);
}