#include <BWAPI.h>

#include "buildorder.h"


using namespace BWAPI::UnitTypes;
using namespace BWAPI::TechTypes;
using namespace BWAPI::UpgradeTypes;

/*  Protoss Template
data->allowed.units[Protoss_Nexus] = 0;
expand = true;
data->allowed.units[Protoss_Assimilator] = 0;
data->allowed.units[Protoss_Gateway] = 0;
data->allowed.units[Protoss_Forge] = 0;
data->allowed.units[Protoss_Photon_Cannon] = 0;
data->allowed.units[Protoss_Cybernetics_Core] = 0;
data->allowed.units[Protoss_Shield_Battery] = 0;
data->allowed.units[Protoss_Robotics_Facility] = 0;
data->allowed.units[Protoss_Stargate] = 0;
data->allowed.units[Protoss_Citadel_of_Adun] = 0;
data->allowed.units[Protoss_Robotics_Support_Bay] = 0;
data->allowed.units[Protoss_Fleet_Beacon] = 0;
data->allowed.units[Protoss_Templar_Archives] = 0;
data->allowed.units[Protoss_Observatory] = 0;
data->allowed.units[Protoss_Arbiter_Tribunal] = 0;
data->allowed.units[Protoss_Probe] = 0;
data->allowed.units[Protoss_Zealot] = 0;
data->allowed.units[Protoss_Dragoon] = 0;
data->allowed.units[Protoss_High_Templar] = 0;
data->allowed.units[Protoss_Archon] = 0;
data->allowed.units[Protoss_Dark_Templar] = 0;
data->allowed.units[Protoss_Dark_Archon] = 0;
data->allowed.units[Protoss_Shuttle] = 0;
data->allowed.units[Protoss_Reaver] = 0;
data->allowed.units[Protoss_Observer] = 0;
data->allowed.units[Protoss_Scout] = 0;
data->allowed.units[Protoss_Carrier] = 0;
data->allowed.units[Protoss_Arbiter] = 0;
data->allowed.units[Protoss_Corsair] = 0;
data->allowed.upgrades[Protoss_Ground_Weapons] = 0;
data->allowed.upgrades[Protoss_Ground_Armor] = 0;
data->allowed.upgrades[Protoss_Plasma_Shields] = 0;
data->allowed.upgrades[Protoss_Air_Weapons] = 0;
data->allowed.upgrades[Protoss_Air_Armor] = 0;
data->allowed.upgrades[Singularity_Charge] = 0;
data->allowed.upgrades[Leg_Enhancements] = 0;
data->allowed.upgrades[Scarab_Damage] = 0;
data->allowed.upgrades[Reaver_Capacity] = 0;
data->allowed.upgrades[Gravitic_Drive] = 0;
data->allowed.upgrades[Apial_Sensors] = 0;
data->allowed.upgrades[Gravitic_Thrusters] = 0;
data->allowed.upgrades[Carrier_Capacity] = 0;
data->allowed.upgrades[Argus_Jewel] = 0;
data->allowed.upgrades[Khaydarin_Amulet] = 0;
data->allowed.upgrades[Argus_Talisman] = 0;
data->allowed.upgrades[Gravitic_Boosters] = 0;
data->allowed.upgrades[Sensor_Array] = 0;
data->allowed.upgrades[Khaydarin_Core] = 0;
data->allowed.techs[Disruption_Web] = 0;
data->allowed.techs[Psionic_Storm] = 0;
data->allowed.techs[Hallucination] = 0;
data->allowed.techs[Mind_Control] = 0;
data->allowed.techs[Maelstrom] = 0;
data->allowed.techs[Recall] = 0;
data->allowed.techs[Stasis_Field] = 0;
*/

/* Terran Template
data->allowed.units[Terran_Command_Center] = 0;
expand = true;
data->allowed.units[Terran_Supply_Depot] = 0;
data->allowed.units[Terran_Refinery] = 0;
data->allowed.units[Terran_Barracks] = 0;
data->allowed.units[Terran_Engineering_Bay] = 0;
data->allowed.units[Terran_Missile_Turret] = 0;
data->allowed.units[Terran_Academy] = 0;
data->allowed.units[Terran_Bunker] = 0;
data->allowed.units[Terran_Factory] = 0;
data->allowed.units[Terran_Starport] = 0;
data->allowed.units[Terran_Science_Facility] = 0;
data->allowed.units[Terran_Armory] = 0;
data->allowed.units[Terran_Comsat_Station] = 0;
data->allowed.units[Terran_Nuclear_Silo] = 0;
data->allowed.units[Terran_Machine_Shop] = 0;
data->allowed.units[Terran_Control_Tower] = 0;
data->allowed.units[Terran_Covert_Ops] = 0;
data->allowed.units[Terran_Physics_Lab] = 0;
data->allowed.units[Terran_SCV] = 0;
data->allowed.units[Terran_Marine] = 0;
data->allowed.units[Terran_Firebat] = 0;
data->allowed.units[Terran_Ghost] = 0;
data->allowed.units[Terran_Medic] = 0;
data->allowed.units[Terran_Vulture] = 0;
data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
data->allowed.units[Terran_Goliath] = 0;
data->allowed.units[Terran_Wraith] = 0;
data->allowed.units[Terran_Dropship] = 0;
data->allowed.units[Terran_Science_Vessel] = 0;
data->allowed.units[Terran_Battlecruiser] = 0;
data->allowed.units[Terran_Valkyrie] = 0;
data->allowed.units[Terran_Nuclear_Missile] = 0;
data->allowed.upgrades[Terran_Infantry_Weapons] = 0;
data->allowed.upgrades[Terran_Infantry_Armor] = 0;
data->allowed.upgrades[U_238_Shells] = 0;
data->allowed.upgrades[Caduceus_Reactor] = 0;
data->allowed.upgrades[Titan_Reactor] = 0;
data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
data->allowed.upgrades[Terran_Ship_Weapons] = 0;
data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
data->allowed.upgrades[Terran_Ship_Plating] = 0;
data->allowed.upgrades[Ion_Thrusters] = 0;
data->allowed.upgrades[Charon_Boosters] = 0;
data->allowed.upgrades[Apollo_Reactor] = 0;
data->allowed.upgrades[Ocular_Implants] = 0;
data->allowed.upgrades[Moebius_Reactor] = 0;
data->allowed.upgrades[Colossus_Reactor] = 0;
data->allowed.techs[Stim_Packs] = 0;
data->allowed.techs[Restoration] = 0;
data->allowed.techs[Optical_Flare] = 0;
data->allowed.techs[EMP_Shockwave] = 0;
data->allowed.techs[Irradiate] = 0;
data->allowed.techs[Spider_Mines] = 0;
data->allowed.techs[Tank_Siege_Mode] = 0;
data->allowed.techs[Cloaking_Field] = 0;
data->allowed.techs[Lockdown] = 0;
data->allowed.techs[Personnel_Cloaking] = 0;
data->allowed.techs[Yamato_Gun] = 0;
*/

/* Zerg Template
data->allowed.units[Zerg_Hatchery] = 0;
expand = false;
data->allowed.units[Zerg_Creep_Colony] = 0;
data->allowed.units[Zerg_Extractor] = 0;
data->allowed.units[Zerg_Spawning_Pool] = 0;
data->allowed.units[Zerg_Evolution_Chamber] = 0;
data->allowed.units[Zerg_Hydralisk_Den] = 0;
data->allowed.units[Zerg_Spire] = 0;
data->allowed.units[Zerg_Queens_Nest] = 0;
data->allowed.units[Zerg_Nydus_Canal] = 0;
data->allowed.units[Zerg_Ultralisk_Cavern] = 0;
data->allowed.units[Zerg_Defiler_Mound] = 0;
data->allowed.units[Zerg_Lair] = 0;
data->allowed.units[Zerg_Spore_Colony] = 0;
data->allowed.units[Zerg_Sunken_Colony] = 0;
data->allowed.units[Zerg_Greater_Spire] = 0;
data->allowed.units[Zerg_Hive] = 0;
data->allowed.units[Zerg_Zergling] = 0;
data->allowed.units[Zerg_Hydralisk] = 0;
data->allowed.units[Zerg_Mutalisk] = 0;
data->allowed.units[Zerg_Scourge] = 0;
data->allowed.units[Zerg_Queen] = 0;
data->allowed.units[Zerg_Ultralisk] = 0;
data->allowed.units[Zerg_Defiler] = 0;
data->allowed.units[Zerg_Lurker] = 0;
data->allowed.units[Zerg_Guardian] = 0;
data->allowed.units[Zerg_Devourer] = 0;
data->allowed.upgrades[Metabolic_Boost] = 0;
data->allowed.upgrades[Adrenal_Glands] = 0;
data->allowed.upgrades[Zerg_Melee_Attacks] = 0;
data->allowed.upgrades[Zerg_Missile_Attacks] = 0;
data->allowed.upgrades[Zerg_Carapace] = 0;
data->allowed.upgrades[Muscular_Augments] = 0;
data->allowed.upgrades[Grooved_Spines] = 0;
data->allowed.upgrades[Zerg_Flyer_Attacks] = 0;
data->allowed.upgrades[Zerg_Flyer_Carapace] = 0;
data->allowed.upgrades[Gamete_Meiosis] = 0;
data->allowed.upgrades[Anabolic_Synthesis] = 0;
data->allowed.upgrades[Chitinous_Plating] = 0;
data->allowed.upgrades[Metasynaptic_Node] = 0;
data->allowed.upgrades[Ventral_Sacs] = 0;
data->allowed.upgrades[Antennae] = 0;
data->allowed.upgrades[Pneumatized_Carapace] = 0;
data->allowed.techs[Burrowing] = 0;
data->allowed.techs[Lurker_Aspect] = 0;
data->allowed.techs[Spawn_Broodlings] = 0;
data->allowed.techs[Ensnare] = 0;
data->allowed.techs[Plague] = 0;
data->allowed.techs[Consume] = 0;
*/

//---------- HELPER FUNCTIONS---------------//
bool zergOrProtossEnemy() {
  for (auto enemy : BWAPI::Broodwar->enemies()) {
    if (enemy->getRace() != BWAPI::Races::Terran) {
      return true;
    }
  }
  return false;
}

bool isGettingOrHasTech(BWAPI::TechType tech) {
  auto self = BWAPI::Broodwar->self();
  return self->isResearching(tech) || self->hasResearched(tech);
}

bool isGettingOrHasUpgrade(BWAPI::UpgradeType upgrade, int level) {
  auto self = BWAPI::Broodwar->self();
  return self->isUpgrading(upgrade) || level <= self->getUpgradeLevel(upgrade);
}

bool isExpanding() {
  for (auto& unit : BWAPI::Broodwar->self()->getUnits()) {
    if (!unit->getType().isWorker())
      continue;

    if (unit->getClientInfo<BWAPI::UnitType>(static_cast<int>(ClientInfo::BuildType)).isResourceDepot())
      return true;
  }
  return false;
}

void TutorialBootCamp(std::shared_ptr<Data> data) {
  //auto data = BWAPI::Broodwar->self()->getClientInfo<std::shared_ptr<Data>>(static_cast<int>(ClientInfo::Data));
  auto& allowed = data->allowed;
  allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1);
  data->expand = false;
  allowed.units[Terran_Refinery] = data->rawCountLessThan(Terran_Refinery, 1);
  allowed.units[Terran_SCV] = true;
}

void Wasteland(std::shared_ptr<Data> data) {
  //auto data = BWAPI::Broodwar->self()->getClientInfo<std::shared_ptr<Data>>(static_cast<int>(ClientInfo::Data));
  data->allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1);
  data->expand = false;
  data->allowed.units[Terran_Refinery] = 0;
  data->allowed.units[Terran_Barracks] = data->rawCountLessThan(Terran_Barracks, 1);
  data->allowed.units[Terran_Engineering_Bay] = 0;
  data->allowed.units[Terran_Missile_Turret] = 0;
  data->allowed.units[Terran_Academy] = 0;
  data->allowed.units[Terran_Bunker] = 0;
  data->allowed.units[Terran_Factory] = 0;
  data->allowed.units[Terran_Starport] = 0;
  data->allowed.units[Terran_Science_Facility] = 0;
  data->allowed.units[Terran_Armory] = 0;
  data->allowed.units[Terran_Comsat_Station] = 0;
  data->allowed.units[Terran_Nuclear_Silo] = 0;
  data->allowed.units[Terran_Machine_Shop] = 0;
  data->allowed.units[Terran_Control_Tower] = 0;
  data->allowed.units[Terran_Covert_Ops] = 0;
  data->allowed.units[Terran_Physics_Lab] = 0;
  data->allowed.units[Terran_SCV] = 0;
  data->allowed.units[Terran_Marine] = data->rawCountLessThan(Terran_Marine, 10);
  data->allowed.units[Terran_Firebat] = 0;
  data->allowed.units[Terran_Ghost] = 0;
  data->allowed.units[Terran_Medic] = 0;
  data->allowed.units[Terran_Vulture] = 0;
  data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
  data->allowed.units[Terran_Goliath] = 0;
  data->allowed.units[Terran_Wraith] = 0;
  data->allowed.units[Terran_Dropship] = 0;
  data->allowed.units[Terran_Science_Vessel] = 0;
  data->allowed.units[Terran_Battlecruiser] = 0;
  data->allowed.units[Terran_Valkyrie] = 0;
  data->allowed.units[Terran_Nuclear_Missile] = 0;
  data->allowed.upgrades[Terran_Infantry_Weapons] = 0;
  data->allowed.upgrades[Terran_Infantry_Armor] = 0;
  data->allowed.upgrades[U_238_Shells] = 0;
  data->allowed.upgrades[Caduceus_Reactor] = 0;
  data->allowed.upgrades[Titan_Reactor] = 0;
  data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
  data->allowed.upgrades[Terran_Ship_Weapons] = 0;
  data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
  data->allowed.upgrades[Terran_Ship_Plating] = 0;
  data->allowed.upgrades[Ion_Thrusters] = 0;
  data->allowed.upgrades[Charon_Boosters] = 0;
  data->allowed.upgrades[Apollo_Reactor] = 0;
  data->allowed.upgrades[Ocular_Implants] = 0;
  data->allowed.upgrades[Moebius_Reactor] = 0;
  data->allowed.upgrades[Colossus_Reactor] = 0;
  data->allowed.techs[Stim_Packs] = 0;
  data->allowed.techs[Restoration] = 0;
  data->allowed.techs[Optical_Flare] = 0;
  data->allowed.techs[EMP_Shockwave] = 0;
  data->allowed.techs[Irradiate] = 0;
  data->allowed.techs[Spider_Mines] = 0;
  data->allowed.techs[Tank_Siege_Mode] = 0;
  data->allowed.techs[Cloaking_Field] = 0;
  data->allowed.techs[Lockdown] = 0;
  data->allowed.techs[Personnel_Cloaking] = 0;
  data->allowed.techs[Yamato_Gun] = 0;
}

void BackwaterStation(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  data->allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1);
  data->expand = false;
  data->allowed.units[Terran_Refinery] = data->completeCountGreaterThanOrEquals(Terran_SCV, 5)
    && data->rawCountLessThan(Terran_Refinery, 1);
  data->allowed.units[Terran_Barracks] = data->rawCountLessThan(Terran_Barracks, 1);
  data->allowed.units[Terran_Engineering_Bay] = data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && data->rawCountLessThan(Terran_Engineering_Bay, 1);
  data->allowed.units[Terran_Missile_Turret] = 0;
  data->allowed.units[Terran_Academy] = 0;
  data->allowed.units[Terran_Bunker] = 0;
  data->allowed.units[Terran_Factory] = 0;
  data->allowed.units[Terran_Starport] = 0;
  data->allowed.units[Terran_Science_Facility] = 0;
  data->allowed.units[Terran_Armory] = 0;
  data->allowed.units[Terran_Comsat_Station] = 0;
  data->allowed.units[Terran_Nuclear_Silo] = 0;
  data->allowed.units[Terran_Machine_Shop] = 0;
  data->allowed.units[Terran_Control_Tower] = 0;
  data->allowed.units[Terran_Covert_Ops] = 0;
  data->allowed.units[Terran_Physics_Lab] = 0;
  data->allowed.units[Terran_SCV] = true;
  data->allowed.units[Terran_Marine] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Terran_Marine, 12))
      || ((flags & 0x1)
        && data->rawCountLessThan(Terran_Marine, 20)));
  data->allowed.units[Terran_Firebat] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && ((flags & 0x1)
      && data->rawCountLessThan(Terran_Firebat, 10));
  data->allowed.units[Terran_Ghost] = 0;
  data->allowed.units[Terran_Medic] = 0;
  data->allowed.units[Terran_Vulture] = 0;
  data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
  data->allowed.units[Terran_Goliath] = 0;
  data->allowed.units[Terran_Wraith] = 0;
  data->allowed.units[Terran_Dropship] = 0;
  data->allowed.units[Terran_Science_Vessel] = 0;
  data->allowed.units[Terran_Battlecruiser] = 0;
  data->allowed.units[Terran_Valkyrie] = 0;
  data->allowed.units[Terran_Nuclear_Missile] = 0;
  data->allowed.upgrades[Terran_Infantry_Weapons] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
    && !isGettingOrHasUpgrade(Terran_Infantry_Weapons, 1);
  data->allowed.upgrades[Terran_Infantry_Armor] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
    && isGettingOrHasUpgrade(Terran_Infantry_Weapons, 1)
    && !isGettingOrHasUpgrade(Terran_Infantry_Armor, 1);
  data->allowed.upgrades[U_238_Shells] = data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && !isGettingOrHasUpgrade(U_238_Shells, 1);
  data->allowed.upgrades[Caduceus_Reactor] = 0;
  data->allowed.upgrades[Titan_Reactor] = 0;
  data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
  data->allowed.upgrades[Terran_Ship_Weapons] = 0;
  data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
  data->allowed.upgrades[Terran_Ship_Plating] = 0;
  data->allowed.upgrades[Ion_Thrusters] = 0;
  data->allowed.upgrades[Charon_Boosters] = 0;
  data->allowed.upgrades[Apollo_Reactor] = 0;
  data->allowed.upgrades[Ocular_Implants] = 0;
  data->allowed.upgrades[Moebius_Reactor] = 0;
  data->allowed.upgrades[Colossus_Reactor] = 0;
  data->allowed.techs[Stim_Packs] = data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && isGettingOrHasUpgrade(U_238_Shells, 1)
    && !isGettingOrHasTech(Stim_Packs);
  data->allowed.techs[Restoration] = 0;
  data->allowed.techs[Optical_Flare] = 0;
  data->allowed.techs[EMP_Shockwave] = 0;
  data->allowed.techs[Irradiate] = 0;
  data->allowed.techs[Spider_Mines] = 0;
  data->allowed.techs[Tank_Siege_Mode] = 0;
  data->allowed.techs[Cloaking_Field] = 0;
  data->allowed.techs[Lockdown] = 0;
  data->allowed.techs[Personnel_Cloaking] = 0;
  data->allowed.techs[Yamato_Gun] = 0;
}

void DesperateAlliance(std::shared_ptr<Data> data) {
  data->allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1);
  data->expand = false;
  data->allowed.units[Terran_Refinery] = data->completeCountGreaterThanOrEquals(Terran_SCV, 5)
    && data->rawCountLessThan(Terran_Refinery, 1);
  data->allowed.units[Terran_Barracks] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
    && data->rawCountLessThan(Terran_Barracks, 2);
  data->allowed.units[Terran_Engineering_Bay] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
    && data->rawCountGreaterThanOrEquals(Terran_Barracks, 2)
    && data->rawCountLessThan(Terran_Engineering_Bay, 1);
  data->allowed.units[Terran_Missile_Turret] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Barracks, 2)
    && data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
    && data->incompleteCountEquals(Terran_Missile_Turret, 0)
    && data->rawCountLessThan(Terran_Missile_Turret, 20);
  data->allowed.units[Terran_Academy] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && data->rawCountLessThan(Terran_Academy, 1);
  data->allowed.units[Terran_Bunker] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->rawCountGreaterThanOrEquals(Terran_Refinery, 1)
    && data->rawCountLessThan(Terran_Bunker, 4);
  data->allowed.units[Terran_Factory] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 2)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && data->rawCountLessThan(Terran_Factory, 1);
  data->allowed.units[Terran_Starport] = 0;
  data->allowed.units[Terran_Science_Facility] = 0;
  data->allowed.units[Terran_Armory] = 0;
  data->allowed.units[Terran_Comsat_Station] = 0;
  data->allowed.units[Terran_Nuclear_Silo] = 0;
  data->allowed.units[Terran_Machine_Shop] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
    && data->rawCountLessThan(Terran_Machine_Shop, data->counts.complete[Terran_Factory]);
  data->allowed.units[Terran_Control_Tower] = 0;
  data->allowed.units[Terran_Covert_Ops] = 0;
  data->allowed.units[Terran_Physics_Lab] = 0;
  data->allowed.units[Terran_SCV] = true;
  data->allowed.units[Terran_Marine] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && ((data->rawCountLessThan(Terran_Refinery, 1)
      || data->rawCountLessThan(Terran_Academy, 1))
      || data->rawCountLessThanOrEquals(Terran_Marine, data->counts.raw[Terran_Firebat] * 2));
  data->allowed.units[Terran_Firebat] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && data->rawCountLessThan(Terran_Firebat, data->counts.raw[Terran_Marine], 2);
  data->allowed.units[Terran_Ghost] = 0;
  data->allowed.units[Terran_Medic] = 0;
  data->allowed.units[Terran_Vulture] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1);
  data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
  data->allowed.units[Terran_Goliath] = 0;
  data->allowed.units[Terran_Wraith] = 0;
  data->allowed.units[Terran_Dropship] = 0;
  data->allowed.units[Terran_Science_Vessel] = 0;
  data->allowed.units[Terran_Battlecruiser] = 0;
  data->allowed.units[Terran_Valkyrie] = 0;
  data->allowed.units[Terran_Nuclear_Missile] = 0;
  data->allowed.upgrades[Terran_Infantry_Weapons] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && !isGettingOrHasUpgrade(Terran_Infantry_Weapons, 1);
  data->allowed.upgrades[Terran_Infantry_Armor] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && isGettingOrHasUpgrade(Terran_Infantry_Weapons, 1)
    && !isGettingOrHasUpgrade(Terran_Infantry_Armor, 1);
  data->allowed.upgrades[U_238_Shells] = data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && !isGettingOrHasUpgrade(U_238_Shells, 1);
  data->allowed.upgrades[Caduceus_Reactor] = 0;
  data->allowed.upgrades[Titan_Reactor] = 0;
  data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
  data->allowed.upgrades[Terran_Ship_Weapons] = 0;
  data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
  data->allowed.upgrades[Terran_Ship_Plating] = 0;
  data->allowed.upgrades[Ion_Thrusters] = data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && isGettingOrHasTech(Spider_Mines)
    && !isGettingOrHasUpgrade(Ion_Thrusters, 1);
  data->allowed.upgrades[Charon_Boosters] = 0;
  data->allowed.upgrades[Apollo_Reactor] = 0;
  data->allowed.upgrades[Ocular_Implants] = 0;
  data->allowed.upgrades[Moebius_Reactor] = 0;
  data->allowed.upgrades[Colossus_Reactor] = 0;
  data->allowed.techs[Stim_Packs] = data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
    && isGettingOrHasUpgrade(U_238_Shells, 1)
    && !isGettingOrHasTech(Stim_Packs);
  data->allowed.techs[Restoration] = 0;
  data->allowed.techs[Optical_Flare] = 0;
  data->allowed.techs[EMP_Shockwave] = 0;
  data->allowed.techs[Irradiate] = 0;
  data->allowed.techs[Spider_Mines] = data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && !isGettingOrHasTech(Spider_Mines);
  data->allowed.techs[Tank_Siege_Mode] = 0;
  data->allowed.techs[Cloaking_Field] = 0;
  data->allowed.techs[Lockdown] = 0;
  data->allowed.techs[Personnel_Cloaking] = 0;
  data->allowed.techs[Yamato_Gun] = 0;
}

void Revolution(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  if (flags & 0x1) {
    data->allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1);
    data->expand = false;
    data->allowed.units[Terran_Refinery] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->rawCountLessThan(Terran_Refinery, 1);
    data->allowed.units[Terran_Barracks] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->rawCountLessThan(Terran_Barracks, 2);
    data->allowed.units[Terran_Engineering_Bay] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
      && data->rawCountGreaterThanOrEquals(Terran_SCV, 20)
      && data->rawCountLessThan(Terran_Engineering_Bay, 1);
    data->allowed.units[Terran_Missile_Turret] = 0;
    data->allowed.units[Terran_Academy] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Barracks, 2)
      && data->rawCountLessThan(Terran_Academy, 1);
    data->allowed.units[Terran_Bunker] = 0;
    data->allowed.units[Terran_Factory] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Barracks, 2)
      && data->rawCountLessThan(Terran_Factory, 2);
    data->allowed.units[Terran_Starport] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
      && data->rawCountLessThan(Terran_Starport, 2);
    data->allowed.units[Terran_Science_Facility] = 0;
    data->allowed.units[Terran_Armory] = 0;
    data->allowed.units[Terran_Comsat_Station] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
      && data->rawCountLessThan(Terran_Comsat_Station, data->counts.complete[Terran_Command_Center]);
    data->allowed.units[Terran_Nuclear_Silo] = 0;
    data->allowed.units[Terran_Machine_Shop] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
      && data->rawCountLessThan(Terran_Machine_Shop, 1);
    data->allowed.units[Terran_Control_Tower] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
      && data->rawCountLessThan(Terran_Control_Tower, data->counts.complete[Terran_Starport]);
    data->allowed.units[Terran_Covert_Ops] = 0;
    data->allowed.units[Terran_Physics_Lab] = 0;
    data->allowed.units[Terran_SCV] = data->rawCountLessThan(Terran_SCV, 31);
    data->allowed.units[Terran_Marine] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
      && ((!(flags & 0x2)
        && data->rawCountLessThan(Terran_Marine, 24))
        || ((flags & 0x2)
          && data->rawCountLessThan(Terran_Marine, 16)));
    data->allowed.units[Terran_Firebat] = 0;
    data->allowed.units[Terran_Ghost] = 0;
    data->allowed.units[Terran_Medic] = 0;
    data->allowed.units[Terran_Vulture] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
      && (!(flags & 0x2)
        && data->rawCountLessThan(Terran_Vulture, 4));
    data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
    data->allowed.units[Terran_Goliath] = 0;
    data->allowed.units[Terran_Wraith] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
      && ((flags & 0x2)
        && data->rawCountLessThan(Terran_Wraith, 12));
    data->allowed.units[Terran_Dropship] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
      && data->rawCountLessThan(Terran_Dropship, 4);
    data->allowed.units[Terran_Science_Vessel] = 0;
    data->allowed.units[Terran_Battlecruiser] = 0;
    data->allowed.units[Terran_Valkyrie] = 0;
    data->allowed.units[Terran_Nuclear_Missile] = 0;
    data->allowed.upgrades[Terran_Infantry_Weapons] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
      && !isGettingOrHasUpgrade(Terran_Infantry_Weapons, 1);
    data->allowed.upgrades[Terran_Infantry_Armor] = data->completeCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
      && isGettingOrHasUpgrade(Terran_Infantry_Weapons, 1)
      && !isGettingOrHasUpgrade(Terran_Infantry_Armor, 1);
    data->allowed.upgrades[U_238_Shells] = 0;
    data->allowed.upgrades[Caduceus_Reactor] = 0;
    data->allowed.upgrades[Titan_Reactor] = 0;
    data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
    data->allowed.upgrades[Terran_Ship_Weapons] = 0;
    data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
    data->allowed.upgrades[Terran_Ship_Plating] = 0;
    data->allowed.upgrades[Ion_Thrusters] = 0;
    data->allowed.upgrades[Charon_Boosters] = 0;
    data->allowed.upgrades[Apollo_Reactor] = 0;
    data->allowed.upgrades[Ocular_Implants] = 0;
    data->allowed.upgrades[Moebius_Reactor] = 0;
    data->allowed.upgrades[Colossus_Reactor] = 0;
    data->allowed.techs[Stim_Packs] = 0;
    data->allowed.techs[Restoration] = 0;
    data->allowed.techs[Optical_Flare] = 0;
    data->allowed.techs[EMP_Shockwave] = 0;
    data->allowed.techs[Irradiate] = 0;
    data->allowed.techs[Spider_Mines] = 0;
    data->allowed.techs[Tank_Siege_Mode] = 0;
    data->allowed.techs[Cloaking_Field] = 0;
    data->allowed.techs[Lockdown] = 0;
    data->allowed.techs[Personnel_Cloaking] = 0;
    data->allowed.techs[Yamato_Gun] = 0;
  }
}

void NoradII(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  if (flags & 0x1) {
    data->allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1)
      || (data->rawCountLessThan(Terran_Command_Center, 2)
        && data->completeCountGreaterThanOrEquals(Terran_Factory, 2));
    data->expand = true;
    data->allowed.units[Terran_Refinery] = data->rawCountLessThan(Terran_Refinery, data->counts.complete[Terran_Command_Center])
      && data->rawCountGreaterThanOrEquals(Terran_SCV, 10);
    data->allowed.units[Terran_Barracks] = data->completeCountGreaterThanOrEquals(Terran_Command_Center, 1)
      && data->rawCountLessThan(Terran_Barracks, 1);
    data->allowed.units[Terran_Engineering_Bay] = 0;
    data->allowed.units[Terran_Missile_Turret] = 0;
    data->allowed.units[Terran_Academy] = 0;
    data->allowed.units[Terran_Bunker] = 0;
    data->allowed.units[Terran_Factory] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
      && (data->rawCountLessThan(Terran_Factory, 2)
        || (data->rawCountGreaterThanOrEquals(Terran_Command_Center, 2)
          && data->rawCountLessThan(Terran_Factory, 3)));
    data->allowed.units[Terran_Starport] = data->completeCountGreaterThanOrEquals(Terran_Factory, 2)
      && data->rawCountLessThan(Terran_Starport, 1);
    data->allowed.units[Terran_Science_Facility] = 0;
    data->allowed.units[Terran_Armory] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
      && data->rawCountLessThan(Terran_Armory, 1);
    data->allowed.units[Terran_Comsat_Station] = 0;
    data->allowed.units[Terran_Nuclear_Silo] = 0;
    data->allowed.units[Terran_Machine_Shop] = 0;
    data->allowed.units[Terran_Control_Tower] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
      && data->rawCountLessThan(Terran_Control_Tower, 1);
    data->allowed.units[Terran_Covert_Ops] = 0;
    data->allowed.units[Terran_Physics_Lab] = 0;
    data->allowed.units[Terran_SCV] = data->rawCountLessThan(Terran_SCV, 50);
    data->allowed.units[Terran_Marine] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
      && data->rawCountLessThan(Terran_Marine, data->counts.raw[Terran_Bunker]);
    data->allowed.units[Terran_Firebat] = 0;
    data->allowed.units[Terran_Ghost] = 0;
    data->allowed.units[Terran_Medic] = 0;
    data->allowed.units[Terran_Vulture] = 0;
    data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
    data->allowed.units[Terran_Goliath] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Armory, 1)
      && ((!(flags & 0x2)
        && data->rawCountLessThan(Terran_Goliath, 24))
        || ((flags & 0x2)
          && data->rawCountLessThan(Terran_Goliath, 36)));
    data->allowed.units[Terran_Wraith] = 0;
    data->allowed.units[Terran_Dropship] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
      && data->rawCountLessThan(Terran_Dropship, 2);
    data->allowed.units[Terran_Science_Vessel] = 0;
    data->allowed.units[Terran_Battlecruiser] = 0;
    data->allowed.units[Terran_Valkyrie] = 0;
    data->allowed.units[Terran_Nuclear_Missile] = 0;
    data->allowed.upgrades[Terran_Infantry_Weapons] = 0;
    data->allowed.upgrades[Terran_Infantry_Armor] = 0;
    data->allowed.upgrades[U_238_Shells] = 0;
    data->allowed.upgrades[Caduceus_Reactor] = 0;
    data->allowed.upgrades[Titan_Reactor] = 0;
    data->allowed.upgrades[Terran_Vehicle_Weapons] = data->completeCountGreaterThanOrEquals(Terran_Armory, 1)
      && !isGettingOrHasUpgrade(Terran_Vehicle_Weapons, 1);
    data->allowed.upgrades[Terran_Ship_Weapons] = 0;
    data->allowed.upgrades[Terran_Vehicle_Plating] = data->completeCountGreaterThanOrEquals(Terran_Armory, 1)
      && isGettingOrHasUpgrade(Terran_Vehicle_Weapons, 1)
      && !isGettingOrHasUpgrade(Terran_Vehicle_Plating, 1);
    data->allowed.upgrades[Terran_Ship_Plating] = 0;
    data->allowed.upgrades[Ion_Thrusters] = 0;
    data->allowed.upgrades[Charon_Boosters] = 0;
    data->allowed.upgrades[Apollo_Reactor] = 0;
    data->allowed.upgrades[Ocular_Implants] = 0;
    data->allowed.upgrades[Moebius_Reactor] = 0;
    data->allowed.upgrades[Colossus_Reactor] = 0;
    data->allowed.techs[Stim_Packs] = 0;
    data->allowed.techs[Restoration] = 0;
    data->allowed.techs[Optical_Flare] = 0;
    data->allowed.techs[EMP_Shockwave] = 0;
    data->allowed.techs[Irradiate] = 0;
    data->allowed.techs[Spider_Mines] = 0;
    data->allowed.techs[Tank_Siege_Mode] = 0;
    data->allowed.techs[Cloaking_Field] = 0;
    data->allowed.techs[Lockdown] = 0;
    data->allowed.techs[Personnel_Cloaking] = 0;
    data->allowed.techs[Yamato_Gun] = 0;
  }
}

void ProtossMeleeExp(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  if (!data->scouted
    && data->supplyUsed >= 24) {
    Job scout;
    scout.type = JobType::Scout;
    data->jobList.push_back(scout);
    data->scouted = true;
  }
  data->allowed.units[Protoss_Nexus] = !isExpanding()
    && (((flags & 0x1)
      && ((data->rawCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1)
        && data->rawCountLessThan(Protoss_Nexus, 2))
        || (data->rawCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1)
          && data->rawCountGreaterThanOrEquals(Protoss_Forge, 1))
        && data->rawCountLessThan(Protoss_Nexus, 3)))
      || (flags & 0x2));
  data->expand = true;
  data->allowed.units[Protoss_Assimilator] = (flags & 0x1)
    && data->rawCountLessThan(Protoss_Assimilator, data->counts.raw[Protoss_Nexus]);
  data->allowed.units[Protoss_Gateway] = data->completeCountGreaterThanOrEquals(Protoss_Pylon, 1)
    && (data->rawCountLessThan(Protoss_Gateway, 2)
      || (data->rawCountLessThan(Protoss_Gateway, 3)
        && data->rawCountGreaterThanOrEquals(Protoss_Shield_Battery, 1)));
  data->allowed.units[Protoss_Forge] = (flags & 0x1)
    && data->rawCountLessThan(Protoss_Forge, 1)
    && data->rawCountGreaterThanOrEquals(Protoss_Nexus, 2);
  data->allowed.units[Protoss_Photon_Cannon] = data->completeCountGreaterThanOrEquals(Protoss_Forge, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Nexus, 2)
    && data->rawCountLessThan(Protoss_Photon_Cannon, data->counts.complete[Protoss_Pylon], 2);
  data->allowed.units[Protoss_Cybernetics_Core] = (flags & 0x1)
    && data->rawCountLessThan(Protoss_Cybernetics_Core, 1);
  data->allowed.units[Protoss_Shield_Battery] = data->rawCountGreaterThanOrEquals(Protoss_Gateway, 2)
    && data->completeCountGreaterThanOrEquals(Protoss_Pylon, 2)
    && data->rawCountLessThan(Protoss_Shield_Battery, data->counts.complete[Protoss_Nexus]);
  data->allowed.units[Protoss_Robotics_Facility] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1)
    && data->rawCountGreaterThanOrEquals(Protoss_Nexus, 2)
    && data->rawCountLessThan(Protoss_Robotics_Facility, 1);
  data->allowed.units[Protoss_Stargate] = (flags & 0x2)
    && data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1)
    && data->rawCountLessThan(Protoss_Stargate, 2);
  data->allowed.units[Protoss_Citadel_of_Adun] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1)
    && data->rawCountLessThan(Protoss_Citadel_of_Adun, 1);
  data->allowed.units[Protoss_Robotics_Support_Bay] = (flags & 0x4)
    && data->completeCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1)
    && data->rawCountLessThan(Protoss_Robotics_Support_Bay, 1);
  data->allowed.units[Protoss_Fleet_Beacon] = (flags & 0x4)
    && data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && data->rawCountLessThan(Protoss_Fleet_Beacon, 1);
  data->allowed.units[Protoss_Templar_Archives] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Protoss_Citadel_of_Adun, 1)
    && data->rawCountLessThan(Protoss_Templar_Archives, 1);
  data->allowed.units[Protoss_Observatory] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1)
    && data->rawCountLessThan(Protoss_Observatory, 1);
  data->allowed.units[Protoss_Arbiter_Tribunal] = (flags & 0x4)
    && data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && data->rawCountLessThan(Protoss_Arbiter_Tribunal, 1);
  data->allowed.units[Protoss_Probe] = data->rawCountLessThan(Protoss_Probe, 50);
  data->allowed.units[Protoss_Zealot] = data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1)
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Zealot, 15))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Zealot, 15))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Zealot, 12))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Zealot, 8)));
  data->allowed.units[Protoss_Dragoon] = (data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Dragoon, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Dragoon, 8))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Dragoon, 6))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Dragoon, 6)));
  data->allowed.units[Protoss_High_Templar] = (flags & 0x1)
    && (flags & 0x2)
    && (data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1)
      && data->completeCountGreaterThanOrEquals(Protoss_Templar_Archives, 1))
    && data->rawCountLessThan(Protoss_High_Templar, data->counts.raw[Protoss_Nexus])
    && data->rawCountLessThan(Protoss_High_Templar, 5);
  data->allowed.units[Protoss_Archon] = (flags & 0x1)
    && (flags & 0x2)
    && data->completeCountGreaterThanOrEquals(Protoss_High_Templar, 4)
    && data->rawCountLessThan(Protoss_Archon, 2);
  data->allowed.units[Protoss_Dark_Templar] = (data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Templar_Archives, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Dark_Templar, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Dark_Templar, 2))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Dark_Templar, 2))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Dark_Templar, 2)));
  data->allowed.units[Protoss_Dark_Archon] = data->completeCountGreaterThanOrEquals(Protoss_Dark_Templar, 2)
    && data->rawCountLessThan(Protoss_Dark_Archon, 1);
  data->allowed.units[Protoss_Shuttle] = data->completeCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1)
    && data->rawCountLessThan(Protoss_Shuttle, 2);
  data->allowed.units[Protoss_Reaver] = 0;
  data->allowed.units[Protoss_Observer] = data->completeCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Observatory, 1)
    && data->rawCountLessThan(Protoss_Observer, data->counts.raw[Protoss_Nexus] + 1);
  data->allowed.units[Protoss_Scout] = (data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Scout, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Scout, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Scout, 8))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Scout, 10)));
  data->allowed.units[Protoss_Carrier] = (data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Fleet_Beacon, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Carrier, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Carrier, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Carrier, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Carrier, 5)));
  data->allowed.units[Protoss_Arbiter] = (data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Arbiter_Tribunal, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Arbiter, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Arbiter, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Arbiter, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Arbiter, 1)));
  data->allowed.units[Protoss_Corsair] = (data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Protoss_Corsair, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Corsair, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Protoss_Corsair, 4))
      || ((flags & 0x1)
        && (flags & 0x2)
        && (flags & 0x4)
        && data->rawCountLessThan(Protoss_Corsair, 8)));
  data->allowed.upgrades[Protoss_Ground_Weapons] = data->completeCountGreaterThanOrEquals(Protoss_Forge, 1)
    && isGettingOrHasUpgrade(Leg_Enhancements, 1)
    && data->rawCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && !isGettingOrHasUpgrade(Protoss_Ground_Weapons, 1);
  data->allowed.upgrades[Protoss_Ground_Armor] = 0;
  data->allowed.upgrades[Protoss_Plasma_Shields] = data->completeCountGreaterThanOrEquals(Protoss_Forge, 1)
    && isGettingOrHasUpgrade(Gravitic_Boosters, 1)
    && !isGettingOrHasUpgrade(Protoss_Plasma_Shields, 1);
  data->allowed.upgrades[Protoss_Air_Weapons] = 0;
  data->allowed.upgrades[Protoss_Air_Armor] = 0;
  data->allowed.upgrades[Singularity_Charge] = data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1)
    && !isGettingOrHasUpgrade(Singularity_Charge, 1)
    && data->rawCountGreaterThanOrEquals(Protoss_Nexus, 2);
  data->allowed.upgrades[Leg_Enhancements] = data->completeCountGreaterThanOrEquals(Protoss_Citadel_of_Adun, 1)
    && isGettingOrHasUpgrade(Singularity_Charge, 1)
    && !isGettingOrHasUpgrade(Leg_Enhancements, 1);
  data->allowed.upgrades[Scarab_Damage] = 0;
  data->allowed.upgrades[Reaver_Capacity] = 0;
  data->allowed.upgrades[Gravitic_Drive] = 0;
  data->allowed.upgrades[Apial_Sensors] = 0;
  data->allowed.upgrades[Gravitic_Thrusters] = 0;
  data->allowed.upgrades[Carrier_Capacity] = (flags & 0x4)
    && data->completeCountGreaterThanOrEquals(Protoss_Fleet_Beacon, 1)
    && isGettingOrHasTech(Disruption_Web)
    && !isGettingOrHasUpgrade(Carrier_Capacity, 1);
  data->allowed.upgrades[Argus_Jewel] = 0;
  data->allowed.upgrades[Khaydarin_Amulet] = 0;
  data->allowed.upgrades[Argus_Talisman] = 0;
  data->allowed.upgrades[Gravitic_Boosters] = data->completeCountGreaterThanOrEquals(Protoss_Observatory, 1)
    && isGettingOrHasTech(Psionic_Storm)
    && !isGettingOrHasUpgrade(Gravitic_Boosters, 1);
  data->allowed.upgrades[Sensor_Array] = 0;
  data->allowed.upgrades[Khaydarin_Core] = 0;
  data->allowed.techs[Disruption_Web] = data->completeCountGreaterThanOrEquals(Protoss_Fleet_Beacon, 1)
    && isGettingOrHasTech(Maelstrom)
    && !isGettingOrHasTech(Disruption_Web);
  data->allowed.techs[Psionic_Storm] = data->completeCountGreaterThanOrEquals(Protoss_Templar_Archives, 1)
    && isGettingOrHasUpgrade(Protoss_Ground_Weapons, 1)
    && !isGettingOrHasTech(Psionic_Storm);
  data->allowed.techs[Hallucination] = 0;
  data->allowed.techs[Mind_Control] = 0;
  data->allowed.techs[Maelstrom] = data->completeCountGreaterThanOrEquals(Protoss_Templar_Archives, 1)
    && isGettingOrHasUpgrade(Protoss_Plasma_Shields, 1)
    && !isGettingOrHasTech(Maelstrom);
  data->allowed.techs[Recall] = 0;
  data->allowed.techs[Stasis_Field] = 0; // isGettingOrHasTech(Disruption_Web); LAST
}

void ProtossMeleeIslandExp(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  data->allowed.units[Protoss_Nexus] = (data->rawCountLessThan(Protoss_Nexus, 1)
    || (data->rawCountLessThan(Protoss_Nexus, 2)
      && data->completeCountGreaterThanOrEquals(Protoss_Shuttle, 1))
    || (data->rawCountGreaterThanOrEquals(Protoss_Nexus, 2)
      && data->completeCountGreaterThanOrEquals(Protoss_Fleet_Beacon, 1)))
    && !isExpanding();
  data->expand = true;
  data->allowed.units[Protoss_Assimilator] = data->rawCountLessThan(Protoss_Assimilator, data->counts.complete[Protoss_Nexus])
    && data->rawCountGreaterThanOrEquals(Protoss_Pylon, 1);
  data->allowed.units[Protoss_Gateway] = (data->rawCountLessThan(Protoss_Gateway, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Pylon, 1)
    && data->rawCountGreaterThanOrEquals(Protoss_Assimilator, 1))
    || (data->rawCountLessThan(Protoss_Gateway, 2)
      && data->rawCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1));
  data->allowed.units[Protoss_Forge] = 0;
  data->allowed.units[Protoss_Photon_Cannon] = 0;
  data->allowed.units[Protoss_Cybernetics_Core] = data->rawCountLessThan(Protoss_Cybernetics_Core, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1);
  data->allowed.units[Protoss_Shield_Battery] = data->rawCountLessThan(Protoss_Shield_Battery, 1)
    && data->rawCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1);
  data->allowed.units[Protoss_Robotics_Facility] = data->rawCountLessThan(Protoss_Robotics_Facility, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1);
  data->allowed.units[Protoss_Stargate] = ((flags & 0x1)
    && data->rawCountLessThan(Protoss_Stargate, 1))
    || ((flags & 0x2)
      && data->rawCountLessThan(Protoss_Stargate, 3)
      && data->rawCountGreaterThanOrEquals(Protoss_Fleet_Beacon, 1));
  data->allowed.units[Protoss_Citadel_of_Adun] = 0;
  data->allowed.units[Protoss_Robotics_Support_Bay] = 0;
  data->allowed.units[Protoss_Fleet_Beacon] = (flags & 0x2)
    && data->rawCountLessThan(Protoss_Fleet_Beacon, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1);
  data->allowed.units[Protoss_Templar_Archives] = 0;
  data->allowed.units[Protoss_Observatory] = 0;
  data->allowed.units[Protoss_Arbiter_Tribunal] = 0;
  data->allowed.units[Protoss_Zealot] = data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1)
    && ((!(flags & 0x1)
      && !(flags & 0x2)
      && data->rawCountLessThan(Protoss_Zealot, 6))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Zealot, 12))
      || ((flags & 0x1)
        && (flags & 0x2)
        && data->rawCountLessThan(Protoss_Zealot, 8)));
  data->allowed.units[Protoss_Dragoon] = (data->completeCountGreaterThanOrEquals(Protoss_Gateway, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Cybernetics_Core, 1))
    && (((flags & 0x1)
      && !(flags & 0x2)
      && data->rawCountLessThan(Protoss_Dragoon, 6))
      || ((flags & 0x1)
        && (flags & 0x2)
        && data->rawCountLessThan(Protoss_Dragoon, 12)));
  data->allowed.units[Protoss_High_Templar] = 0;
  data->allowed.units[Protoss_Dark_Templar] = 0;
  data->allowed.units[Protoss_Shuttle] = data->completeCountGreaterThanOrEquals(Protoss_Robotics_Facility, 1)
    && ((!(flags & 0x1)
      && !(flags & 0x2)
      && data->rawCountLessThan(Protoss_Shuttle, 1))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Protoss_Shuttle, 4))
      || ((flags & 0x1)
        && (flags & 0x2)
        && data->rawCountLessThan(Protoss_Shuttle, 5)));
  data->allowed.units[Protoss_Reaver] = 0;
  data->allowed.units[Protoss_Observer] = 0;
  data->allowed.units[Protoss_Scout] = data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && (((flags & 0x1)
      && !(flags & 0x2)
      && data->rawCountLessThan(Protoss_Scout, 5))
      || ((flags & 0x1)
        && (flags & 0x2)
        && data->rawCountLessThan(Protoss_Scout, 11)));
  data->allowed.units[Protoss_Carrier] = (data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && data->completeCountGreaterThanOrEquals(Protoss_Fleet_Beacon, 1))
    && (((flags & 0x1)
      && !(flags & 0x2)
      && data->rawCountLessThan(Protoss_Carrier, 2))
      || ((flags & 0x1)
        && (flags & 0x2)
        && data->rawCountLessThan(Protoss_Carrier, 6)));
  data->allowed.units[Protoss_Arbiter] = 0;
  data->allowed.units[Protoss_Corsair] = data->completeCountGreaterThanOrEquals(Protoss_Stargate, 1)
    && (((flags & 0x1)
      && !(flags & 0x2)
      && data->rawCountLessThan(Protoss_Corsair, 2))
      || ((flags & 0x1)
        && (flags & 0x2)
        && data->rawCountLessThan(Protoss_Corsair, 5)));
  data->allowed.upgrades[Protoss_Ground_Weapons] = 0;
  data->allowed.upgrades[Protoss_Ground_Armor] = 0;
  data->allowed.upgrades[Protoss_Plasma_Shields] = 0;
  data->allowed.upgrades[Protoss_Air_Weapons] = 0;
  data->allowed.upgrades[Protoss_Air_Armor] = 0;
  data->allowed.upgrades[Singularity_Charge] = 0;
  data->allowed.upgrades[Leg_Enhancements] = 0;
  data->allowed.upgrades[Scarab_Damage] = 0;
  data->allowed.upgrades[Reaver_Capacity] = 0;
  data->allowed.upgrades[Gravitic_Drive] = 0;
  data->allowed.upgrades[Apial_Sensors] = 0;
  data->allowed.upgrades[Gravitic_Thrusters] = 0;
  data->allowed.upgrades[Carrier_Capacity] = 0;
  data->allowed.upgrades[Argus_Jewel] = 0;
  data->allowed.upgrades[Khaydarin_Amulet] = 0;
  data->allowed.upgrades[Argus_Talisman] = 0;
  data->allowed.upgrades[Gravitic_Boosters] = 0;
  data->allowed.upgrades[Sensor_Array] = 0;
  data->allowed.upgrades[Khaydarin_Core] = 0;
  data->allowed.techs[Disruption_Web] = 0;
  data->allowed.techs[Psionic_Storm] = 0;
  data->allowed.techs[Hallucination] = 0;
  data->allowed.techs[Mind_Control] = 0;
  data->allowed.techs[Maelstrom] = 0;
  data->allowed.techs[Recall] = 0;
  data->allowed.techs[Stasis_Field] = 0;
}

void TerranMeleeExp(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  if (!data->scouted
    && data->supplyUsed >= 24) {
    Job scout;
    scout.type = JobType::Scout;
    data->jobList.push_back(scout);
    data->scouted = true;
  }
  data->allowed.units[Terran_Command_Center] = data->rawCountLessThan(Terran_Command_Center, 1)
    || ((flags & 0x2)
      && data->rawCountLessThan(Terran_Command_Center, 3))
    || (data->rawCountGreaterThanOrEquals(Terran_Science_Facility, 1)
    && data->rawCountGreaterThanOrEquals(Terran_SCV, 20));
  data->expand = true;
  data->allowed.units[Terran_Refinery] = data->rawCountLessThan(Terran_Refinery, data->counts.complete[Terran_Command_Center])
    && data->rawCountGreaterThanOrEquals(Terran_Barracks, 1);
  data->allowed.units[Terran_Barracks] = data->rawCountLessThan(Terran_Barracks, 1)
    || (data->rawCountGreaterThanOrEquals(Terran_Academy, 1)
      && data->rawCountLessThan(Terran_Barracks, 2));
  data->allowed.units[Terran_Engineering_Bay] = (flags & 0x1)
    && data->rawCountLessThan(Terran_Engineering_Bay, 1);
  data->allowed.units[Terran_Missile_Turret] = data->rawCountGreaterThanOrEquals(Terran_Engineering_Bay, 1)
    && data->rawCountGreaterThanOrEquals(Terran_Command_Center, 2)
    && data->rawCountLessThan(Terran_Missile_Turret, data->counts.complete[Terran_Command_Center] * 4);
  data->allowed.units[Terran_Academy] = data->rawCountLessThan(Terran_Academy, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Refinery, 1);
  data->allowed.units[Terran_Bunker] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 2)
    && (data->rawCountLessThan(Terran_Bunker, 1)
      || (data->completeCountGreaterThanOrEquals(Terran_Bunker, 1)
        && data->rawCountLessThan(Terran_Bunker, 2)));
  data->allowed.units[Terran_Factory] = (flags & 0x1)
    && ((data->completeCountGreaterThanOrEquals(Terran_Barracks, 2)
      && data->rawCountLessThan(Terran_Factory, 1))
    || (data->completeCountGreaterThanOrEquals(Terran_Science_Facility, 2)
      && data->rawCountLessThan(Terran_Factory, 2)));
  data->allowed.units[Terran_Starport] = (flags & 0x2)
    && (data->rawCountLessThan(Terran_Starport, 1)
      || (data->completeCountGreaterThanOrEquals(Terran_Factory, 2)
        && data->rawCountLessThan(Terran_Starport, 2)));
  data->allowed.units[Terran_Science_Facility] = (flags & 0x2)
    && ((data->rawCountLessThan(Terran_Science_Facility, 1)
      && data->completeCountGreaterThanOrEquals(Terran_Armory, 1))
    || (data->rawCountLessThan(Terran_Science_Facility, 2)
      && data->completeCountGreaterThanOrEquals(Terran_Science_Facility, 1)));
  data->allowed.units[Terran_Armory] = (flags & 0x2)
    && data->rawCountLessThan(Terran_Armory, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Starport, 1);
  data->allowed.units[Terran_Comsat_Station] = ((flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && data->rawCountLessThan(Terran_Comsat_Station, data->counts.complete[Terran_Command_Center]));
  data->allowed.units[Terran_Nuclear_Silo] = data->completeCountGreaterThanOrEquals(Terran_Covert_Ops, 1)
    && data->rawCountGreaterThanOrEquals(Terran_Comsat_Station, 1);
  data->allowed.units[Terran_Machine_Shop] = ((flags & 0x1)
    && data->rawCountLessThan(Terran_Machine_Shop, data->counts.complete[Terran_Factory]));
  data->allowed.units[Terran_Control_Tower] = data->rawCountLessThan(Terran_Control_Tower, data->counts.complete[Terran_Starport]);
  data->allowed.units[Terran_Covert_Ops] = data->rawCountLessThan(Terran_Covert_Ops, 1);
  data->allowed.units[Terran_Physics_Lab] = data->rawCountLessThan(Terran_Physics_Lab, 1);
  data->allowed.units[Terran_SCV] = data->rawCountLessThan(Terran_SCV, 50);
  data->allowed.units[Terran_Marine] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->rawCountLessThan(Terran_Marine, 12 + 4 * data->counts.complete[Terran_Bunker]);
  data->allowed.units[Terran_Firebat] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && zergOrProtossEnemy() ? data->rawCountLessThan(Terran_Firebat, 8 + data->counts.complete[Terran_Bunker]) : data->rawCountLessThan(Terran_Firebat, data->counts.complete[Terran_Bunker]);
  data->allowed.units[Terran_Ghost] = (flags & 0x2)
    && data->completeCountGreaterThanOrEquals(Terran_Science_Facility, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Covert_Ops, 1)
    && data->rawCountLessThan(Terran_Ghost, 3);
  data->allowed.units[Terran_Medic] = data->completeCountGreaterThanOrEquals(Terran_Barracks, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && data->rawCountLessThan(Terran_Medic, 4);
  data->allowed.units[Terran_Vulture] = (flags & 0x2)
    && data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
    && isGettingOrHasTech(Spider_Mines)
    && data->rawCountLessThan(Terran_Vulture, 6);
  data->allowed.units[Terran_Siege_Tank_Tank_Mode] = ((flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && data->counts.raw[Terran_Siege_Tank_Tank_Mode] + data->counts.raw[Terran_Siege_Tank_Siege_Mode] < 5);
  data->allowed.units[Terran_Goliath] = data->completeCountGreaterThanOrEquals(Terran_Factory, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Armory, 1)
    && data->rawCountLessThan(Terran_Goliath, 4);
  data->allowed.units[Terran_Wraith] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Dropship, 1)
    && data->rawCountLessThan(Terran_Wraith, 6);
  data->allowed.units[Terran_Dropship] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
    && data->rawCountLessThan(Terran_Dropship, 3);
  data->allowed.units[Terran_Science_Vessel] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
    && data->rawCountLessThan(Terran_Science_Vessel, data->counts.complete[Terran_Command_Center]);
  data->allowed.units[Terran_Battlecruiser] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Physics_Lab, 1)
    && data->rawCountLessThanOrEquals(Terran_Battlecruiser, 4);
  data->allowed.units[Terran_Valkyrie] = data->completeCountGreaterThanOrEquals(Terran_Starport, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Armory, 1)
    && data->completeCountGreaterThanOrEquals(Terran_Dropship, 1)
    && data->rawCountLessThan(Terran_Valkyrie, 2);
  data->allowed.units[Terran_Nuclear_Missile] = data->rawCountLessThanOrEquals(Terran_Nuclear_Missile, data->counts.complete[Terran_Nuclear_Silo]);
  data->allowed.upgrades[Terran_Infantry_Weapons] = 0;
  data->allowed.upgrades[Terran_Infantry_Armor] = 0;
  data->allowed.upgrades[U_238_Shells] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && !isGettingOrHasUpgrade(U_238_Shells, 1);
  data->allowed.upgrades[Caduceus_Reactor] = 0;
  data->allowed.upgrades[Titan_Reactor] = data->completeCountGreaterThanOrEquals(Terran_Science_Facility, 1)
    && isGettingOrHasTech(EMP_Shockwave)
    && !isGettingOrHasUpgrade(Titan_Reactor, 1);
  data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
  data->allowed.upgrades[Terran_Ship_Weapons] = 0;
  data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
  data->allowed.upgrades[Terran_Ship_Plating] = 0;
  data->allowed.upgrades[Ion_Thrusters] = data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && isGettingOrHasUpgrade(Charon_Boosters, 1)
    && !isGettingOrHasUpgrade(Ion_Thrusters, 1);
  data->allowed.upgrades[Charon_Boosters] = data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && isGettingOrHasTech(Spider_Mines)
    && !isGettingOrHasUpgrade(Charon_Boosters, 1);
  data->allowed.upgrades[Apollo_Reactor] = data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
    && isGettingOrHasTech(Cloaking_Field)
    && !isGettingOrHasUpgrade(Apollo_Reactor, 1);
  data->allowed.upgrades[Ocular_Implants] = data->completeCountGreaterThanOrEquals(Terran_Covert_Ops, 1)
    && isGettingOrHasUpgrade(Moebius_Reactor, 1)
    && !isGettingOrHasUpgrade(Ocular_Implants, 1);
  data->allowed.upgrades[Moebius_Reactor] = data->completeCountGreaterThanOrEquals(Terran_Covert_Ops, 1)
    && isGettingOrHasTech(Personnel_Cloaking)
    && !isGettingOrHasUpgrade(Moebius_Reactor, 1);    
  data->allowed.upgrades[Colossus_Reactor] = data->completeCountGreaterThanOrEquals(Terran_Physics_Lab, 1)
    && isGettingOrHasTech(Yamato_Gun)
    && !isGettingOrHasUpgrade(Colossus_Reactor, 1);
  data->allowed.techs[Stim_Packs] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && isGettingOrHasTech(Optical_Flare)
    && !isGettingOrHasTech(Stim_Packs);
  data->allowed.techs[Restoration] = data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && isGettingOrHasUpgrade(Charon_Boosters, 1)
    && !isGettingOrHasTech(Restoration);
  data->allowed.techs[Optical_Flare] = (flags & 0x1)
    && data->completeCountGreaterThanOrEquals(Terran_Academy, 1)
    && isGettingOrHasUpgrade(U_238_Shells, 1)
    && !isGettingOrHasTech(Optical_Flare);
  data->allowed.techs[EMP_Shockwave] = data->completeCountGreaterThanOrEquals(Terran_Science_Facility, 1)
    && isGettingOrHasTech(Irradiate)
    && !isGettingOrHasTech(EMP_Shockwave);
  data->allowed.techs[Irradiate] = data->completeCountGreaterThanOrEquals(Terran_Science_Facility, 1)
    && !isGettingOrHasTech(Irradiate);
  data->allowed.techs[Spider_Mines] = data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && isGettingOrHasTech(Tank_Siege_Mode)
    && !isGettingOrHasTech(Spider_Mines);
  data->allowed.techs[Tank_Siege_Mode] = (flags & 0x2)
    && data->completeCountGreaterThanOrEquals(Terran_Machine_Shop, 1)
    && !isGettingOrHasTech(Tank_Siege_Mode);
  data->allowed.techs[Cloaking_Field] = data->completeCountGreaterThanOrEquals(Terran_Control_Tower, 1)
    && !isGettingOrHasTech(Cloaking_Field);
  data->allowed.techs[Lockdown] = data->completeCountGreaterThanOrEquals(Terran_Covert_Ops, 1)
    && !isGettingOrHasTech(Lockdown);
  data->allowed.techs[Personnel_Cloaking] = data->completeCountGreaterThanOrEquals(Terran_Covert_Ops, 1)
    && isGettingOrHasTech(Lockdown)
    && !isGettingOrHasTech(Personnel_Cloaking);
  data->allowed.techs[Yamato_Gun] = data->completeCountGreaterThanOrEquals(Terran_Physics_Lab, 1)
    && !isGettingOrHasTech(Yamato_Gun);
}

void TerranMeleeIslandExp(std::shared_ptr<Data> data) {
  data->allowed.units[Terran_Command_Center] = 0;
  data->expand = true;
  data->allowed.units[Terran_Supply_Depot] = 0;
  data->allowed.units[Terran_Refinery] = 0;
  data->allowed.units[Terran_Barracks] = 0;
  data->allowed.units[Terran_Engineering_Bay] = 0;
  data->allowed.units[Terran_Missile_Turret] = 0;
  data->allowed.units[Terran_Academy] = 0;
  data->allowed.units[Terran_Bunker] = 0;
  data->allowed.units[Terran_Factory] = 0;
  data->allowed.units[Terran_Starport] = 0;
  data->allowed.units[Terran_Science_Facility] = 0;
  data->allowed.units[Terran_Armory] = 0;
  data->allowed.units[Terran_Comsat_Station] = 0;
  data->allowed.units[Terran_Nuclear_Silo] = 0;
  data->allowed.units[Terran_Machine_Shop] = 0;
  data->allowed.units[Terran_Control_Tower] = 0;
  data->allowed.units[Terran_Covert_Ops] = 0;
  data->allowed.units[Terran_Physics_Lab] = 0;
  data->allowed.units[Terran_SCV] = 0;
  data->allowed.units[Terran_Marine] = 0;
  data->allowed.units[Terran_Firebat] = 0;
  data->allowed.units[Terran_Ghost] = 0;
  data->allowed.units[Terran_Medic] = 0;
  data->allowed.units[Terran_Vulture] = 0;
  data->allowed.units[Terran_Siege_Tank_Tank_Mode] = 0;
  data->allowed.units[Terran_Goliath] = 0;
  data->allowed.units[Terran_Wraith] = 0;
  data->allowed.units[Terran_Dropship] = 0;
  data->allowed.units[Terran_Science_Vessel] = 0;
  data->allowed.units[Terran_Battlecruiser] = 0;
  data->allowed.units[Terran_Valkyrie] = 0;
  data->allowed.units[Terran_Nuclear_Missile] = 0;
  data->allowed.upgrades[Terran_Infantry_Weapons] = 0;
  data->allowed.upgrades[Terran_Infantry_Armor] = 0;
  data->allowed.upgrades[U_238_Shells] = 0;
  data->allowed.upgrades[Caduceus_Reactor] = 0;
  data->allowed.upgrades[Titan_Reactor] = 0;
  data->allowed.upgrades[Terran_Vehicle_Weapons] = 0;
  data->allowed.upgrades[Terran_Ship_Weapons] = 0;
  data->allowed.upgrades[Terran_Vehicle_Plating] = 0;
  data->allowed.upgrades[Terran_Ship_Plating] = 0;
  data->allowed.upgrades[Ion_Thrusters] = 0;
  data->allowed.upgrades[Charon_Boosters] = 0;
  data->allowed.upgrades[Apollo_Reactor] = 0;
  data->allowed.upgrades[Ocular_Implants] = 0;
  data->allowed.upgrades[Moebius_Reactor] = 0;
  data->allowed.upgrades[Colossus_Reactor] = 0;
  data->allowed.techs[Stim_Packs] = 0;
  data->allowed.techs[Restoration] = 0;
  data->allowed.techs[Optical_Flare] = 0;
  data->allowed.techs[EMP_Shockwave] = 0;
  data->allowed.techs[Irradiate] = 0;
  data->allowed.techs[Spider_Mines] = 0;
  data->allowed.techs[Tank_Siege_Mode] = 0;
  data->allowed.techs[Cloaking_Field] = 0;
  data->allowed.techs[Lockdown] = 0;
  data->allowed.techs[Personnel_Cloaking] = 0;
  data->allowed.techs[Yamato_Gun] = 0;
}

void ZergMeleeExp(std::shared_ptr<Data> data) {
  auto flags = BWAPI::Broodwar->self()->getClientInfo<int>(static_cast<int>(ClientInfo::Flags));
  if (!data->scouted
    && data->supplyUsed >= 24) {
    Job scout;
    scout.type = JobType::Scout;
    data->jobList.push_back(scout);
    data->scouted = true;
  }
  data->allowed.units[Zerg_Hatchery] = data->rawHatcheryCount() < 2
    || (data->rawCountGreaterThanOrEquals(Zerg_Hydralisk_Den, 1)
      && data->rawHatcheryCount() < 3)
    || (data->rawHatcheryCount() < 5 && (flags & 0x1))
    || data->rawCountGreaterThanOrEquals(Zerg_Hive, 1);
  data->expand = 2 <= data->rawHatcheryCount() && !isExpanding();
  data->allowed.units[Zerg_Creep_Colony] = (data->rawGroundColonyCount() < 2
    && data->rawCountGreaterThanOrEquals(Zerg_Spawning_Pool, 1))
    || (data->rawGroundColonyCount() < 4
      && data->rawCountGreaterThanOrEquals(Zerg_Hydralisk_Den, 1))
    || (2 < data->rawHatcheryCount()
      && data->rawGroundColonyCount() < 2 * data->rawHatcheryCount() - 4);
  data->allowed.units[Zerg_Extractor] = (data->rawCountEquals(Zerg_Extractor, 0)
    && data->rawCountGreaterThanOrEquals(Zerg_Spawning_Pool, 1))
    || (2 < data->rawHatcheryCount()
      && data->rawCountLessThan(Zerg_Extractor, data->rawHatcheryCount() - 1));
  data->allowed.units[Zerg_Spawning_Pool] = data->rawCountEquals(Zerg_Spawning_Pool, 0)
    && 2 <= data->rawHatcheryCount();
  data->allowed.units[Zerg_Evolution_Chamber] = data->rawCountEquals(Zerg_Evolution_Chamber, 0)
    && data->rawCountGreaterThanOrEquals(Zerg_Lair, 1)
    && data->rawCountGreaterThanOrEquals(Zerg_Queens_Nest, 1);
  data->allowed.units[Zerg_Hydralisk_Den] = data->rawCountEquals(Zerg_Hydralisk_Den, 0)
    && 0 < data->rawLairCount();
  data->allowed.units[Zerg_Spire] = data->rawCountEquals(Zerg_Spire, 0)
    && data->rawCountGreaterThanOrEquals(Zerg_Lair, 1)
    && data->rawCountGreaterThanOrEquals(Zerg_Evolution_Chamber, 1);
  data->allowed.units[Zerg_Queens_Nest] = data->rawCountEquals(Zerg_Queens_Nest, 0)
    && 3 < data->rawHatcheryCount()
    && data->completeCountGreaterThanOrEquals(Zerg_Lair, 1);
  data->allowed.units[Zerg_Nydus_Canal] = false;
  data->allowed.units[Zerg_Ultralisk_Cavern] = data->rawCountEquals(Zerg_Ultralisk_Cavern, 0)
    && data->rawCountGreaterThanOrEquals(Zerg_Hive, 1);
  data->allowed.units[Zerg_Defiler_Mound] = data->rawCountEquals(Zerg_Defiler_Mound, 0)
    && data->rawCountGreaterThanOrEquals(Zerg_Hive, 1);
  data->allowed.units[Zerg_Lair] = data->rawLairCount() == 0
    && 1 < data->rawHatcheryCount()
    && data->completeCountGreaterThanOrEquals(Zerg_Spawning_Pool, 1);
  data->allowed.units[Zerg_Spore_Colony] = data->completeCountGreaterThanOrEquals(Zerg_Evolution_Chamber, 1)
    && data->rawCountEquals(Zerg_Sunken_Colony, 4 + 2 * data->rawHatcheryCount() - 2);
  data->allowed.units[Zerg_Sunken_Colony] = data->rawCountGreaterThanOrEquals(Zerg_Spawning_Pool, 1)
    && (data->rawCountLessThanOrEquals(Zerg_Sunken_Colony, 4)
      && data->rawCountGreaterThanOrEquals(Zerg_Creep_Colony, 1))
    || (data->rawCountLessThanOrEquals(Zerg_Sunken_Colony, 2 * data->rawHatcheryCount() - 2)
      && data->rawCountGreaterThanOrEquals(Zerg_Creep_Colony, 1));
  data->allowed.units[Zerg_Greater_Spire] = data->completeCountGreaterThanOrEquals(Zerg_Hive, 1)
    && data->completeCountGreaterThanOrEquals(Zerg_Spire, 1)
    && data->rawCountEquals(Zerg_Greater_Spire, 0);
  data->allowed.units[Zerg_Hive] = data->rawCountEquals(Zerg_Hive, 0)
    && data->completeCountGreaterThanOrEquals(Zerg_Queens_Nest, 1)
    && (data->completeCountGreaterThanOrEquals(Zerg_Spire, 1)
      || data->completeCountGreaterThanOrEquals(Zerg_Greater_Spire, 1))
    && 4 < data->rawHatcheryCount();
  data->allowed.units[Zerg_Drone] = data->rawCountLessThan(Zerg_Drone, 50);
  data->allowed.units[Zerg_Zergling] = data->completeCountGreaterThanOrEquals(Zerg_Spawning_Pool, 1)
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Zergling, 10))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Zergling, 26))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Zergling, 60)));
  data->allowed.units[Zerg_Hydralisk] = data->completeCountGreaterThanOrEquals(Zerg_Hydralisk_Den, 1)
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Hydralisk, 20))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Hydralisk, 10))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Hydralisk, 14)));
  data->allowed.units[Zerg_Mutalisk] = (data->completeCountGreaterThanOrEquals(Zerg_Spire, 1)
    || data->rawCountGreaterThanOrEquals(Zerg_Greater_Spire, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Mutalisk, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Mutalisk, 9))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Mutalisk, 4)));
  data->allowed.units[Zerg_Scourge] = (data->completeCountGreaterThanOrEquals(Zerg_Spire, 1)
    || data->rawCountGreaterThanOrEquals(Zerg_Greater_Spire, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Scourge, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Scourge, 8))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Scourge, 4)));
  data->allowed.units[Zerg_Queen] = data->completeCountGreaterThanOrEquals(Zerg_Queens_Nest, 1)
    && data->rawCountLessThan(Zerg_Queen, 3);
  data->allowed.units[Zerg_Ultralisk] = data->completeCountGreaterThanOrEquals(Zerg_Ultralisk_Cavern, 1)
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Ultralisk, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Ultralisk, 0))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Ultralisk, 0)));
  data->allowed.units[Zerg_Defiler] = data->completeCountGreaterThanOrEquals(Zerg_Defiler_Mound, 1)
    && data->rawCountLessThan(Zerg_Defiler, 3);
  data->allowed.units[Zerg_Lurker] = (BWAPI::Broodwar->self()->hasResearched(Lurker_Aspect)
    && data->completeCountGreaterThanOrEquals(Zerg_Hydralisk, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Lurker, 2))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Lurker, 3))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Lurker, 4)));
  data->allowed.units[Zerg_Guardian] = (data->completeCountGreaterThanOrEquals(Zerg_Greater_Spire, 1)
    && data->completeCountGreaterThanOrEquals(Zerg_Mutalisk, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Guardian, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Guardian, 4))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Guardian, 4)));
  data->allowed.units[Zerg_Devourer] = (data->completeCountGreaterThanOrEquals(Zerg_Greater_Spire, 1)
    && data->completeCountGreaterThanOrEquals(Zerg_Mutalisk, 1))
    && ((!(flags & 0x1)
      && data->rawCountLessThan(Zerg_Devourer, 0))
      || ((flags & 0x1)
        && !(flags & 0x2)
        && data->rawCountLessThan(Zerg_Devourer, 4))
      || ((flags & 0x1)
        && (flags & 0x2)
        && !(flags & 0x4)
        && data->rawCountLessThan(Zerg_Devourer, 4)));
  data->allowed.upgrades[Metabolic_Boost] = !isGettingOrHasUpgrade(Metabolic_Boost, 1)
    && isGettingOrHasUpgrade(Zerg_Flyer_Attacks, 1);
  data->allowed.upgrades[Adrenal_Glands] = !isGettingOrHasUpgrade(Adrenal_Glands, 1)
    && isGettingOrHasTech(Plague);
  data->allowed.upgrades[Zerg_Melee_Attacks] = !isGettingOrHasUpgrade(Zerg_Melee_Attacks, 1)
    && isGettingOrHasUpgrade(Adrenal_Glands, 1);
  data->allowed.upgrades[Zerg_Missile_Attacks] = !isGettingOrHasUpgrade(Zerg_Missile_Attacks, 1)
    && isGettingOrHasUpgrade(Grooved_Spines, 1);
  data->allowed.upgrades[Zerg_Carapace] = !isGettingOrHasUpgrade(Zerg_Carapace, 1)
    && isGettingOrHasUpgrade(Metabolic_Boost, 1);
  data->allowed.upgrades[Muscular_Augments] = !isGettingOrHasUpgrade(Muscular_Augments, 1)
    && isGettingOrHasTech(Burrowing);
  data->allowed.upgrades[Grooved_Spines] = !isGettingOrHasUpgrade(Grooved_Spines, 1)
    && isGettingOrHasUpgrade(Muscular_Augments, 1);
  data->allowed.upgrades[Zerg_Flyer_Attacks] = (!isGettingOrHasUpgrade(Zerg_Flyer_Attacks, 1)
    && isGettingOrHasUpgrade(Zerg_Missile_Attacks, 1))
    || (!isGettingOrHasUpgrade(Zerg_Flyer_Attacks, 2)
      && isGettingOrHasUpgrade(Zerg_Melee_Attacks, 1));
  data->allowed.upgrades[Zerg_Flyer_Carapace] = !isGettingOrHasUpgrade(Zerg_Flyer_Carapace, 1)
    && isGettingOrHasUpgrade(Zerg_Carapace, 1);
  data->allowed.upgrades[Gamete_Meiosis] = !isGettingOrHasUpgrade(Gamete_Meiosis, 1)
    && isGettingOrHasUpgrade(Zerg_Flyer_Attacks, 2);
  data->allowed.upgrades[Anabolic_Synthesis] = !isGettingOrHasUpgrade(Anabolic_Synthesis, 1)
    && isGettingOrHasUpgrade(Gamete_Meiosis, 1);
  data->allowed.upgrades[Chitinous_Plating] = !isGettingOrHasUpgrade(Chitinous_Plating, 1)
    && isGettingOrHasTech(Spawn_Broodlings);
  data->allowed.upgrades[Metasynaptic_Node] = !isGettingOrHasUpgrade(Metasynaptic_Node, 1)
    && isGettingOrHasTech(Consume);
  data->allowed.upgrades[Ventral_Sacs] = 1 <= data->completeLairCount()
    && !isGettingOrHasUpgrade(Ventral_Sacs, 1)
    && isGettingOrHasUpgrade(Pneumatized_Carapace, 1);
  data->allowed.upgrades[Antennae] = !isGettingOrHasUpgrade(Antennae, 1)
    && isGettingOrHasUpgrade(Anabolic_Synthesis, 1);
  data->allowed.upgrades[Pneumatized_Carapace] = 1 <= data->completeLairCount()
    && !isGettingOrHasUpgrade(Pneumatized_Carapace, 1)
    && isGettingOrHasTech(Lurker_Aspect);
  data->allowed.techs[Burrowing] = isGettingOrHasUpgrade(Pneumatized_Carapace, 1)
    && !isGettingOrHasTech(Burrowing)
    && 3 <= data->rawHatcheryCount();
  data->allowed.techs[Lurker_Aspect] = 1 <= data->completeLairCount()
    && 3 <= data->rawHatcheryCount()
    && !isGettingOrHasTech(Lurker_Aspect);
  data->allowed.techs[Spawn_Broodlings] = !isGettingOrHasTech(Spawn_Broodlings)
    && isGettingOrHasTech(Ensnare);
  data->allowed.techs[Ensnare] = !isGettingOrHasTech(Ensnare)
    && isGettingOrHasUpgrade(Zerg_Flyer_Carapace, 1);
  data->allowed.techs[Plague] = !isGettingOrHasTech(Plague)
    && isGettingOrHasUpgrade(Chitinous_Plating, 1);
  data->allowed.techs[Consume] = !isGettingOrHasTech(Consume)
    && isGettingOrHasUpgrade(Antennae, 1);
  //isGettingOrHasUpgrade(Metasynaptic_Node, 1) last
}

void ZergMeleeIslandExp(std::shared_ptr<Data> data) {
  data->allowed.units[Zerg_Hatchery] = 0;
  data->expand = false;
  data->allowed.units[Zerg_Creep_Colony] = 0;
  data->allowed.units[Zerg_Extractor] = 0;
  data->allowed.units[Zerg_Spawning_Pool] = 0;
  data->allowed.units[Zerg_Evolution_Chamber] = 0;
  data->allowed.units[Zerg_Hydralisk_Den] = 0;
  data->allowed.units[Zerg_Spire] = 0;
  data->allowed.units[Zerg_Queens_Nest] = 0;
  data->allowed.units[Zerg_Nydus_Canal] = 0;
  data->allowed.units[Zerg_Ultralisk_Cavern] = 0;
  data->allowed.units[Zerg_Defiler_Mound] = 0;
  data->allowed.units[Zerg_Lair] = 0;
  data->allowed.units[Zerg_Spore_Colony] = 0;
  data->allowed.units[Zerg_Sunken_Colony] = 0;
  data->allowed.units[Zerg_Greater_Spire] = 0;
  data->allowed.units[Zerg_Hive] = 0;
  data->allowed.units[Zerg_Zergling] = 0;
  data->allowed.units[Zerg_Hydralisk] = 0;
  data->allowed.units[Zerg_Mutalisk] = 0;
  data->allowed.units[Zerg_Scourge] = 0;
  data->allowed.units[Zerg_Queen] = 0;
  data->allowed.units[Zerg_Ultralisk] = 0;
  data->allowed.units[Zerg_Defiler] = 0;
  data->allowed.units[Zerg_Lurker] = 0;
  data->allowed.units[Zerg_Guardian] = 0;
  data->allowed.units[Zerg_Devourer] = 0;
  data->allowed.upgrades[Metabolic_Boost] = 0;
  data->allowed.upgrades[Adrenal_Glands] = 0;
  data->allowed.upgrades[Zerg_Melee_Attacks] = 0;
  data->allowed.upgrades[Zerg_Missile_Attacks] = 0;
  data->allowed.upgrades[Zerg_Carapace] = 0;
  data->allowed.upgrades[Muscular_Augments] = 0;
  data->allowed.upgrades[Grooved_Spines] = 0;
  data->allowed.upgrades[Zerg_Flyer_Attacks] = 0;
  data->allowed.upgrades[Zerg_Flyer_Carapace] = 0;
  data->allowed.upgrades[Gamete_Meiosis] = 0;
  data->allowed.upgrades[Anabolic_Synthesis] = 0;
  data->allowed.upgrades[Chitinous_Plating] = 0;
  data->allowed.upgrades[Metasynaptic_Node] = 0;
  data->allowed.upgrades[Ventral_Sacs] = 0;
  data->allowed.upgrades[Antennae] = 0;
  data->allowed.upgrades[Pneumatized_Carapace] = 0;
  data->allowed.techs[Burrowing] = 0;
  data->allowed.techs[Lurker_Aspect] = 0;
  data->allowed.techs[Spawn_Broodlings] = 0;
  data->allowed.techs[Ensnare] = 0;
  data->allowed.techs[Plague] = 0;
  data->allowed.techs[Consume] = 0;
}