/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.CommandType;
import bwapi.CoordinateType;
import bwapi.EventType;
import bwapi.ShapeType;
import bwapi.WrappedBuffer;
import com.sun.jna.Pointer;

final class ClientData {
    private WrappedBuffer buffer;
    private GameData gameData = new GameData(0);

    ClientData() {
    }

    GameData gameData() {
        return this.gameData;
    }

    void setBuffer(WrappedBuffer buffer) {
        this.buffer = buffer;
    }

    void setPointer(Pointer pointer) {
        this.setBuffer(new WrappedBuffer(pointer, 33017048));
    }

    class UnitData {
        static final int SIZE = 336;
        private int myOffset;

        UnitData(int myOffset) {
            this.myOffset = myOffset;
        }

        int getClearanceLevel() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setClearanceLevel(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int getId() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setId(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        int getPlayer() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPlayer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }

        int getType() {
            int offset = this.myOffset + 12;
            return ClientData.this.buffer.getInt(offset);
        }

        void setType(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 12, value);
        }

        int getPositionX() {
            int offset = this.myOffset + 16;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPositionX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 16, value);
        }

        int getPositionY() {
            int offset = this.myOffset + 20;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPositionY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 20, value);
        }

        double getAngle() {
            int offset = this.myOffset + 24;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setAngle(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 24, value);
        }

        double getVelocityX() {
            int offset = this.myOffset + 32;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setVelocityX(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 32, value);
        }

        double getVelocityY() {
            int offset = this.myOffset + 40;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setVelocityY(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 40, value);
        }

        int getHitPoints() {
            int offset = this.myOffset + 48;
            return ClientData.this.buffer.getInt(offset);
        }

        void setHitPoints(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 48, value);
        }

        int getLastHitPoints() {
            int offset = this.myOffset + 52;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLastHitPoints(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 52, value);
        }

        int getShields() {
            int offset = this.myOffset + 56;
            return ClientData.this.buffer.getInt(offset);
        }

        void setShields(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 56, value);
        }

        int getEnergy() {
            int offset = this.myOffset + 60;
            return ClientData.this.buffer.getInt(offset);
        }

        void setEnergy(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 60, value);
        }

        int getResources() {
            int offset = this.myOffset + 64;
            return ClientData.this.buffer.getInt(offset);
        }

        void setResources(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 64, value);
        }

        int getResourceGroup() {
            int offset = this.myOffset + 68;
            return ClientData.this.buffer.getInt(offset);
        }

        void setResourceGroup(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 68, value);
        }

        int getKillCount() {
            int offset = this.myOffset + 72;
            return ClientData.this.buffer.getInt(offset);
        }

        void setKillCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 72, value);
        }

        int getAcidSporeCount() {
            int offset = this.myOffset + 76;
            return ClientData.this.buffer.getInt(offset);
        }

        void setAcidSporeCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 76, value);
        }

        int getScarabCount() {
            int offset = this.myOffset + 80;
            return ClientData.this.buffer.getInt(offset);
        }

        void setScarabCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 80, value);
        }

        int getInterceptorCount() {
            int offset = this.myOffset + 84;
            return ClientData.this.buffer.getInt(offset);
        }

        void setInterceptorCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 84, value);
        }

        int getSpiderMineCount() {
            int offset = this.myOffset + 88;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSpiderMineCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 88, value);
        }

        int getGroundWeaponCooldown() {
            int offset = this.myOffset + 92;
            return ClientData.this.buffer.getInt(offset);
        }

        void setGroundWeaponCooldown(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 92, value);
        }

        int getAirWeaponCooldown() {
            int offset = this.myOffset + 96;
            return ClientData.this.buffer.getInt(offset);
        }

        void setAirWeaponCooldown(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 96, value);
        }

        int getSpellCooldown() {
            int offset = this.myOffset + 100;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSpellCooldown(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 100, value);
        }

        int getDefenseMatrixPoints() {
            int offset = this.myOffset + 104;
            return ClientData.this.buffer.getInt(offset);
        }

        void setDefenseMatrixPoints(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 104, value);
        }

        int getDefenseMatrixTimer() {
            int offset = this.myOffset + 108;
            return ClientData.this.buffer.getInt(offset);
        }

        void setDefenseMatrixTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 108, value);
        }

        int getEnsnareTimer() {
            int offset = this.myOffset + 112;
            return ClientData.this.buffer.getInt(offset);
        }

        void setEnsnareTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 112, value);
        }

        int getIrradiateTimer() {
            int offset = this.myOffset + 116;
            return ClientData.this.buffer.getInt(offset);
        }

        void setIrradiateTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 116, value);
        }

        int getLockdownTimer() {
            int offset = this.myOffset + 120;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLockdownTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 120, value);
        }

        int getMaelstromTimer() {
            int offset = this.myOffset + 124;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMaelstromTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 124, value);
        }

        int getOrderTimer() {
            int offset = this.myOffset + 128;
            return ClientData.this.buffer.getInt(offset);
        }

        void setOrderTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 128, value);
        }

        int getPlagueTimer() {
            int offset = this.myOffset + 132;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPlagueTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 132, value);
        }

        int getRemoveTimer() {
            int offset = this.myOffset + 136;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemoveTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 136, value);
        }

        int getStasisTimer() {
            int offset = this.myOffset + 140;
            return ClientData.this.buffer.getInt(offset);
        }

        void setStasisTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 140, value);
        }

        int getStimTimer() {
            int offset = this.myOffset + 144;
            return ClientData.this.buffer.getInt(offset);
        }

        void setStimTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 144, value);
        }

        int getBuildType() {
            int offset = this.myOffset + 148;
            return ClientData.this.buffer.getInt(offset);
        }

        void setBuildType(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 148, value);
        }

        int getTrainingQueueCount() {
            int offset = this.myOffset + 152;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTrainingQueueCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 152, value);
        }

        int getTrainingQueue(int i) {
            int offset = this.myOffset + 156 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTrainingQueue(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 156 + 4 * i, value);
        }

        int getTech() {
            int offset = this.myOffset + 176;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTech(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 176, value);
        }

        int getUpgrade() {
            int offset = this.myOffset + 180;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUpgrade(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 180, value);
        }

        int getRemainingBuildTime() {
            int offset = this.myOffset + 184;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemainingBuildTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 184, value);
        }

        int getRemainingTrainTime() {
            int offset = this.myOffset + 188;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemainingTrainTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 188, value);
        }

        int getRemainingResearchTime() {
            int offset = this.myOffset + 192;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemainingResearchTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 192, value);
        }

        int getRemainingUpgradeTime() {
            int offset = this.myOffset + 196;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemainingUpgradeTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 196, value);
        }

        int getBuildUnit() {
            int offset = this.myOffset + 200;
            return ClientData.this.buffer.getInt(offset);
        }

        void setBuildUnit(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 200, value);
        }

        int getTarget() {
            int offset = this.myOffset + 204;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTarget(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 204, value);
        }

        int getTargetPositionX() {
            int offset = this.myOffset + 208;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTargetPositionX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 208, value);
        }

        int getTargetPositionY() {
            int offset = this.myOffset + 212;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTargetPositionY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 212, value);
        }

        int getOrder() {
            int offset = this.myOffset + 216;
            return ClientData.this.buffer.getInt(offset);
        }

        void setOrder(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 216, value);
        }

        int getOrderTarget() {
            int offset = this.myOffset + 220;
            return ClientData.this.buffer.getInt(offset);
        }

        void setOrderTarget(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 220, value);
        }

        int getOrderTargetPositionX() {
            int offset = this.myOffset + 224;
            return ClientData.this.buffer.getInt(offset);
        }

        void setOrderTargetPositionX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 224, value);
        }

        int getOrderTargetPositionY() {
            int offset = this.myOffset + 228;
            return ClientData.this.buffer.getInt(offset);
        }

        void setOrderTargetPositionY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 228, value);
        }

        int getSecondaryOrder() {
            int offset = this.myOffset + 232;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSecondaryOrder(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 232, value);
        }

        int getRallyPositionX() {
            int offset = this.myOffset + 236;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRallyPositionX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 236, value);
        }

        int getRallyPositionY() {
            int offset = this.myOffset + 240;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRallyPositionY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 240, value);
        }

        int getRallyUnit() {
            int offset = this.myOffset + 244;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRallyUnit(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 244, value);
        }

        int getAddon() {
            int offset = this.myOffset + 248;
            return ClientData.this.buffer.getInt(offset);
        }

        void setAddon(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 248, value);
        }

        int getNydusExit() {
            int offset = this.myOffset + 252;
            return ClientData.this.buffer.getInt(offset);
        }

        void setNydusExit(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 252, value);
        }

        int getPowerUp() {
            int offset = this.myOffset + 256;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPowerUp(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 256, value);
        }

        int getTransport() {
            int offset = this.myOffset + 260;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTransport(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 260, value);
        }

        int getCarrier() {
            int offset = this.myOffset + 264;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCarrier(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 264, value);
        }

        int getHatchery() {
            int offset = this.myOffset + 268;
            return ClientData.this.buffer.getInt(offset);
        }

        void setHatchery(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 268, value);
        }

        boolean getExists() {
            int offset = this.myOffset + 272;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setExists(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 272, (byte)(value ? 1 : 0));
        }

        boolean getHasNuke() {
            int offset = this.myOffset + 273;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setHasNuke(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 273, (byte)(value ? 1 : 0));
        }

        boolean isAccelerating() {
            int offset = this.myOffset + 274;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsAccelerating(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 274, (byte)(value ? 1 : 0));
        }

        boolean isAttacking() {
            int offset = this.myOffset + 275;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsAttacking(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 275, (byte)(value ? 1 : 0));
        }

        boolean isAttackFrame() {
            int offset = this.myOffset + 276;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsAttackFrame(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 276, (byte)(value ? 1 : 0));
        }

        boolean isBeingGathered() {
            int offset = this.myOffset + 277;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsBeingGathered(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 277, (byte)(value ? 1 : 0));
        }

        boolean isBlind() {
            int offset = this.myOffset + 278;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsBlind(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 278, (byte)(value ? 1 : 0));
        }

        boolean isBraking() {
            int offset = this.myOffset + 279;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsBraking(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 279, (byte)(value ? 1 : 0));
        }

        boolean isBurrowed() {
            int offset = this.myOffset + 280;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsBurrowed(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 280, (byte)(value ? 1 : 0));
        }

        int getCarryResourceType() {
            int offset = this.myOffset + 284;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCarryResourceType(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 284, value);
        }

        boolean isCloaked() {
            int offset = this.myOffset + 288;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsCloaked(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 288, (byte)(value ? 1 : 0));
        }

        boolean isCompleted() {
            int offset = this.myOffset + 289;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsCompleted(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 289, (byte)(value ? 1 : 0));
        }

        boolean isConstructing() {
            int offset = this.myOffset + 290;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsConstructing(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 290, (byte)(value ? 1 : 0));
        }

        boolean isDetected() {
            int offset = this.myOffset + 291;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsDetected(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 291, (byte)(value ? 1 : 0));
        }

        boolean isGathering() {
            int offset = this.myOffset + 292;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsGathering(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 292, (byte)(value ? 1 : 0));
        }

        boolean isHallucination() {
            int offset = this.myOffset + 293;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsHallucination(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 293, (byte)(value ? 1 : 0));
        }

        boolean isIdle() {
            int offset = this.myOffset + 294;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsIdle(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 294, (byte)(value ? 1 : 0));
        }

        boolean isInterruptible() {
            int offset = this.myOffset + 295;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsInterruptible(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 295, (byte)(value ? 1 : 0));
        }

        boolean isInvincible() {
            int offset = this.myOffset + 296;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsInvincible(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 296, (byte)(value ? 1 : 0));
        }

        boolean isLifted() {
            int offset = this.myOffset + 297;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsLifted(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 297, (byte)(value ? 1 : 0));
        }

        boolean isMorphing() {
            int offset = this.myOffset + 298;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsMorphing(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 298, (byte)(value ? 1 : 0));
        }

        boolean isMoving() {
            int offset = this.myOffset + 299;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsMoving(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 299, (byte)(value ? 1 : 0));
        }

        boolean isParasited() {
            int offset = this.myOffset + 300;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsParasited(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 300, (byte)(value ? 1 : 0));
        }

        boolean isSelected() {
            int offset = this.myOffset + 301;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsSelected(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 301, (byte)(value ? 1 : 0));
        }

        boolean isStartingAttack() {
            int offset = this.myOffset + 302;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsStartingAttack(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 302, (byte)(value ? 1 : 0));
        }

        boolean isStuck() {
            int offset = this.myOffset + 303;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsStuck(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 303, (byte)(value ? 1 : 0));
        }

        boolean isTraining() {
            int offset = this.myOffset + 304;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsTraining(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 304, (byte)(value ? 1 : 0));
        }

        boolean isUnderStorm() {
            int offset = this.myOffset + 305;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsUnderStorm(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 305, (byte)(value ? 1 : 0));
        }

        boolean isUnderDarkSwarm() {
            int offset = this.myOffset + 306;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsUnderDarkSwarm(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 306, (byte)(value ? 1 : 0));
        }

        boolean isUnderDWeb() {
            int offset = this.myOffset + 307;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsUnderDWeb(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 307, (byte)(value ? 1 : 0));
        }

        boolean isPowered() {
            int offset = this.myOffset + 308;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsPowered(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 308, (byte)(value ? 1 : 0));
        }

        boolean isVisible(int i) {
            int offset = this.myOffset + 309 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsVisible(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 309 + 1 * i, (byte)(value ? 1 : 0));
        }

        int getButtonset() {
            int offset = this.myOffset + 320;
            return ClientData.this.buffer.getInt(offset);
        }

        void setButtonset(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 320, value);
        }

        int getLastAttackerPlayer() {
            int offset = this.myOffset + 324;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLastAttackerPlayer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 324, value);
        }

        boolean getRecentlyAttacked() {
            int offset = this.myOffset + 328;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setRecentlyAttacked(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 328, (byte)(value ? 1 : 0));
        }

        int getReplayID() {
            int offset = this.myOffset + 332;
            return ClientData.this.buffer.getInt(offset);
        }

        void setReplayID(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 332, value);
        }
    }

    class unitFinder {
        static final int SIZE = 8;
        private int myOffset;

        unitFinder(int myOffset) {
            this.myOffset = myOffset;
        }

        int getUnitIndex() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUnitIndex(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int getSearchValue() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSearchValue(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }
    }

    class BulletData {
        static final int SIZE = 80;
        private int myOffset;

        BulletData(int myOffset) {
            this.myOffset = myOffset;
        }

        int getId() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setId(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int getPlayer() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPlayer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        int getType() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setType(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }

        int getSource() {
            int offset = this.myOffset + 12;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSource(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 12, value);
        }

        int getPositionX() {
            int offset = this.myOffset + 16;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPositionX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 16, value);
        }

        int getPositionY() {
            int offset = this.myOffset + 20;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPositionY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 20, value);
        }

        double getAngle() {
            int offset = this.myOffset + 24;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setAngle(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 24, value);
        }

        double getVelocityX() {
            int offset = this.myOffset + 32;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setVelocityX(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 32, value);
        }

        double getVelocityY() {
            int offset = this.myOffset + 40;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setVelocityY(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 40, value);
        }

        int getTarget() {
            int offset = this.myOffset + 48;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTarget(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 48, value);
        }

        int getTargetPositionX() {
            int offset = this.myOffset + 52;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTargetPositionX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 52, value);
        }

        int getTargetPositionY() {
            int offset = this.myOffset + 56;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTargetPositionY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 56, value);
        }

        int getRemoveTimer() {
            int offset = this.myOffset + 60;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemoveTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 60, value);
        }

        boolean getExists() {
            int offset = this.myOffset + 64;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setExists(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 64, (byte)(value ? 1 : 0));
        }

        boolean isVisible(int i) {
            int offset = this.myOffset + 65 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsVisible(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 65 + 1 * i, (byte)(value ? 1 : 0));
        }
    }

    class PlayerData {
        static final int SIZE = 5788;
        private int myOffset;

        PlayerData(int myOffset) {
            this.myOffset = myOffset;
        }

        String getName() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getString(offset, 25);
        }

        void setName(String value) {
            ClientData.this.buffer.putString(this.myOffset + 0, 25, value);
        }

        int getRace() {
            int offset = this.myOffset + 28;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRace(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 28, value);
        }

        int getType() {
            int offset = this.myOffset + 32;
            return ClientData.this.buffer.getInt(offset);
        }

        void setType(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 32, value);
        }

        int getForce() {
            int offset = this.myOffset + 36;
            return ClientData.this.buffer.getInt(offset);
        }

        void setForce(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 36, value);
        }

        boolean isAlly(int i) {
            int offset = this.myOffset + 40 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsAlly(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 40 + 1 * i, (byte)(value ? 1 : 0));
        }

        boolean isEnemy(int i) {
            int offset = this.myOffset + 52 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsEnemy(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 52 + 1 * i, (byte)(value ? 1 : 0));
        }

        boolean isNeutral() {
            int offset = this.myOffset + 64;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsNeutral(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 64, (byte)(value ? 1 : 0));
        }

        int getStartLocationX() {
            int offset = this.myOffset + 68;
            return ClientData.this.buffer.getInt(offset);
        }

        void setStartLocationX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 68, value);
        }

        int getStartLocationY() {
            int offset = this.myOffset + 72;
            return ClientData.this.buffer.getInt(offset);
        }

        void setStartLocationY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 72, value);
        }

        boolean isVictorious() {
            int offset = this.myOffset + 76;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsVictorious(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 76, (byte)(value ? 1 : 0));
        }

        boolean isDefeated() {
            int offset = this.myOffset + 77;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsDefeated(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 77, (byte)(value ? 1 : 0));
        }

        boolean getLeftGame() {
            int offset = this.myOffset + 78;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setLeftGame(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 78, (byte)(value ? 1 : 0));
        }

        boolean isParticipating() {
            int offset = this.myOffset + 79;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsParticipating(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 79, (byte)(value ? 1 : 0));
        }

        int getMinerals() {
            int offset = this.myOffset + 80;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMinerals(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 80, value);
        }

        int getGas() {
            int offset = this.myOffset + 84;
            return ClientData.this.buffer.getInt(offset);
        }

        void setGas(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 84, value);
        }

        int getGatheredMinerals() {
            int offset = this.myOffset + 88;
            return ClientData.this.buffer.getInt(offset);
        }

        void setGatheredMinerals(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 88, value);
        }

        int getGatheredGas() {
            int offset = this.myOffset + 92;
            return ClientData.this.buffer.getInt(offset);
        }

        void setGatheredGas(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 92, value);
        }

        int getRepairedMinerals() {
            int offset = this.myOffset + 96;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRepairedMinerals(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 96, value);
        }

        int getRepairedGas() {
            int offset = this.myOffset + 100;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRepairedGas(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 100, value);
        }

        int getRefundedMinerals() {
            int offset = this.myOffset + 104;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRefundedMinerals(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 104, value);
        }

        int getRefundedGas() {
            int offset = this.myOffset + 108;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRefundedGas(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 108, value);
        }

        int getSupplyTotal(int i) {
            int offset = this.myOffset + 112 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSupplyTotal(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 112 + 4 * i, value);
        }

        int getSupplyUsed(int i) {
            int offset = this.myOffset + 124 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSupplyUsed(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 124 + 4 * i, value);
        }

        int getAllUnitCount(int i) {
            int offset = this.myOffset + 136 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setAllUnitCount(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 136 + 4 * i, value);
        }

        int getVisibleUnitCount(int i) {
            int offset = this.myOffset + 1072 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setVisibleUnitCount(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 1072 + 4 * i, value);
        }

        int getCompletedUnitCount(int i) {
            int offset = this.myOffset + 2008 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCompletedUnitCount(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 2008 + 4 * i, value);
        }

        int getDeadUnitCount(int i) {
            int offset = this.myOffset + 2944 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setDeadUnitCount(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 2944 + 4 * i, value);
        }

        int getKilledUnitCount(int i) {
            int offset = this.myOffset + 3880 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setKilledUnitCount(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3880 + 4 * i, value);
        }

        int getUpgradeLevel(int i) {
            int offset = this.myOffset + 4816 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUpgradeLevel(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4816 + 4 * i, value);
        }

        boolean getHasResearched(int i) {
            int offset = this.myOffset + 5068 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setHasResearched(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 5068 + 1 * i, (byte)(value ? 1 : 0));
        }

        boolean isResearching(int i) {
            int offset = this.myOffset + 5115 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsResearching(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 5115 + 1 * i, (byte)(value ? 1 : 0));
        }

        boolean isUpgrading(int i) {
            int offset = this.myOffset + 5162 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsUpgrading(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 5162 + 1 * i, (byte)(value ? 1 : 0));
        }

        int getColor() {
            int offset = this.myOffset + 5228;
            return ClientData.this.buffer.getInt(offset);
        }

        void setColor(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5228, value);
        }

        int getTotalUnitScore() {
            int offset = this.myOffset + 5232;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTotalUnitScore(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5232, value);
        }

        int getTotalKillScore() {
            int offset = this.myOffset + 5236;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTotalKillScore(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5236, value);
        }

        int getTotalBuildingScore() {
            int offset = this.myOffset + 5240;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTotalBuildingScore(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5240, value);
        }

        int getTotalRazingScore() {
            int offset = this.myOffset + 5244;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTotalRazingScore(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5244, value);
        }

        int getCustomScore() {
            int offset = this.myOffset + 5248;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCustomScore(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5248, value);
        }

        int getMaxUpgradeLevel(int i) {
            int offset = this.myOffset + 5252 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMaxUpgradeLevel(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5252 + 4 * i, value);
        }

        boolean isResearchAvailable(int i) {
            int offset = this.myOffset + 5504 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsResearchAvailable(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 5504 + 1 * i, (byte)(value ? 1 : 0));
        }

        boolean isUnitAvailable(int i) {
            int offset = this.myOffset + 5551 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsUnitAvailable(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 5551 + 1 * i, (byte)(value ? 1 : 0));
        }
    }

    class ForceData {
        static final int SIZE = 32;
        private int myOffset;

        ForceData(int myOffset) {
            this.myOffset = myOffset;
        }

        String getName() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getString(offset, 32);
        }

        void setName(String value) {
            ClientData.this.buffer.putString(this.myOffset + 0, 32, value);
        }
    }

    class RegionData {
        static final int SIZE = 1068;
        private int myOffset;

        RegionData(int myOffset) {
            this.myOffset = myOffset;
        }

        int getId() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setId(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int islandID() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setIslandID(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        int getCenter_x() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCenter_x(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }

        int getCenter_y() {
            int offset = this.myOffset + 12;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCenter_y(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 12, value);
        }

        int getPriority() {
            int offset = this.myOffset + 16;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPriority(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 16, value);
        }

        int getLeftMost() {
            int offset = this.myOffset + 20;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLeftMost(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 20, value);
        }

        int getRightMost() {
            int offset = this.myOffset + 24;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRightMost(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 24, value);
        }

        int getTopMost() {
            int offset = this.myOffset + 28;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTopMost(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 28, value);
        }

        int getBottomMost() {
            int offset = this.myOffset + 32;
            return ClientData.this.buffer.getInt(offset);
        }

        void setBottomMost(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 32, value);
        }

        int getNeighborCount() {
            int offset = this.myOffset + 36;
            return ClientData.this.buffer.getInt(offset);
        }

        void setNeighborCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 36, value);
        }

        int getNeighbors(int i) {
            int offset = this.myOffset + 40 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setNeighbors(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 40 + 4 * i, value);
        }

        boolean isAccessible() {
            int offset = this.myOffset + 1064;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsAccessible(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 1064, (byte)(value ? 1 : 0));
        }

        boolean isHigherGround() {
            int offset = this.myOffset + 1065;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsHigherGround(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 1065, (byte)(value ? 1 : 0));
        }
    }

    class Event {
        static final int SIZE = 12;
        private int myOffset;

        Event(int myOffset) {
            this.myOffset = myOffset;
        }

        EventType getType() {
            int offset = this.myOffset + 0;
            return EventType.idToEnum[ClientData.this.buffer.getInt(offset)];
        }

        void setType(EventType value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value.id);
        }

        int getV1() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setV1(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        int getV2() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setV2(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }
    }

    class Position {
        static final int SIZE = 8;
        private int myOffset;

        Position(int myOffset) {
            this.myOffset = myOffset;
        }

        int getX() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int getY() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }
    }

    class Command {
        static final int SIZE = 12;
        private int myOffset;

        Command(int myOffset) {
            this.myOffset = myOffset;
        }

        CommandType getType() {
            int offset = this.myOffset + 0;
            return CommandType.idToEnum[ClientData.this.buffer.getInt(offset)];
        }

        void setType(CommandType value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value.id);
        }

        int getValue1() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setValue1(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        int getValue2() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setValue2(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }
    }

    class Shape {
        static final int SIZE = 40;
        private int myOffset;

        Shape(int myOffset) {
            this.myOffset = myOffset;
        }

        ShapeType getType() {
            int offset = this.myOffset + 0;
            return ShapeType.idToEnum[ClientData.this.buffer.getInt(offset)];
        }

        void setType(ShapeType value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value.id);
        }

        CoordinateType getCtype() {
            int offset = this.myOffset + 4;
            return CoordinateType.idToEnum[ClientData.this.buffer.getInt(offset)];
        }

        void setCtype(CoordinateType value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value.id);
        }

        int getX1() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setX1(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }

        int getY1() {
            int offset = this.myOffset + 12;
            return ClientData.this.buffer.getInt(offset);
        }

        void setY1(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 12, value);
        }

        int getX2() {
            int offset = this.myOffset + 16;
            return ClientData.this.buffer.getInt(offset);
        }

        void setX2(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 16, value);
        }

        int getY2() {
            int offset = this.myOffset + 20;
            return ClientData.this.buffer.getInt(offset);
        }

        void setY2(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 20, value);
        }

        int getExtra1() {
            int offset = this.myOffset + 24;
            return ClientData.this.buffer.getInt(offset);
        }

        void setExtra1(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 24, value);
        }

        int getExtra2() {
            int offset = this.myOffset + 28;
            return ClientData.this.buffer.getInt(offset);
        }

        void setExtra2(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 28, value);
        }

        int getColor() {
            int offset = this.myOffset + 32;
            return ClientData.this.buffer.getInt(offset);
        }

        void setColor(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 32, value);
        }

        boolean isSolid() {
            int offset = this.myOffset + 36;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsSolid(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 36, (byte)(value ? 1 : 0));
        }
    }

    class GameData {
        static final int SIZE = 33017048;
        private int myOffset;

        GameData(int myOffset) {
            this.myOffset = myOffset;
        }

        int getClient_version() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setClient_version(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int getRevision() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRevision(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        boolean isDebug() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsDebug(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 8, (byte)(value ? 1 : 0));
        }

        int getInstanceID() {
            int offset = this.myOffset + 12;
            return ClientData.this.buffer.getInt(offset);
        }

        void setInstanceID(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 12, value);
        }

        int getBotAPM_noselects() {
            int offset = this.myOffset + 16;
            return ClientData.this.buffer.getInt(offset);
        }

        void setBotAPM_noselects(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 16, value);
        }

        int getBotAPM_selects() {
            int offset = this.myOffset + 20;
            return ClientData.this.buffer.getInt(offset);
        }

        void setBotAPM_selects(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 20, value);
        }

        int getForceCount() {
            int offset = this.myOffset + 24;
            return ClientData.this.buffer.getInt(offset);
        }

        void setForceCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 24, value);
        }

        ForceData getForces(int i) {
            int offset = this.myOffset + 28 + 32 * i;
            return new ForceData(offset);
        }

        int getPlayerCount() {
            int offset = this.myOffset + 188;
            return ClientData.this.buffer.getInt(offset);
        }

        void setPlayerCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 188, value);
        }

        PlayerData getPlayers(int i) {
            int offset = this.myOffset + 192 + 5788 * i;
            return new PlayerData(offset);
        }

        int getInitialUnitCount() {
            int offset = this.myOffset + 69648;
            return ClientData.this.buffer.getInt(offset);
        }

        void setInitialUnitCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 69648, value);
        }

        UnitData getUnits(int i) {
            int offset = this.myOffset + 69656 + 336 * i;
            return new UnitData(offset);
        }

        int getUnitArray(int i) {
            int offset = this.myOffset + 3429656 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUnitArray(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3429656 + 4 * i, value);
        }

        BulletData getBullets(int i) {
            int offset = this.myOffset + 3436456 + 80 * i;
            return new BulletData(offset);
        }

        int getNukeDotCount() {
            int offset = this.myOffset + 3444456;
            return ClientData.this.buffer.getInt(offset);
        }

        void setNukeDotCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3444456, value);
        }

        Position getNukeDots(int i) {
            int offset = this.myOffset + 3444460 + 8 * i;
            return new Position(offset);
        }

        int getGameType() {
            int offset = this.myOffset + 3446060;
            return ClientData.this.buffer.getInt(offset);
        }

        void setGameType(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446060, value);
        }

        int getLatency() {
            int offset = this.myOffset + 3446064;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLatency(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446064, value);
        }

        int getLatencyFrames() {
            int offset = this.myOffset + 3446068;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLatencyFrames(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446068, value);
        }

        int getLatencyTime() {
            int offset = this.myOffset + 3446072;
            return ClientData.this.buffer.getInt(offset);
        }

        void setLatencyTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446072, value);
        }

        int getRemainingLatencyFrames() {
            int offset = this.myOffset + 3446076;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemainingLatencyFrames(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446076, value);
        }

        int getRemainingLatencyTime() {
            int offset = this.myOffset + 3446080;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRemainingLatencyTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446080, value);
        }

        boolean getHasLatCom() {
            int offset = this.myOffset + 3446084;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setHasLatCom(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 3446084, (byte)(value ? 1 : 0));
        }

        boolean getHasGUI() {
            int offset = this.myOffset + 3446085;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setHasGUI(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 3446085, (byte)(value ? 1 : 0));
        }

        int getReplayFrameCount() {
            int offset = this.myOffset + 3446088;
            return ClientData.this.buffer.getInt(offset);
        }

        void setReplayFrameCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446088, value);
        }

        int getRandomSeed() {
            int offset = this.myOffset + 3446092;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRandomSeed(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446092, value);
        }

        int getFrameCount() {
            int offset = this.myOffset + 3446096;
            return ClientData.this.buffer.getInt(offset);
        }

        void setFrameCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446096, value);
        }

        int getElapsedTime() {
            int offset = this.myOffset + 3446100;
            return ClientData.this.buffer.getInt(offset);
        }

        void setElapsedTime(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446100, value);
        }

        int getCountdownTimer() {
            int offset = this.myOffset + 3446104;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCountdownTimer(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446104, value);
        }

        int getFps() {
            int offset = this.myOffset + 3446108;
            return ClientData.this.buffer.getInt(offset);
        }

        void setFps(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446108, value);
        }

        double getAverageFPS() {
            int offset = this.myOffset + 3446112;
            return ClientData.this.buffer.getDouble(offset);
        }

        void setAverageFPS(double value) {
            ClientData.this.buffer.putDouble(this.myOffset + 3446112, value);
        }

        int getMouseX() {
            int offset = this.myOffset + 3446120;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMouseX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446120, value);
        }

        int getMouseY() {
            int offset = this.myOffset + 3446124;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMouseY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446124, value);
        }

        boolean getMouseState(int i) {
            int offset = this.myOffset + 3446128 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setMouseState(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 3446128 + 1 * i, (byte)(value ? 1 : 0));
        }

        boolean getKeyState(int i) {
            int offset = this.myOffset + 3446131 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setKeyState(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 3446131 + 1 * i, (byte)(value ? 1 : 0));
        }

        int getScreenX() {
            int offset = this.myOffset + 3446388;
            return ClientData.this.buffer.getInt(offset);
        }

        void setScreenX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446388, value);
        }

        int getScreenY() {
            int offset = this.myOffset + 3446392;
            return ClientData.this.buffer.getInt(offset);
        }

        void setScreenY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446392, value);
        }

        boolean getFlags(int i) {
            int offset = this.myOffset + 3446396 + 1 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setFlags(int i, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 3446396 + 1 * i, (byte)(value ? 1 : 0));
        }

        int getMapWidth() {
            int offset = this.myOffset + 3446400;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMapWidth(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446400, value);
        }

        int getMapHeight() {
            int offset = this.myOffset + 3446404;
            return ClientData.this.buffer.getInt(offset);
        }

        void setMapHeight(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3446404, value);
        }

        String getMapFileName() {
            int offset = this.myOffset + 3446408;
            return ClientData.this.buffer.getString(offset, 261);
        }

        void setMapFileName(String value) {
            ClientData.this.buffer.putString(this.myOffset + 3446408, 261, value);
        }

        String getMapPathName() {
            int offset = this.myOffset + 3446669;
            return ClientData.this.buffer.getString(offset, 261);
        }

        void setMapPathName(String value) {
            ClientData.this.buffer.putString(this.myOffset + 3446669, 261, value);
        }

        String getMapName() {
            int offset = this.myOffset + 3446930;
            return ClientData.this.buffer.getString(offset, 33);
        }

        void setMapName(String value) {
            ClientData.this.buffer.putString(this.myOffset + 3446930, 33, value);
        }

        String getMapHash() {
            int offset = this.myOffset + 3446963;
            return ClientData.this.buffer.getString(offset, 41);
        }

        void setMapHash(String value) {
            ClientData.this.buffer.putString(this.myOffset + 3446963, 41, value);
        }

        int getGroundHeight(int i, int j) {
            int offset = this.myOffset + 3447004 + 4 * j + 1024 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setGetGroundHeight(int i, int j, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 3447004 + 4 * j + 1024 * i, value);
        }

        boolean isWalkable(int i, int j) {
            int offset = this.myOffset + 3709148 + 1 * j + 1024 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsWalkable(int i, int j, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 3709148 + 1 * j + 1024 * i, (byte)(value ? 1 : 0));
        }

        boolean isBuildable(int i, int j) {
            int offset = this.myOffset + 4757724 + 1 * j + 256 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsBuildable(int i, int j, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 4757724 + 1 * j + 256 * i, (byte)(value ? 1 : 0));
        }

        boolean isVisible(int i, int j) {
            int offset = this.myOffset + 4823260 + 1 * j + 256 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsVisible(int i, int j, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 4823260 + 1 * j + 256 * i, (byte)(value ? 1 : 0));
        }

        boolean isExplored(int i, int j) {
            int offset = this.myOffset + 4888796 + 1 * j + 256 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsExplored(int i, int j, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 4888796 + 1 * j + 256 * i, (byte)(value ? 1 : 0));
        }

        boolean getHasCreep(int i, int j) {
            int offset = this.myOffset + 4954332 + 1 * j + 256 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setHasCreep(int i, int j, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 4954332 + 1 * j + 256 * i, (byte)(value ? 1 : 0));
        }

        boolean isOccupied(int i, int j) {
            int offset = this.myOffset + 5019868 + 1 * j + 256 * i;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsOccupied(int i, int j, boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 5019868 + 1 * j + 256 * i, (byte)(value ? 1 : 0));
        }

        short getMapTileRegionId(int i, int j) {
            int offset = this.myOffset + 5085404 + 2 * j + 512 * i;
            return ClientData.this.buffer.getShort(offset);
        }

        void setMapTileRegionId(int i, int j, short value) {
            ClientData.this.buffer.putShort(this.myOffset + 5085404 + 2 * j + 512 * i, value);
        }

        short getMapSplitTilesMiniTileMask(int i) {
            int offset = this.myOffset + 5216476 + 2 * i;
            return ClientData.this.buffer.getShort(offset);
        }

        void setMapSplitTilesMiniTileMask(int i, short value) {
            ClientData.this.buffer.putShort(this.myOffset + 5216476 + 2 * i, value);
        }

        short getMapSplitTilesRegion1(int i) {
            int offset = this.myOffset + 5226476 + 2 * i;
            return ClientData.this.buffer.getShort(offset);
        }

        void setMapSplitTilesRegion1(int i, short value) {
            ClientData.this.buffer.putShort(this.myOffset + 5226476 + 2 * i, value);
        }

        short getMapSplitTilesRegion2(int i) {
            int offset = this.myOffset + 5236476 + 2 * i;
            return ClientData.this.buffer.getShort(offset);
        }

        void setMapSplitTilesRegion2(int i, short value) {
            ClientData.this.buffer.putShort(this.myOffset + 5236476 + 2 * i, value);
        }

        int getRegionCount() {
            int offset = this.myOffset + 5246476;
            return ClientData.this.buffer.getInt(offset);
        }

        void setRegionCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 5246476, value);
        }

        RegionData getRegions(int i) {
            int offset = this.myOffset + 5246480 + 1068 * i;
            return new RegionData(offset);
        }

        int getStartLocationCount() {
            int offset = this.myOffset + 10586480;
            return ClientData.this.buffer.getInt(offset);
        }

        void setStartLocationCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586480, value);
        }

        Position getStartLocations(int i) {
            int offset = this.myOffset + 10586484 + 8 * i;
            return new Position(offset);
        }

        boolean isInGame() {
            int offset = this.myOffset + 10586548;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsInGame(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 10586548, (byte)(value ? 1 : 0));
        }

        boolean isMultiplayer() {
            int offset = this.myOffset + 10586549;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsMultiplayer(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 10586549, (byte)(value ? 1 : 0));
        }

        boolean isBattleNet() {
            int offset = this.myOffset + 10586550;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsBattleNet(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 10586550, (byte)(value ? 1 : 0));
        }

        boolean isPaused() {
            int offset = this.myOffset + 10586551;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsPaused(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 10586551, (byte)(value ? 1 : 0));
        }

        boolean isReplay() {
            int offset = this.myOffset + 10586552;
            return ClientData.this.buffer.getByte(offset) != 0;
        }

        void setIsReplay(boolean value) {
            ClientData.this.buffer.putByte(this.myOffset + 10586552, (byte)(value ? 1 : 0));
        }

        int getSelectedUnitCount() {
            int offset = this.myOffset + 10586556;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSelectedUnitCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586556, value);
        }

        int getSelectedUnits(int i) {
            int offset = this.myOffset + 10586560 + 4 * i;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSelectedUnits(int i, int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586560 + 4 * i, value);
        }

        int getSelf() {
            int offset = this.myOffset + 10586608;
            return ClientData.this.buffer.getInt(offset);
        }

        void setSelf(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586608, value);
        }

        int getEnemy() {
            int offset = this.myOffset + 10586612;
            return ClientData.this.buffer.getInt(offset);
        }

        void setEnemy(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586612, value);
        }

        int getNeutral() {
            int offset = this.myOffset + 10586616;
            return ClientData.this.buffer.getInt(offset);
        }

        void setNeutral(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586616, value);
        }

        int getEventCount() {
            int offset = this.myOffset + 10586620;
            return ClientData.this.buffer.getInt(offset);
        }

        void setEventCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10586620, value);
        }

        Event getEvents(int i) {
            int offset = this.myOffset + 10586624 + 12 * i;
            return new Event(offset);
        }

        int getEventStringCount() {
            int offset = this.myOffset + 10706624;
            return ClientData.this.buffer.getInt(offset);
        }

        void setEventStringCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10706624, value);
        }

        String getEventStrings(int i) {
            int offset = this.myOffset + 10706628 + 256 * i;
            return ClientData.this.buffer.getString(offset, 256);
        }

        void setEventStrings(int i, String value) {
            ClientData.this.buffer.putString(this.myOffset + 10706628 + 256 * i, 256, value);
        }

        int getStringCount() {
            int offset = this.myOffset + 10962628;
            return ClientData.this.buffer.getInt(offset);
        }

        void setStringCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 10962628, value);
        }

        String getStrings(int i) {
            int offset = this.myOffset + 10962632 + 1024 * i;
            return ClientData.this.buffer.getString(offset, 1024);
        }

        void setStrings(int i, String value) {
            ClientData.this.buffer.putString(this.myOffset + 10962632 + 1024 * i, 1024, value);
        }

        int getShapeCount() {
            int offset = this.myOffset + 31442632;
            return ClientData.this.buffer.getInt(offset);
        }

        void setShapeCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 31442632, value);
        }

        Shape getShapes(int i) {
            int offset = this.myOffset + 31442636 + 40 * i;
            return new Shape(offset);
        }

        int getCommandCount() {
            int offset = this.myOffset + 32242636;
            return ClientData.this.buffer.getInt(offset);
        }

        void setCommandCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 32242636, value);
        }

        Command getCommands(int i) {
            int offset = this.myOffset + 32242640 + 12 * i;
            return new Command(offset);
        }

        int getUnitCommandCount() {
            int offset = this.myOffset + 32482640;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUnitCommandCount(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 32482640, value);
        }

        UnitCommand getUnitCommands(int i) {
            int offset = this.myOffset + 32482644 + 24 * i;
            return new UnitCommand(offset);
        }

        int getUnitSearchSize() {
            int offset = this.myOffset + 32962644;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUnitSearchSize(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 32962644, value);
        }

        unitFinder getXUnitSearch(int i) {
            int offset = this.myOffset + 32962648 + 8 * i;
            return new unitFinder(offset);
        }

        unitFinder getYUnitSearch(int i) {
            int offset = this.myOffset + 32989848 + 8 * i;
            return new unitFinder(offset);
        }
    }

    class UnitCommand {
        static final int SIZE = 24;
        private int myOffset;

        UnitCommand(int myOffset) {
            this.myOffset = myOffset;
        }

        int getTid() {
            int offset = this.myOffset + 0;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTid(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 0, value);
        }

        int getUnitIndex() {
            int offset = this.myOffset + 4;
            return ClientData.this.buffer.getInt(offset);
        }

        void setUnitIndex(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 4, value);
        }

        int getTargetIndex() {
            int offset = this.myOffset + 8;
            return ClientData.this.buffer.getInt(offset);
        }

        void setTargetIndex(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 8, value);
        }

        int getX() {
            int offset = this.myOffset + 12;
            return ClientData.this.buffer.getInt(offset);
        }

        void setX(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 12, value);
        }

        int getY() {
            int offset = this.myOffset + 16;
            return ClientData.this.buffer.getInt(offset);
        }

        void setY(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 16, value);
        }

        int getExtra() {
            int offset = this.myOffset + 20;
            return ClientData.this.buffer.getInt(offset);
        }

        void setExtra(int value) {
            ClientData.this.buffer.putInt(this.myOffset + 20, value);
        }
    }
}

