/*
 * Decompiled with CFR 0.152.
 */
package Strategery.History;

import Lifecycle.With$;
import Strategery.History.HistoricalGame;
import Strategery.History.HistorySerializer$;
import Strategery.History.WriteFile$;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.math.Ordering$Long$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class HistoryLoader$ {
    public static HistoryLoader$ MODULE$;
    private final String filenameHistoryPrefix;
    private final String filenameEnemyToken;
    private final String filenameTemplate;
    private final String[] seedFilesDirectories;
    private final String[] directoriesInDecendingOrderOfRecency;

    static {
        new HistoryLoader$();
    }

    private String filenameHistoryPrefix() {
        return this.filenameHistoryPrefix;
    }

    private String filenameEnemyToken() {
        return this.filenameEnemyToken;
    }

    private String filenameTemplate() {
        return this.filenameTemplate;
    }

    private String loadFilesDirectory() {
        return With$.MODULE$.bwapiData().read();
    }

    private String saveFilesDirectory() {
        return With$.MODULE$.bwapiData().write();
    }

    private String[] seedFilesDirectories() {
        return this.seedFilesDirectories;
    }

    private String[] directoriesInDecendingOrderOfRecency() {
        return this.directoriesInDecendingOrderOfRecency;
    }

    public Seq<HistoricalGame> load() {
        Iterable<String> gamesSerialized = this.loadAllGames(Predef$.MODULE$.wrapRefArray((Object[])this.directoriesInDecendingOrderOfRecency()));
        Vector<HistoricalGame> games = HistorySerializer$.MODULE$.readGames(gamesSerialized);
        HashMap gamesByTimestamp = new HashMap();
        games.foreach((Function1<HistoricalGame, Object> & Serializable & scala.Serializable)game -> {
            gamesByTimestamp.update(BoxesRunTime.boxToLong(game.timestamp()), gamesByTimestamp.getOrElse(BoxesRunTime.boxToLong(game.timestamp()), (Function0<HistoricalGame> & Serializable & scala.Serializable)() -> game));
            return BoxedUnit.UNIT;
        });
        return (Seq)((SeqLike)gamesByTimestamp.values().toSeq().sortBy((Function1<HistoricalGame, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong(x$1.timestamp()), Ordering$Long$.MODULE$)).reverse();
    }

    public void save(Iterable<HistoricalGame> games) {
        Seq gamesToSave = (Seq)((IterableLike)((Iterable)games.filter((Function1<HistoricalGame, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(HistoryLoader$.$anonfun$save$1(x$2)))).toSeq().sortBy((Function1<HistoricalGame, Object> & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong(HistoryLoader$.$anonfun$save$2(x$3)), Ordering$Long$.MODULE$)).take(With$.MODULE$.configuration().maximumGamesHistoryPerOpponent());
        Vector<String> gamesToSaveSerialized = HistorySerializer$.MODULE$.writeGames(gamesToSave);
        this.saveGames(this.saveName(), gamesToSaveSerialized);
    }

    private String saveName() {
        return new StringBuilder(0).append(this.saveFilesDirectory()).append(this.filenameTemplate().replace(this.filenameEnemyToken(), With$.MODULE$.history().currentEnemyName())).toString();
    }

    private Iterable<String> loadAllGames(Iterable<String> directories) {
        return directories.flatMap((Function1<String, Iterable> & Serializable & scala.Serializable)directory -> MODULE$.loadGamesFromDirectory((String)directory), Iterable$.MODULE$.canBuildFrom());
    }

    private Iterable<String> loadGamesFromDirectory(String directory) {
        try {
            File[] files2 = new File(directory).listFiles();
            if (files2 == null) {
                files2 = (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
            }
            File[] historyFiles = (File[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])files2)).filter((Function1<File, Object> & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean(HistoryLoader$.$anonfun$loadGamesFromDirectory$1(x$4)));
            return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])historyFiles)).flatMap((Function1<File, Iterable> & Serializable & scala.Serializable)file -> MODULE$.loadGamesFromFile((File)file), Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringBuilder(31).append("Failed to read games directory ").append(directory).toString());
            With$.MODULE$.logger().onException(exception);
            return (Iterable)package$.MODULE$.Iterable().empty();
        }
    }

    private Iterable<String> loadGamesFromFile(File file) {
        BufferedReader reader = null;
        ArrayBuffer output = (ArrayBuffer)package$.MODULE$.Iterable().empty();
        String filename = "[Unknown file]";
        try {
            if (file.exists()) {
                filename = file.getName();
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                ArrayBuffer lines = new ArrayBuffer();
                boolean proceed = true;
                while (proceed) {
                    String nextLine = reader.readLine();
                    proceed = nextLine != null;
                    if (!proceed) continue;
                    lines.$plus$eq(nextLine);
                }
                output = lines;
            }
        }
        catch (Exception exception) {
            With$.MODULE$.logger().warn(new StringOps("Failed to load game history from %s").format(Predef$.MODULE$.genericWrapArray(new Object[]{filename})));
            With$.MODULE$.logger().onException(exception);
        }
        if (reader != null) {
            reader.close();
        }
        return output;
    }

    private void saveGames(String filename, Iterable<String> lines) {
        WriteFile$.MODULE$.apply(filename, lines, "save game history");
    }

    public static final /* synthetic */ boolean $anonfun$save$1(HistoricalGame x$2) {
        String string = x$2.enemyName();
        String string2 = With$.MODULE$.history().currentEnemyName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ long $anonfun$save$2(HistoricalGame x$3) {
        return -x$3.timestamp();
    }

    public static final /* synthetic */ boolean $anonfun$loadGamesFromDirectory$1(File x$4) {
        return x$4.getName().contains(MODULE$.filenameHistoryPrefix());
    }

    private HistoryLoader$() {
        MODULE$ = this;
        Integer arg$macro$1 = BoxesRunTime.boxToInteger(HistorySerializer$.MODULE$.formatVersion());
        this.filenameHistoryPrefix = new StringOps("_v%s_history_").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$1}));
        this.filenameEnemyToken = "{opponent}";
        String arg$macro$2 = this.filenameHistoryPrefix();
        String arg$macro$3 = this.filenameEnemyToken();
        this.filenameTemplate = new StringOps("%s%s.csv").format(Predef$.MODULE$.genericWrapArray(new Object[]{arg$macro$2, arg$macro$3}));
        this.seedFilesDirectories = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new String[]{"", "PretrainP", "PretrainT", "PretrainZ"})).map((Function1<String, String> & Serializable & scala.Serializable)relative -> new StringBuilder(0).append(With$.MODULE$.bwapiData().ai()).append((String)relative).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.directoriesInDecendingOrderOfRecency = (String[])new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])new String[]{this.loadFilesDirectory(), this.saveFilesDirectory()})).$plus$plus(new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])this.seedFilesDirectories())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }
}

