/*
 * Decompiled with CFR 0.152.
 */
package util;

public class Time {
    private int minutes;
    private int seconds;
    private int frames;

    public Time(int frames) {
        this.frames = frames;
        this.minutes = frames / 1440;
        this.seconds = frames / 24 % 60;
    }

    public Time(int minutes, int seconds) {
        this.minutes = minutes;
        this.seconds = seconds;
        this.frames = 24 * (minutes * 60 + seconds);
    }

    public String toString() {
        return this.minutes + ":" + (this.seconds < 10 ? "0" + this.seconds : Integer.valueOf(this.seconds));
    }

    public boolean lessThanOrEqual(Time t2) {
        return this.minutes < t2.minutes || this.minutes == t2.minutes && this.seconds <= t2.seconds;
    }

    public boolean greaterThan(Time t2) {
        return this.minutes > t2.minutes || this.minutes == t2.minutes && this.seconds > t2.seconds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Time)) {
            return false;
        }
        Time t2 = (Time)o;
        return this.frames == t2.frames;
    }

    public int hashCode() {
        return this.frames;
    }

    public int getFrames() {
        return this.frames;
    }
}

