/*
 * Decompiled with CFR 0.152.
 */
package map;

import bwapi.Game;
import bwapi.TilePosition;
import bwapi.UnitType;

public class TilePositionValidator {
    private final Game game;

    public TilePositionValidator(Game game) {
        this.game = game;
    }

    public boolean isWithinMap(TilePosition tp) {
        if (tp == null) {
            return false;
        }
        int mapWidth = this.game.mapWidth();
        int mapHeight = this.game.mapHeight();
        return tp.getX() >= 0 && tp.getX() < mapWidth && tp.getY() >= 0 && tp.getY() < mapHeight;
    }

    public boolean isWalkable(TilePosition tp) {
        if (!this.isWithinMap(tp)) {
            return false;
        }
        int startWalkX = tp.getX() * 4;
        int startWalkY = tp.getY() * 4;
        for (int dx = 0; dx < 4; ++dx) {
            for (int dy = 0; dy < 4; ++dy) {
                int walkX = startWalkX + dx;
                int walkY = startWalkY + dy;
                if (this.game.isWalkable(walkX, walkY)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isBuildable(TilePosition tp) {
        if (!this.isWithinMap(tp)) {
            return false;
        }
        return this.game.isBuildable(tp);
    }

    public boolean isBuildable(TilePosition tp, UnitType buildingType) {
        if (!this.isWithinMap(tp)) {
            return false;
        }
        for (int x = 0; x < buildingType.tileWidth(); ++x) {
            for (int y = 0; y < buildingType.tileHeight(); ++y) {
                TilePosition buildTile = new TilePosition(tp.getX() + x, tp.getY() + y);
                if (this.isWithinMap(buildTile) && this.game.isBuildable(buildTile, true)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isValid(TilePosition tp) {
        return this.isWalkable(tp);
    }
}

