/*
 * Decompiled with CFR 0.152.
 */
package map;

import bwapi.Color;
import bwapi.Game;
import bwapi.Point;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import bwem.Mineral;
import debug.Painters;
import information.BaseInfo;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import map.TilePositionValidator;
import util.PositionInterpolator;

public class BuildTiles {
    private Game game;
    private BWEM bwem;
    private BaseInfo baseInfo;
    private TilePositionValidator tilePositionValidator;
    private Painters painters;
    private HashSet<TilePosition> mediumBuildTiles = new HashSet();
    private HashSet<TilePosition> largeBuildTiles = new HashSet();
    private HashSet<TilePosition> mineralExlusionTiles = new HashSet();
    private HashSet<TilePosition> geyserExlusionTiles = new HashSet();
    private HashSet<TilePosition> ccExclusionTiles = new HashSet();
    private HashSet<TilePosition> frontBaseTiles = new HashSet();
    private HashSet<TilePosition> backBaseTiles = new HashSet();
    private TilePosition mainChokeBunker;
    private TilePosition naturalChokeBunker;
    private TilePosition closeBunkerTile;
    private TilePosition mainChokeTurret;
    private TilePosition naturalChokeTurret;
    private Base startingBase;

    public BuildTiles(Game game, BWEM bwem, BaseInfo baseInfo) {
        this.game = game;
        this.bwem = bwem;
        this.baseInfo = baseInfo;
        this.tilePositionValidator = new TilePositionValidator(game);
        this.painters = new Painters(game, bwem);
        this.startingBase = baseInfo.getStartingBase();
        this.generateBuildTiles();
    }

    private void generateBuildTiles() {
        this.mineralExclusionZone(this.startingBase);
        this.geyserExclusionZone(this.startingBase);
        this.ccExclusionZone(this.startingBase);
        this.generateFrontBaseTiles();
        this.generateBackBaseTiles();
        this.generateChokeBunkerTiles();
        this.generateCloseBunkerTile();
        this.generateChokeTurretTiles();
        this.generateLargeTiles();
        this.generateMediumTiles(this.backBaseTiles);
    }

    private void regenerateBuildTiles() {
        this.mineralExclusionZone(this.baseInfo.getNaturalBase());
        this.geyserExclusionZone(this.baseInfo.getNaturalBase());
        this.ccExclusionZone(this.baseInfo.getNaturalBase());
        this.generateMediumTiles(this.frontBaseTiles);
        this.generateMediumTiles(this.baseInfo.getNaturalTiles());
    }

    private void generateLargeTiles() {
        int yDiff;
        int gap = 3;
        ArrayList<TilePosition> sortedFrontTiles = new ArrayList<TilePosition>(this.frontBaseTiles);
        TilePosition chokePos = this.baseInfo.getMainChoke().getCenter().toTilePosition();
        TilePosition ccPos = this.baseInfo.getStartingBase().getLocation();
        int xDiff = Math.abs(chokePos.getX() - ccPos.getX());
        if (xDiff > (yDiff = Math.abs(chokePos.getY() - ccPos.getY()))) {
            sortedFrontTiles.sort(Comparator.comparingInt(Point::getX));
        } else {
            sortedFrontTiles.sort(Comparator.comparingInt(Point::getY));
        }
        for (TilePosition tile : sortedFrontTiles) {
            if (this.largeBuildTiles.size() >= 12) break;
            if (this.backBaseTiles.contains(tile) || !this.isValidBarracksStack(tile, UnitType.Terran_Barracks, gap)) continue;
            int stackX = tile.getX();
            int stackY = tile.getY();
            int adjacentX = stackX + UnitType.Terran_Barracks.tileWidth() + gap;
            TilePosition adjacentPos = new TilePosition(adjacentX, stackY);
            if (!this.frontBaseTiles.contains(adjacentPos) || !this.isValidBarracksStack(adjacentPos, UnitType.Terran_Barracks, gap)) continue;
            this.addBarracksStack(stackX, stackY, UnitType.Terran_Barracks);
            this.addBarracksStack(adjacentX, stackY, UnitType.Terran_Barracks);
        }
        if (this.largeBuildTiles.size() < 12) {
            for (TilePosition tile : sortedFrontTiles) {
                if (this.largeBuildTiles.size() >= 12) break;
                if (this.backBaseTiles.contains(tile) || this.intersectsExclusionZones(tile) || !this.isValidBarracksStack(tile, UnitType.Terran_Barracks, gap) || this.largeBuildTiles.contains(tile)) continue;
                this.addBarracksStack(tile.getX(), tile.getY(), UnitType.Terran_Barracks);
            }
        }
    }

    private boolean isValidBarracksStack(TilePosition topTile, UnitType barracksType, int gap) {
        int barWidth = barracksType.tileWidth();
        int barHeight = barracksType.tileHeight();
        TilePosition bottomTile = new TilePosition(topTile.getX(), topTile.getY() + barHeight);
        TilePosition bufferRow = new TilePosition(topTile.getX(), topTile.getY() + 2 * barHeight);
        return this.isValidBarracksPosition(topTile, barracksType, gap) && this.isValidBarracksPosition(bottomTile, barracksType, gap) && this.isValidBufferRow(bufferRow, barWidth);
    }

    private boolean isValidBufferRow(TilePosition start, int width) {
        for (int i = 0; i < width; ++i) {
            TilePosition bufferTile = new TilePosition(start.getX() + i, start.getY());
            if (this.tilePositionValidator.isWithinMap(bufferTile) && !this.intersectsExclusionZones(bufferTile) && this.tilePositionValidator.isWalkable(bufferTile)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidBarracksPosition(TilePosition tile, UnitType barracksType, int gap) {
        int y;
        int barWidth = barracksType.tileWidth();
        int barHeight = barracksType.tileHeight();
        for (int x = 0; x < barWidth; ++x) {
            for (y = 0; y < barHeight; ++y) {
                TilePosition checkTile = new TilePosition(tile.getX() + x, tile.getY() + y);
                if (!this.intersectsExclusionZones(checkTile) && this.tilePositionValidator.isBuildable(checkTile) && !this.intersectsExistingBuildTiles(checkTile, barracksType)) continue;
                return false;
            }
        }
        for (int bufferX = 0; bufferX < gap; ++bufferX) {
            for (y = 0; y < barHeight; ++y) {
                TilePosition bufferTile = new TilePosition(tile.getX() + barWidth + bufferX, tile.getY() + y);
                if (this.tilePositionValidator.isWithinMap(bufferTile) && !this.intersectsExclusionZones(bufferTile) && this.tilePositionValidator.isWalkable(bufferTile)) continue;
                return false;
            }
        }
        return !this.intersectsNeutralBuildings(tile, tile.x, tile.y);
    }

    private void addBarracksStack(int x, int y, UnitType barracksType) {
        int barHeight = barracksType.tileHeight();
        this.largeBuildTiles.add(new TilePosition(x, y));
        this.largeBuildTiles.add(new TilePosition(x, y + barHeight));
    }

    private void generateMediumTiles(HashSet<TilePosition> baseTiles) {
        UnitType depotType = UnitType.Terran_Supply_Depot;
        int gap = 1;
        ArrayList<TilePosition> sortedBackTiles = new ArrayList<TilePosition>(baseTiles);
        sortedBackTiles.sort(Comparator.comparingInt(Point::getY).thenComparingInt(Point::getX));
        HashSet<TilePosition> usedTiles = new HashSet<TilePosition>();
        for (TilePosition tile : sortedBackTiles) {
            TilePosition bottomTile;
            if (this.mediumBuildTiles.size() >= 24) break;
            if (usedTiles.contains(tile) || usedTiles.contains(bottomTile = new TilePosition(tile.getX(), tile.getY() + depotType.tileHeight())) || !baseTiles.contains(bottomTile) || this.blockedByExistingBuilding(tile, depotType) || !this.isValidSupplyDepotStack(tile, depotType, gap)) continue;
            this.mediumBuildTiles.add(tile);
            this.mediumBuildTiles.add(bottomTile);
            usedTiles.add(tile);
            usedTiles.add(bottomTile);
            for (int y = 0; y < 2 * depotType.tileHeight(); ++y) {
                usedTiles.add(new TilePosition(tile.getX() + depotType.tileWidth(), tile.getY() + y));
            }
        }
    }

    private boolean isValidSupplyDepotStack(TilePosition topTile, UnitType depotType, int gap) {
        int depotHeight = depotType.tileHeight();
        TilePosition bottomTile = new TilePosition(topTile.getX(), topTile.getY() + depotHeight);
        return this.isValidSupplyDepotPosition(topTile, depotType, gap) && this.isValidSupplyDepotPosition(bottomTile, depotType, gap);
    }

    private boolean isValidSupplyDepotPosition(TilePosition tile, UnitType depotType, int gap) {
        int depotWidth = depotType.tileWidth();
        int depotHeight = depotType.tileHeight();
        for (int x = 0; x < depotWidth; ++x) {
            for (int y = 0; y < depotHeight; ++y) {
                TilePosition checkTile = new TilePosition(tile.getX() + x, tile.getY() + y);
                if (!this.intersectsExclusionZones(checkTile) && this.tilePositionValidator.isBuildable(checkTile) && !this.intersectsExistingBuildTiles(checkTile, depotType)) continue;
                return false;
            }
        }
        for (int y = 0; y < depotHeight; ++y) {
            TilePosition gapTile = new TilePosition(tile.getX() + depotWidth, tile.getY() + y);
            if (this.tilePositionValidator.isWithinMap(gapTile) && !this.intersectsExclusionZones(gapTile) && this.tilePositionValidator.isWalkable(gapTile) && !this.isTileInPlannedBuildingFootprint(gapTile)) continue;
            return false;
        }
        return !this.intersectsNeutralBuildings(tile, tile.x, tile.y);
    }

    private boolean isTileInPlannedBuildingFootprint(TilePosition tile) {
        int buildingHeight;
        int buildingWidth;
        TilePosition ccPos = this.baseInfo.getStartingBase().getLocation();
        int ccX = ccPos.getX();
        int ccY = ccPos.getY();
        int ccWidth = UnitType.Terran_Command_Center.tileWidth();
        int ccHeight = UnitType.Terran_Command_Center.tileHeight();
        if (tile.getX() >= ccX && tile.getX() < ccX + ccWidth && tile.getY() >= ccY && tile.getY() < ccY + ccHeight) {
            return true;
        }
        if (this.bunkerOverlap(tile, this.mainChokeBunker) || this.bunkerOverlap(tile, this.naturalChokeBunker)) {
            return true;
        }
        for (TilePosition largeTile : this.largeBuildTiles) {
            buildingWidth = UnitType.Terran_Barracks.tileWidth();
            buildingHeight = UnitType.Terran_Barracks.tileHeight();
            if (tile.getX() < largeTile.getX() || tile.getX() >= largeTile.getX() + buildingWidth || tile.getY() < largeTile.getY() || tile.getY() >= largeTile.getY() + buildingHeight) continue;
            return true;
        }
        for (TilePosition mediumTile : this.mediumBuildTiles) {
            buildingWidth = UnitType.Terran_Supply_Depot.tileWidth();
            buildingHeight = UnitType.Terran_Supply_Depot.tileHeight();
            if (tile.getX() < mediumTile.getX() || tile.getX() >= mediumTile.getX() + buildingWidth || tile.getY() < mediumTile.getY() || tile.getY() >= mediumTile.getY() + buildingHeight) continue;
            return true;
        }
        return false;
    }

    private boolean bunkerOverlap(TilePosition startingTile, TilePosition bunkerPosition) {
        if (bunkerPosition == null) {
            return false;
        }
        int bunkerX = bunkerPosition.getX();
        int bunkerY = bunkerPosition.getY();
        int bunkerWidth = UnitType.Terran_Bunker.tileWidth();
        int bunkerHeight = UnitType.Terran_Bunker.tileHeight();
        return startingTile.getX() >= bunkerX && startingTile.getX() < bunkerX + bunkerWidth && startingTile.getY() >= bunkerY && startingTile.getY() < bunkerY + bunkerHeight;
    }

    private void generateCloseBunkerTile() {
        TilePosition chokePos = this.baseInfo.getMainChoke().getCenter().toTilePosition();
        TilePosition basePos = this.baseInfo.getStartingBase().getLocation();
        int firstMidX = (chokePos.getX() + basePos.getX()) / 2;
        int firstMidY = (chokePos.getY() + basePos.getY()) / 2;
        int finalMidX = (firstMidX + basePos.getX()) / 2;
        int finalMidY = (firstMidY + basePos.getY()) / 2;
        TilePosition finalMidPoint = new TilePosition(finalMidX, finalMidY);
        int searchRadius = 4;
        int closestDistance = Integer.MAX_VALUE;
        int bunkerWidth = UnitType.Terran_Bunker.tileWidth();
        int bunkerHeight = UnitType.Terran_Bunker.tileHeight();
        for (int x = finalMidX - searchRadius; x <= finalMidX + searchRadius; ++x) {
            for (int y = finalMidY - searchRadius; y <= finalMidY + searchRadius; ++y) {
                int distToMid;
                TilePosition testPos = new TilePosition(x, y);
                boolean validLocation = true;
                for (int bx = x; bx < x + bunkerWidth; ++bx) {
                    for (int by = y; by < y + bunkerHeight; ++by) {
                        TilePosition footprintTile = new TilePosition(bx, by);
                        if (!this.intersectsExclusionZones(footprintTile)) continue;
                        validLocation = false;
                        break;
                    }
                    if (!validLocation) break;
                }
                if (!validLocation || !this.tilePositionValidator.isBuildable(testPos, UnitType.Terran_Bunker) || (distToMid = testPos.getApproxDistance(finalMidPoint)) >= closestDistance) continue;
                closestDistance = distToMid;
                this.closeBunkerTile = testPos;
            }
        }
    }

    private void generateChokeBunkerTiles() {
        TilePosition baseTile;
        TilePosition chokeTile;
        TilePosition closerNatural;
        TilePosition naturalBunker;
        ChokePoint naturalChoke;
        ChokePoint mainChoke = this.baseInfo.getMainChoke();
        if (mainChoke != null) {
            TilePosition chokeTile2 = mainChoke.getCenter().toTilePosition();
            TilePosition baseTile2 = this.baseInfo.getStartingBase().getLocation();
            TilePosition closerMain = PositionInterpolator.interpolate(chokeTile2, baseTile2, 0.15);
            TilePosition mainBunker = this.findValidTileNear(closerMain, UnitType.Terran_Bunker);
            int minDist = Integer.MAX_VALUE;
            for (TilePosition candidate : this.frontBaseTiles) {
                int dist;
                if (!this.tilePositionValidator.isBuildable(candidate, UnitType.Terran_Bunker) || this.intersectsExclusionZones(candidate) || this.isTileInPlannedBuildingFootprint(candidate) || (dist = candidate.getApproxDistance(closerMain)) >= minDist) continue;
                minDist = dist;
                mainBunker = candidate;
            }
            if (mainBunker != null && this.frontBaseTiles.contains(mainBunker)) {
                this.mainChokeBunker = mainBunker;
            }
        }
        if ((naturalChoke = this.baseInfo.getNaturalChoke()) != null && (naturalBunker = this.findValidTileNear(closerNatural = PositionInterpolator.interpolate(chokeTile = naturalChoke.getCenter().toTilePosition(), baseTile = this.baseInfo.getNaturalBase().getLocation(), 0.0), UnitType.Terran_Bunker)) != null) {
            this.naturalChokeBunker = naturalBunker;
        }
    }

    private TilePosition findValidTileNear(TilePosition center, UnitType unitType) {
        int searchRadius = 6;
        for (int r = 0; r <= searchRadius; ++r) {
            for (int dx = -r; dx <= r; ++dx) {
                for (int dy = -r; dy <= r; ++dy) {
                    TilePosition test;
                    if (Math.abs(dx) != r && Math.abs(dy) != r || !this.tilePositionValidator.isBuildable(test = new TilePosition(center.getX() + dx, center.getY() + dy), unitType) || this.intersectsExclusionZones(test) || this.isTileInPlannedBuildingFootprint(test)) continue;
                    return test;
                }
            }
        }
        return null;
    }

    private void generateChokeTurretTiles() {
        ChokePoint naturalChoke;
        ChokePoint mainChoke = this.baseInfo.getMainChoke();
        if (mainChoke != null) {
            TilePosition chokeTile = mainChoke.getCenter().toTilePosition();
            TilePosition baseTile = this.baseInfo.getStartingBase().getLocation();
            TilePosition closerMain = PositionInterpolator.interpolate(chokeTile, baseTile, 0.25);
            TilePosition mainTurret = null;
            int minDist = Integer.MAX_VALUE;
            int searchRadius = 4;
            for (int x = closerMain.getX() - searchRadius; x <= closerMain.getX() + searchRadius; ++x) {
                for (int y = closerMain.getY() - searchRadius; y <= closerMain.getY() + searchRadius; ++y) {
                    int dist;
                    TilePosition candidate = new TilePosition(x, y);
                    int distToBunker = candidate.getApproxDistance(this.mainChokeBunker);
                    if (!this.tilePositionValidator.isBuildable(candidate, UnitType.Terran_Missile_Turret) || this.intersectsExclusionZones(candidate) || this.isTileInPlannedBuildingFootprint(candidate) || distToBunker <= 2 || (dist = candidate.getApproxDistance(closerMain)) >= minDist) continue;
                    minDist = dist;
                    mainTurret = candidate;
                }
            }
            if (mainTurret != null && this.frontBaseTiles.contains(mainTurret)) {
                this.mainChokeTurret = mainTurret;
            }
        }
        if ((naturalChoke = this.baseInfo.getNaturalChoke()) != null && this.naturalChokeBunker != null) {
            TilePosition chokeTile = naturalChoke.getCenter().toTilePosition();
            TilePosition baseTile = this.baseInfo.getNaturalBase().getLocation();
            TilePosition closerNatural = PositionInterpolator.interpolate(chokeTile, baseTile, 0.2);
            TilePosition naturalTurret = null;
            int minDist = Integer.MAX_VALUE;
            int searchRadius = 4;
            for (int x = closerNatural.getX() - searchRadius; x <= closerNatural.getX() + searchRadius; ++x) {
                for (int y = closerNatural.getY() - searchRadius; y <= closerNatural.getY() + searchRadius; ++y) {
                    TilePosition candidate = new TilePosition(x, y);
                    int distToBunker = candidate.getApproxDistance(this.naturalChokeBunker);
                    int distToNatural = candidate.getApproxDistance(closerNatural);
                    if (!this.tilePositionValidator.isBuildable(candidate, UnitType.Terran_Missile_Turret) || this.intersectsExclusionZones(candidate) || this.isTileInPlannedBuildingFootprint(candidate) || distToBunker <= 2 || distToNatural >= minDist) continue;
                    minDist = distToNatural;
                    naturalTurret = candidate;
                }
            }
            if (naturalTurret != null) {
                this.naturalChokeTurret = naturalTurret;
            }
        }
    }

    private boolean intersectsExistingBuildTiles(TilePosition newTilePosition, UnitType unitType) {
        int y;
        int x;
        int existingYEnd;
        int existingXEnd;
        int existingYStart;
        int existingXStart;
        int y2;
        int x2;
        boolean inCCBuffer;
        int newX = newTilePosition.getX();
        int newY = newTilePosition.getY();
        int typeWidth = unitType.tileWidth();
        int typeHeight = unitType.tileHeight();
        TilePosition ccPosition = this.baseInfo.getStartingBase().getLocation();
        int ccX = ccPosition.getX();
        int ccY = ccPosition.getY();
        int ccWidth = UnitType.Terran_Command_Center.tileWidth();
        int ccHeight = UnitType.Terran_Command_Center.tileHeight();
        boolean bl = inCCBuffer = newX >= ccX - 2 && newX < ccX + ccWidth + 2 && newY >= ccY - 2 && newY < ccY + ccHeight + 2;
        if (inCCBuffer) {
            return true;
        }
        if (this.closeBunkerTile != null) {
            int bunkerXStart = this.closeBunkerTile.getX();
            int bunkerYStart = this.closeBunkerTile.getY();
            int bunkerXEnd = this.closeBunkerTile.getX() + UnitType.Terran_Bunker.tileWidth();
            int bunkerYEnd = this.closeBunkerTile.getY() + UnitType.Terran_Bunker.tileHeight();
            for (x2 = newX; x2 < newX + typeWidth; ++x2) {
                for (y2 = newY; y2 < newY + typeHeight; ++y2) {
                    if (x2 < bunkerXStart || x2 >= bunkerXEnd || y2 < bunkerYStart || y2 >= bunkerYEnd) continue;
                    return true;
                }
            }
        }
        if (this.mainChokeBunker != null) {
            int mainChokeBunkerX = this.mainChokeBunker.getX();
            int mainChokeBunkerY = this.mainChokeBunker.getY();
            int mainChokeXEnd = mainChokeBunkerX + UnitType.Terran_Bunker.tileWidth();
            int mainChokeYEnd = mainChokeBunkerY + UnitType.Terran_Bunker.tileHeight();
            for (x2 = newX; x2 < newX + typeWidth; ++x2) {
                for (y2 = newY; y2 < newY + typeHeight; ++y2) {
                    if (x2 < mainChokeBunkerX || x2 >= mainChokeXEnd || y2 < mainChokeBunkerY || y2 >= mainChokeYEnd) continue;
                    return true;
                }
            }
        }
        if (this.mainChokeTurret != null) {
            int mainChokeTurretX = this.mainChokeTurret.getX();
            int mainChokeTurretY = this.mainChokeTurret.getY();
            int mainChokeTurretXEnd = mainChokeTurretX + UnitType.Terran_Missile_Turret.tileWidth();
            int mainChokeTurretYEnd = mainChokeTurretY + UnitType.Terran_Missile_Turret.tileHeight();
            for (x2 = newX; x2 < newX + typeWidth; ++x2) {
                for (y2 = newY; y2 < newY + typeHeight; ++y2) {
                    if (x2 < mainChokeTurretX || x2 >= mainChokeTurretXEnd || y2 < mainChokeTurretY || y2 >= mainChokeTurretYEnd) continue;
                    return true;
                }
            }
        }
        for (TilePosition existingTile : this.largeBuildTiles) {
            existingXStart = existingTile.getX();
            existingYStart = existingTile.getY();
            existingXEnd = existingXStart + UnitType.Terran_Engineering_Bay.tileWidth();
            existingYEnd = existingYStart + UnitType.Terran_Engineering_Bay.tileHeight();
            for (x = newX; x < newX + typeWidth; ++x) {
                for (y = newY; y < newY + typeHeight; ++y) {
                    if (x < existingXStart || x >= existingXEnd || y < existingYStart || y >= existingYEnd) continue;
                    return true;
                }
            }
            int bufferXStart = existingXEnd;
            int bufferXEnd = existingXEnd + 3;
            int bufferYStart = existingYStart;
            int bufferYEnd = existingYEnd;
            for (int x3 = newX; x3 < newX + typeWidth; ++x3) {
                for (int y3 = newY; y3 < newY + typeHeight; ++y3) {
                    if (x3 < bufferXStart || x3 >= bufferXEnd || y3 < bufferYStart || y3 >= bufferYEnd) continue;
                    return true;
                }
            }
        }
        for (TilePosition existingTile : this.mediumBuildTiles) {
            existingXStart = existingTile.getX();
            existingYStart = existingTile.getY();
            existingXEnd = existingTile.getX() + UnitType.Terran_Supply_Depot.tileWidth();
            existingYEnd = existingTile.getY() + UnitType.Terran_Supply_Depot.tileHeight();
            for (x = newX; x < newX + typeWidth; ++x) {
                for (y = newY; y < newY + typeHeight; ++y) {
                    if (x < existingXStart || x >= existingXEnd || y < existingYStart || y >= existingYEnd) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean intersectsNeutralBuildings(TilePosition tile, int width, int height) {
        for (Unit neutralBuilding : this.game.getNeutralUnits()) {
            if (!neutralBuilding.getType().isBuilding() || neutralBuilding.getType() == UnitType.Resource_Vespene_Geyser || neutralBuilding.getType() == UnitType.Resource_Mineral_Field) continue;
            TilePosition buildingTile = neutralBuilding.getTilePosition();
            int buildingWidth = neutralBuilding.getType().tileWidth();
            int buildingHeight = neutralBuilding.getType().tileHeight();
            if (tile.getX() >= buildingTile.getX() + buildingWidth || tile.getX() + width <= buildingTile.getX() || tile.getY() >= buildingTile.getY() + buildingHeight || tile.getY() + height <= buildingTile.getY()) continue;
            return true;
        }
        return false;
    }

    private void mineralExclusionZone(Base base) {
        Point lowestXTile = null;
        Point highestXTile = null;
        Point lowestYTile = null;
        Point highestYTile = null;
        TilePosition commandCenterTile = base.getLocation();
        for (Mineral mineral : this.baseInfo.getStartingMinerals()) {
            TilePosition mineralTile = mineral.getUnit().getTilePosition();
            if (lowestXTile == null || mineralTile.getX() < lowestXTile.getX()) {
                lowestXTile = mineralTile;
            }
            if (highestXTile == null || mineralTile.getX() > highestXTile.getX()) {
                highestXTile = mineralTile;
            }
            if (lowestYTile == null || mineralTile.getY() < lowestYTile.getY()) {
                lowestYTile = mineralTile;
            }
            if (highestYTile != null && mineralTile.getY() <= highestYTile.getY()) continue;
            highestYTile = mineralTile;
        }
        int boxStartX = Math.min(lowestXTile.getX(), commandCenterTile.getX());
        int boxEndX = Math.max(highestXTile.getX() + 1, commandCenterTile.getX());
        int boxStartY = Math.min(lowestYTile.getY(), commandCenterTile.getY());
        int boxEndY = Math.max(highestYTile.getY(), commandCenterTile.getY());
        for (int x = boxStartX; x <= boxEndX; ++x) {
            for (int y = boxStartY; y <= boxEndY; ++y) {
                this.mineralExlusionTiles.add(new TilePosition(x, y));
            }
        }
    }

    private void geyserExclusionZone(Base base) {
        TilePosition geyserTile = base.getGeysers().iterator().next().getUnit().getTilePosition();
        int geyserX = geyserTile.getX();
        int geyserY = geyserTile.getY();
        TilePosition commandCenterTile = this.baseInfo.getStartingBase().getLocation();
        int boxStartX = Math.min(geyserX, commandCenterTile.getX());
        int boxEndX = Math.max(geyserX + 3, commandCenterTile.getX());
        int boxStartY = Math.min(geyserY, commandCenterTile.getY());
        int boxEndY = Math.max(geyserY + 2, commandCenterTile.getY());
        for (int x = boxStartX; x <= boxEndX; ++x) {
            for (int y = boxStartY; y <= boxEndY; ++y) {
                this.geyserExlusionTiles.add(new TilePosition(x, y));
            }
        }
    }

    private void ccExclusionZone(Base base) {
        TilePosition commandCenterTile = base.getLocation();
        int ccX = commandCenterTile.getX();
        int ccY = commandCenterTile.getY();
        int ccX_end = ccX + UnitType.Terran_Command_Center.tileWidth();
        int ccHeight = UnitType.Terran_Command_Center.tileHeight();
        for (int x = ccX_end; x < ccX_end + 3; ++x) {
            for (int y = ccY; y < ccY + ccHeight; ++y) {
                this.ccExclusionTiles.add(new TilePosition(x, y));
            }
        }
    }

    private boolean intersectsExclusionZones(TilePosition tilePosition) {
        return this.geyserExlusionTiles.contains(tilePosition) || this.mineralExlusionTiles.contains(tilePosition) || this.ccExclusionTiles.contains(tilePosition);
    }

    private void generateFrontBaseTiles() {
        HashSet<TilePosition> baseTiles = new HashSet<TilePosition>(this.baseInfo.getBaseTiles());
        TilePosition chokePos = this.baseInfo.getMainChoke().getCenter().toTilePosition();
        TilePosition ccPos = this.baseInfo.getStartingBase().getLocation();
        int xDiff = Math.abs(chokePos.getX() - ccPos.getX());
        int yDiff = Math.abs(chokePos.getY() - ccPos.getY());
        for (TilePosition tilePosition : baseTiles) {
            if (this.geyserExlusionTiles.contains(tilePosition) || this.mineralExlusionTiles.contains(tilePosition)) continue;
            if (xDiff > yDiff) {
                if (chokePos.getX() < ccPos.getX() && tilePosition.getX() < ccPos.getX()) {
                    this.frontBaseTiles.add(tilePosition);
                    continue;
                }
                if (chokePos.getX() <= ccPos.getX() || tilePosition.getX() <= ccPos.getX()) continue;
                this.frontBaseTiles.add(tilePosition);
                continue;
            }
            if (chokePos.getY() < ccPos.getY() && tilePosition.getY() < ccPos.getY()) {
                this.frontBaseTiles.add(tilePosition);
                continue;
            }
            if (chokePos.getY() <= ccPos.getY() || tilePosition.getY() <= ccPos.getY()) continue;
            this.frontBaseTiles.add(tilePosition);
        }
    }

    private void generateBackBaseTiles() {
        HashSet<TilePosition> baseTiles = new HashSet<TilePosition>(this.baseInfo.getBaseTiles());
        for (TilePosition tilePosition : baseTiles) {
            if (this.geyserExlusionTiles.contains(tilePosition) || this.mineralExlusionTiles.contains(tilePosition) || this.frontBaseTiles.contains(tilePosition)) continue;
            this.backBaseTiles.add(tilePosition);
        }
    }

    private boolean blockedByExistingBuilding(TilePosition tilePosition, UnitType buildingType) {
        int width = buildingType.tileWidth();
        int height = buildingType.tileHeight();
        for (int x = tilePosition.getX(); x < tilePosition.getX() + width; ++x) {
            for (int y = tilePosition.getY(); y < tilePosition.getY() + height; ++y) {
                TilePosition tile = new TilePosition(x, y);
                if (!this.tilePositionValidator.isWithinMap(tile)) {
                    return true;
                }
                if (this.game.canBuildHere(tile, buildingType, null)) continue;
                return true;
            }
        }
        return false;
    }

    public void updateRemainingTiles(TilePosition tilePosition) {
        this.largeBuildTiles.removeIf(tile -> tile.equals(tilePosition));
        this.mediumBuildTiles.removeIf(tile -> tile.equals(tilePosition));
    }

    public HashSet<TilePosition> getMediumBuildTiles() {
        return this.mediumBuildTiles;
    }

    public HashSet<TilePosition> getLargeBuildTiles() {
        return this.largeBuildTiles;
    }

    public TilePosition getCloseBunkerTile() {
        return this.closeBunkerTile;
    }

    public TilePosition getNaturalChokeBunker() {
        return this.naturalChokeBunker;
    }

    public TilePosition getMainChokeBunker() {
        return this.mainChokeBunker;
    }

    public TilePosition getMainChokeTurret() {
        return this.mainChokeTurret;
    }

    public TilePosition getNaturalChokeTurret() {
        return this.naturalChokeTurret;
    }

    public void onFrame() {
        if (this.mediumBuildTiles.isEmpty() || this.mediumBuildTiles.size() == 1) {
            this.regenerateBuildTiles();
        }
        this.painters.paintPaintBunkerTile(this.closeBunkerTile);
        this.painters.paintPaintBunkerTile(this.mainChokeBunker);
        this.painters.paintPaintBunkerTile(this.naturalChokeBunker);
        this.painters.paintMissileTile(this.mainChokeTurret);
        this.painters.paintMissileTile(this.naturalChokeTurret);
        this.painters.paintAvailableBuildTiles(this.largeBuildTiles, 0, "Production");
        this.painters.paintAvailableBuildTiles(this.mediumBuildTiles, 15, "Medium");
        this.painters.paintLargeBuildTiles(this.largeBuildTiles);
        this.painters.paintMediumBuildTiles(this.mediumBuildTiles, Color.Blue);
    }

    public void onUnitComplete(Unit unit) {
        if (!unit.getType().isBuilding()) {
            return;
        }
        for (TilePosition tilePosition : this.largeBuildTiles) {
            if (!unit.getTilePosition().equals(tilePosition)) continue;
            this.largeBuildTiles.removeIf(tile -> tile.equals(tilePosition));
            break;
        }
        for (TilePosition tilePosition : this.mediumBuildTiles) {
            if (!unit.getTilePosition().equals(tilePosition)) continue;
            this.mediumBuildTiles.removeIf(tile -> tile.equals(tilePosition));
            break;
        }
    }
}

