/*
 * Decompiled with CFR 0.152.
 */
package map;

import bwapi.Position;
import bwem.Base;
import bwem.ChokePoint;
import information.BaseInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AllBasePaths {
    private BaseInfo baseInfo;
    private HashMap<Base, List<Position>> pathLists = new HashMap();

    public AllBasePaths(BaseInfo baseInfo) {
        this.baseInfo = baseInfo;
        this.calculateAllPaths();
    }

    private void calculateAllPaths() {
        Position startingBasePos = this.baseInfo.getStartingBase().getCenter();
        for (Base base : this.baseInfo.getMapBases()) {
            if (this.baseInfo.getStartingBase().equals(base)) continue;
            Position nearestWalkable = this.baseInfo.getPathFinding().findNearestWalkable(base.getCenter());
            List<Position> path = this.baseInfo.getPathFinding().findPath(startingBasePos, nearestWalkable);
            if (path == null || path.isEmpty()) continue;
            for (ChokePoint choke : this.baseInfo.getChokePoints()) {
                Position chokePos = choke.getCenter().toPosition();
                for (Position pathPos : path) {
                    if (!(chokePos.getDistance(pathPos) < 175.0)) continue;
                    if (!this.pathLists.containsKey(base)) {
                        this.pathLists.put(base, new ArrayList());
                    }
                    this.pathLists.get(base).add(chokePos);
                }
            }
        }
    }

    public HashMap<Base, List<Position>> getPathLists() {
        return this.pathLists;
    }
}

