/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups.units;

import bwapi.Game;
import bwapi.Unit;
import bwapi.UnitType;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.UnitStatus;

public class Wraith
extends CombatUnits {
    private EnemyInformation enemyInformation;
    private BaseInfo baseInfo;

    public Wraith(Game game, EnemyInformation enemyInformation, Unit unit) {
        super(game, unit);
        this.enemyInformation = enemyInformation;
        this.baseInfo = enemyInformation.getBaseInfo();
        this.unitStatus = UnitStatus.HUNTING;
        this.priorityTargets.add(UnitType.Protoss_Shuttle);
        this.priorityTargets.add(UnitType.Protoss_Probe);
    }

    @Override
    public void attack() {
        int frameCount = this.game.getFrameCount();
        if (frameCount % 12 != 0) {
            return;
        }
        if (this.enemyUnit == null) {
            return;
        }
        if (this.priorityTargetExists) {
            this.setUnitStatus(UnitStatus.HUNTING);
        } else {
            this.setUnitStatus(UnitStatus.ATTACK);
        }
        if (this.unit.getDistance(this.enemyUnit.getEnemyPosition()) > 128) {
            this.unit.move(this.enemyUnit.getEnemyPosition());
        } else {
            this.unit.attack(this.enemyUnit.getEnemyUnit());
        }
    }

    @Override
    public void hunting() {
        if (this.enemyUnit != null) {
            this.attack();
        } else {
            this.setUnitStatus(UnitStatus.ATTACK);
        }
    }
}

