/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups.units;

import bwapi.Game;
import bwapi.Position;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwapi.WeaponType;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import java.util.HashSet;
import java.util.Random;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.UnitStatus;

public class SiegeTank
extends CombatUnits {
    private EnemyInformation enemyInformation;
    private BaseInfo baseInfo;
    private UnitType defaultMode = UnitType.Terran_Siege_Tank_Tank_Mode;
    private HashSet<TilePosition> mainEdgeTiles = new HashSet();
    private HashSet<TilePosition> combinedTankTiles = new HashSet();
    private HashSet<TilePosition> backupSiegeTiles = new HashSet();
    private TilePosition siegeTile = null;
    private boolean foundSiegeTile = false;
    private static final int SIEGE_RANGE = 384;

    public SiegeTank(Game game, EnemyInformation enemyInformation, Unit unit) {
        super(game, unit);
        this.enemyInformation = enemyInformation;
        this.baseInfo = enemyInformation.getBaseInfo();
        this.mainEdgeTiles = this.baseInfo.getMainCliffEdge();
        this.combinedTankTiles = this.baseInfo.getCombinedTankTiles();
        this.backupSiegeTiles = this.baseInfo.getBackupMainSiegeTiles();
    }

    @Override
    public void attack() {
        if (this.enemyUnit == null) {
            return;
        }
        this.siegeLogic();
        this.unit.attack(this.enemyUnit.getEnemyPosition());
    }

    @Override
    public void retreat() {
        if (this.enemyUnit == null) {
            return;
        }
        if (this.enemyUnit.getEnemyUnit().getDistance(this.unit) > 128) {
            super.setUnitStatus(UnitStatus.ATTACK);
            return;
        }
        if (super.getRallyPoint().toPosition().getApproxDistance(this.unit.getPosition()) < 128) {
            super.setUnitStatus(UnitStatus.RALLY);
            return;
        }
        if (this.kiteThreshold()) {
            if (this.unit.getGroundWeaponCooldown() == 0) {
                this.unit.attack(this.rallyPoint.toPosition());
                return;
            }
            this.unit.move(this.rallyPoint.toPosition());
            return;
        }
        this.unit.attack(this.rallyPoint.toPosition());
    }

    @Override
    public void defend() {
        if (this.enemyUnit == null) {
            this.setUnitStatus(UnitStatus.RALLY);
            return;
        }
        if (this.kiteThreshold()) {
            if (this.unit.getGroundWeaponCooldown() == 0) {
                this.unit.attack(this.rallyPoint.toPosition());
                return;
            }
            int maxRange = this.weaponRange();
            Position kitePos = this.getKitePos(maxRange);
            this.unit.move(kitePos);
            return;
        }
        this.siegeLogic();
        this.unit.attack(this.enemyUnit.getEnemyPosition());
    }

    @Override
    public void rally() {
        if (this.rallyPoint == null) {
            return;
        }
        if (this.isSieged()) {
            super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
            this.unit.unsiege();
        }
        if (super.getRallyPoint().getApproxDistance(this.unit.getTilePosition()) < 128 && this.enemyUnit != null) {
            super.setUnitStatus(UnitStatus.DEFEND);
            return;
        }
        if (!this.enemyInBase && this.canSiege()) {
            super.setUnitType(UnitType.Terran_Siege_Tank_Siege_Mode);
            super.setUnitStatus(UnitStatus.SIEGEDEF);
        }
        this.unit.attack(this.rallyPoint.toPosition());
    }

    public void siegeDef() {
        if (this.siegeTile == null) {
            this.setSiegeTile();
        }
        if (this.foundSiegeTile) {
            if (this.unit.getDistance(this.siegeTile.toPosition()) > 32) {
                this.unit.move(this.siegeTile.toPosition());
            } else if (!this.isSieged() && this.canSiege()) {
                super.setUnitType(UnitType.Terran_Siege_Tank_Siege_Mode);
                this.unit.siege();
            }
        }
        this.siegeLogic();
    }

    private void setSiegeTile() {
        if (!this.combinedTankTiles.isEmpty() && this.baseInfo.isNaturalOwned()) {
            this.pickSiegeDefTile(this.combinedTankTiles);
        } else if (!this.mainEdgeTiles.isEmpty()) {
            this.pickSiegeDefTile(this.mainEdgeTiles);
        } else {
            this.pickSiegeDefTile(this.backupSiegeTiles);
        }
    }

    private void pickSiegeDefTile(HashSet<TilePosition> tileSet) {
        Random rand = new Random(this.unitID);
        int index = rand.nextInt(tileSet.size());
        TilePosition targetTile = null;
        int i = 0;
        for (TilePosition tile : tileSet) {
            if (i == index) {
                targetTile = tile;
                break;
            }
            ++i;
        }
        if (targetTile != null) {
            this.siegeTile = targetTile;
            this.foundSiegeTile = true;
        }
    }

    private void siegeLogic() {
        if (this.enemyUnit == null) {
            return;
        }
        switch (super.getUnitStatus()) {
            case ATTACK: {
                if (!this.isSieged() && this.enemyUnit.getEnemyUnit().getDistance(this.unit) < 128) {
                    super.setUnitStatus(UnitStatus.RETREAT);
                }
                if (!this.isSieged() || this.enemyUnit.getEnemyUnit().getDistance(this.unit) >= 128) break;
                super.setUnitStatus(UnitStatus.RETREAT);
                super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
                this.unit.unsiege();
                break;
            }
            case DEFEND: {
                if (!this.isSieged() || this.enemyUnit.getEnemyUnit().getDistance(this.unit) >= 128) break;
                super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
                this.unit.unsiege();
                break;
            }
            case RETREAT: {
                if (!this.isSieged()) break;
                super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
                this.unit.unsiege();
                break;
            }
            case SIEGEDEF: {
                if (this.isSieged() && this.enemyUnit.getEnemyUnit().getDistance(this.unit) < 128) {
                    super.setUnitStatus(UnitStatus.RETREAT);
                    super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
                    this.unit.unsiege();
                }
                if (!this.isSieged() || !this.enemyInBase || this.enemyUnit.getEnemyUnit().getDistance(this.unit) <= 384) break;
                super.setUnitStatus(UnitStatus.DEFEND);
                super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
                this.unit.unsiege();
            }
        }
        if (this.enemyUnit.getEnemyUnit().getDistance(this.unit) < 384 && !this.isSieged() && this.enemyUnit.getEnemyUnit().getDistance(this.unit) > 128 && this.canSiege()) {
            super.setUnitType(UnitType.Terran_Siege_Tank_Siege_Mode);
            this.unit.siege();
        }
        if (this.enemyUnit.getEnemyUnit().getDistance(this.unit) > 384 && this.isSieged()) {
            super.setUnitType(UnitType.Terran_Siege_Tank_Tank_Mode);
            this.unit.unsiege();
        }
    }

    private boolean kiteThreshold() {
        int maxRange = this.weaponRange();
        double kiteThreshold = (double)maxRange * 0.2;
        Position enemyPosition = this.enemyUnit.getEnemyPosition();
        Position unitPosition = this.unit.getPosition();
        double distanceToEnemy = unitPosition.getDistance(enemyPosition);
        return distanceToEnemy < kiteThreshold;
    }

    private Position getKitePos(int maxRange) {
        Position enemyPosition = this.enemyUnit.getEnemyPosition();
        Position unitPosition = this.unit.getPosition();
        double dx = unitPosition.getX() - enemyPosition.getX();
        double dy = unitPosition.getY() - enemyPosition.getY();
        double length = Math.sqrt(dx * dx + dy * dy);
        double scale = (double)maxRange / length;
        int targetX = (int)((double)enemyPosition.getX() + dx * scale);
        int targetY = (int)((double)enemyPosition.getY() + dy * scale);
        Position kitePos = new Position(targetX, targetY);
        return kitePos;
    }

    private boolean canSiege() {
        return this.game.self().hasResearched(TechType.Tank_Siege_Mode);
    }

    public boolean isSieged() {
        return this.unit.getType() == UnitType.Terran_Siege_Tank_Siege_Mode;
    }

    private int weaponRange() {
        WeaponType weaponType = this.unit.getType().groundWeapon();
        return weaponType.maxRange();
    }

    public UnitType getDefaultMode() {
        return this.defaultMode;
    }
}

