/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups.units;

import bwapi.Game;
import bwapi.Position;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UpgradeType;
import bwapi.WeaponType;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.UnitStatus;

public class Marine
extends CombatUnits {
    private static final int UPGRADE_RANGE = 32;

    public Marine(Game game, Unit unit) {
        super(game, unit);
    }

    @Override
    public void attack() {
        if (this.enemyUnit == null) {
            return;
        }
        if (super.isInBunker()) {
            this.inBunker = false;
        }
        this.kite();
        if (this.minimnumThreshold()) {
            return;
        }
        if (!this.unit.isStimmed() && this.unit.isAttacking()) {
            this.unit.useTech(TechType.Stim_Packs);
        }
        if (!this.unit.isStartingAttack() && this.unit.getGroundWeaponCooldown() == 0 && !this.unit.isAttackFrame()) {
            this.unit.attack(this.enemyUnit.getEnemyPosition());
        }
    }

    @Override
    public void defend() {
        if (this.enemyUnit == null) {
            this.setUnitStatus(UnitStatus.RALLY);
            return;
        }
        this.kite();
        if (this.minimnumThreshold()) {
            return;
        }
        if (!this.unit.isStimmed() && this.unit.isAttacking()) {
            this.unit.useTech(TechType.Stim_Packs);
        }
        if (!this.unit.isStartingAttack() && this.unit.getGroundWeaponCooldown() == 0 && !this.unit.isAttackFrame()) {
            this.unit.attack(this.enemyUnit.getEnemyPosition());
        }
    }

    @Override
    public void retreat() {
        if (this.enemyUnit == null || this.enemyUnit.getEnemyPosition() == null) {
            return;
        }
        if (!this.unit.isStimmed() && this.unit.isAttacking()) {
            this.unit.useTech(TechType.Stim_Packs);
        }
        if (!this.unit.isStartingAttack() && this.unit.getGroundWeaponCooldown() == 0 && !this.unit.isAttackFrame()) {
            this.unit.attack(this.enemyUnit.getEnemyPosition());
        }
        if (!this.inRangeOfThreat) {
            this.setUnitStatus(UnitStatus.ATTACK);
        }
    }

    private void kite() {
        if (this.enemyUnit.getEnemyType().isBuilding()) {
            return;
        }
        int maxRange = this.weaponRange();
        double kiteThreshold = (double)maxRange * 0.9;
        Position enemyPosition = this.enemyUnit.getEnemyPosition();
        Position unitPosition = this.unit.getPosition();
        double distanceToEnemy = unitPosition.getDistance(enemyPosition);
        if (distanceToEnemy < kiteThreshold) {
            double dx = unitPosition.getX() - enemyPosition.getX();
            double dy = unitPosition.getY() - enemyPosition.getY();
            double length = Math.sqrt(dx * dx + dy * dy);
            double scale = (double)maxRange / length;
            int targetX = (int)((double)enemyPosition.getX() + dx * scale);
            int targetY = (int)((double)enemyPosition.getY() + dy * scale);
            Position kitePos = new Position(targetX, targetY);
            this.unit.move(kitePos);
        }
    }

    private boolean minimnumThreshold() {
        double halfRange = (double)this.weaponRange() * 0.25;
        Position enemyPosition = this.enemyUnit.getEnemyPosition();
        Position unitPosition = this.unit.getPosition();
        double distanceToEnemy = unitPosition.getDistance(enemyPosition);
        return distanceToEnemy < halfRange;
    }

    private int weaponRange() {
        WeaponType weaponType = this.unit.getType().groundWeapon();
        if (this.game.self().getUpgradeLevel(UpgradeType.U_238_Shells) > 0) {
            return weaponType.maxRange() + 32;
        }
        return weaponType.maxRange();
    }
}

