/*
 * Decompiled with CFR 0.152.
 */
package macro.unitgroups;

import bwapi.Game;
import bwapi.Unit;
import information.enemy.EnemyInformation;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.units.Battlecruiser;
import macro.unitgroups.units.Comsat;
import macro.unitgroups.units.Firebat;
import macro.unitgroups.units.Ghost;
import macro.unitgroups.units.Goliath;
import macro.unitgroups.units.Marine;
import macro.unitgroups.units.Medic;
import macro.unitgroups.units.Scan;
import macro.unitgroups.units.ScienceVessel;
import macro.unitgroups.units.SiegeTank;
import macro.unitgroups.units.SpiderMines;
import macro.unitgroups.units.Valkyrie;
import macro.unitgroups.units.Vulture;
import macro.unitgroups.units.Wraith;

public class CombatUnitCreator {
    private Game game;
    private EnemyInformation enemyInformation;

    public CombatUnitCreator(Game game, EnemyInformation enemyInformation) {
        this.game = game;
        this.enemyInformation = enemyInformation;
    }

    public CombatUnits createCombatUnit(Unit unit) {
        switch (unit.getType()) {
            case Terran_Marine: {
                return new Marine(this.game, unit);
            }
            case Terran_Medic: {
                return new Medic(this.game, unit);
            }
            case Terran_Firebat: {
                return new Firebat(this.game, unit);
            }
            case Terran_Ghost: {
                return new Ghost(this.game, unit);
            }
            case Terran_Vulture: {
                return new Vulture(this.game, this.enemyInformation, unit);
            }
            case Terran_Siege_Tank_Tank_Mode: {
                return new SiegeTank(this.game, this.enemyInformation, unit);
            }
            case Terran_Goliath: {
                return new Goliath(this.game, unit);
            }
            case Terran_Battlecruiser: {
                return new Battlecruiser(this.game, unit);
            }
            case Terran_Wraith: {
                return new Wraith(this.game, this.enemyInformation, unit);
            }
            case Terran_Valkyrie: {
                return new Valkyrie(this.game, unit);
            }
            case Terran_Science_Vessel: {
                return new ScienceVessel(this.game, unit);
            }
            case Terran_Comsat_Station: {
                return new Comsat(this.game, unit);
            }
            case Spell_Scanner_Sweep: {
                return new Scan(this.game, unit);
            }
            case Terran_Vulture_Spider_Mine: {
                return new SpiderMines(this.game, unit);
            }
        }
        return new CombatUnits(this.game, unit);
    }
}

