/*
 * Decompiled with CFR 0.152.
 */
package macro;

import bwapi.Game;
import bwapi.Position;
import bwapi.TechType;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import debug.Painters;
import information.BaseInfo;
import information.Scouting;
import information.enemy.EnemyInformation;
import information.enemy.EnemyUnits;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import macro.ClosestUnit;
import macro.RallyPoint;
import macro.unitgroups.CombatUnitCreator;
import macro.unitgroups.CombatUnits;
import macro.unitgroups.UnitStatus;
import macro.unitgroups.units.SiegeTank;
import macro.unitgroups.units.Vulture;
import map.PathFinding;
import util.Time;

public class UnitManager {
    private EnemyInformation enemyInformation;
    private BaseInfo baseInfo;
    private Game game;
    private CombatUnitCreator combatUnitCreator;
    private Painters painters;
    private Scouting scouting;
    private RallyPoint rallyPoint;
    private PathFinding pathFinding;
    private HashSet<CombatUnits> combatUnits = new HashSet();
    private HashMap<UnitType, Integer> unitCount = new HashMap();
    private HashMap<Base, CombatUnits> designatedScouts = new HashMap();
    private int bunkerLoad = 0;
    private int scouts = 0;
    private int rallyClock = 0;
    private Unit bunker = null;
    private boolean bunkerunLoaded = false;
    private boolean beingAllInned = false;
    private boolean defendedAllIn = false;

    public UnitManager(EnemyInformation enemyInformation, BaseInfo baseInfo, Game game, Scouting scouting) {
        this.enemyInformation = enemyInformation;
        this.baseInfo = baseInfo;
        this.game = game;
        this.scouting = scouting;
        this.combatUnitCreator = new CombatUnitCreator(game, enemyInformation);
        this.pathFinding = baseInfo.getPathFinding();
        this.rallyPoint = new RallyPoint(this.pathFinding, enemyInformation, baseInfo);
        this.painters = new Painters(game);
        this.initUnitCounts();
    }

    public void onFrame() {
        this.paintRanges();
        this.enemyOpenerResponse();
        this.rallyPoint.onFrame();
        int frameCount = this.game.getFrameCount();
        if (this.enemyInformation.getEnemyOpener() != null && this.beingAllInned && !this.defendedAllIn) {
            ++this.rallyClock;
        }
        if (new Time(this.rallyClock).greaterThan(new Time(1, 0))) {
            if (!this.enemyInformation.enemyInBase()) {
                this.defendedAllIn = true;
                this.rallyClock = 0;
            } else {
                this.rallyClock = 0;
            }
        }
        if (frameCount % 8 != 0) {
            return;
        }
        for (CombatUnits combatUnit : this.combatUnits) {
            if (combatUnit.getUnitType() == UnitType.Spell_Scanner_Sweep || combatUnit.getUnitType() == UnitType.Terran_Vulture_Spider_Mine) continue;
            combatUnit.onFrame();
            if (combatUnit.getRallyPoint() == null || this.baseInfo.getNaturalBase() != null && !combatUnit.isNaturalRallySet()) {
                if (this.baseInfo.getOwnedBases().contains(this.baseInfo.getNaturalBase())) {
                    combatUnit.setNaturalRallySet(true);
                }
                this.rallyPoint.setRallyPoint(combatUnit);
            }
            switch (combatUnit.getUnitType()) {
                case Terran_Marine: {
                    break;
                }
                case Terran_Medic: {
                    ClosestUnit.findClosestFriendlyUnit(combatUnit, this.combatUnits, UnitType.Terran_Marine);
                }
            }
            combatUnit.setInBase(this.baseInfo.getBaseTiles().contains(combatUnit.getUnit().getTilePosition()));
            UnitStatus unitStatus = combatUnit.getUnitStatus();
            if (!(this.unitCount.get((Object)UnitType.Terran_Marine) <= 14 && (this.unitCount.get((Object)UnitType.Terran_Siege_Tank_Tank_Mode) <= 2 || this.unitCount.get((Object)UnitType.Terran_Vulture) <= 4 && this.unitCount.get((Object)UnitType.Terran_Goliath) <= 4) || unitStatus != UnitStatus.RALLY && unitStatus != UnitStatus.LOAD && unitStatus != UnitStatus.SIEGEDEF)) {
                if (this.bunker != null) {
                    this.unLoadBunker(combatUnit);
                }
                if (combatUnit instanceof SiegeTank && ((SiegeTank)combatUnit).isSieged()) {
                    combatUnit.getUnit().unsiege();
                }
                if (combatUnit.getUnitType() == UnitType.Terran_Vulture) {
                    ((Vulture)combatUnit).setLobotomyOverride(true);
                }
                combatUnit.setUnitStatus(UnitStatus.ATTACK);
            } else if (combatUnit.getUnitType() == UnitType.Terran_Vulture) {
                ((Vulture)combatUnit).setLobotomyOverride(false);
            }
            if (unitStatus == UnitStatus.RALLY || unitStatus == UnitStatus.DEFEND) {
                combatUnit.setResetClock(combatUnit.getResetClock() + 12);
                if (new Time(combatUnit.getResetClock()).greaterThan(new Time(0, 30))) {
                    this.rallyPoint.setRallyPoint(combatUnit);
                    combatUnit.setResetClock(0);
                }
                if (this.obstructingBuild(combatUnit)) {
                    combatUnit.setUnitStatus(UnitStatus.OBSTRUCTING);
                    continue;
                }
                if (combatUnit.getUnitType() == UnitType.Terran_Marine && !combatUnit.isInBunker() && this.bunker != null && this.bunkerLoad < 4) {
                    combatUnit.setUnitStatus(UnitStatus.LOAD);
                }
            }
            if (unitStatus == UnitStatus.OBSTRUCTING && !this.obstructingBuild(combatUnit)) {
                combatUnit.setUnitStatus(UnitStatus.RALLY);
            }
            if (!(!this.scouting.isCompletedScout() && !this.scouting.isAttemptsMaxed() || this.enemyInformation.isEnemyBuildingDiscovered() || combatUnit.getUnitType() != UnitType.Terran_Marine && combatUnit.getUnitType() != UnitType.Terran_Vulture || this.scouts >= this.baseInfo.getMapBases().size())) {
                combatUnit.setUnitStatus(UnitStatus.SCOUT);
                this.assignScouts(combatUnit);
                ++this.scouts;
            }
            if (unitStatus == UnitStatus.SIEGEDEF) {
                ((SiegeTank)combatUnit).siegeDef();
            }
            if (this.hasTankSupport(combatUnit)) {
                combatUnit.setHasTankSupport(true);
            } else {
                combatUnit.setHasTankSupport(false);
            }
            switch (unitStatus) {
                case ATTACK: {
                    ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), Integer.MAX_VALUE);
                    if (combatUnit.getUnitType() == UnitType.Terran_Marine) {
                        if (this.inRangeOfThreat(combatUnit) && this.typeOfThreat(combatUnit) == UnitType.Zerg_Lurker) {
                            this.avoidThreat(combatUnit);
                            combatUnit.setUnitStatus(UnitStatus.RETREAT);
                            break;
                        }
                        if (this.inRangeOfThreat(combatUnit) && combatUnit.hasTankSupport()) {
                            this.avoidThreat(combatUnit);
                            combatUnit.setUnitStatus(UnitStatus.RETREAT);
                            break;
                        }
                        combatUnit.attack();
                        break;
                    }
                    if (this.inRangeOfThreat(combatUnit)) {
                        this.avoidThreat(combatUnit);
                        combatUnit.setUnitStatus(UnitStatus.RETREAT);
                        break;
                    }
                    combatUnit.attack();
                    break;
                }
                case RALLY: {
                    if (this.enemyInBase()) {
                        combatUnit.setEnemyInBase(true);
                        ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), 900);
                    } else {
                        combatUnit.setEnemyInBase(false);
                        ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), 150);
                    }
                    combatUnit.rally();
                    break;
                }
                case LOAD: {
                    this.loadBunker(combatUnit);
                    break;
                }
                case DEFEND: {
                    if (this.enemyInBase()) {
                        combatUnit.setEnemyInBase(true);
                        ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), 1000);
                    } else {
                        combatUnit.setEnemyInBase(false);
                        ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), 250);
                    }
                    combatUnit.defend();
                    break;
                }
                case RETREAT: {
                    if (!this.inRangeOfThreat(combatUnit)) {
                        combatUnit.setInRangeOfThreat(false);
                        ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), Integer.MAX_VALUE);
                    }
                    if (this.inRangeOfThreat(combatUnit)) {
                        this.avoidThreat(combatUnit);
                    }
                    combatUnit.retreat();
                    break;
                }
                case SCOUT: {
                    this.scoutBases();
                    break;
                }
                case ADDON: {
                    this.scanInvisibleUnits(combatUnit);
                    break;
                }
                case OBSTRUCTING: {
                    this.moveFromObstruction(combatUnit);
                    break;
                }
                case SIEGEDEF: {
                    if (!this.enemyInBase()) break;
                    combatUnit.setEnemyInBase(true);
                    ClosestUnit.findClosestUnit(combatUnit, this.enemyInformation.getEnemyUnits(), 900);
                    break;
                }
                case HUNTING: {
                    ClosestUnit.priorityTargets(combatUnit, combatUnit.getPriorityTargets(), this.enemyInformation.getEnemyUnits(), Integer.MAX_VALUE);
                    combatUnit.hunting();
                }
            }
        }
    }

    private boolean enemyInBase() {
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            if (enemyUnit.getEnemyPosition() == null || !enemyUnit.getEnemyType().canAttack()) continue;
            TilePosition enemyTile = enemyUnit.getEnemyPosition().toTilePosition();
            if (!this.baseInfo.getBaseTiles().contains(enemyTile)) continue;
            return true;
        }
        return false;
    }

    public void loadBunker(CombatUnits combatUnit) {
        combatUnit.getUnit().load(this.bunker);
        if (!combatUnit.isInBunker()) {
            ++this.bunkerLoad;
        }
        combatUnit.setInBunker(true);
    }

    public void unLoadBunker(CombatUnits combatUnit) {
        this.bunker.unloadAll();
        this.bunkerLoad = 0;
        combatUnit.setInBunker(false);
    }

    private void assignScouts(CombatUnits combatUnit) {
        for (Base base : this.baseInfo.getMapBases()) {
            if (this.designatedScouts.containsKey(base)) continue;
            this.designatedScouts.put(base, combatUnit);
            break;
        }
    }

    private void unassignScout(CombatUnits combatUnit) {
        for (Base base : this.designatedScouts.keySet()) {
            if (this.designatedScouts.get(base).getUnitID() != combatUnit.getUnitID()) continue;
            this.designatedScouts.remove(base);
            --this.scouts;
            break;
        }
    }

    private void scoutBases() {
        for (Base base : this.designatedScouts.keySet()) {
            CombatUnits scout = this.designatedScouts.get(base);
            scout.getUnit().attack(base.getCenter());
            if (!this.enemyInformation.isEnemyBuildingDiscovered()) continue;
            scout.setUnitStatus(UnitStatus.RALLY);
        }
        if (this.enemyInformation.isEnemyBuildingDiscovered()) {
            this.scouts = 0;
            this.designatedScouts.clear();
        }
    }

    private void enemyOpenerResponse() {
        if (this.enemyInformation.getEnemyOpener() == null) {
            return;
        }
        switch (this.enemyInformation.getEnemyOpener().getStrategyName()) {
            case "Cannon Rush": {
                this.beingAllInned = true;
                break;
            }
            case "Four Pool": {
                this.beingAllInned = true;
            }
        }
    }

    private void scanInvisibleUnits(CombatUnits combatUnit) {
        if (combatUnit.getUnitType() != UnitType.Terran_Comsat_Station) {
            return;
        }
        if (this.isActiveScanNearUnit()) {
            return;
        }
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            if (enemyUnit.getEnemyType() == UnitType.Protoss_Observer || !enemyUnit.getEnemyUnit().isCloaked() && !enemyUnit.getEnemyUnit().isBurrowed() || !enemyUnit.getEnemyUnit().isVisible()) continue;
            combatUnit.getUnit().useTech(TechType.Scanner_Sweep, enemyUnit.getEnemyPosition());
        }
    }

    private boolean isActiveScanNearUnit() {
        for (CombatUnits scanUnit : this.combatUnits) {
            if (scanUnit.getUnitStatus() != UnitStatus.SCAN) continue;
            for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
                int distance;
                if (!enemyUnit.getEnemyUnit().isCloaked() && !enemyUnit.getEnemyUnit().isBurrowed() || !enemyUnit.getEnemyUnit().isVisible() || (distance = scanUnit.getUnit().getPosition().getApproxDistance(enemyUnit.getEnemyPosition())) > 300) continue;
                return true;
            }
        }
        return false;
    }

    private boolean obstructingBuild(CombatUnits combatUnit) {
        for (Unit unit : this.game.self().getUnits()) {
            if (!unit.getType().isWorker() || combatUnit.getRallyPoint() == null || unit.isMoving() || unit.isConstructing() || unit.getPosition().getApproxDistance(combatUnit.getUnit().getPosition()) >= 100 || combatUnit.getUnit().getPosition().getApproxDistance(combatUnit.getRallyPoint().toPosition()) >= 100) continue;
            return true;
        }
        return false;
    }

    private void moveFromObstruction(CombatUnits combatUnit) {
        Unit worker = null;
        for (Unit unit : this.game.self().getUnits()) {
            if (!unit.getType().isWorker() || unit.isMoving() || unit.isConstructing() || unit.getPosition().getApproxDistance(combatUnit.getUnit().getPosition()) >= 100) continue;
            worker = unit;
            break;
        }
        if (worker == null) {
            return;
        }
        Position workerPos = worker.getPosition();
        Position unitPos = combatUnit.getUnit().getPosition();
        int dx = unitPos.getX() - workerPos.getX();
        int dy = unitPos.getY() - workerPos.getY();
        int moveX = unitPos.getX() + dx * 100 / Math.max(1, unitPos.getApproxDistance(workerPos));
        int moveY = unitPos.getY() + dy * 100 / Math.max(1, unitPos.getApproxDistance(workerPos));
        moveX = Math.min(Math.max(moveX, 0), this.game.mapWidth() * 32);
        moveY = Math.min(Math.max(moveY, 0), this.game.mapHeight() * 32);
        Position movePos = new Position(moveX, moveY);
        combatUnit.getUnit().attack(movePos);
    }

    private void avoidThreat(CombatUnits combatUnit) {
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            if (enemyUnit.getEnemyPosition() == null || (enemyUnit.getEnemyType() != UnitType.Protoss_Photon_Cannon || !enemyUnit.getEnemyUnit().isPowered() || !enemyUnit.getEnemyUnit().isCompleted()) && enemyUnit.getEnemyType() != UnitType.Zerg_Sunken_Colony && (enemyUnit.getEnemyType() != UnitType.Zerg_Lurker || !enemyUnit.getEnemyUnit().isBurrowed() || enemyUnit.getEnemyUnit().isDetected())) continue;
            Position unitPos = combatUnit.getUnit().getPosition();
            Position threatPos = enemyUnit.getEnemyPosition();
            int dx = unitPos.getX() - threatPos.getX();
            int dy = unitPos.getY() - threatPos.getY();
            int moveX = unitPos.getX() + dx * 200 / Math.max(1, unitPos.getApproxDistance(threatPos));
            int moveY = unitPos.getY() + dy * 200 / Math.max(1, unitPos.getApproxDistance(threatPos));
            moveX = Math.min(Math.max(moveX, 0), this.game.mapWidth() * 32);
            moveY = Math.min(Math.max(moveY, 0), this.game.mapHeight() * 32);
            Position movePos = new Position(moveX, moveY);
            combatUnit.getUnit().move(movePos);
            break;
        }
    }

    private boolean inRangeOfThreat(CombatUnits combatUnit) {
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            boolean isThreat;
            if (enemyUnit.getEnemyPosition() == null || !(isThreat = enemyUnit.getEnemyType() == UnitType.Protoss_Photon_Cannon && enemyUnit.getEnemyUnit().isPowered() && enemyUnit.getEnemyUnit().isCompleted() || enemyUnit.getEnemyType() == UnitType.Zerg_Sunken_Colony || enemyUnit.getEnemyType() == UnitType.Zerg_Lurker && enemyUnit.getEnemyUnit().isBurrowed() && !enemyUnit.getEnemyUnit().isDetected()) || combatUnit.getUnit().getPosition().getApproxDistance(enemyUnit.getEnemyPosition()) >= enemyUnit.getEnemyType().groundWeapon().maxRange() + 125) continue;
            combatUnit.setInRangeOfThreat(true);
            return true;
        }
        return false;
    }

    private UnitType typeOfThreat(CombatUnits combatUnit) {
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            boolean isThreat;
            if (enemyUnit.getEnemyPosition() == null || !(isThreat = enemyUnit.getEnemyType() == UnitType.Zerg_Lurker && enemyUnit.getEnemyUnit().isBurrowed() && !enemyUnit.getEnemyUnit().isDetected()) || combatUnit.getUnit().getPosition().getApproxDistance(enemyUnit.getEnemyPosition()) >= enemyUnit.getEnemyType().groundWeapon().maxRange() + 100) continue;
            return enemyUnit.getEnemyType();
        }
        return null;
    }

    private boolean hasTankSupport(CombatUnits combatUnit) {
        if (this.unitCount.get((Object)UnitType.Terran_Siege_Tank_Tank_Mode) > 0 || this.unitCount.get((Object)UnitType.Terran_Siege_Tank_Siege_Mode) > 0) {
            ClosestUnit.findClosestFriendlyUnit(combatUnit, this.combatUnits, UnitType.Terran_Siege_Tank_Tank_Mode);
            if (combatUnit.getFriendlyUnit() != null && combatUnit.getUnit().getDistance(combatUnit.getFriendlyUnit().getUnit()) < 300) {
                return true;
            }
            for (CombatUnits unit : this.combatUnits) {
                int distanceToEnemy;
                if (unit.getUnitType() != UnitType.Terran_Siege_Tank_Tank_Mode && unit.getUnitType() != UnitType.Terran_Siege_Tank_Siege_Mode || unit.getEnemyUnit() == null || unit.isInBase() || (distanceToEnemy = unit.getUnit().getDistance(unit.getEnemyUnit().getEnemyPosition())) >= 400) continue;
                return true;
            }
        }
        return false;
    }

    private void initUnitCounts() {
        for (UnitType unitType : UnitType.values()) {
            if (!unitType.getRace().toString().equals("Terran") || unitType.isCritter() || unitType.isHero() || unitType.isBeacon() || unitType.isSpecialBuilding()) continue;
            this.unitCount.put(unitType, 0);
        }
    }

    private boolean isExistingUnit(Unit unit) {
        for (CombatUnits combatUnit : this.combatUnits) {
            if (combatUnit.getUnitID() != unit.getID()) continue;
            return true;
        }
        return false;
    }

    public void onUnitComplete(Unit unit) {
        if (unit.getType() == UnitType.Terran_Bunker) {
            this.bunker = unit;
            return;
        }
        if (unit.getType() == UnitType.Terran_Comsat_Station) {
            CombatUnits combatUnit = this.combatUnitCreator.createCombatUnit(unit);
            this.combatUnits.add(combatUnit);
            this.unitCount.put(unit.getType(), this.unitCount.getOrDefault((Object)unit.getType(), 0) + 1);
            return;
        }
        if (unit.getType() == UnitType.Spell_Scanner_Sweep) {
            CombatUnits combatUnit = this.combatUnitCreator.createCombatUnit(unit);
            this.combatUnits.add(combatUnit);
            this.unitCount.put(unit.getType(), this.unitCount.getOrDefault((Object)unit.getType(), 0) + 1);
            return;
        }
        if (this.isExistingUnit(unit)) {
            return;
        }
        CombatUnits combatUnit = this.combatUnitCreator.createCombatUnit(unit);
        this.combatUnits.add(combatUnit);
        this.unitCount.put(unit.getType(), this.unitCount.getOrDefault((Object)unit.getType(), 0) + 1);
    }

    public void onUnitDestroy(Unit unit) {
        if (unit.getType() == UnitType.Terran_Bunker) {
            this.bunker = null;
            return;
        }
        if (unit.getType().isBuilding() && unit.getType() != UnitType.Terran_Comsat_Station) {
            return;
        }
        Iterator<CombatUnits> iterator = this.combatUnits.iterator();
        while (iterator.hasNext()) {
            CombatUnits combatUnit = iterator.next();
            if (combatUnit.getUnitID() != unit.getID()) continue;
            if (combatUnit.getUnitStatus() == UnitStatus.LOAD) {
                --this.bunkerLoad;
            }
            if (combatUnit.getUnitStatus() == UnitStatus.SCOUT) {
                this.unassignScout(combatUnit);
            }
            iterator.remove();
            break;
        }
        if (this.unitCount.containsKey((Object)unit.getType())) {
            this.unitCount.put(unit.getType(), this.unitCount.get((Object)unit.getType()) - 1);
        }
    }

    public void paintRanges() {
        for (CombatUnits combatUnit : this.combatUnits) {
            this.painters.paintUnitStatus(combatUnit);
            this.painters.paintClosestEnemy(combatUnit);
            this.painters.paintStimStatus(combatUnit);
            this.painters.paintCombatScouts(combatUnit);
            this.painters.paintMedicTarget(combatUnit);
        }
    }

    public HashSet<CombatUnits> getCombatUnits() {
        return this.combatUnits;
    }
}

