/*
 * Decompiled with CFR 0.152.
 */
package information.enemy;

import bwapi.Game;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import information.enemy.EnemyUnits;
import macro.ResourceManager;
import macro.unitgroups.WorkerStatus;
import macro.unitgroups.Workers;
import util.Time;

public class EnemyScoutResponse {
    private Game game;
    private EnemyInformation enemyInformation;
    private ResourceManager resourceManager;
    private BaseInfo baseInfo;
    private EnemyUnits enemyScout;
    private Workers counterScout;
    private boolean initiallyScouted = false;

    public EnemyScoutResponse(Game game, EnemyInformation enemyInformation, ResourceManager resourceManager, BaseInfo baseInfo) {
        this.game = game;
        this.enemyInformation = enemyInformation;
        this.resourceManager = resourceManager;
        this.baseInfo = baseInfo;
    }

    private void initialScoutInBase() {
        for (EnemyUnits enemyUnit : this.enemyInformation.getEnemyUnits()) {
            if (!enemyUnit.getEnemyType().isWorker() || !this.enemyInformation.enemyInBase()) continue;
            this.setEnemyScout(enemyUnit);
            this.initiallyScouted = true;
        }
    }

    private void followScout() {
        if (this.counterScout != null && this.enemyScout.getEnemyPosition() != null) {
            this.counterScout.getUnit().attack(this.enemyScout.getEnemyUnit());
        }
    }

    private void assignCounterScout() {
        if (this.counterScout == null) {
            for (Workers worker : this.resourceManager.getWorkers()) {
                if (worker.getUnit().isCarryingMinerals() || worker.getWorkerStatus() != WorkerStatus.MINERALS) continue;
                worker.setWorkerStatus(WorkerStatus.COUNTERSCOUT);
                this.counterScout = worker;
                return;
            }
        }
    }

    private void clearCounterScout() {
        if (this.counterScout != null && !this.enemyScout.getEnemyUnit().exists()) {
            this.counterScout.setWorkerStatus(WorkerStatus.IDLE);
            this.counterScout = null;
        }
    }

    private void setEnemyScout(EnemyUnits enemyScout) {
        this.enemyScout = enemyScout;
    }

    public void onFrame() {
        if (new Time(this.game.getFrameCount()).greaterThan(new Time(3, 30))) {
            this.clearCounterScout();
            return;
        }
        if (!this.initiallyScouted) {
            this.initialScoutInBase();
        }
        if (this.enemyScout != null) {
            this.assignCounterScout();
            this.followScout();
        }
    }
}

