/*
 * Decompiled with CFR 0.152.
 */
package information.enemy;

import bwapi.Game;
import bwapi.Text;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Base;
import information.BaseInfo;
import information.enemy.EnemyStrategyManager;
import information.enemy.EnemyUnits;
import information.enemy.enemyopeners.EnemyStrategy;
import information.enemy.enemytechunits.EnemyTechUnits;
import java.util.HashSet;
import util.Time;

public class EnemyInformation {
    private HashSet<EnemyUnits> enemyUnits = new HashSet();
    private HashSet<EnemyTechUnits> enemyTechUnits = new HashSet();
    private HashSet<UnitType> enemyTechunitResponse = new HashSet();
    private BaseInfo baseInfo;
    private Game game;
    private EnemyUnits startingEnemyBase = null;
    private Base enemyNatural = null;
    private EnemyStrategyManager enemyStrategyManager;
    private EnemyStrategy enemyOpener;
    private boolean enemyBuildingDiscovered = false;

    public EnemyInformation(BaseInfo baseInfo, Game game) {
        this.baseInfo = baseInfo;
        this.game = game;
        this.enemyStrategyManager = new EnemyStrategyManager(baseInfo);
    }

    private boolean previouslyDiscovered(Unit unit) {
        for (EnemyUnits enemyUnit : this.enemyUnits) {
            if (enemyUnit.getEnemyID() != unit.getID()) continue;
            return true;
        }
        return false;
    }

    private boolean checkForBuildings() {
        for (EnemyUnits enemyUnit : this.enemyUnits) {
            if (!enemyUnit.getEnemyType().isBuilding()) continue;
            return true;
        }
        return false;
    }

    public boolean enemyInBase() {
        for (EnemyUnits enemyUnit : this.enemyUnits) {
            if (!enemyUnit.getEnemyType().canAttack()) continue;
            if (this.baseInfo.getBaseTiles().contains(enemyUnit.getEnemyUnit().getTilePosition())) {
                return true;
            }
            if (!this.baseInfo.getNaturalTiles().contains(enemyUnit.getEnemyUnit().getTilePosition())) continue;
            return true;
        }
        return false;
    }

    public boolean hasType(UnitType unitType) {
        for (EnemyUnits enemyUnit : this.enemyUnits) {
            if (enemyUnit.getEnemyType() != unitType) continue;
            return true;
        }
        return false;
    }

    public boolean outRangingUnitNearby(EnemyUnits enemyUnit, UnitType friendlyUnitType, int range) {
        for (EnemyUnits outRangingUnit : this.enemyUnits) {
            if (outRangingUnit.getEnemyID() == enemyUnit.getEnemyID() || !outRangingUnit.getEnemyType().canAttack() || outRangingUnit.getEnemyType().isBuilding() || outRangingUnit.getEnemyType().groundWeapon().maxRange() + 32 < friendlyUnitType.groundWeapon().maxRange() || outRangingUnit.getEnemyUnit().getDistance(enemyUnit.getEnemyUnit().getPosition()) > range) continue;
            return true;
        }
        return false;
    }

    private void checkTechUnits() {
        for (EnemyTechUnits enemyTechUnit : this.enemyStrategyManager.getEnemyTechUnits()) {
            if (enemyTechUnit.isEnemyTechUnit(this.enemyUnits) && !this.enemyTechUnits.contains(enemyTechUnit)) {
                if (!enemyTechUnit.hasTriggeredResponse()) {
                    enemyTechUnit.techBuildingResponse();
                    enemyTechUnit.techUpgradeResponse();
                    enemyTechUnit.setTriggeredResponse(true);
                }
                this.enemyTechUnits.add(enemyTechUnit);
                this.enemyTechunitResponse.add(enemyTechUnit.getResponseUnitType());
                continue;
            }
            if (enemyTechUnit.isEnemyTechUnit(this.enemyUnits) || !this.enemyTechUnits.contains(enemyTechUnit)) continue;
            this.enemyTechUnits.remove(enemyTechUnit);
            this.enemyTechunitResponse.remove((Object)enemyTechUnit.getResponseUnitType());
        }
    }

    public void onFrame() {
        Time currentTime = new Time(this.game.getFrameCount());
        for (EnemyUnits enemyUnit : this.enemyUnits) {
            if (!enemyUnit.getEnemyUnit().isVisible()) continue;
            if (enemyUnit.getEnemyUnit().getType() != enemyUnit.getEnemyType()) {
                this.updateUnitType(enemyUnit);
            }
            enemyUnit.setEnemyPosition(enemyUnit.getEnemyUnit().getPosition());
        }
        for (EnemyStrategy enemyStrategy : this.enemyStrategyManager.getEnemyStrategies()) {
            if (!enemyStrategy.isEnemyStrategy(this.enemyUnits, currentTime) || this.enemyOpener != null) continue;
            this.enemyOpener = enemyStrategy;
            this.game.sendText("Potential enemy opener detected: " + enemyStrategy.getStrategyName(), new Text[0]);
            break;
        }
        this.checkTechUnits();
        if (this.enemyOpener != null) {
            this.game.drawTextScreen(5, 60, "Enemy Opener: " + this.enemyOpener.getStrategyName(), new Text[0]);
        } else {
            this.game.drawTextScreen(5, 60, "Enemy Opener: Unknown", new Text[0]);
        }
    }

    public void onUnitDiscover(Unit unit) {
        if (!this.previouslyDiscovered(unit)) {
            this.addEnemyUnit(unit);
            if (unit.getType().isBuilding()) {
                this.enemyBuildingDiscovered = true;
            }
        }
        if (this.startingEnemyBase == null && unit.getType().isResourceDepot()) {
            for (EnemyUnits enemyUnit : this.enemyUnits) {
                if (!enemyUnit.getEnemyType().isResourceDepot() || enemyUnit.getEnemyID() != unit.getID()) continue;
                this.startingEnemyBase = enemyUnit;
            }
        }
    }

    public void onUnitShow(Unit unit) {
    }

    public void onUnitDestroy(Unit unit) {
        for (EnemyUnits enemyUnit : this.enemyUnits) {
            if (enemyUnit.getEnemyID() != unit.getID()) continue;
            this.enemyUnits.remove(enemyUnit);
            break;
        }
        if (!this.checkForBuildings() && unit.getType().isBuilding()) {
            this.enemyBuildingDiscovered = false;
        }
    }

    public void onUnitRenegade(Unit unit) {
        if (!(unit.getPlayer() == this.game.self() || this.game.enemy() != unit.getPlayer() || this.previouslyDiscovered(unit) || unit.getType() != UnitType.Zerg_Extractor && unit.getType() != UnitType.Terran_Refinery && unit.getType() != UnitType.Protoss_Assimilator)) {
            this.addEnemyUnit(unit);
        }
    }

    private void updateUnitType(EnemyUnits enemyUnit) {
        enemyUnit.setEnemyType(enemyUnit.getEnemyUnit().getType());
    }

    private void addEnemyUnit(Unit unit) {
        this.enemyUnits.add(new EnemyUnits(unit.getID(), unit));
    }

    public HashSet<EnemyUnits> getEnemyUnits() {
        return this.enemyUnits;
    }

    public EnemyUnits getStartingEnemyBase() {
        return this.startingEnemyBase;
    }

    public EnemyStrategy getEnemyOpener() {
        return this.enemyOpener;
    }

    public boolean isEnemyBuildingDiscovered() {
        return this.enemyBuildingDiscovered;
    }

    public BaseInfo getBaseInfo() {
        return this.baseInfo;
    }

    public HashSet<EnemyTechUnits> getEnemyTechUnits() {
        return this.enemyTechUnits;
    }

    public HashSet<UnitType> getTechUnitResponse() {
        return this.enemyTechunitResponse;
    }
}

