/*
 * Decompiled with CFR 0.152.
 */
package information;

import bwapi.Game;
import bwapi.Player;
import bwapi.Position;
import bwapi.Unit;
import bwem.BWEM;
import bwem.Base;
import debug.Painters;
import information.BaseInfo;
import information.enemy.EnemyInformation;
import macro.ResourceManager;
import macro.unitgroups.WorkerStatus;
import macro.unitgroups.Workers;

public class Scouting {
    private BWEM bwem;
    private Game game;
    private ResourceManager resourceManager;
    private BaseInfo baseInfo;
    private Painters painters;
    private Player player;
    private EnemyInformation enemyInformation;
    private Workers scout;
    private int scoutRadius = 200;
    private int positionCount = 8;
    private int currentPositionIndex = 0;
    private int scoutingAttempts = 0;
    private boolean completedScout = false;
    private boolean attemptsMaxed = false;

    public Scouting(BWEM bwem, Game game, Player player, ResourceManager resourceManager, BaseInfo baseInfo, EnemyInformation enemyInformation) {
        this.bwem = bwem;
        this.game = game;
        this.player = player;
        this.resourceManager = resourceManager;
        this.baseInfo = baseInfo;
        this.enemyInformation = enemyInformation;
        this.painters = new Painters(game, bwem, resourceManager);
    }

    public void sendScout() {
        if (this.scoutingAttempts >= 3) {
            this.attemptsMaxed = true;
            return;
        }
        if (this.scout == null) {
            this.selectScout();
        }
        for (Base startingBase : this.baseInfo.getStartingBases()) {
            if (startingBase == this.baseInfo.getStartingBase() || this.baseInfo.isExplored(startingBase)) continue;
            this.scout.getUnit().move(startingBase.getCenter());
        }
    }

    private void selectScout() {
        for (Workers scv : this.resourceManager.getWorkers()) {
            if (scv.getWorkerStatus() != WorkerStatus.MINERALS) continue;
            ++this.scoutingAttempts;
            this.scout = scv;
            scv.setWorkerStatus(WorkerStatus.SCOUTING);
            break;
        }
    }

    public void scoutEnemyPerimeter() {
        if (this.scout == null) {
            return;
        }
        if (this.scout.getUnit().isAttacking()) {
            this.scout.getUnit().stop();
        }
        Position enemyBasePos = this.enemyInformation.getStartingEnemyBase().getEnemyPosition();
        double angle = Math.PI * 2 * (double)this.currentPositionIndex / (double)this.positionCount;
        int x = (int)((double)enemyBasePos.getX() + (double)this.scoutRadius * Math.cos(angle));
        int y = (int)((double)enemyBasePos.getY() + (double)this.scoutRadius * Math.sin(angle));
        Position targetPosition = new Position(x, y);
        if (this.scout.getUnit().getDistance(targetPosition) < 90) {
            this.currentPositionIndex = (this.currentPositionIndex + 1) % this.positionCount;
            angle = Math.PI * 2 * (double)this.currentPositionIndex / (double)this.positionCount;
            x = (int)((double)enemyBasePos.getX() + (double)this.scoutRadius * Math.cos(angle));
            y = (int)((double)enemyBasePos.getY() + (double)this.scoutRadius * Math.sin(angle));
            targetPosition = new Position(x, y);
        }
        this.scout.getUnit().rightClick(targetPosition);
    }

    public void onFrame() {
        if (this.player.supplyUsed() / 2 >= 10 && this.enemyInformation.getStartingEnemyBase() == null) {
            this.sendScout();
        }
        if (this.enemyInformation.getStartingEnemyBase() != null) {
            this.scoutEnemyPerimeter();
            this.completedScout = true;
        }
        if (this.scout != null) {
            this.painters.paintScoutPath(this.scout.getUnit());
        }
    }

    public void onEnemyDestroy(Unit unit) {
        if (this.scout == null) {
            return;
        }
        if (unit.getID() == this.scout.getUnit().getID()) {
            this.scout = null;
        }
    }

    public boolean isCompletedScout() {
        return this.completedScout;
    }

    public boolean isAttemptsMaxed() {
        return this.attemptsMaxed;
    }
}

