/*
 * Decompiled with CFR 0.152.
 */
package information;

import bwapi.Game;
import bwapi.Position;
import bwapi.TilePosition;
import bwapi.Unit;
import bwapi.UnitType;
import bwem.Area;
import bwem.BWEM;
import bwem.Base;
import bwem.ChokePoint;
import bwem.Geyser;
import bwem.Mineral;
import debug.Painters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import map.AllBasePaths;
import map.PathFinding;

public class BaseInfo {
    private BWEM bwem;
    private Game game;
    private PathFinding pathFinding;
    private AllBasePaths allBasePaths;
    private Base startingBase;
    private Base naturalBase;
    private ChokePoint chokePoint;
    private Unit initalCC = null;
    private HashSet<Base> mapBases = new HashSet();
    private HashSet<Base> startingBases = new HashSet();
    private HashSet<Mineral> startingMinerals = new HashSet();
    private HashSet<Geyser> startingGeysers = new HashSet();
    private HashSet<TilePosition> baseTiles = new HashSet();
    private HashSet<TilePosition> naturalTiles = new HashSet();
    private HashSet<Base> ownedBases = new HashSet();
    private HashSet<ChokePoint> chokePoints = new HashSet();
    private HashSet<TilePosition> usedGeysers = new HashSet();
    private HashSet<TilePosition> mainCliffEdge = new HashSet();
    private HashSet<TilePosition> naturalChokeEdge = new HashSet();
    private HashSet<TilePosition> combinedTankTiles = new HashSet();
    private HashSet<TilePosition> backupMainSiegeTiles = new HashSet();
    private HashMap<Base, TilePosition> geyserTiles = new HashMap();
    private HashMap<Base, List<Position>> allPathsMap;
    private ArrayList<Base> orderedExpansions = new ArrayList();
    private boolean naturalOwned = false;
    private Painters painters;

    public BaseInfo(BWEM bwem, Game game) {
        this.bwem = bwem;
        this.game = game;
        this.pathFinding = new PathFinding(bwem, game);
        this.painters = new Painters(game, bwem);
        this.init();
    }

    public void init() {
        for (Unit unit : this.game.getAllUnits()) {
            if (unit.getType() != UnitType.Terran_Command_Center) continue;
            this.initalCC = unit;
        }
        this.addAllBases();
        this.setStartingBase();
        this.addStartingBases();
        this.setStartingMineralPatches();
        this.setStartingGeysers();
        this.setChokePoints();
        this.allBasePaths = new AllBasePaths(this);
        this.allPathsMap = new HashMap<Base, List<Position>>(this.allBasePaths.getPathLists());
        this.setNaturalBase();
        this.setStartingBaseTiles();
        this.setNaturalBaseTiles();
        this.setOrderedExpansions();
        this.setGeyserTiles();
        this.setMainCliffEdge();
        this.setNaturalChokeEdge();
        this.combineTankTiles();
        this.backupMainSiegeTiles();
    }

    private void addAllBases() {
        for (Base base : this.bwem.getMap().getBases()) {
            this.mapBases.add(base);
        }
    }

    private void addStartingBases() {
        for (Base base : this.mapBases) {
            if (base.getLocation() == this.startingBase.getLocation() || !base.isStartingLocation()) continue;
            this.startingBases.add(base);
        }
    }

    public boolean isExplored(Base base) {
        return this.game.isExplored(base.getLocation());
    }

    private void setGeyserTiles() {
        for (Base base : this.mapBases) {
            if (base.getGeysers().isEmpty()) continue;
            for (Geyser geyser : base.getGeysers()) {
                this.geyserTiles.put(base, geyser.getUnit().getTilePosition());
            }
        }
    }

    public HashSet<TilePosition> getTilesForBase(Base base) {
        HashSet<TilePosition> tiles = new HashSet<TilePosition>();
        Area baseArea = base.getArea();
        int mapWidth = this.game.mapWidth();
        int mapHeight = this.game.mapHeight();
        for (int x = 0; x < mapWidth; ++x) {
            for (int y = 0; y < mapHeight; ++y) {
                TilePosition tile = new TilePosition(x, y);
                Area tileArea = this.bwem.getMap().getArea(tile);
                if (tileArea == null || tileArea.getId() != baseArea.getId()) continue;
                tiles.add(tile);
            }
        }
        return tiles;
    }

    private void setStartingBaseTiles() {
        this.baseTiles = this.getTilesForBase(this.startingBase);
    }

    private void setNaturalBaseTiles() {
        this.naturalTiles = this.getTilesForBase(this.naturalBase);
    }

    private void setStartingMineralPatches() {
        for (Mineral mineral : this.startingBase.getMinerals()) {
            this.startingMinerals.add(mineral);
        }
    }

    private void setStartingGeysers() {
        for (Geyser geyser : this.startingBase.getGeysers()) {
            this.startingGeysers.add(geyser);
        }
    }

    private void setChokePoints() {
        this.chokePoints.addAll(this.bwem.getMap().getChokePoints());
    }

    private void setStartingBase() {
        Base closestStartingBase = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Base base : this.mapBases) {
            int distance;
            if (!base.isStartingLocation() || closestDistance <= (distance = this.initalCC.getDistance(base.getLocation().toPosition()))) continue;
            closestStartingBase = base;
            closestDistance = distance;
            this.startingBase = closestStartingBase;
        }
    }

    private void setNaturalBase() {
        Base closestBase = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Base base : this.mapBases) {
            List<Position> path;
            if (base == this.startingBase || (path = this.allPathsMap.get(base)) == null || path.isEmpty()) continue;
            int distance = path.size();
            if (base.getGeysers().isEmpty() || distance >= closestDistance) continue;
            closestBase = base;
            closestDistance = distance;
        }
        this.naturalBase = closestBase;
    }

    private void setOrderedExpansions() {
        block0: for (Base base : this.mapBases) {
            List<Position> path;
            if (base == this.startingBase || (path = this.allPathsMap.get(base)) == null || path.isEmpty()) continue;
            int distance = path.size();
            if (base.getGeysers().isEmpty()) continue;
            if (this.orderedExpansions.isEmpty()) {
                this.orderedExpansions.add(base);
                continue;
            }
            for (int i = 0; i < this.orderedExpansions.size(); ++i) {
                Base currentBase = this.orderedExpansions.get(i);
                List<Position> currentPath = this.allPathsMap.get(currentBase);
                int currentDistance = currentPath.size();
                if (currentDistance > distance) {
                    this.orderedExpansions.add(i, base);
                    continue block0;
                }
                if (i != this.orderedExpansions.size() - 1) continue;
                this.orderedExpansions.add(base);
                continue block0;
            }
        }
    }

    public void readdExpansion(Unit unit) {
        Base closestBase = null;
        int closestDistance = Integer.MAX_VALUE;
        for (Base base : this.mapBases) {
            int distance = unit.getPosition().getApproxDistance(base.getLocation().toPosition());
            if (distance >= closestDistance) continue;
            closestBase = base;
            closestDistance = distance;
        }
        if (closestBase == null) {
            return;
        }
        if (!this.orderedExpansions.contains(closestBase)) {
            this.orderedExpansions.add(0, closestBase);
        }
    }

    private void setMainCliffEdge() {
        ChokePoint mainChoke = this.getMainChoke();
        ChokePoint naturalChoke = this.getNaturalChoke();
        HashSet<TilePosition> actualCliffEdge = new HashSet<TilePosition>();
        if (mainChoke == null || naturalChoke == null) {
            return;
        }
        for (TilePosition tile : this.baseTiles) {
            int distanceToMainChoke = mainChoke.getCenter().toPosition().getApproxDistance(tile.toPosition());
            int distanceToNaturalChoke = naturalChoke.getCenter().toPosition().getApproxDistance(tile.toPosition());
            if (distanceToMainChoke < 160 || distanceToMainChoke > 256 || distanceToNaturalChoke > 400) continue;
            boolean isCliffEdge = false;
            for (int dx = -1; dx <= 1 && !isCliffEdge; ++dx) {
                for (int dy = -1; dy <= 1 && !isCliffEdge; ++dy) {
                    TilePosition adj;
                    if (dx == 0 && dy == 0 || this.baseTiles.contains(adj = new TilePosition(tile.getX() + dx, tile.getY() + dy))) continue;
                    isCliffEdge = true;
                }
            }
            if (!isCliffEdge) continue;
            actualCliffEdge.add(tile);
        }
        for (TilePosition edgeTile : actualCliffEdge) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    TilePosition adj;
                    if (dx == 0 && dy == 0 || !this.baseTiles.contains(adj = new TilePosition(edgeTile.getX() + dx, edgeTile.getY() + dy)) || this.mainCliffEdge.contains(adj)) continue;
                    this.mainCliffEdge.add(adj);
                }
            }
        }
    }

    private void setNaturalChokeEdge() {
        ChokePoint naturalChoke = this.getNaturalChoke();
        if (naturalChoke == null || this.naturalTiles.isEmpty()) {
            return;
        }
        Position chokeCenter = naturalChoke.getCenter().toPosition();
        int minDistance = 96;
        int maxDistance = 188;
        for (TilePosition tile : this.naturalTiles) {
            int distanceToChoke = chokeCenter.getApproxDistance(tile.toPosition());
            if (distanceToChoke < minDistance || distanceToChoke > maxDistance || !this.pathFinding.getTilePositionValidator().isWalkable(tile)) continue;
            this.naturalChokeEdge.add(tile);
        }
    }

    private void combineTankTiles() {
        this.combinedTankTiles.addAll(this.mainCliffEdge);
        this.combinedTankTiles.addAll(this.naturalChokeEdge);
    }

    private void backupMainSiegeTiles() {
        ChokePoint mainChoke = this.getMainChoke();
        ChokePoint naturalChoke = this.getNaturalChoke();
        HashSet<TilePosition> actualCliffEdge = new HashSet<TilePosition>();
        if (mainChoke == null || naturalChoke == null) {
            return;
        }
        for (TilePosition tile : this.baseTiles) {
            int distanceToMainChoke = mainChoke.getCenter().toPosition().getApproxDistance(tile.toPosition());
            int distanceToNaturalChoke = naturalChoke.getCenter().toPosition().getApproxDistance(tile.toPosition());
            if (distanceToMainChoke < 160 || distanceToMainChoke > 256) continue;
            boolean isCliffEdge = false;
            for (int dx = -1; dx <= 1 && !isCliffEdge; ++dx) {
                for (int dy = -1; dy <= 1 && !isCliffEdge; ++dy) {
                    TilePosition adj;
                    if (dx == 0 && dy == 0 || this.baseTiles.contains(adj = new TilePosition(tile.getX() + dx, tile.getY() + dy))) continue;
                    isCliffEdge = true;
                }
            }
            if (!isCliffEdge) continue;
            actualCliffEdge.add(tile);
        }
        for (TilePosition edgeTile : actualCliffEdge) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    TilePosition adj;
                    if (dx == 0 && dy == 0 || !this.baseTiles.contains(adj = new TilePosition(edgeTile.getX() + dx, edgeTile.getY() + dy)) || this.backupMainSiegeTiles.contains(adj)) continue;
                    this.backupMainSiegeTiles.add(adj);
                }
            }
        }
    }

    public ChokePoint getMainChoke() {
        if (this.startingBase == null || this.naturalBase == null) {
            return null;
        }
        List<Position> path = this.pathFinding.findPath(this.startingBase.getLocation().toPosition(), this.naturalBase.getLocation().toPosition());
        if (path.isEmpty()) {
            return null;
        }
        ChokePoint closestChokePoint = null;
        int minDistance = Integer.MAX_VALUE;
        for (ChokePoint chokePoint : this.bwem.getMap().getChokePoints()) {
            Position chokePos = chokePoint.getCenter().toPosition();
            for (Position pathPos : path) {
                int distance = chokePos.getApproxDistance(pathPos);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closestChokePoint = chokePoint;
            }
        }
        return closestChokePoint;
    }

    public boolean hasBunkerInNatural() {
        for (Unit building : this.game.self().getUnits()) {
            if (!building.getType().isBuilding() || building.getType() != UnitType.Terran_Bunker || !this.getNaturalTiles().contains(building.getTilePosition())) continue;
            return true;
        }
        return false;
    }

    public ChokePoint getNaturalChoke() {
        ChokePoint closestChokePoint = null;
        int closestDistance = Integer.MAX_VALUE;
        for (ChokePoint chokePoint : this.bwem.getMap().getChokePoints()) {
            int distance;
            if (chokePoint == this.getMainChoke() || (distance = this.naturalBase.getLocation().getApproxDistance(chokePoint.getCenter().toTilePosition())) >= closestDistance) continue;
            closestChokePoint = chokePoint;
            closestDistance = distance;
        }
        return closestChokePoint;
    }

    public HashSet<Base> getStartingBases() {
        return this.startingBases;
    }

    public HashSet<Mineral> getStartingMinerals() {
        return this.startingMinerals;
    }

    public HashSet<Geyser> getStartingGeysers() {
        return this.startingGeysers;
    }

    public Base getStartingBase() {
        return this.startingBase;
    }

    public Base getNaturalBase() {
        return this.naturalBase;
    }

    public HashSet<TilePosition> getBaseTiles() {
        return this.baseTiles;
    }

    public HashSet<TilePosition> getNaturalTiles() {
        return this.naturalTiles;
    }

    public HashSet<Base> getMapBases() {
        return this.mapBases;
    }

    public ArrayList<Base> getOrderedExpansions() {
        return this.orderedExpansions;
    }

    public HashSet<Base> getOwnedBases() {
        return this.ownedBases;
    }

    public HashMap<Base, TilePosition> getGeyserTiles() {
        return this.geyserTiles;
    }

    public HashSet<TilePosition> getUsedGeysers() {
        return this.usedGeysers;
    }

    public PathFinding getPathFinding() {
        return this.pathFinding;
    }

    public HashSet<ChokePoint> getChokePoints() {
        return this.chokePoints;
    }

    public AllBasePaths getAllBasePaths() {
        return this.allBasePaths;
    }

    public HashSet<TilePosition> getMainCliffEdge() {
        return this.mainCliffEdge;
    }

    public HashSet<TilePosition> getCombinedTankTiles() {
        return this.combinedTankTiles;
    }

    public HashSet<TilePosition> getBackupMainSiegeTiles() {
        return this.backupMainSiegeTiles;
    }

    public boolean isNaturalOwned() {
        return this.naturalOwned;
    }

    public void onFrame() {
        this.painters.paintAllChokes();
        this.painters.paintNatural(this.naturalBase);
    }

    public void onUnitCreate(Unit unit) {
        if (unit.getType() != UnitType.Terran_Command_Center) {
            return;
        }
        if (unit.getDistance(this.naturalBase.getCenter()) < 100) {
            this.baseTiles.addAll(this.naturalTiles);
            this.naturalOwned = true;
        }
    }

    public void onUnitComplete(Unit unit) {
        for (Base base : this.mapBases) {
            if (unit.getPosition().getApproxDistance(base.getLocation().toPosition()) >= 100) continue;
            this.ownedBases.add(base);
            break;
        }
    }

    public void onUnitDestroy(Unit unit) {
        for (Base base : this.ownedBases) {
            if (unit.getPosition().getApproxDistance(base.getLocation().toPosition()) >= 100) continue;
            this.ownedBases.remove(base);
            break;
        }
        if (unit.getDistance(this.naturalBase.getCenter()) < 100) {
            this.baseTiles.removeAll(this.naturalTiles);
            this.naturalOwned = false;
        }
    }
}

