/*
 * Decompiled with CFR 0.152.
 */
package bwta;

import bwapi.Position;
import bwem.Area;
import bwta.BWTA;
import bwta.BaseLocation;
import bwta.Chokepoint;
import java.util.List;
import java.util.stream.Collectors;

public class Region {
    private final Area area;
    private final Position center;

    Region(Area area) {
        this.area = area;
        this.center = area.getWalkPositionWithHighestAltitude().toPosition();
    }

    public Position getCenter() {
        return this.center;
    }

    public List<Chokepoint> getChokepoints() {
        return this.area.getChokePoints().stream().map(c -> BWTA.chokeMap.get(c)).collect(Collectors.toList());
    }

    public List<BaseLocation> getBaseLocations() {
        return this.area.getBases().stream().map(b -> BWTA.baseMap.get(b)).collect(Collectors.toList());
    }

    public boolean isReachable(Region region) {
        return this.area.isAccessibleFrom(region.area);
    }

    public List<Region> getReachableRegions() {
        return this.area.getAccessibleNeighbors().stream().map(a -> BWTA.regionMap.get(a)).collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Region)) {
            return false;
        }
        return this.area.equals(((Region)o).area);
    }

    public int hashCode() {
        return this.area.hashCode();
    }
}

