/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.Game;
import bwapi.Order;
import bwapi.Player;
import bwapi.Position;
import bwapi.Race;
import bwapi.TechType;
import bwapi.Unit;
import bwapi.UnitCommand;
import bwapi.UnitType;
import bwapi.UpgradeType;

class CommandTemp {
    final UnitCommand command;
    EventType eventType = EventType.Resource;
    Player player = null;
    final Game game;

    CommandTemp(UnitCommand command, Game game) {
        this.command = command;
        this.game = game;
    }

    int getUnitID(Unit unit) {
        if (unit == null) {
            return -1;
        }
        return unit.getID();
    }

    void execute() {
        switch (this.command.type) {
            case Halt_Construction: {
                this.eventType = EventType.Order;
            }
        }
        this.execute(this.game.getRemainingLatencyFrames() == 0);
    }

    void execute(boolean isCurrentFrame) {
        if (!this.game.isLatComEnabled() || this.command.isQueued()) {
            return;
        }
        Unit unit = this.command.unit;
        Unit target = this.command.target;
        int frame = this.game.getFrameCount();
        if (isCurrentFrame) {
            switch (this.command.type) {
                case Morph: 
                case Build_Addon: 
                case Train: {
                    if (this.eventType == EventType.Resource) break;
                    return;
                }
                default: {
                    return;
                }
            }
        }
        if (this.player == null) {
            Player player = this.player = unit != null ? unit.getPlayer() : this.game.self();
        }
        if (unit == null || !unit.exists()) {
            return;
        }
        switch (this.command.type) {
            case Follow: 
            case Hold_Position: 
            case Move: 
            case Patrol: 
            case Right_Click_Position: 
            case Attack_Move: {
                if (unit.getType().canMove()) break;
                return;
            }
        }
        switch (this.command.type) {
            case Attack_Move: {
                unit.self().order.set(Order.AttackMove, frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                break;
            }
            case Attack_Unit: {
                if (target == null || !target.exists() || !unit.getType().canAttack()) {
                    return;
                }
                unit.self().order.set(Order.AttackUnit, frame);
                unit.self().target.set(this.getUnitID(target), frame);
                break;
            }
            case Build: {
                unit.self().order.set(Order.PlaceBuilding, frame);
                unit.self().isConstructing.set(true, frame);
                unit.self().isIdle.set(false, frame);
                unit.self().buildType.set(UnitType.idToEnum[this.command.extra], frame);
                break;
            }
            case Build_Addon: {
                UnitType addonType = UnitType.idToEnum[this.command.extra];
                switch (this.eventType) {
                    case Resource: {
                        this.player.self().minerals.setOrAdd(-addonType.mineralPrice(), frame);
                        this.player.self().gas.setOrAdd(-addonType.gasPrice(), frame);
                        if (isCurrentFrame) break;
                        unit.self().isIdle.set(false, frame);
                        unit.self().order.set(Order.PlaceAddon, frame);
                        break;
                    }
                    case Order: {
                        unit.self().isConstructing.set(true, frame);
                        unit.self().order.set(Order.Nothing, frame);
                        unit.self().secondaryOrder.set(Order.BuildAddon, frame);
                        unit.self().buildType.set(UnitType.idToEnum[this.command.extra], frame);
                    }
                }
                break;
            }
            case Burrow: {
                unit.self().order.set(Order.Burrowing, frame);
                break;
            }
            case Cancel_Addon: {
                switch (this.eventType) {
                    case Resource: {
                        UnitType addonType = unit.getBuildType();
                        this.player.self().minerals.setOrAdd((int)((double)addonType.mineralPrice() * 0.75), frame);
                        this.player.self().gas.setOrAdd((int)((double)addonType.gasPrice() * 0.75), frame);
                        unit.self().buildType.set(UnitType.None, frame);
                        break;
                    }
                    case Order: {
                        unit.self().remainingBuildTime.set(0, frame);
                        unit.self().isConstructing.set(false, frame);
                        unit.self().order.set(Order.Nothing, frame);
                        unit.self().isIdle.set(true, frame);
                        unit.self().buildUnit.set(-1, frame);
                    }
                }
                break;
            }
            case Cancel_Construction: {
                Unit builder;
                if (unit.getType().getRace() == Race.Terran && (builder = unit.getBuildUnit()) != null && builder.exists()) {
                    switch (this.eventType) {
                        case Resource: {
                            builder.self().buildType.set(UnitType.None, frame);
                            break;
                        }
                        case Order: {
                            builder.self().isConstructing.set(false, frame);
                            builder.self().order.set(Order.ResetCollision, frame);
                            break;
                        }
                        case Finish: {
                            builder.self().order.set(Order.PlayerGuard, frame);
                        }
                    }
                }
                if (this.eventType == EventType.Resource) {
                    unit.self().buildUnit.set(-1, frame);
                    this.player.self().minerals.setOrAdd((int)((double)unit.getType().mineralPrice() * 0.75), frame);
                    this.player.self().gas.setOrAdd((int)((double)unit.getType().gasPrice() * 0.75), frame);
                    unit.self().remainingBuildTime.set(0, frame);
                }
                if (unit.getType().getRace() != Race.Zerg) break;
                switch (this.eventType) {
                    case Resource: {
                        unit.self().type.set(unit.getType().whatBuilds().getFirst(), frame);
                        unit.self().buildType.set(UnitType.None, frame);
                        unit.self().isMorphing.set(false, frame);
                        unit.self().order.set(Order.ResetCollision, frame);
                        unit.self().isConstructing.set(false, frame);
                        this.player.self().supplyUsed[unit.getType().getRace().id].setOrAdd(unit.getType().supplyRequired(), frame);
                        break;
                    }
                    case Order: {
                        unit.self().order.set(Order.PlayerGuard, frame);
                        unit.self().isIdle.set(true, frame);
                    }
                }
                break;
            }
            case Cancel_Morph: {
                switch (this.eventType) {
                    case Resource: {
                        UnitType builtType = unit.getBuildType();
                        UnitType newType = builtType.whatBuilds().getFirst();
                        if (newType.isBuilding()) {
                            this.player.self().minerals.setOrAdd((int)((double)builtType.mineralPrice() * 0.75), frame);
                            this.player.self().gas.setOrAdd((int)((double)builtType.gasPrice() * 0.75), frame);
                        } else {
                            this.player.self().minerals.setOrAdd(builtType.mineralPrice(), frame);
                            this.player.self().gas.setOrAdd(builtType.gasPrice(), frame);
                        }
                        if (newType.isBuilding() && newType.producesCreep()) {
                            unit.self().order.set(Order.InitCreepGrowth, frame);
                        }
                        if (unit.getType() != UnitType.Zerg_Egg) {
                            unit.self().type.set(newType, frame);
                        }
                        unit.self().buildType.set(UnitType.None, frame);
                        unit.self().isConstructing.set(false, frame);
                        unit.self().isMorphing.set(false, frame);
                        unit.self().isCompleted.set(true, frame);
                        unit.self().remainingBuildTime.set(0, frame);
                        break;
                    }
                    case Order: {
                        if (unit.getType().isBuilding()) {
                            unit.self().isIdle.set(true, frame);
                            unit.self().order.set(Order.Nothing, frame);
                            if (unit.getType() != UnitType.Zerg_Hatchery && unit.getType() != UnitType.Zerg_Lair) break;
                            unit.self().secondaryOrder.set(Order.SpreadCreep, frame);
                            break;
                        }
                        this.player.self().supplyUsed[unit.getType().getRace().id].setOrAdd(-(unit.getType().supplyRequired() * (1 + (unit.getType().isTwoUnitsInOneEgg() ? 1 : 0))), frame);
                        this.player.self().supplyUsed[unit.getType().getRace().id].setOrAdd(unit.getType().whatBuilds().getFirst().supplyRequired() * unit.getType().whatBuilds().getSecond(), frame);
                        break;
                    }
                    case Finish: {
                        if (unit.getType() == UnitType.Zerg_Hatchery || unit.getType() == UnitType.Zerg_Lair) {
                            unit.self().secondaryOrder.set(Order.SpawningLarva, frame);
                            break;
                        }
                        if (unit.getType().isBuilding()) break;
                        unit.self().order.set(Order.PlayerGuard, frame);
                        unit.self().isCompleted.set(true, frame);
                        unit.self().isConstructing.set(false, frame);
                        unit.self().isIdle.set(true, frame);
                        unit.self().isMorphing.set(false, frame);
                    }
                }
                break;
            }
            case Cancel_Research: {
                switch (this.eventType) {
                    case Resource: {
                        TechType techType = unit.getTech();
                        this.player.self().minerals.setOrAdd(techType.mineralPrice(), frame);
                        this.player.self().gas.setOrAdd(techType.gasPrice(), frame);
                        unit.self().remainingResearchTime.set(0, frame);
                        unit.self().tech.set(TechType.None, frame);
                        break;
                    }
                    case Order: {
                        unit.self().order.set(Order.Nothing, frame);
                        unit.self().isIdle.set(true, frame);
                    }
                }
                break;
            }
            case Cancel_Train_Slot: {
                if (this.command.extra != 0) {
                    if (this.eventType != EventType.Resource) break;
                    UnitType unitType = unit.getTrainingQueue().get(this.command.extra);
                    this.player.self().minerals.setOrAdd(unitType.mineralPrice(), frame);
                    this.player.self().gas.setOrAdd(unitType.gasPrice(), frame);
                    for (int i = this.command.extra; i < 4; ++i) {
                        unit.self().trainingQueue[i].set(unit.getTrainingQueue().get(i + 1), frame);
                    }
                    unit.self().trainingQueueCount.setOrAdd(-1, frame);
                    break;
                }
            }
            case Cancel_Train: {
                switch (this.eventType) {
                    case Resource: {
                        UnitType unitType = unit.getTrainingQueue().get(unit.getTrainingQueueCount() - 1);
                        this.player.self().minerals.setOrAdd(unitType.mineralPrice(), frame);
                        this.player.self().gas.setOrAdd(unitType.gasPrice(), frame);
                        unit.self().buildUnit.set(-1, frame);
                        if (unit.getTrainingQueueCount() != 1) break;
                        unit.self().isIdle.set(false, frame);
                        unit.self().isTraining.set(false, frame);
                        break;
                    }
                    case Order: {
                        unit.self().trainingQueueCount.setOrAdd(-1, frame);
                        UnitType unitType = unit.getTrainingQueue().get(unit.getTrainingQueueCount());
                        this.player.self().supplyUsed[unitType.getRace().id].setOrAdd(-unitType.supplyRequired(), frame);
                        if (unit.getTrainingQueueCount() == 0) {
                            unit.self().buildType.set(UnitType.None, frame);
                            break;
                        }
                        UnitType ut = unit.getTrainingQueue().get(unit.getTrainingQueueCount() - 1);
                        unit.self().remainingTrainTime.set(ut.buildTime(), frame);
                        unit.self().buildType.set(ut, frame);
                        break;
                    }
                    case Finish: {
                        if (unit.getBuildType() != UnitType.None) break;
                        unit.self().order.set(Order.Nothing, frame);
                    }
                }
                break;
            }
            case Cancel_Upgrade: {
                switch (this.eventType) {
                    case Resource: {
                        UpgradeType upgradeType = unit.getUpgrade();
                        int nextLevel = unit.getPlayer().getUpgradeLevel(upgradeType) + 1;
                        this.player.self().minerals.setOrAdd(upgradeType.mineralPrice(nextLevel), frame);
                        this.player.self().gas.setOrAdd(upgradeType.gasPrice(nextLevel), frame);
                        unit.self().upgrade.set(UpgradeType.None, frame);
                        unit.self().remainingUpgradeTime.set(0, frame);
                        break;
                    }
                    case Order: {
                        unit.self().order.set(Order.Nothing, frame);
                        unit.self().isIdle.set(true, frame);
                    }
                }
                break;
            }
            case Cloak: {
                unit.self().order.set(Order.Cloak, frame);
                unit.self().energy.setOrAdd(-unit.getType().cloakingTech().energyCost(), frame);
                break;
            }
            case Decloak: {
                unit.self().order.set(Order.Decloak, frame);
                break;
            }
            case Follow: {
                unit.self().order.set(Order.Follow, frame);
                unit.self().target.set(this.getUnitID(target), frame);
                unit.self().isIdle.set(false, frame);
                unit.self().isMoving.set(true, frame);
                break;
            }
            case Gather: {
                unit.self().target.set(this.getUnitID(target), frame);
                unit.self().isIdle.set(false, frame);
                unit.self().isMoving.set(true, frame);
                unit.self().isGathering.set(true, frame);
                if (target != null && target.exists() && target.getType().isMineralField()) {
                    unit.self().order.set(Order.MoveToMinerals, frame);
                    break;
                }
                if (target == null || !target.exists() || !target.getType().isRefinery()) break;
                unit.self().order.set(Order.MoveToGas, frame);
                break;
            }
            case Halt_Construction: {
                switch (this.eventType) {
                    case Order: {
                        Unit building = unit.getBuildUnit();
                        if (building != null) {
                            building.self().buildUnit.set(-1, frame);
                        }
                        unit.self().buildUnit.set(-1, frame);
                        unit.self().order.set(Order.ResetCollision, frame);
                        unit.self().isConstructing.set(false, frame);
                        unit.self().buildType.set(UnitType.None, frame);
                        break;
                    }
                    case Finish: {
                        unit.self().order.set(Order.PlayerGuard, frame);
                        unit.self().isIdle.set(true, frame);
                    }
                }
                break;
            }
            case Hold_Position: {
                unit.self().isMoving.set(false, frame);
                unit.self().isIdle.set(false, frame);
                unit.self().order.set(Order.HoldPosition, frame);
                break;
            }
            case Land: {
                unit.self().order.set(Order.BuildingLand, frame);
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Lift: {
                unit.self().order.set(Order.BuildingLiftOff, frame);
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Load: {
                if (unit.getType() == UnitType.Terran_Bunker) {
                    unit.self().order.set(Order.PickupBunker, frame);
                    unit.self().target.set(this.getUnitID(target), frame);
                } else if (unit.getType().spaceProvided() != 0) {
                    unit.self().order.set(Order.PickupTransport, frame);
                    unit.self().target.set(this.getUnitID(target), frame);
                } else if (target != null && target.exists() && target.getType().spaceProvided() != 0) {
                    unit.self().order.set(Order.EnterTransport, frame);
                    unit.self().target.set(this.getUnitID(target), frame);
                }
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Morph: {
                UnitType morphType = UnitType.idToEnum[this.command.extra];
                switch (this.eventType) {
                    case Resource: {
                        if (!isCurrentFrame) {
                            unit.self().isCompleted.set(false, frame);
                            unit.self().isIdle.set(false, frame);
                            unit.self().isConstructing.set(true, frame);
                            unit.self().isMorphing.set(true, frame);
                            unit.self().buildType.set(morphType, frame);
                        }
                        if (unit.getType().isBuilding()) {
                            if (!isCurrentFrame) {
                                unit.self().order.set(Order.ZergBuildingMorph, frame);
                                unit.self().type.set(morphType, frame);
                            }
                            this.player.self().minerals.setOrAdd(-morphType.mineralPrice(), frame);
                            this.player.self().gas.setOrAdd(-morphType.gasPrice(), frame);
                            break;
                        }
                        this.player.self().supplyUsed[morphType.getRace().id].setOrAdd(morphType.supplyRequired() * (1 + (morphType.isTwoUnitsInOneEgg() ? 1 : 0)) - unit.getType().supplyRequired(), frame);
                        if (isCurrentFrame) break;
                        unit.self().order.set(Order.ZergUnitMorph, frame);
                        this.player.self().minerals.setOrAdd(-morphType.mineralPrice(), frame);
                        this.player.self().gas.setOrAdd(-morphType.gasPrice(), frame);
                        switch (morphType) {
                            case Zerg_Lurker_Egg: {
                                unit.self().type.set(UnitType.Zerg_Lurker_Egg, frame);
                                break;
                            }
                            case Zerg_Devourer: 
                            case Zerg_Guardian: {
                                unit.self().type.set(UnitType.Zerg_Cocoon, frame);
                                break;
                            }
                            default: {
                                unit.self().type.set(UnitType.Zerg_Egg, frame);
                            }
                        }
                        unit.self().trainingQueue[unit.getTrainingQueueCount()].set(morphType, frame);
                        unit.self().trainingQueueCount.setOrAdd(1, frame);
                        break;
                    }
                    case Order: {
                        if (!unit.getType().isBuilding()) break;
                        unit.self().order.set(Order.IncompleteBuilding, frame);
                    }
                }
                break;
            }
            case Move: {
                unit.self().order.set(Order.Move, frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                unit.self().isMoving.set(true, frame);
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Patrol: {
                unit.self().order.set(Order.Patrol, frame);
                unit.self().isIdle.set(false, frame);
                unit.self().isMoving.set(true, frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                break;
            }
            case Repair: {
                if (unit.getType() != UnitType.Terran_SCV) {
                    return;
                }
                unit.self().order.set(Order.Repair, frame);
                unit.self().target.set(this.getUnitID(target), frame);
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Research: {
                TechType techType = TechType.idToEnum[this.command.extra];
                unit.self().order.set(Order.ResearchTech, frame);
                unit.self().tech.set(techType, frame);
                unit.self().isIdle.set(false, frame);
                unit.self().remainingResearchTime.set(techType.researchTime(), frame);
                this.player.self().minerals.setOrAdd(-techType.mineralPrice(), frame);
                this.player.self().gas.setOrAdd(-techType.gasPrice(), frame);
                this.player.self().isResearching[techType.id].set(true, frame);
                break;
            }
            case Return_Cargo: {
                if (!unit.isCarrying()) {
                    return;
                }
                unit.self().order.set(unit.isCarryingGas() ? Order.ReturnGas : Order.ReturnMinerals, frame);
                unit.self().isGathering.set(true, frame);
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Right_Click_Position: {
                unit.self().order.set(Order.Move, frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                unit.self().isMoving.set(true, frame);
                unit.self().isIdle.set(false, frame);
                break;
            }
            case Right_Click_Unit: {
                if (target == null || !target.exists()) break;
                unit.self().target.set(this.getUnitID(target), frame);
                unit.self().isIdle.set(false, frame);
                unit.self().isMoving.set(true, frame);
                if (unit.getType().isWorker() && target.getType().isMineralField()) {
                    unit.self().isGathering.set(true, frame);
                    unit.self().order.set(Order.MoveToMinerals, frame);
                    break;
                }
                if (unit.getType().isWorker() && target.getType().isRefinery()) {
                    unit.self().isGathering.set(true, frame);
                    unit.self().order.set(Order.MoveToGas, frame);
                    break;
                }
                if (unit.getType().isWorker() && target.getType().getRace() == Race.Terran && target.getType().whatBuilds().getFirst() == unit.getType() && !target.isCompleted()) {
                    unit.self().order.set(Order.ConstructingBuilding, frame);
                    unit.self().buildUnit.set(this.getUnitID(target), frame);
                    target.self().buildUnit.set(this.getUnitID(unit), frame);
                    unit.self().isConstructing.set(true, frame);
                    target.self().isConstructing.set(true, frame);
                    break;
                }
                if (unit.getType().canAttack() && target.getPlayer() != unit.getPlayer() && !target.getType().isNeutral()) {
                    unit.self().order.set(Order.AttackUnit, frame);
                    break;
                }
                if (!unit.getType().canMove()) break;
                unit.self().order.set(Order.Follow, frame);
                break;
            }
            case Set_Rally_Position: {
                if (!unit.getType().canProduce()) {
                    return;
                }
                unit.self().order.set(Order.RallyPointTile, frame);
                unit.self().rallyPositionX.set(this.command.x, frame);
                unit.self().rallyPositionY.set(this.command.y, frame);
                unit.self().rallyUnit.set(-1, frame);
                break;
            }
            case Set_Rally_Unit: {
                if (!unit.getType().canProduce()) {
                    return;
                }
                if (target == null || !target.exists()) {
                    return;
                }
                unit.self().order.set(Order.RallyPointUnit, frame);
                unit.self().rallyUnit.set(this.getUnitID(target), frame);
                break;
            }
            case Siege: {
                unit.self().order.set(Order.Sieging, frame);
                break;
            }
            case Stop: {
                unit.self().order.set(Order.Stop, frame);
                unit.self().isIdle.set(true, frame);
                break;
            }
            case Train: {
                UnitType unitType = UnitType.idToEnum[this.command.extra];
                if (!isCurrentFrame) {
                    this.player.self().minerals.setOrAdd(-unitType.mineralPrice(), frame);
                    this.player.self().gas.setOrAdd(-unitType.gasPrice(), frame);
                }
                unit.self().trainingQueue[unit.getTrainingQueueCount()].set(unitType, frame);
                unit.self().trainingQueueCount.setOrAdd(1, frame);
                this.player.self().supplyUsed[unitType.getRace().id].setOrAdd(unitType.supplyRequired(), frame);
                unit.self().isTraining.set(true, frame);
                unit.self().isIdle.set(false, frame);
                unit.self().remainingTrainTime.set(unitType.buildTime(), frame);
                if (unitType != UnitType.Terran_Nuclear_Missile) break;
                unit.self().secondaryOrder.set(Order.Train, frame);
                break;
            }
            case Unburrow: {
                unit.self().order.set(Order.Unburrowing, frame);
                break;
            }
            case Unload: {
                unit.self().order.set(Order.Unload, frame);
                unit.self().target.set(this.getUnitID(target), frame);
                break;
            }
            case Unload_All: {
                if (unit.getType() == UnitType.Terran_Bunker) {
                    unit.self().order.set(Order.Unload, frame);
                    break;
                }
                unit.self().order.set(Order.MoveUnload, frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                break;
            }
            case Unload_All_Position: {
                unit.self().order.set(Order.MoveUnload, frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                break;
            }
            case Unsiege: {
                unit.self().order.set(Order.Unsieging, frame);
                break;
            }
            case Upgrade: {
                UpgradeType upgradeType = UpgradeType.idToEnum[this.command.extra];
                unit.self().order.set(Order.Upgrade, frame);
                unit.self().upgrade.set(upgradeType, frame);
                unit.self().isIdle.set(false, frame);
                int level = unit.getPlayer().getUpgradeLevel(upgradeType);
                unit.self().remainingUpgradeTime.set(upgradeType.upgradeTime(level + 1), frame);
                this.player.self().minerals.setOrAdd(-upgradeType.mineralPrice(level + 1), frame);
                this.player.self().gas.setOrAdd(upgradeType.gasPrice(level + 1), frame);
                this.player.self().isUpgrading[upgradeType.id].set(true, frame);
                break;
            }
            case Use_Tech: {
                if (TechType.idToEnum[this.command.extra] != TechType.Stim_Packs || unit.getHitPoints() <= 10) break;
                unit.self().hitPoints.setOrAdd(-10, frame);
                unit.self().stimTimer.set(17, frame);
                break;
            }
            case Use_Tech_Position: {
                TechType techType = TechType.idToEnum[this.command.extra];
                if (!techType.targetsPosition()) {
                    return;
                }
                unit.self().order.set(techType.getOrder(), frame);
                unit.self().targetPositionX.set(this.command.x, frame);
                unit.self().targetPositionY.set(this.command.y, frame);
                unit.self().orderTargetPositionX.set(this.command.x, frame);
                unit.self().orderTargetPositionY.set(this.command.y, frame);
                break;
            }
            case Use_Tech_Unit: {
                if (target == null || !target.exists()) break;
                TechType techType = TechType.idToEnum[this.command.extra];
                if (!techType.targetsUnit()) {
                    return;
                }
                unit.self().order.set(techType.getOrder(), frame);
                unit.self().orderTarget.set(this.getUnitID(target), frame);
                Position targetPosition = target.getPosition();
                unit.self().targetPositionX.set(targetPosition.x, frame);
                unit.self().targetPositionY.set(targetPosition.y, frame);
                unit.self().orderTargetPositionX.set(targetPosition.x, frame);
                unit.self().orderTargetPositionY.set(targetPosition.y, frame);
                break;
            }
        }
    }

    static enum EventType {
        Order,
        Resource,
        Finish;

    }
}

