/*
 * Decompiled with CFR 0.152.
 */
package bwapi;

import bwapi.BWClientConfiguration;
import bwapi.BWEventListener;
import bwapi.BotWrapper;
import bwapi.Client;
import bwapi.ClientData;
import bwapi.Game;
import bwapi.PerformanceMetrics;
import java.util.Objects;

public class BWClient {
    private BWClientConfiguration configuration = new BWClientConfiguration();
    private final BWEventListener eventListener;
    private BotWrapper botWrapper;
    private Client client;
    private PerformanceMetrics performanceMetrics;

    public BWClient(BWEventListener eventListener) {
        Objects.requireNonNull(eventListener);
        this.eventListener = eventListener;
    }

    public Game getGame() {
        return this.botWrapper == null ? null : this.botWrapper.getGame();
    }

    public PerformanceMetrics getPerformanceMetrics() {
        return this.performanceMetrics;
    }

    public BWClientConfiguration getConfiguration() {
        return this.configuration;
    }

    boolean doTime() {
        return !this.configuration.getUnlimitedFrameZero() || this.client.isConnected() && this.client.liveClientData().gameData().getFrameCount() > 0;
    }

    public int framesBehind() {
        return this.botWrapper == null ? 0 : Math.max(0, this.client.liveClientData().gameData().getFrameCount() - this.getGame().getFrameCount());
    }

    Client getClient() {
        return this.client;
    }

    public void startGame() {
        BWClientConfiguration configuration = new BWClientConfiguration();
        this.startGame(configuration);
    }

    @Deprecated
    public void startGame(boolean autoContinue) {
        BWClientConfiguration configuration = new BWClientConfiguration();
        configuration.withAutoContinue(autoContinue);
        this.startGame(configuration);
    }

    public void startGame(BWClientConfiguration gameConfiguration) {
        gameConfiguration.validateAndLock();
        this.configuration = gameConfiguration;
        this.performanceMetrics = new PerformanceMetrics(this.configuration);
        this.botWrapper = new BotWrapper(this.configuration, this.eventListener);
        Thread.currentThread().setName("JBWAPI Client");
        if (this.configuration.getAsync()) {
            Thread.currentThread().setPriority(4);
        }
        if (this.client == null) {
            this.client = new Client(this);
        }
        this.client.reconnect();
        do {
            ClientData.GameData liveGameData = this.client.liveClientData().gameData();
            while (!liveGameData.isInGame()) {
                if (!this.client.isConnected()) {
                    return;
                }
                this.client.sendFrameReceiveFrame();
                if (!liveGameData.isInGame()) continue;
                this.performanceMetrics = new PerformanceMetrics(this.configuration);
                this.botWrapper.startNewGame(this.client.mapFile(), this.performanceMetrics);
            }
            while (liveGameData.isInGame()) {
                this.botWrapper.onFrame();
                this.performanceMetrics.getFlushSideEffects().time(() -> this.getGame().sideEffects.flushTo(liveGameData));
                this.performanceMetrics.getFrameDurationReceiveToSend().stopTiming();
                this.client.sendFrameReceiveFrame();
                if (this.client.isConnected()) continue;
                System.out.println("Reconnecting...");
                this.client.reconnect();
            }
            this.botWrapper.endGame();
        } while (this.configuration.getAutoContinue());
    }

    void setClient(Client client) {
        this.client = client;
    }
}

