/*
 * Decompiled with CFR 0.152.
 */
package unit.squad;

import bwapi.Unit;
import bwapi.UnitType;
import info.GameState;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import unit.squad.CombatSimulator;
import unit.squad.Squad;
import util.Filter;

public class ScourgeCombatSimulator
implements CombatSimulator {
    @Override
    public CombatSimulator.CombatResult evaluate(Squad squad, GameState gameState) {
        Set<Unit> enemyUnits = gameState.getDetectedEnemyUnits();
        Set<Unit> enemyBuildings = gameState.getEnemyBuildings();
        ArrayList<Unit> airTargets = new ArrayList<Unit>();
        for (Unit enemy : enemyUnits) {
            if (!enemy.isFlying() || !enemy.isDetected() || enemy.isInvincible() || Filter.isLowPriorityCombatTarget(enemy.getType())) continue;
            airTargets.add(enemy);
        }
        for (Unit building : enemyBuildings) {
            if (!building.isFlying() || !building.isDetected() || building.isInvincible()) continue;
            airTargets.add(building);
        }
        if (airTargets.isEmpty()) {
            return CombatSimulator.CombatResult.RETREAT;
        }
        return this.canKillTarget(squad, airTargets) ? CombatSimulator.CombatResult.ENGAGE : CombatSimulator.CombatResult.RETREAT;
    }

    private boolean canKillTarget(Squad squad, List<Unit> airTargets) {
        int squadSize = squad.size();
        if (squadSize == 0) {
            return false;
        }
        int scourgeDAMAGE = 110;
        List<Unit> prioritizedTargets = this.prioritizeTargets(airTargets);
        int remainingScourge = squadSize;
        for (Unit target : prioritizedTargets) {
            if (remainingScourge <= 0) break;
            int targetHP = target.getHitPoints() + target.getShields();
            int scourgeNeeded = (int)Math.ceil((double)targetHP / (double)scourgeDAMAGE);
            if (scourgeNeeded <= remainingScourge) {
                return true;
            }
            if (!this.isHighPriorityTarget(target)) continue;
            remainingScourge = Math.max(0, remainingScourge - scourgeNeeded);
        }
        return false;
    }

    private List<Unit> prioritizeTargets(List<Unit> airTargets) {
        ArrayList<Unit> highPriority = new ArrayList<Unit>();
        ArrayList<Unit> mediumPriority = new ArrayList<Unit>();
        ArrayList<Unit> lowPriority = new ArrayList<Unit>();
        for (Unit target : airTargets) {
            UnitType type = target.getType();
            if (this.isLowPriorityTarget(type)) {
                lowPriority.add(target);
                continue;
            }
            if (this.isFloatingBuilding(type)) {
                mediumPriority.add(target);
                continue;
            }
            highPriority.add(target);
        }
        ArrayList<Unit> prioritized = new ArrayList<Unit>();
        prioritized.addAll(highPriority);
        prioritized.addAll(mediumPriority);
        prioritized.addAll(lowPriority);
        return prioritized;
    }

    private boolean isHighPriorityTarget(Unit target) {
        UnitType type = target.getType();
        return !this.isFloatingBuilding(type) && !this.isLowPriorityTarget(type);
    }

    private boolean isFloatingBuilding(UnitType type) {
        return type.isFlyingBuilding();
    }

    private boolean isLowPriorityTarget(UnitType type) {
        return type == UnitType.Zerg_Overlord || type == UnitType.Protoss_Interceptor;
    }
}

