/*
 * Decompiled with CFR 0.152.
 */
package unit;

import bwapi.Game;
import bwapi.Unit;
import bwapi.UnitType;
import info.BaseData;
import info.GameState;
import info.map.BuildingPlanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import macro.plan.Plan;
import macro.plan.PlanComparator;
import macro.plan.PlanState;
import macro.plan.PlanType;
import unit.managed.ManagedUnit;
import unit.managed.UnitRole;

public class BuildingManager {
    private GameState gameState;
    private ManagedUnit lair;
    private HashSet<ManagedUnit> hatcheries = new HashSet();
    private HashSet<ManagedUnit> colonies = new HashSet();

    public BuildingManager(Game game, GameState gameState) {
        this.gameState = gameState;
    }

    public void onFrame() {
        this.assignScheduledPlannedItems();
    }

    public void add(ManagedUnit managedUnit) {
        BuildingPlanner buildingPlanner = this.gameState.getBuildingPlanner();
        buildingPlanner.reserveBuildingTiles(managedUnit.getUnit());
        UnitType unitType = managedUnit.getUnitType();
        BaseData baseData = this.gameState.getBaseData();
        switch (unitType) {
            case Zerg_Hatchery: 
            case Zerg_Lair: 
            case Zerg_Hive: {
                this.hatcheries.add(managedUnit);
                break;
            }
            case Zerg_Creep_Colony: {
                this.colonies.add(managedUnit);
            }
            case Zerg_Sunken_Colony: {
                baseData.addSunkenColony(managedUnit.getUnit());
            }
        }
    }

    public void remove(ManagedUnit managedUnit) {
        BuildingPlanner buildingPlanner = this.gameState.getBuildingPlanner();
        buildingPlanner.removeBuildingTiles(managedUnit.getUnit());
        UnitType unitType = managedUnit.getUnitType();
        if (unitType != managedUnit.getUnit().getType()) {
            unitType = managedUnit.getUnit().getType();
        }
        BaseData baseData = this.gameState.getBaseData();
        switch (unitType) {
            case Zerg_Hatchery: 
            case Zerg_Lair: 
            case Zerg_Hive: {
                this.hatcheries.remove(managedUnit);
                break;
            }
            case Zerg_Creep_Colony: {
                this.colonies.remove(managedUnit);
                break;
            }
            case Zerg_Sunken_Colony: {
                baseData.removeSunkenColony(managedUnit.getUnit());
            }
        }
    }

    private void assignScheduledPlannedItems() {
        List scheduledPlans = this.gameState.getPlansScheduled().stream().collect(Collectors.toList());
        if (scheduledPlans.isEmpty()) {
            return;
        }
        Collections.sort(scheduledPlans, new PlanComparator());
        ArrayList<Plan> assignedPlans = new ArrayList<Plan>();
        ArrayList<Plan> completePlans = new ArrayList<Plan>();
        for (Plan plan : scheduledPlans) {
            if (plan.getType() != PlanType.BUILDING) {
                return;
            }
            if (plan.getState() == PlanState.COMPLETE) {
                completePlans.add(plan);
                continue;
            }
            UnitType unitType = plan.getPlannedUnit();
            boolean didAssign = false;
            switch (unitType) {
                case Zerg_Lair: {
                    didAssign = this.assignMorphLair(plan);
                    break;
                }
                case Zerg_Sunken_Colony: {
                    didAssign = this.assignMorphSunkenColony(plan);
                    break;
                }
                case Zerg_Hive: {
                    didAssign = this.assignMorphHive(plan);
                }
            }
            if (!didAssign) continue;
            assignedPlans.add(plan);
            break;
        }
        HashSet<Plan> morphingPlans = this.gameState.getPlansMorphing();
        for (Plan plan : assignedPlans) {
            scheduledPlans.remove(plan);
            morphingPlans.add(plan);
        }
        for (Plan plan : completePlans) {
            scheduledPlans.remove(plan);
        }
        this.gameState.setPlansScheduled(scheduledPlans.stream().collect(Collectors.toCollection(HashSet::new)));
    }

    private boolean assignMorphLair(Plan plan) {
        for (ManagedUnit managedHatchery : this.hatcheries) {
            Unit hatchery = managedHatchery.getUnit();
            if (!hatchery.canBuild(plan.getPlannedUnit()) || this.gameState.getAssignedPlannedItems().containsKey(hatchery)) continue;
            managedHatchery.setRole(UnitRole.MORPH);
            this.gameState.getAssignedPlannedItems().put(hatchery, plan);
            managedHatchery.setPlan(plan);
            this.lair = managedHatchery;
            return true;
        }
        return false;
    }

    private boolean assignMorphHive(Plan plan) {
        Unit lairUnit = this.lair.getUnit();
        if (lairUnit.canBuild(plan.getPlannedUnit()) && !this.gameState.getAssignedPlannedItems().containsKey(lairUnit)) {
            this.lair.setRole(UnitRole.MORPH);
            this.gameState.getAssignedPlannedItems().put(lairUnit, plan);
            this.lair.setPlan(plan);
            return true;
        }
        return false;
    }

    private boolean assignMorphSunkenColony(Plan plan) {
        for (ManagedUnit managedColony : this.colonies) {
            Unit colony = managedColony.getUnit();
            if (!colony.canBuild(plan.getPlannedUnit()) || this.gameState.getAssignedPlannedItems().containsKey(colony)) continue;
            managedColony.setRole(UnitRole.MORPH);
            this.gameState.getAssignedPlannedItems().put(colony, plan);
            managedColony.setPlan(plan);
            return true;
        }
        return false;
    }
}

