/*
 * Decompiled with CFR 0.152.
 */
package strategy.buildorder.zerg;

import bwapi.UnitType;
import bwapi.UpgradeType;
import info.BaseData;
import info.GameState;
import info.TechProgression;
import java.util.ArrayList;
import java.util.List;
import macro.plan.Plan;
import strategy.buildorder.zerg.ZergBase;
import util.Time;

public class OneHatchSpire
extends ZergBase {
    public OneHatchSpire() {
        super("1HatchSpire");
    }

    @Override
    public List<Plan> plan(GameState gameState) {
        Plan hatcheryPlan;
        boolean enemyHasSpire;
        ArrayList<Plan> plans = new ArrayList<Plan>();
        TechProgression techProgression = gameState.getTechProgression();
        BaseData baseData = gameState.getBaseData();
        int gas = gameState.getResourceCount().availableGas();
        int plannedHatcheries = gameState.getPlannedHatcheries();
        int extractorCount = baseData.numExtractor();
        int hatchCount = gameState.ourUnitCount(UnitType.Zerg_Hatchery) + gameState.ourUnitCount(UnitType.Zerg_Lair);
        int lairCount = gameState.ourUnitCount(UnitType.Zerg_Lair);
        int spireCount = gameState.ourUnitCount(UnitType.Zerg_Spire);
        int mutaCount = gameState.ourUnitCount(UnitType.Zerg_Mutalisk);
        int scourgeCount = gameState.ourUnitCount(UnitType.Zerg_Scourge);
        int droneCount = gameState.ourUnitCount(UnitType.Zerg_Drone);
        int zerglingCount = gameState.ourUnitCount(UnitType.Zerg_Zergling);
        boolean firstGas = gameState.canPlanExtractor() && techProgression.isSpawningPool() && extractorCount < 1;
        boolean anotherGas = gameState.canPlanExtractor() && spireCount > 0;
        boolean wantLair = gameState.canPlanLair() && lairCount < 1;
        boolean wantSpire = techProgression.canPlanSpire() && spireCount < 1 && lairCount >= 1;
        boolean wantMetabolicBoost = techProgression.canPlanMetabolicBoost() && !techProgression.isMetabolicBoost() && zerglingCount > 5 && lairCount > 0;
        boolean wantFlyingCarapace = mutaCount > 6 && techProgression.canPlanFlyerDefense() && techProgression.getFlyerDefense() < 1;
        boolean wantOverlordSpeed = this.needOverlordSpeed(gameState) && techProgression.canPlanOverlordSpeed();
        boolean floatingMinerals = gameState.getGameTime().greaterThan(new Time(5, 0)) && gameState.getResourceCount().availableMinerals() > (plannedHatcheries + 1) * 350;
        boolean wantHatchery = this.behindOnHatchery(gameState) || floatingMinerals;
        boolean bl = enemyHasSpire = gameState.enemyUnitCount(UnitType.Zerg_Spire) > 0;
        if (wantHatchery && (hatcheryPlan = this.planNewBase(gameState)) != null) {
            plans.add(hatcheryPlan);
            return plans;
        }
        if (techProgression.canPlanPool() && droneCount > 8) {
            Plan poolPlan = this.planSpawningPool(gameState);
            plans.add(poolPlan);
            return plans;
        }
        if (wantLair) {
            Plan lairPlan = this.planLair(gameState);
            plans.add(lairPlan);
            return plans;
        }
        if (wantSpire) {
            Plan spirePlan = this.planSpire(gameState);
            plans.add(spirePlan);
            return plans;
        }
        if (wantMetabolicBoost) {
            Plan metabolicBoostPlan = this.planUpgrade(gameState, UpgradeType.Metabolic_Boost);
            plans.add(metabolicBoostPlan);
        }
        if (wantFlyingCarapace) {
            Plan flyingCarapacePlan = this.planUpgrade(gameState, UpgradeType.Zerg_Flyer_Carapace);
            plans.add(flyingCarapacePlan);
        }
        if (wantOverlordSpeed) {
            Plan overlordSpeedPlan = this.planUpgrade(gameState, UpgradeType.Pneumatized_Carapace);
            plans.add(overlordSpeedPlan);
        }
        if (firstGas || anotherGas) {
            Plan extractorPlan = this.planExtractor(gameState);
            plans.add(extractorPlan);
        }
        int desiredScourge = 2;
        if (techProgression.isSpire() && scourgeCount < 2 && mutaCount > 5 && enemyHasSpire) {
            int i = 0;
            while (i < 2 - scourgeCount) {
                Plan scourgePlan = this.planUnit(gameState, UnitType.Zerg_Scourge);
                plans.add(scourgePlan);
                ++i;
            }
            return plans;
        }
        int flexibleMutalisks = Math.max(0, (gas - 300) / 100);
        int desiredMutalisks = Math.min(11 + flexibleMutalisks, 40);
        if (techProgression.isSpire() && mutaCount < desiredMutalisks) {
            Plan mutaliskPlan = this.planUnit(gameState, UnitType.Zerg_Mutalisk);
            plans.add(mutaliskPlan);
            return plans;
        }
        int desiredZerglings = this.zerglingsNeeded(gameState);
        if (zerglingCount < desiredZerglings) {
            int i = 0;
            while (i < desiredZerglings - zerglingCount) {
                Plan zerglingPlan = this.planUnit(gameState, UnitType.Zerg_Zergling);
                plans.add(zerglingPlan);
                ++i;
            }
            return plans;
        }
        int desiredDroneCount = 10 + (hatchCount - 1) * 6;
        if (droneCount < desiredDroneCount && gameState.canPlanDrone()) {
            Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
            plans.add(dronePlan);
            return plans;
        }
        return plans;
    }

    @Override
    public boolean needLair() {
        return true;
    }
}

