/*
 * Decompiled with CFR 0.152.
 */
package strategy.buildorder.terran;

import bwapi.Race;
import bwapi.UnitType;
import bwapi.UpgradeType;
import info.BaseData;
import info.GameState;
import info.TechProgression;
import java.util.ArrayList;
import java.util.List;
import macro.plan.Plan;
import strategy.buildorder.terran.TerranBase;
import util.Time;

public class TwoHatchMuta
extends TerranBase {
    private boolean startedFlyerUpgrade = false;

    public TwoHatchMuta() {
        super("2HatchMuta");
    }

    @Override
    public List<Plan> plan(GameState gameState) {
        Plan hatcheryPlan;
        ArrayList<Plan> plans = new ArrayList<Plan>();
        Time time = gameState.getGameTime();
        TechProgression techProgression = gameState.getTechProgression();
        BaseData baseData = gameState.getBaseData();
        int baseCount = baseData.currentBaseCount();
        int extractorCount = baseData.numExtractor();
        int supply = gameState.getSupply();
        int plannedHatcheries = gameState.getPlannedHatcheries();
        int hatchCount = gameState.ourUnitCount(UnitType.Zerg_Hatchery);
        int plannedAndCurrentHatcheries = plannedHatcheries + baseCount;
        int lairCount = gameState.ourUnitCount(UnitType.Zerg_Lair);
        int spireCount = gameState.ourUnitCount(UnitType.Zerg_Spire);
        int hydraCount = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        int mutaCount = gameState.ourUnitCount(UnitType.Zerg_Mutalisk);
        int scourgeCount = gameState.ourUnitCount(UnitType.Zerg_Scourge);
        int droneCount = gameState.ourUnitCount(UnitType.Zerg_Drone);
        int zerglingCount = gameState.ourUnitCount(UnitType.Zerg_Zergling);
        int overlordCount = gameState.ourUnitCount(UnitType.Zerg_Overlord);
        int enemyVessel = gameState.enemyUnitCount(UnitType.Terran_Science_Vessel);
        int enemyDropship = gameState.enemyUnitCount(UnitType.Terran_Dropship);
        int enemyValkyrie = gameState.enemyUnitCount(UnitType.Terran_Valkyrie);
        int enemyWraith = gameState.enemyUnitCount(UnitType.Terran_Wraith);
        boolean firstGas = gameState.canPlanExtractor() && techProgression.isSpawningPool() && extractorCount < 1;
        boolean secondGas = gameState.canPlanExtractor() && lairCount > 0;
        boolean floatingMinerals = gameState.getGameTime().greaterThan(new Time(5, 0)) && gameState.getResourceCount().availableMinerals() > (plannedHatcheries + 1) * 350;
        boolean wantNatural = plannedAndCurrentHatcheries < 2 && droneCount >= 12;
        boolean wantThird = plannedAndCurrentHatcheries < 3 && spireCount > 0 && mutaCount > 5;
        boolean wantBaseAdvantage = this.behindOnBases(gameState) || floatingMinerals;
        boolean wantLair = gameState.canPlanLair() && lairCount < 1 && baseCount >= 2;
        boolean wantSpire = techProgression.canPlanSpire() && spireCount < 1 && lairCount >= 1 && droneCount >= 16;
        boolean wantMetabolicBoost = techProgression.canPlanMetabolicBoost() && !techProgression.isMetabolicBoost() && lairCount > 0;
        boolean wantFlyingAttack = mutaCount > 6 && techProgression.canPlanFlyerAttack() && techProgression.getFlyerAttack() < 1 && !this.startedFlyerUpgrade;
        boolean wantOverlordSpeed = this.needOverlordSpeed(gameState) && techProgression.canPlanOverlordSpeed();
        int desiredSunkenColonies = this.requiredSunkens(gameState);
        if (!gameState.basesNeedingSunken(desiredSunkenColonies).isEmpty()) {
            plans.addAll(this.planSunkenColony(gameState));
        }
        if ((wantNatural || wantThird || wantBaseAdvantage) && (hatcheryPlan = this.planNewBase(gameState)) != null) {
            plans.add(hatcheryPlan);
            return plans;
        }
        if (firstGas || secondGas) {
            Plan extractorPlan = this.planExtractor(gameState);
            plans.add(extractorPlan);
        }
        if (spireCount > 1 && overlordCount < 4) {
            Plan overlordPlan = this.planUnit(gameState, UnitType.Zerg_Overlord);
            plans.add(overlordPlan);
            return plans;
        }
        if (techProgression.canPlanPool() && droneCount > 10) {
            Plan poolPlan = this.planSpawningPool(gameState);
            plans.add(poolPlan);
            return plans;
        }
        if (wantLair) {
            Plan lairPlan = this.planLair(gameState);
            plans.add(lairPlan);
            return plans;
        }
        if (wantSpire) {
            Plan spirePlan = this.planSpire(gameState);
            plans.add(spirePlan);
            return plans;
        }
        if (wantMetabolicBoost) {
            Plan metabolicBoostPlan = this.planUpgrade(gameState, UpgradeType.Metabolic_Boost);
            plans.add(metabolicBoostPlan);
        }
        if (wantFlyingAttack) {
            this.startedFlyerUpgrade = true;
            Plan flyingCarapacePlan = this.planUpgrade(gameState, UpgradeType.Zerg_Flyer_Attacks);
            plans.add(flyingCarapacePlan);
        }
        if (wantOverlordSpeed) {
            Plan overlordSpeedPlan = this.planUpgrade(gameState, UpgradeType.Pneumatized_Carapace);
            plans.add(overlordSpeedPlan);
        }
        int desiredScourge = enemyVessel + enemyDropship + enemyValkyrie + enemyWraith;
        if (techProgression.isSpire() && scourgeCount < desiredScourge) {
            int i = 0;
            while (i < desiredScourge - scourgeCount) {
                Plan scourgePlan = this.planUnit(gameState, UnitType.Zerg_Scourge);
                plans.add(scourgePlan);
                ++i;
            }
            return plans;
        }
        int desiredMutalisks = this.desiredMutalisks(gameState);
        if (techProgression.isSpire() && mutaCount < desiredMutalisks) {
            Plan mutaliskPlan = this.planUnit(gameState, UnitType.Zerg_Mutalisk);
            plans.add(mutaliskPlan);
            return plans;
        }
        int desiredZerglings = this.zerglingsNeeded(gameState);
        if (zerglingCount < desiredZerglings) {
            Plan zerglingPlan = this.planUnit(gameState, UnitType.Zerg_Zergling);
            plans.add(zerglingPlan);
            return plans;
        }
        int desiredDrones = this.dronesNeeded(gameState);
        if (plans.isEmpty() && droneCount < desiredDrones) {
            Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
            plans.add(dronePlan);
            return plans;
        }
        return plans;
    }

    protected int dronesNeeded(GameState gameState) {
        int drones = 16;
        int lairCount = gameState.ourUnitCount(UnitType.Zerg_Lair);
        int hatchCount = gameState.ourUnitCount(UnitType.Zerg_Hatchery);
        if (lairCount > 0) {
            drones += 6;
        }
        if (hatchCount > 2) {
            drones += 6 * (hatchCount - 1);
        }
        return drones;
    }

    private int desiredMutalisks(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        if (!techProgression.isSpire()) {
            return 0;
        }
        int baseTarget = 11;
        int availableMinerals = gameState.getResourceCount().availableMinerals();
        if (availableMinerals > 400) {
            int extraMutalisks = availableMinerals / 100;
            baseTarget += Math.min(extraMutalisks, 20);
        }
        return baseTarget;
    }

    @Override
    public boolean playsRace(Race race) {
        return race == Race.Terran;
    }

    @Override
    public boolean needLair() {
        return true;
    }
}

