/*
 * Decompiled with CFR 0.152.
 */
package strategy.buildorder.protoss;

import bwapi.Race;
import bwapi.UnitType;
import bwapi.UpgradeType;
import info.BaseData;
import info.GameState;
import info.TechProgression;
import info.tracking.StrategyTracker;
import java.util.ArrayList;
import java.util.List;
import macro.plan.Plan;
import strategy.buildorder.protoss.ProtossBase;
import util.Time;

public class ThreeHatchMuta
extends ProtossBase {
    private boolean plannedFirstMacroHatch = false;
    private boolean plannedSecondMacroHatch = false;
    private boolean plannedThirdMacroHatch = false;
    private boolean plannedHydraliskDen = false;
    private boolean plannedEvolutionChamber = false;

    public ThreeHatchMuta() {
        super("3HatchMuta");
    }

    @Override
    public List<Plan> plan(GameState gameState) {
        Plan evolutionChamberPlan;
        Plan hydraliskDenPlan;
        Plan macroHatchPlan;
        Plan hatcheryPlan;
        ArrayList<Plan> plans = new ArrayList<Plan>();
        Time time = gameState.getGameTime();
        TechProgression techProgression = gameState.getTechProgression();
        BaseData baseData = gameState.getBaseData();
        StrategyTracker strategyTracker = gameState.getStrategyTracker();
        boolean cannonRushed = strategyTracker.isDetectedStrategy("CannonRush");
        int baseCount = baseData.currentBaseCount();
        int extractorCount = baseData.numExtractor();
        int supply = gameState.getSupply();
        int plannedHatcheries = gameState.getPlannedHatcheries();
        int macroHatchCount = baseData.numMacroHatcheries();
        int hatchCount = gameState.ourUnitCount(UnitType.Zerg_Hatchery);
        int plannedAndCurrentHatcheries = plannedHatcheries + baseCount;
        int lairCount = gameState.ourUnitCount(UnitType.Zerg_Lair);
        int spireCount = gameState.ourUnitCount(UnitType.Zerg_Spire);
        int hydraCount = gameState.ourUnitCount(UnitType.Zerg_Hydralisk);
        int mutaCount = gameState.ourUnitCount(UnitType.Zerg_Mutalisk);
        int scourgeCount = gameState.ourUnitCount(UnitType.Zerg_Scourge);
        int droneCount = gameState.ourUnitCount(UnitType.Zerg_Drone);
        int zerglingCount = gameState.ourUnitCount(UnitType.Zerg_Zergling);
        int overlordCount = gameState.ourUnitCount(UnitType.Zerg_Overlord);
        int enemyCorsairCount = gameState.enemyUnitCount(UnitType.Protoss_Corsair);
        int enemyObserverCount = gameState.enemyUnitCount(UnitType.Protoss_Observer);
        boolean gasBlocked = cannonRushed && time.lessThanOrEqual(new Time(4, 0));
        boolean firstGas = !gasBlocked && gameState.canPlanExtractor() && (time.greaterThan(new Time(2, 32)) || supply > 40) && extractorCount < 1;
        boolean secondGas = gameState.canPlanExtractor() && (spireCount > 0 || droneCount >= 20);
        boolean wantNatural = plannedAndCurrentHatcheries < 2 && supply >= 24;
        boolean wantThird = plannedAndCurrentHatcheries < 3 && droneCount > 13 && techProgression.isSpawningPool();
        boolean wantBaseAdvantage = this.behindOnBases(gameState);
        boolean floatingMinerals = gameState.getGameTime().greaterThan(new Time(5, 0)) && gameState.getResourceCount().availableMinerals() > (plannedHatcheries + 1) * 350;
        boolean wantFirstMacroHatch = this.wantFirstMacroHatchery(gameState);
        boolean wantSecondMacroHatch = this.wantSecondMacroHatchery(gameState);
        boolean wantThirdMacroHatch = this.wantThirdMacroHatchery(gameState);
        boolean wantLair = gameState.canPlanLair() && lairCount < 1 && time.greaterThan(new Time(2, 30)) && baseCount >= 2;
        boolean wantSpire = techProgression.canPlanSpire() && spireCount < 1 && supply >= 48 && lairCount >= 1 && droneCount >= 16;
        boolean wantHydraliskDen = this.wantHydraliskDen(gameState);
        boolean wantEvolutionChamber = this.wantEvolutionChamber(gameState);
        boolean wantMetabolicBoost = techProgression.canPlanMetabolicBoost() && !techProgression.isMetabolicBoost() && lairCount > 0;
        boolean wantCarapaceUpgrade = this.wantCarapaceUpgrade(gameState);
        boolean wantOverlordSpeed = this.needOverlordSpeed(gameState) && techProgression.canPlanOverlordSpeed();
        int desiredSunkenColonies = this.requiredSunkens(gameState);
        if (!gameState.basesNeedingSunken(desiredSunkenColonies).isEmpty()) {
            plans.addAll(this.planSunkenColony(gameState));
        }
        if ((wantNatural || wantThird || wantBaseAdvantage || floatingMinerals) && (hatcheryPlan = this.planNewBase(gameState)) != null) {
            plans.add(hatcheryPlan);
            return plans;
        }
        if (wantFirstMacroHatch && (macroHatchPlan = this.planMacroHatchery(gameState)) != null) {
            this.plannedFirstMacroHatch = true;
            plans.add(macroHatchPlan);
            return plans;
        }
        if (wantSecondMacroHatch && (macroHatchPlan = this.planMacroHatchery(gameState)) != null) {
            this.plannedSecondMacroHatch = true;
            plans.add(macroHatchPlan);
            return plans;
        }
        if (wantThirdMacroHatch && (macroHatchPlan = this.planMacroHatchery(gameState)) != null) {
            this.plannedThirdMacroHatch = true;
            plans.add(macroHatchPlan);
            return plans;
        }
        if (firstGas || secondGas) {
            Plan extractorPlan = this.planExtractor(gameState);
            plans.add(extractorPlan);
        }
        if (techProgression.canPlanPool() && droneCount > 10) {
            Plan poolPlan = this.planSpawningPool(gameState);
            plans.add(poolPlan);
            return plans;
        }
        if (wantLair) {
            Plan lairPlan = this.planLair(gameState);
            plans.add(lairPlan);
            return plans;
        }
        if (wantSpire) {
            Plan spirePlan = this.planSpire(gameState);
            plans.add(spirePlan);
            return plans;
        }
        if (wantHydraliskDen && (hydraliskDenPlan = this.planHydraliskDen(gameState)) != null) {
            this.plannedHydraliskDen = true;
            plans.add(hydraliskDenPlan);
            return plans;
        }
        if (wantEvolutionChamber && (evolutionChamberPlan = this.planEvolutionChamber(gameState)) != null) {
            this.plannedEvolutionChamber = true;
            plans.add(evolutionChamberPlan);
            return plans;
        }
        if (wantMetabolicBoost) {
            Plan metabolicBoostPlan = this.planUpgrade(gameState, UpgradeType.Metabolic_Boost);
            plans.add(metabolicBoostPlan);
        }
        if (wantCarapaceUpgrade) {
            Plan carapacePlan = this.planUpgrade(gameState, UpgradeType.Zerg_Carapace);
            plans.add(carapacePlan);
        }
        if (wantOverlordSpeed) {
            Plan overlordSpeedPlan = this.planUpgrade(gameState, UpgradeType.Pneumatized_Carapace);
            plans.add(overlordSpeedPlan);
        }
        int desiredScourge = enemyCorsairCount + enemyObserverCount;
        if (techProgression.isSpire() && scourgeCount < desiredScourge) {
            int i = 0;
            while (i < desiredScourge - scourgeCount) {
                Plan scourgePlan = this.planUnit(gameState, UnitType.Zerg_Scourge);
                plans.add(scourgePlan);
                ++i;
            }
            return plans;
        }
        int desiredMutalisks = this.desiredMutalisks(gameState);
        if (techProgression.isSpire() && mutaCount < desiredMutalisks) {
            int i = 0;
            while (i < desiredMutalisks - mutaCount) {
                Plan mutaliskPlan = this.planUnit(gameState, UnitType.Zerg_Mutalisk);
                plans.add(mutaliskPlan);
                ++i;
            }
            return plans;
        }
        int desiredHydralisks = this.desiredHydralisks(gameState);
        if (techProgression.isHydraliskDen() && hydraCount < desiredHydralisks) {
            int i = 0;
            while (i < desiredHydralisks - hydraCount) {
                Plan hydraliskPlan = this.planUnit(gameState, UnitType.Zerg_Hydralisk);
                plans.add(hydraliskPlan);
                ++i;
            }
            return plans;
        }
        int desiredZerglings = this.zerglingsNeeded(gameState);
        if (zerglingCount < desiredZerglings) {
            int i = 0;
            while (i < desiredZerglings - zerglingCount) {
                Plan zerglingPlan = this.planUnit(gameState, UnitType.Zerg_Zergling);
                plans.add(zerglingPlan);
                ++i;
            }
            return plans;
        }
        int droneTarget = hatchCount * 7;
        if (macroHatchCount > 0 && droneCount < droneTarget) {
            int i = 0;
            while (i < droneTarget - droneCount) {
                Plan zerglingPlan = this.planUnit(gameState, UnitType.Zerg_Drone);
                plans.add(zerglingPlan);
                ++i;
            }
            return plans;
        }
        if (plans.isEmpty() && gameState.canPlanDrone()) {
            Plan dronePlan = this.planUnit(gameState, UnitType.Zerg_Drone);
            plans.add(dronePlan);
            return plans;
        }
        return plans;
    }

    private boolean wantFirstMacroHatchery(GameState gameState) {
        if (this.plannedFirstMacroHatch) {
            return false;
        }
        int macroHatchCount = gameState.getBaseData().numMacroHatcheries();
        if (macroHatchCount >= 1) {
            return false;
        }
        int mutaCount = gameState.ourUnitCount(UnitType.Zerg_Mutalisk);
        Time gameTime = gameState.getGameTime();
        return mutaCount > 1 || gameTime.greaterThan(new Time(10, 0));
    }

    private boolean wantSecondMacroHatchery(GameState gameState) {
        if (this.plannedSecondMacroHatch) {
            return false;
        }
        if (this.plannedFirstMacroHatch && gameState.getGameTime().lessThanOrEqual(new Time(8, 0))) {
            return false;
        }
        int macroHatchCount = gameState.getBaseData().numMacroHatcheries();
        if (macroHatchCount >= 2) {
            return false;
        }
        int mutaCount = gameState.ourUnitCount(UnitType.Zerg_Mutalisk);
        Time gameTime = gameState.getGameTime();
        return mutaCount >= 7 || gameTime.greaterThan(new Time(11, 0));
    }

    private boolean wantThirdMacroHatchery(GameState gameState) {
        if (this.plannedThirdMacroHatch) {
            return false;
        }
        if (this.plannedSecondMacroHatch && gameState.getGameTime().lessThanOrEqual(new Time(9, 0))) {
            return false;
        }
        int macroHatchCount = gameState.getBaseData().numMacroHatcheries();
        if (macroHatchCount >= 3) {
            return false;
        }
        int mutaCount = gameState.ourUnitCount(UnitType.Zerg_Mutalisk);
        Time gameTime = gameState.getGameTime();
        return mutaCount >= 8 || gameTime.greaterThan(new Time(12, 0));
    }

    private boolean wantHydraliskDen(GameState gameState) {
        if (this.plannedHydraliskDen) {
            return false;
        }
        if (!this.plannedFirstMacroHatch) {
            return false;
        }
        TechProgression techProgression = gameState.getTechProgression();
        return techProgression.canPlanHydraliskDen();
    }

    private boolean wantEvolutionChamber(GameState gameState) {
        if (this.plannedEvolutionChamber) {
            return false;
        }
        if (!this.plannedHydraliskDen) {
            return false;
        }
        TechProgression techProgression = gameState.getTechProgression();
        return techProgression.canPlanEvolutionChamber();
    }

    private boolean wantCarapaceUpgrade(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        if (techProgression.getEvolutionChambers() < 1) {
            return false;
        }
        return techProgression.canPlanCarapaceUpgrades() && techProgression.getCarapaceUpgrades() < 1;
    }

    private int desiredMutalisks(GameState gameState) {
        return 9;
    }

    private int desiredHydralisks(GameState gameState) {
        TechProgression techProgression = gameState.getTechProgression();
        if (!techProgression.isHydraliskDen()) {
            return 0;
        }
        return 25;
    }

    @Override
    public boolean playsRace(Race race) {
        switch (race) {
            case Terran: 
            case Protoss: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean needLair() {
        return true;
    }
}

